/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.parameter.CommonParameter;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.ResourceProcessor;
import org.tron.core.db.TransactionTrace;
import org.tron.core.exception.AccountResourceInsufficientException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.Common;

public class EnergyProcessor
extends ResourceProcessor {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");

    public EnergyProcessor(DynamicPropertiesStore dynamicPropertiesStore, AccountStore accountStore) {
        super(dynamicPropertiesStore, accountStore);
    }

    public static long getHeadSlot(DynamicPropertiesStore dynamicPropertiesStore) {
        return (dynamicPropertiesStore.getLatestBlockHeaderTimestamp() - Long.parseLong(CommonParameter.getInstance().getGenesisBlock().getTimestamp())) / 3000L;
    }

    public void updateUsage(AccountCapsule accountCapsule) {
        long now = this.getHeadSlot();
        this.updateUsage(accountCapsule, now);
    }

    private void updateUsage(AccountCapsule accountCapsule, long now) {
        Protocol.Account.AccountResource accountResource = accountCapsule.getAccountResource();
        long oldEnergyUsage = accountResource.getEnergyUsage();
        long latestConsumeTime = accountResource.getLatestConsumeTimeForEnergy();
        accountCapsule.setEnergyUsage(this.increase(accountCapsule, Common.ResourceCode.ENERGY, oldEnergyUsage, 0L, latestConsumeTime, now));
    }

    public void updateTotalEnergyAverageUsage() {
        long now = this.getHeadSlot();
        long blockEnergyUsage = this.dynamicPropertiesStore.getBlockEnergyUsage();
        long totalEnergyAverageUsage = this.dynamicPropertiesStore.getTotalEnergyAverageUsage();
        long totalEnergyAverageTime = this.dynamicPropertiesStore.getTotalEnergyAverageTime();
        long newPublicEnergyAverageUsage = this.increase(totalEnergyAverageUsage, blockEnergyUsage, totalEnergyAverageTime, now, this.averageWindowSize);
        this.dynamicPropertiesStore.saveTotalEnergyAverageUsage(newPublicEnergyAverageUsage);
        this.dynamicPropertiesStore.saveTotalEnergyAverageTime(now);
    }

    public void updateAdaptiveTotalEnergyLimit() {
        long totalEnergyAverageUsage = this.dynamicPropertiesStore.getTotalEnergyAverageUsage();
        long targetTotalEnergyLimit = this.dynamicPropertiesStore.getTotalEnergyTargetLimit();
        long totalEnergyCurrentLimit = this.dynamicPropertiesStore.getTotalEnergyCurrentLimit();
        long totalEnergyLimit = this.dynamicPropertiesStore.getTotalEnergyLimit();
        long result = totalEnergyAverageUsage > targetTotalEnergyLimit ? totalEnergyCurrentLimit * 99L / 100L : totalEnergyCurrentLimit * 1000L / 999L;
        result = Math.min(Math.max(result, totalEnergyLimit), totalEnergyLimit * this.dynamicPropertiesStore.getAdaptiveResourceLimitMultiplier());
        this.dynamicPropertiesStore.saveTotalEnergyCurrentLimit(result);
        logger.debug("Adjust totalEnergyCurrentLimit, old: {}, new: {}.", (Object)totalEnergyCurrentLimit, (Object)result);
    }

    @Override
    public void consume(TransactionCapsule trx, TransactionTrace trace) throws ContractValidateException, AccountResourceInsufficientException {
        throw new RuntimeException("Not support");
    }

    public boolean useEnergy(AccountCapsule accountCapsule, long energy, long now) {
        long newEnergyUsage;
        long energyUsage = accountCapsule.getEnergyUsage();
        long latestConsumeTime = accountCapsule.getAccountResource().getLatestConsumeTimeForEnergy();
        long energyLimit = this.calculateGlobalEnergyLimit(accountCapsule);
        if (energy > energyLimit - (newEnergyUsage = !this.dynamicPropertiesStore.supportUnfreezeDelay() ? this.increase(energyUsage, 0L, latestConsumeTime, now) : this.recovery(accountCapsule, Common.ResourceCode.ENERGY, energyUsage, latestConsumeTime, now)) && this.dynamicPropertiesStore.getAllowTvmFreeze() == 0L && !this.dynamicPropertiesStore.supportUnfreezeDelay()) {
            return false;
        }
        long latestOperationTime = this.dynamicPropertiesStore.getLatestBlockHeaderTimestamp();
        newEnergyUsage = !this.dynamicPropertiesStore.supportUnfreezeDelay() ? this.increase(newEnergyUsage, energy, now, now) : this.increase(accountCapsule, Common.ResourceCode.ENERGY, energyUsage, energy, latestConsumeTime, now);
        accountCapsule.setEnergyUsage(newEnergyUsage);
        accountCapsule.setLatestOperationTime(latestOperationTime);
        accountCapsule.setLatestConsumeTimeForEnergy(now);
        this.accountStore.put(accountCapsule.createDbKey(), accountCapsule);
        if (this.dynamicPropertiesStore.getAllowAdaptiveEnergy() == 1L) {
            long blockEnergyUsage = this.dynamicPropertiesStore.getBlockEnergyUsage() + energy;
            this.dynamicPropertiesStore.saveBlockEnergyUsage(blockEnergyUsage);
        }
        return true;
    }

    public long calculateGlobalEnergyLimit(AccountCapsule accountCapsule) {
        long frozeBalance = accountCapsule.getAllFrozenBalanceForEnergy();
        if (this.dynamicPropertiesStore.supportUnfreezeDelay()) {
            return this.calculateGlobalEnergyLimitV2(frozeBalance);
        }
        if (frozeBalance < 1000000L) {
            return 0L;
        }
        long energyWeight = frozeBalance / 1000000L;
        long totalEnergyLimit = this.dynamicPropertiesStore.getTotalEnergyCurrentLimit();
        long totalEnergyWeight = this.dynamicPropertiesStore.getTotalEnergyWeight();
        if (this.dynamicPropertiesStore.allowNewReward() && totalEnergyWeight <= 0L) {
            return 0L;
        }
        assert (totalEnergyWeight > 0L);
        return (long)((double)energyWeight * ((double)totalEnergyLimit / (double)totalEnergyWeight));
    }

    public long calculateGlobalEnergyLimitV2(long frozeBalance) {
        double energyWeight = (double)frozeBalance / 1000000.0;
        long totalEnergyLimit = this.dynamicPropertiesStore.getTotalEnergyCurrentLimit();
        long totalEnergyWeight = this.dynamicPropertiesStore.getTotalEnergyWeight();
        if (totalEnergyWeight == 0L) {
            return 0L;
        }
        return (long)(energyWeight * ((double)totalEnergyLimit / (double)totalEnergyWeight));
    }

    public long getAccountLeftEnergyFromFreeze(AccountCapsule accountCapsule) {
        long now = this.getHeadSlot();
        long energyUsage = accountCapsule.getEnergyUsage();
        long latestConsumeTime = accountCapsule.getAccountResource().getLatestConsumeTimeForEnergy();
        long energyLimit = this.calculateGlobalEnergyLimit(accountCapsule);
        long newEnergyUsage = this.recovery(accountCapsule, Common.ResourceCode.ENERGY, energyUsage, latestConsumeTime, now);
        return Long.max(energyLimit - newEnergyUsage, 0L);
    }

    private long getHeadSlot() {
        return EnergyProcessor.getHeadSlot(this.dynamicPropertiesStore);
    }
}

