/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeProcessor {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private long supply;

    public ExchangeProcessor(long supply) {
        this.supply = supply;
    }

    private long exchangeToSupply(long balance, long quant) {
        logger.debug("balance: " + balance);
        long newBalance = balance + quant;
        logger.debug("balance + quant: " + newBalance);
        double issuedSupply = (double)(-this.supply) * (1.0 - Math.pow(1.0 + (double)quant / (double)newBalance, 5.0E-4));
        logger.debug("issuedSupply: " + issuedSupply);
        long out = (long)issuedSupply;
        this.supply += out;
        return out;
    }

    private long exchangeFromSupply(long balance, long supplyQuant) {
        this.supply -= supplyQuant;
        double exchangeBalance = (double)balance * (Math.pow(1.0 + (double)supplyQuant / (double)this.supply, 2000.0) - 1.0);
        logger.debug("exchangeBalance: " + exchangeBalance);
        return (long)exchangeBalance;
    }

    public long exchange(long sellTokenBalance, long buyTokenBalance, long sellTokenQuant) {
        long relay = this.exchangeToSupply(sellTokenBalance, sellTokenQuant);
        return this.exchangeFromSupply(buyTokenBalance, relay);
    }
}

