/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.contract.AssetIssueContractOuterClass;

public class AssetIssueCapsule
implements ProtoCapsule<AssetIssueContractOuterClass.AssetIssueContract> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private AssetIssueContractOuterClass.AssetIssueContract assetIssueContract;

    public AssetIssueCapsule(byte[] data) {
        try {
            this.assetIssueContract = AssetIssueContractOuterClass.AssetIssueContract.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage());
        }
    }

    public AssetIssueCapsule(AssetIssueContractOuterClass.AssetIssueContract assetIssueContract) {
        this.assetIssueContract = assetIssueContract;
    }

    public AssetIssueCapsule(byte[] ownerAddress, String id, String name, String abbr, long totalSupply, int precision) {
        this.assetIssueContract = AssetIssueContractOuterClass.AssetIssueContract.newBuilder().setOwnerAddress(ByteString.copyFrom((byte[])ownerAddress)).setId(id).setName(ByteString.copyFrom((byte[])name.getBytes())).setAbbr(ByteString.copyFrom((byte[])abbr.getBytes())).setTotalSupply(totalSupply).setPrecision(precision).build();
    }

    public static String createDbKeyString(String name, long order) {
        return name + "_" + order;
    }

    @Override
    public byte[] getData() {
        return this.assetIssueContract.toByteArray();
    }

    @Override
    public AssetIssueContractOuterClass.AssetIssueContract getInstance() {
        return this.assetIssueContract;
    }

    public String toString() {
        return this.assetIssueContract.toString();
    }

    public ByteString getName() {
        return this.assetIssueContract.getName();
    }

    public String getId() {
        return this.assetIssueContract.getId();
    }

    public void setId(String id) {
        this.assetIssueContract = this.assetIssueContract.toBuilder().setId(id).build();
    }

    public int getPrecision() {
        return this.assetIssueContract.getPrecision();
    }

    public void setPrecision(int precision) {
        this.assetIssueContract = this.assetIssueContract.toBuilder().setPrecision(precision).build();
    }

    public long getOrder() {
        return this.assetIssueContract.getOrder();
    }

    public void setOrder(long order) {
        this.assetIssueContract = this.assetIssueContract.toBuilder().setOrder(order).build();
    }

    public byte[] createDbV2Key() {
        return ByteArray.fromString((String)this.assetIssueContract.getId());
    }

    public byte[] createDbKey() {
        return this.getName().toByteArray();
    }

    public byte[] createDbKeyFinal(DynamicPropertiesStore dynamicPropertiesStore) {
        if (dynamicPropertiesStore.getAllowSameTokenName() == 0L) {
            return this.createDbKey();
        }
        return this.createDbV2Key();
    }

    public int getNum() {
        return this.assetIssueContract.getNum();
    }

    public int getTrxNum() {
        return this.assetIssueContract.getTrxNum();
    }

    public long getStartTime() {
        return this.assetIssueContract.getStartTime();
    }

    public long getEndTime() {
        return this.assetIssueContract.getEndTime();
    }

    public ByteString getOwnerAddress() {
        return this.assetIssueContract.getOwnerAddress();
    }

    public int getFrozenSupplyCount() {
        return this.getInstance().getFrozenSupplyCount();
    }

    public List<AssetIssueContractOuterClass.AssetIssueContract.FrozenSupply> getFrozenSupplyList() {
        return this.getInstance().getFrozenSupplyList();
    }

    public long getFrozenSupply() {
        List<AssetIssueContractOuterClass.AssetIssueContract.FrozenSupply> frozenList = this.getFrozenSupplyList();
        long[] frozenBalance = new long[]{0L};
        frozenList.forEach(frozen -> {
            frozenBalance[0] = Long.sum(frozenBalance[0], frozen.getFrozenAmount());
        });
        return frozenBalance[0];
    }

    public long getFreeAssetNetLimit() {
        return this.assetIssueContract.getFreeAssetNetLimit();
    }

    public void setFreeAssetNetLimit(long newLimit) {
        this.assetIssueContract = this.assetIssueContract.toBuilder().setFreeAssetNetLimit(newLimit).build();
    }

    public long getPublicFreeAssetNetLimit() {
        return this.assetIssueContract.getPublicFreeAssetNetLimit();
    }

    public void setPublicFreeAssetNetLimit(long newPublicLimit) {
        this.assetIssueContract = this.assetIssueContract.toBuilder().setPublicFreeAssetNetLimit(newPublicLimit).build();
    }

    public long getPublicFreeAssetNetUsage() {
        return this.assetIssueContract.getPublicFreeAssetNetUsage();
    }

    public void setPublicFreeAssetNetUsage(long value) {
        this.assetIssueContract = this.assetIssueContract.toBuilder().setPublicFreeAssetNetUsage(value).build();
    }

    public long getPublicLatestFreeNetTime() {
        return this.assetIssueContract.getPublicLatestFreeNetTime();
    }

    public void setPublicLatestFreeNetTime(long time) {
        this.assetIssueContract = this.assetIssueContract.toBuilder().setPublicLatestFreeNetTime(time).build();
    }

    public void setUrl(ByteString newUrl) {
        this.assetIssueContract = this.assetIssueContract.toBuilder().setUrl(newUrl).build();
    }

    public ByteString getUrl() {
        return this.assetIssueContract.getUrl();
    }

    public void setDescription(ByteString description) {
        this.assetIssueContract = this.assetIssueContract.toBuilder().setDescription(description).build();
    }

    public ByteString getDesc() {
        return this.assetIssueContract.getDescription();
    }
}

