/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.zksnark;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.ByteUtil;
import org.tron.core.exception.ZksnarkException;

public class MerklePath {
    private List<List<Boolean>> authenticationPath;
    private List<Boolean> index;

    public MerklePath(List<List<Boolean>> authenticationPath, List<Boolean> index) {
        this.authenticationPath = authenticationPath;
        this.index = index;
    }

    private static byte[] listList2Bytes(List<List<Byte>> v) {
        ArrayList resultList = Lists.newArrayList();
        resultList.add(MerklePath.writeCompactSize(v.size()));
        for (List<Byte> list : v) {
            resultList.add(MerklePath.writeCompactSize(list.size()));
            for (Byte b : list) {
                byte[] bytes2 = new byte[]{b};
                resultList.add(bytes2);
            }
        }
        int sum = resultList.stream().mapToInt(bytes -> ((byte[])bytes).length).sum();
        byte[] resultBytes = new byte[sum];
        int index = 0;
        for (byte[] bytes2 : resultList) {
            System.arraycopy(bytes2, 0, resultBytes, index, bytes2.length);
            index += bytes2.length;
        }
        return resultBytes;
    }

    private static byte[] writeCompactSize(long nSize) {
        byte[] result;
        if (nSize < 253L) {
            result = new byte[]{(byte)nSize};
        } else if (nSize <= 65535L) {
            result = new byte[]{-3, (byte)nSize, (byte)(nSize >> 8)};
        } else if (nSize <= -1L) {
            result = new byte[4];
            System.arraycopy(ByteArray.fromInt((int)((int)nSize)), 0, result, 1, 8);
        } else {
            result = new byte[5];
            System.arraycopy(ByteArray.fromLong((long)nSize), 0, result, 1, 8);
        }
        return result;
    }

    private static long convertVectorToLong(List<Boolean> v) throws ZksnarkException {
        if (v.size() > 64) {
            throw new ZksnarkException("boolean vector can't be larger than 64 bits");
        }
        long result = 0L;
        for (int i = 0; i < v.size(); ++i) {
            if (!v.get(i).booleanValue()) continue;
            result |= 1L << v.size() - 1 - i;
        }
        return result;
    }

    public byte[] encode() throws ZksnarkException {
        assert (this.authenticationPath.size() == this.index.size());
        ArrayList pathByteList = Lists.newArrayList();
        for (int i = 0; i < this.authenticationPath.size(); ++i) {
            pathByteList.add(Lists.newArrayList());
            for (int p = 0; p < this.authenticationPath.get(i).size(); ++p) {
                int i1;
                byte bByte = (byte)(this.authenticationPath.get(i).get(p) != false ? 1 : 0);
                if (((List)pathByteList.get(i)).size() > p / 8) {
                    i1 = (Byte)((List)pathByteList.get(i)).get(p / 8) | bByte << 7 - p % 8;
                    ((List)pathByteList.get(i)).set(p / 8, (byte)i1);
                    continue;
                }
                i1 = bByte << 7 - p % 8;
                ((List)pathByteList.get(i)).add((byte)i1);
            }
        }
        long indexLong = MerklePath.convertVectorToLong(this.index);
        byte[] indexBytes = ByteArray.fromLong((long)indexLong);
        ByteUtil.reverse((byte[])indexBytes);
        byte[] pathByteArray = MerklePath.listList2Bytes(pathByteList);
        byte[] result = new byte[pathByteArray.length + 8];
        System.arraycopy(pathByteArray, 0, result, 0, pathByteArray.length);
        System.arraycopy(indexBytes, 0, result, pathByteArray.length, 8);
        return result;
    }

    public List<List<Boolean>> getAuthenticationPath() {
        return this.authenticationPath;
    }

    public List<Boolean> getIndex() {
        return this.index;
    }
}

