/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.storage.rocksdb;

import com.google.common.collect.Sets;
import com.google.common.primitives.Bytes;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.rocksdb.AbstractComparator;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Cache;
import org.rocksdb.Checkpoint;
import org.rocksdb.DirectComparator;
import org.rocksdb.Filter;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Statistics;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.setting.RocksDbSettings;
import org.tron.common.storage.WriteOptionsWrapper;
import org.tron.common.storage.metric.DbStat;
import org.tron.common.utils.FileUtil;
import org.tron.common.utils.PropUtil;
import org.tron.core.db.common.DbSourceInter;
import org.tron.core.db.common.iterator.DBIterator;
import org.tron.core.db.common.iterator.RockStoreIterator;
import org.tron.core.db2.common.Instance;
import org.tron.core.db2.common.WrappedByteArray;

public class RocksDbDataSourceImpl
extends DbStat
implements DbSourceInter<byte[]>,
Iterable<Map.Entry<byte[], byte[]>>,
Instance<RocksDbDataSourceImpl> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    ReadOptions readOpts;
    private String dataBaseName;
    private RocksDB database;
    private volatile boolean alive;
    private String parentPath;
    private ReadWriteLock resetDbLock = new ReentrantReadWriteLock();
    private static final String KEY_ENGINE = "ENGINE";
    private static final String ROCKSDB = "ROCKSDB";
    private DirectComparator comparator;
    private static final Logger rocksDbLogger = LoggerFactory.getLogger((String)"ROCKSDB");

    public RocksDbDataSourceImpl(String parentPath, String name, RocksDbSettings settings, DirectComparator comparator) {
        this.dataBaseName = name;
        this.parentPath = parentPath;
        this.comparator = comparator;
        RocksDbSettings.setRocksDbSettings((RocksDbSettings)settings);
        this.initDB();
    }

    public RocksDbDataSourceImpl(String parentPath, String name, RocksDbSettings settings) {
        this.dataBaseName = name;
        this.parentPath = parentPath;
        RocksDbSettings.setRocksDbSettings((RocksDbSettings)settings);
        this.initDB();
    }

    public RocksDbDataSourceImpl(String parentPath, String name) {
        this.parentPath = parentPath;
        this.dataBaseName = name;
    }

    public Path getDbPath() {
        return Paths.get(this.parentPath, this.dataBaseName);
    }

    public RocksDB getDatabase() {
        return this.database;
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    @Override
    public void closeDB() {
        this.resetDbLock.writeLock().lock();
        try {
            if (!this.isAlive()) {
                return;
            }
            this.database.close();
            this.alive = false;
        }
        catch (Exception e) {
            logger.error("Failed to find the dbStore file on the closeDB: {}.", (Object)this.dataBaseName, (Object)e);
        }
        finally {
            this.resetDbLock.writeLock().unlock();
        }
    }

    @Override
    public void resetDb() {
        this.resetDbLock.writeLock().lock();
        try {
            this.closeDB();
            FileUtil.recursiveDelete((String)this.getDbPath().toString());
            this.initDB();
        }
        finally {
            this.resetDbLock.writeLock().unlock();
        }
    }

    private boolean quitIfNotAlive() {
        if (!this.isAlive()) {
            logger.warn("DB {} is not alive.", (Object)this.dataBaseName);
        }
        return !this.isAlive();
    }

    /*
     * Loose catch block
     */
    @Override
    public Set<byte[]> allKeys() throws RuntimeException {
        this.resetDbLock.readLock().lock();
        try {
            if (this.quitIfNotAlive()) {
                Set<byte[]> set = null;
                return set;
            }
            HashSet result = Sets.newHashSet();
            try (RocksIterator iter = this.getRocksIterator();){
                iter.seekToFirst();
                while (iter.isValid()) {
                    result.add(iter.key());
                    iter.next();
                }
                HashSet hashSet = result;
                return hashSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    @Override
    public Set<byte[]> allValues() throws RuntimeException {
        return null;
    }

    @Override
    public long getTotal() throws RuntimeException {
        return 0L;
    }

    @Override
    public String getDBName() {
        return this.dataBaseName;
    }

    @Override
    public void setDBName(String name) {
    }

    public boolean checkOrInitEngine() {
        String dir = this.getDbPath().toString();
        String enginePath = dir + File.separator + "engine.properties";
        if (FileUtil.createDirIfNotExists((String)dir)) {
            if (!FileUtil.createFileIfNotExists((String)enginePath)) {
                return false;
            }
        } else {
            return false;
        }
        String engine = PropUtil.readProperty((String)enginePath, (String)KEY_ENGINE);
        if (engine.isEmpty() && !PropUtil.writeProperty((String)enginePath, (String)KEY_ENGINE, (String)ROCKSDB)) {
            return false;
        }
        engine = PropUtil.readProperty((String)enginePath, (String)KEY_ENGINE);
        return ROCKSDB.equals(engine);
    }

    @Override
    public void initDB() {
        if (!this.checkOrInitEngine()) {
            throw new RuntimeException(String.format("failed to check database: %s, engine do not match", this.dataBaseName));
        }
        this.initDB(RocksDbSettings.getSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDB(RocksDbSettings settings) {
        this.resetDbLock.writeLock().lock();
        try {
            if (this.isAlive()) {
                return;
            }
            if (this.dataBaseName == null) {
                throw new IllegalArgumentException("No name set to the dbStore");
            }
            try (Options options = new Options();){
                if (settings.isEnableStatistics()) {
                    options.setStatistics(new Statistics());
                    options.setStatsDumpPeriodSec(60);
                }
                options.setCreateIfMissing(true);
                options.setIncreaseParallelism(1);
                options.setLevelCompactionDynamicLevelBytes(true);
                options.setMaxOpenFiles(settings.getMaxOpenFiles());
                options.setNumLevels(settings.getLevelNumber());
                options.setMaxBytesForLevelMultiplier(settings.getMaxBytesForLevelMultiplier());
                options.setMaxBytesForLevelBase(settings.getMaxBytesForLevelBase());
                options.setMaxBackgroundCompactions(settings.getCompactThreads());
                options.setLevel0FileNumCompactionTrigger(settings.getLevel0FileNumCompactionTrigger());
                options.setTargetFileSizeMultiplier(settings.getTargetFileSizeMultiplier());
                options.setTargetFileSizeBase(settings.getTargetFileSizeBase());
                if (this.comparator != null) {
                    options.setComparator((AbstractComparator)this.comparator);
                }
                options.setLogger(new org.rocksdb.Logger(options){

                    protected void log(InfoLogLevel infoLogLevel, String logMsg) {
                        rocksDbLogger.info("{} {}", (Object)RocksDbDataSourceImpl.this.dataBaseName, (Object)logMsg);
                    }
                });
                BlockBasedTableConfig tableCfg = new BlockBasedTableConfig();
                options.setTableFormatConfig((TableFormatConfig)tableCfg);
                tableCfg.setBlockSize(settings.getBlockSize());
                tableCfg.setBlockCache((Cache)RocksDbSettings.getCache());
                tableCfg.setCacheIndexAndFilterBlocks(true);
                tableCfg.setPinL0FilterAndIndexBlocksInCache(true);
                tableCfg.setFilter((Filter)new BloomFilter(10, false));
                this.readOpts = new ReadOptions();
                this.readOpts = this.readOpts.setPrefixSameAsStart(true).setVerifyChecksums(false);
                try {
                    logger.debug("Opening database {}.", (Object)this.dataBaseName);
                    Path dbPath = this.getDbPath();
                    if (!Files.isSymbolicLink(dbPath.getParent())) {
                        Files.createDirectories(dbPath.getParent(), new FileAttribute[0]);
                    }
                    try {
                        this.database = RocksDB.open((Options)options, (String)dbPath.toString());
                    }
                    catch (RocksDBException e) {
                        throw new RuntimeException(String.format("failed to open database: %s", this.dataBaseName), e);
                    }
                    this.alive = true;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(String.format("failed to init database: %s", this.dataBaseName), ioe);
                }
                logger.debug("Init DB {} done.", (Object)this.dataBaseName);
            }
        }
        finally {
            this.resetDbLock.writeLock().unlock();
        }
    }

    @Override
    public void putData(byte[] key, byte[] value) {
        this.resetDbLock.readLock().lock();
        try {
            if (this.quitIfNotAlive()) {
                return;
            }
            this.database.put(key, value);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(this.dataBaseName, e);
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    @Override
    public byte[] getData(byte[] key) {
        this.resetDbLock.readLock().lock();
        try {
            if (this.quitIfNotAlive()) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = this.database.get(key);
            return byArray;
        }
        catch (RocksDBException e) {
            throw new RuntimeException(this.dataBaseName, e);
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    @Override
    public void deleteData(byte[] key) {
        this.resetDbLock.readLock().lock();
        try {
            if (this.quitIfNotAlive()) {
                return;
            }
            this.database.delete(key);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(this.dataBaseName, e);
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    @Override
    public boolean flush() {
        return false;
    }

    public DBIterator iterator() {
        return new RockStoreIterator(this.getRocksIterator());
    }

    private void updateByBatchInner(Map<byte[], byte[]> rows) throws Exception {
        if (this.quitIfNotAlive()) {
            return;
        }
        try (WriteBatch batch = new WriteBatch();){
            for (Map.Entry<byte[], byte[]> entry : rows.entrySet()) {
                if (entry.getValue() == null) {
                    batch.delete(entry.getKey());
                    continue;
                }
                batch.put(entry.getKey(), entry.getValue());
            }
            this.database.write(new WriteOptions(), batch);
        }
    }

    private void updateByBatchInner(Map<byte[], byte[]> rows, WriteOptions options) throws Exception {
        if (this.quitIfNotAlive()) {
            return;
        }
        try (WriteBatch batch = new WriteBatch();){
            for (Map.Entry<byte[], byte[]> entry : rows.entrySet()) {
                if (entry.getValue() == null) {
                    batch.delete(entry.getKey());
                    continue;
                }
                batch.put(entry.getKey(), entry.getValue());
            }
            this.database.write(options, batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateByBatch(Map<byte[], byte[]> rows, WriteOptionsWrapper optionsWrapper) {
        this.resetDbLock.readLock().lock();
        try {
            if (this.quitIfNotAlive()) {
                return;
            }
            this.updateByBatchInner(rows, optionsWrapper.rocks);
        }
        catch (Exception e) {
            try {
                this.updateByBatchInner(rows);
            }
            catch (Exception e1) {
                throw new RuntimeException(this.dataBaseName, e1);
            }
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateByBatch(Map<byte[], byte[]> rows) {
        this.resetDbLock.readLock().lock();
        try {
            if (this.quitIfNotAlive()) {
                return;
            }
            this.updateByBatchInner(rows);
        }
        catch (Exception e) {
            try {
                this.updateByBatchInner(rows);
            }
            catch (Exception e1) {
                throw new RuntimeException(this.dataBaseName, e1);
            }
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    /*
     * Loose catch block
     */
    public List<byte[]> getKeysNext(byte[] key, long limit) {
        this.resetDbLock.readLock().lock();
        try {
            if (this.quitIfNotAlive()) {
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                return arrayList;
            }
            if (limit <= 0L) {
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                return arrayList;
            }
            try (RocksIterator iter = this.getRocksIterator();){
                ArrayList<byte[]> result = new ArrayList<byte[]>();
                iter.seek(key);
                for (long i = 0L; iter.isValid() && i < limit; ++i) {
                    result.add(iter.key());
                    iter.next();
                }
                ArrayList<byte[]> arrayList = result;
                return arrayList;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    /*
     * Loose catch block
     */
    public Map<byte[], byte[]> getNext(byte[] key, long limit) {
        this.resetDbLock.readLock().lock();
        try {
            if (this.quitIfNotAlive()) {
                Map<byte[], byte[]> map = null;
                return map;
            }
            if (limit <= 0L) {
                Map<byte[], byte[]> map = Collections.emptyMap();
                return map;
            }
            try (RocksIterator iter = this.getRocksIterator();){
                HashMap<byte[], byte[]> result = new HashMap<byte[], byte[]>();
                iter.seek(key);
                for (long i = 0L; iter.isValid() && i < limit; ++i) {
                    result.put(iter.key(), iter.value());
                    iter.next();
                }
                HashMap<byte[], byte[]> hashMap = result;
                return hashMap;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Map<WrappedByteArray, byte[]> prefixQuery(byte[] key) {
        this.resetDbLock.readLock().lock();
        try {
            HashMap<WrappedByteArray, byte[]> hashMap;
            if (this.quitIfNotAlive()) {
                Map<WrappedByteArray, byte[]> map = null;
                return map;
            }
            try (RocksIterator iterator = this.getRocksIterator();){
                HashMap<WrappedByteArray, byte[]> result = new HashMap<WrappedByteArray, byte[]>();
                iterator.seek(key);
                while (iterator.isValid()) {
                    if (Bytes.indexOf((byte[])iterator.key(), (byte[])key) != 0) {
                        HashMap<WrappedByteArray, byte[]> hashMap2 = result;
                        return hashMap2;
                    }
                    result.put(WrappedByteArray.of(iterator.key()), iterator.value());
                    iterator.next();
                }
                hashMap = result;
            }
            return hashMap;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    /*
     * Loose catch block
     */
    public Set<byte[]> getlatestValues(long limit) {
        this.resetDbLock.readLock().lock();
        try {
            if (this.quitIfNotAlive()) {
                Set<byte[]> set = null;
                return set;
            }
            if (limit <= 0L) {
                HashSet hashSet = Sets.newHashSet();
                return hashSet;
            }
            try (RocksIterator iter = this.getRocksIterator();){
                HashSet result = Sets.newHashSet();
                iter.seekToLast();
                for (long i = 0L; iter.isValid() && i < limit; ++i) {
                    result.add(iter.value());
                    iter.prev();
                }
                HashSet hashSet = result;
                return hashSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    /*
     * Loose catch block
     */
    public Set<byte[]> getValuesNext(byte[] key, long limit) {
        this.resetDbLock.readLock().lock();
        try {
            if (this.quitIfNotAlive()) {
                Set<byte[]> set = null;
                return set;
            }
            if (limit <= 0L) {
                HashSet hashSet = Sets.newHashSet();
                return hashSet;
            }
            try (RocksIterator iter = this.getRocksIterator();){
                HashSet result = Sets.newHashSet();
                iter.seek(key);
                for (long i = 0L; iter.isValid() && i < limit; ++i) {
                    result.add(iter.value());
                    iter.next();
                }
                HashSet hashSet = result;
                return hashSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    public void backup(String dir) throws RocksDBException {
        Checkpoint cp = Checkpoint.create((RocksDB)this.database);
        cp.createCheckpoint(dir + this.getDBName());
    }

    private RocksIterator getRocksIterator() {
        try (ReadOptions readOptions = new ReadOptions().setFillCache(false);){
            RocksIterator rocksIterator = this.database.newIterator(readOptions);
            return rocksIterator;
        }
    }

    public boolean deleteDbBakPath(String dir) {
        return FileUtil.deleteDir((File)new File(dir + this.getDBName()));
    }

    @Override
    public RocksDbDataSourceImpl newInstance() {
        return new RocksDbDataSourceImpl(this.parentPath, this.dataBaseName, RocksDbSettings.getSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getStats() throws Exception {
        this.resetDbLock.readLock().lock();
        try {
            if (!this.isAlive()) {
                List<String> list = Collections.emptyList();
                return list;
            }
            String stat = this.database.getProperty("rocksdb.levelstats");
            String[] stats = stat.split("\n");
            List<String> list = Arrays.stream(stats).skip(2L).collect(Collectors.toList());
            return list;
        }
        finally {
            this.resetDbLock.readLock().unlock();
        }
    }

    @Override
    public String getEngine() {
        return ROCKSDB;
    }

    @Override
    public String getName() {
        return this.dataBaseName;
    }

    @Override
    public void stat() {
        this.statProperty();
    }

    public RocksDbDataSourceImpl() {
    }
}

