/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.exception.ItemNotFoundException;

@Component
public class TreeBlockIndexStore
extends TronStoreWithRevoking<BytesCapsule> {
    @Autowired
    public TreeBlockIndexStore(@Value(value="tree-block-index") String dbName) {
        super(dbName);
    }

    public void put(long number, byte[] key) {
        this.put(ByteArray.fromLong((long)number), new BytesCapsule(key));
    }

    public byte[] get(Long num) throws ItemNotFoundException {
        BytesCapsule value = (BytesCapsule)this.getUnchecked(ByteArray.fromLong((long)num));
        if (value == null || value.getData() == null) {
            throw new ItemNotFoundException(String.format("number: %d is not found!", num));
        }
        return value.getData();
    }

    @Override
    public BytesCapsule get(byte[] key) throws ItemNotFoundException {
        byte[] value = this.revokingDB.getUnchecked(key);
        if (ArrayUtils.isEmpty((byte[])value)) {
            throw new ItemNotFoundException(String.format("number: %d is not found!", ByteArray.toLong((byte[])key)));
        }
        return new BytesCapsule(value);
    }
}

