/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.ProposalCapsule;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.protos.Protocol;

@Component
public class ProposalStore
extends TronStoreWithRevoking<ProposalCapsule> {
    @Autowired
    public ProposalStore(@Value(value="proposal") String dbName) {
        super(dbName);
    }

    @Override
    public ProposalCapsule get(byte[] key) throws ItemNotFoundException {
        byte[] value = this.revokingDB.get(key);
        return new ProposalCapsule(value);
    }

    public List<ProposalCapsule> getAllProposals() {
        return Streams.stream(this.iterator()).map(Map.Entry::getValue).sorted((a, b) -> a.getCreateTime() <= b.getCreateTime() ? 1 : -1).collect(Collectors.toList());
    }

    public List<ProposalCapsule> getSpecifiedProposals(Protocol.Proposal.State state, long code2) {
        return Streams.stream(this.iterator()).map(Map.Entry::getValue).filter(proposalCapsule -> proposalCapsule.getState().equals((Object)state)).filter(proposalCapsule -> proposalCapsule.getParameters().containsKey(code2)).sorted((a, b) -> a.getExpirationTime() > b.getExpirationTime() ? 1 : -1).collect(Collectors.toList());
    }
}

