/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.ExchangeCapsule;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.exception.ItemNotFoundException;

@Component
public class ExchangeStore
extends TronStoreWithRevoking<ExchangeCapsule> {
    @Autowired
    protected ExchangeStore(@Value(value="exchange") String dbName) {
        super(dbName);
    }

    @Override
    public ExchangeCapsule get(byte[] key) throws ItemNotFoundException {
        byte[] value = this.revokingDB.get(key);
        return new ExchangeCapsule(value);
    }

    public List<ExchangeCapsule> getAllExchanges() {
        return Streams.stream(this.iterator()).map(Map.Entry::getValue).sorted((a, b) -> a.getCreateTime() <= b.getCreateTime() ? 1 : -1).collect(Collectors.toList());
    }
}

