/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.db.TronStoreWithRevoking;

@Component
public class AssetIssueStore
extends TronStoreWithRevoking<AssetIssueCapsule> {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");

    @Autowired
    protected AssetIssueStore(@Value(value="asset-issue") String dbName) {
        super(dbName);
    }

    @Override
    public AssetIssueCapsule get(byte[] key) {
        return (AssetIssueCapsule)super.getUnchecked(key);
    }

    public List<AssetIssueCapsule> getAllAssetIssues() {
        return Streams.stream(this.iterator()).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private List<AssetIssueCapsule> getAssetIssuesPaginated(List<AssetIssueCapsule> assetIssueList, long offset, long limit) {
        if (limit < 0L || offset < 0L) {
            return null;
        }
        if ((long)assetIssueList.size() <= offset) {
            return null;
        }
        assetIssueList.sort((o1, o2) -> {
            if (o1.getName() != o2.getName()) {
                return o1.getName().toStringUtf8().compareTo(o2.getName().toStringUtf8());
            }
            return Long.compare(o1.getOrder(), o2.getOrder());
        });
        limit = limit > 1000L ? 1000L : limit;
        long end = offset + limit;
        end = end > (long)assetIssueList.size() ? (long)assetIssueList.size() : end;
        return assetIssueList.subList((int)offset, (int)end);
    }

    public List<AssetIssueCapsule> getAssetIssuesPaginated(long offset, long limit) {
        return this.getAssetIssuesPaginated(this.getAllAssetIssues(), offset, limit);
    }
}

