/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.store;

import com.google.protobuf.ByteString;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.db.TronStoreWithRevoking;

@Component
public class AccountIdIndexStore
extends TronStoreWithRevoking<BytesCapsule> {
    @Autowired
    public AccountIdIndexStore(@Value(value="accountid-index") String dbName) {
        super(dbName);
    }

    private static byte[] getLowerCaseAccountId(byte[] bsAccountId) {
        return ByteString.copyFromUtf8((String)ByteString.copyFrom((byte[])bsAccountId).toStringUtf8().toLowerCase()).toByteArray();
    }

    public void put(AccountCapsule accountCapsule) {
        byte[] lowerCaseAccountId = AccountIdIndexStore.getLowerCaseAccountId(accountCapsule.getAccountId().toByteArray());
        super.put(lowerCaseAccountId, new BytesCapsule(accountCapsule.getAddress().toByteArray()));
    }

    public byte[] get(ByteString name) {
        BytesCapsule bytesCapsule = this.get(name.toByteArray());
        if (Objects.nonNull(bytesCapsule)) {
            return bytesCapsule.getData();
        }
        return null;
    }

    @Override
    public BytesCapsule get(byte[] key) {
        byte[] lowerCaseKey = AccountIdIndexStore.getLowerCaseAccountId(key);
        byte[] value = this.revokingDB.getUnchecked(lowerCaseKey);
        if (ArrayUtils.isEmpty((byte[])value)) {
            return null;
        }
        return new BytesCapsule(value);
    }

    @Override
    public boolean has(byte[] key) {
        byte[] lowerCaseKey = AccountIdIndexStore.getLowerCaseAccountId(key);
        byte[] value = this.revokingDB.getUnchecked(lowerCaseKey);
        return !ArrayUtils.isEmpty((byte[])value);
    }
}

