/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.message;

import java.util.HashMap;
import java.util.Map;

public enum MessageTypes {
    FIRST(0),
    TRX(1),
    BLOCK(2),
    TRXS(3),
    BLOCKS(4),
    BLOCKHEADERS(5),
    INVENTORY(6),
    FETCH_INV_DATA(7),
    SYNC_BLOCK_CHAIN(8),
    BLOCK_CHAIN_INVENTORY(9),
    ITEM_NOT_FOUND(16),
    FETCH_BLOCK_HEADERS(17),
    BLOCK_INVENTORY(18),
    TRX_INVENTORY(19),
    PBFT_COMMIT_MSG(20),
    P2P_HELLO(32),
    P2P_DISCONNECT(33),
    P2P_PING(34),
    P2P_PONG(35),
    DISCOVER_PING(48),
    DISCOVER_PONG(49),
    DISCOVER_FIND_PEER(50),
    DISCOVER_PEERS(51),
    PBFT_MSG(52),
    LAST(255);

    private static final Map<Integer, MessageTypes> intToTypeMap;
    private final int type;

    private MessageTypes(int type) {
        this.type = type;
    }

    public static MessageTypes fromByte(byte i) {
        return intToTypeMap.get(i);
    }

    public static boolean inRange(byte code2) {
        return code2 < LAST.asByte();
    }

    public static boolean inP2pRange(byte code2) {
        return code2 <= P2P_PONG.asByte() && code2 >= P2P_HELLO.asByte();
    }

    public static boolean inTronRange(byte code2) {
        return code2 <= PBFT_COMMIT_MSG.asByte() && code2 >= FIRST.asByte();
    }

    public byte asByte() {
        return (byte)this.type;
    }

    public static boolean inPbftRange(byte code2) {
        return code2 == PBFT_MSG.asByte();
    }

    public String toString() {
        switch (this.type) {
            case 1: {
                return "TRX";
            }
            case 2: {
                return "BLOCK";
            }
            case 6: {
                return "INVENTORY";
            }
            case 7: {
                return "FETCH_INV_DATA";
            }
            case 8: {
                return "SYNC_BLOCK_CHAIN";
            }
            case 11: {
                return "BLOCK_INVENTORY";
            }
        }
        return super.toString();
    }

    static {
        intToTypeMap = new HashMap<Integer, MessageTypes>();
        for (MessageTypes type : MessageTypes.values()) {
            intToTypeMap.put(type.type, type);
        }
    }
}

