/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.tron.common.runtime.InternalTransaction;
import org.tron.common.runtime.ProgramResult;
import org.tron.common.runtime.Runtime;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.ForkController;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.StringUtil;
import org.tron.common.utils.WalletUtil;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.ReceiptCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.EnergyProcessor;
import org.tron.core.db.TransactionContext;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.ReceiptCheckErrException;
import org.tron.core.exception.VMIllegalException;
import org.tron.core.store.AbiStore;
import org.tron.core.store.AccountStore;
import org.tron.core.store.CodeStore;
import org.tron.core.store.ContractStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.StoreFactory;
import org.tron.protos.Protocol;
import org.tron.protos.contract.Common;
import org.tron.protos.contract.SmartContractOuterClass;

public class TransactionTrace {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private TransactionCapsule trx;
    private ReceiptCapsule receipt;
    private StoreFactory storeFactory;
    private DynamicPropertiesStore dynamicPropertiesStore;
    private ContractStore contractStore;
    private AccountStore accountStore;
    private CodeStore codeStore;
    private AbiStore abiStore;
    private EnergyProcessor energyProcessor;
    private InternalTransaction.TrxType trxType;
    private long txStartTimeInMs;
    private Runtime runtime;
    private ForkController forkController;
    private TransactionContext transactionContext;
    private TimeResultType timeResultType = TimeResultType.NORMAL;
    private boolean netFeeForBandwidth = true;

    public TransactionTrace(TransactionCapsule trx, StoreFactory storeFactory, Runtime runtime) {
        this.trx = trx;
        Protocol.Transaction.Contract.ContractType contractType = this.trx.getInstance().getRawData().getContract(0).getType();
        switch (contractType.getNumber()) {
            case 31: {
                this.trxType = InternalTransaction.TrxType.TRX_CONTRACT_CALL_TYPE;
                break;
            }
            case 30: {
                this.trxType = InternalTransaction.TrxType.TRX_CONTRACT_CREATION_TYPE;
                break;
            }
            default: {
                this.trxType = InternalTransaction.TrxType.TRX_PRECOMPILED_TYPE;
            }
        }
        this.storeFactory = storeFactory;
        this.dynamicPropertiesStore = storeFactory.getChainBaseManager().getDynamicPropertiesStore();
        this.contractStore = storeFactory.getChainBaseManager().getContractStore();
        this.codeStore = storeFactory.getChainBaseManager().getCodeStore();
        this.abiStore = storeFactory.getChainBaseManager().getAbiStore();
        this.accountStore = storeFactory.getChainBaseManager().getAccountStore();
        this.receipt = new ReceiptCapsule(Sha256Hash.ZERO_HASH);
        this.energyProcessor = new EnergyProcessor(this.dynamicPropertiesStore, this.accountStore);
        this.runtime = runtime;
        this.forkController = new ForkController();
        this.forkController.init(storeFactory.getChainBaseManager());
    }

    public TransactionCapsule getTrx() {
        return this.trx;
    }

    private boolean needVM() {
        return this.trxType == InternalTransaction.TrxType.TRX_CONTRACT_CALL_TYPE || this.trxType == InternalTransaction.TrxType.TRX_CONTRACT_CREATION_TYPE;
    }

    public void init(BlockCapsule blockCap) {
        this.init(blockCap, false);
    }

    public void init(BlockCapsule blockCap, boolean eventPluginLoaded) {
        this.txStartTimeInMs = System.currentTimeMillis();
        this.transactionContext = new TransactionContext(blockCap, this.trx, this.storeFactory, false, eventPluginLoaded);
    }

    public void checkIsConstant() throws ContractValidateException, VMIllegalException {
        if (this.dynamicPropertiesStore.getAllowTvmConstantinople() == 1L) {
            return;
        }
        SmartContractOuterClass.TriggerSmartContract triggerContractFromTransaction = ContractCapsule.getTriggerContractFromTransaction(this.getTrx().getInstance());
        if (InternalTransaction.TrxType.TRX_CONTRACT_CALL_TYPE == this.trxType) {
            ContractCapsule contract = this.contractStore.get(triggerContractFromTransaction.getContractAddress().toByteArray());
            if (contract == null) {
                throw new ContractValidateException(String.format("contract: %s is not in contract store", StringUtil.encode58Check((byte[])triggerContractFromTransaction.getContractAddress().toByteArray())));
            }
            SmartContractOuterClass.SmartContract.ABI abi = contract.getInstance().getAbi();
            if (WalletUtil.isConstant(abi, triggerContractFromTransaction)) {
                throw new VMIllegalException("cannot call constant method");
            }
        }
    }

    public void setBill(long energyUsage) {
        if (energyUsage < 0L) {
            energyUsage = 0L;
        }
        this.receipt.setEnergyUsageTotal(energyUsage);
    }

    public void setPenalty(long energyPenalty) {
        if (energyPenalty < 0L) {
            energyPenalty = 0L;
        }
        this.receipt.setEnergyPenaltyTotal(energyPenalty);
    }

    public void setNetBill(long netUsage, long netFee) {
        this.receipt.setNetUsage(netUsage);
        this.receipt.setNetFee(netFee);
    }

    public void setNetBillForCreateNewAccount(long netUsage, long netFee) {
        this.receipt.setNetUsage(netUsage);
        this.receipt.setNetFee(netFee);
        this.setNetFeeForBandwidth(false);
    }

    public void addNetBill(long netFee) {
        this.receipt.addNetFee(netFee);
    }

    public void exec() throws ContractExeException, ContractValidateException, VMIllegalException {
        this.runtime.execute(this.transactionContext);
        this.setBill(this.transactionContext.getProgramResult().getEnergyUsed());
        this.setPenalty(this.transactionContext.getProgramResult().getEnergyPenaltyTotal());
    }

    public void saveEnergyLeftOfOrigin(long energyLeft) {
        this.receipt.setOriginEnergyLeft(energyLeft);
    }

    public void saveEnergyLeftOfCaller(long energyLeft) {
        this.receipt.setCallerEnergyLeft(energyLeft);
    }

    public void finalization() throws ContractExeException {
        try {
            this.pay();
        }
        catch (BalanceInsufficientException e) {
            throw new ContractExeException(e.getMessage());
        }
        if (StringUtils.isEmpty((Object)this.transactionContext.getProgramResult().getRuntimeError())) {
            for (DataWord contract : this.transactionContext.getProgramResult().getDeleteAccounts()) {
                this.deleteContract(contract.toTronAddress());
            }
        }
    }

    public void pay() throws BalanceInsufficientException {
        byte[] originAccount;
        byte[] callerAccount;
        long percent = 0L;
        long originEnergyLimit = 0L;
        switch (this.trxType) {
            case TRX_CONTRACT_CREATION_TYPE: {
                originAccount = callerAccount = this.trx.getOwnerAddress();
                break;
            }
            case TRX_CONTRACT_CALL_TYPE: {
                SmartContractOuterClass.TriggerSmartContract callContract = ContractCapsule.getTriggerContractFromTransaction(this.trx.getInstance());
                ContractCapsule contractCapsule = this.contractStore.get(callContract.getContractAddress().toByteArray());
                callerAccount = callContract.getOwnerAddress().toByteArray();
                originAccount = contractCapsule.getOriginAddress();
                percent = Math.max(100L - contractCapsule.getConsumeUserResourcePercent(), 0L);
                percent = Math.min(percent, 100L);
                originEnergyLimit = contractCapsule.getOriginEnergyLimit();
                break;
            }
            default: {
                return;
            }
        }
        AccountCapsule origin = this.accountStore.get(originAccount);
        AccountCapsule caller = this.accountStore.get(callerAccount);
        if (this.dynamicPropertiesStore.supportUnfreezeDelay() && this.getRuntimeResult().getException() == null && !this.getRuntimeResult().isRevert()) {
            if (origin != null && !caller.getAddress().equals((Object)origin.getAddress())) {
                this.resetAccountUsage(origin, this.receipt.getOriginEnergyUsage(), this.receipt.getOriginEnergyWindowSize(), this.receipt.getOriginEnergyMergedUsage(), this.receipt.getOriginEnergyMergedWindowSize(), this.receipt.getOriginEnergyWindowSizeV2());
            }
            this.resetAccountUsage(caller, this.receipt.getCallerEnergyUsage(), this.receipt.getCallerEnergyWindowSize(), this.receipt.getCallerEnergyMergedUsage(), this.receipt.getCallerEnergyMergedWindowSize(), this.receipt.getCallerEnergyWindowSizeV2());
        }
        this.receipt.payEnergyBill(this.dynamicPropertiesStore, this.accountStore, this.forkController, origin, caller, percent, originEnergyLimit, this.energyProcessor, EnergyProcessor.getHeadSlot(this.dynamicPropertiesStore));
    }

    private void resetAccountUsage(AccountCapsule accountCap, long usage, long size, long mergedUsage, long mergedSize, long size2) {
        if (this.dynamicPropertiesStore.supportAllowCancelAllUnfreezeV2()) {
            this.resetAccountUsageV2(accountCap, usage, size, mergedUsage, mergedSize, size2);
            return;
        }
        long currentSize = accountCap.getWindowSize(Common.ResourceCode.ENERGY);
        long currentUsage = accountCap.getEnergyUsage();
        long newArea = currentUsage * currentSize - (mergedUsage * mergedSize - usage * size);
        long newSize = mergedSize == currentSize ? size : currentSize;
        long newUsage = Long.max(0L, newArea / newSize);
        accountCap.setEnergyUsage(newUsage);
        accountCap.setNewWindowSize(Common.ResourceCode.ENERGY, newUsage == 0L ? 0L : newSize);
    }

    private void resetAccountUsageV2(AccountCapsule accountCap, long usage, long size, long mergedUsage, long mergedSize, long size2) {
        long currentSize = accountCap.getWindowSize(Common.ResourceCode.ENERGY);
        long currentSize2 = accountCap.getWindowSizeV2(Common.ResourceCode.ENERGY);
        long currentUsage = accountCap.getEnergyUsage();
        long newArea = currentUsage * currentSize - (mergedUsage * mergedSize - usage * size);
        long newSize = mergedSize == currentSize ? size : currentSize;
        long newSize2 = mergedSize == currentSize ? size2 : currentSize2;
        long newUsage = Long.max(0L, newArea / newSize);
        accountCap.setEnergyUsage(newUsage);
        accountCap.setNewWindowSizeV2(Common.ResourceCode.ENERGY, newUsage == 0L ? 0L : newSize2);
    }

    public boolean checkNeedRetry() {
        if (!this.needVM()) {
            return false;
        }
        return this.trx.getContractRet() != Protocol.Transaction.Result.contractResult.OUT_OF_TIME && this.receipt.getResult() == Protocol.Transaction.Result.contractResult.OUT_OF_TIME;
    }

    public void check() throws ReceiptCheckErrException {
        if (!this.needVM()) {
            return;
        }
        if (Objects.isNull(this.trx.getContractRet())) {
            throw new ReceiptCheckErrException(String.format("null resultCode id: %s", this.trx.getTransactionId()));
        }
        if (!this.trx.getContractRet().equals((Object)this.receipt.getResult())) {
            throw new ReceiptCheckErrException(String.format("different resultCode txId: %s, expect: %s, actual: %s", this.trx.getTransactionId(), this.trx.getContractRet(), this.receipt.getResult()));
        }
    }

    public ReceiptCapsule getReceipt() {
        return this.receipt;
    }

    public void setResult() {
        if (!this.needVM()) {
            return;
        }
        this.receipt.setResult(this.transactionContext.getProgramResult().getResultCode());
    }

    public String getRuntimeError() {
        return this.transactionContext.getProgramResult().getRuntimeError();
    }

    public ProgramResult getRuntimeResult() {
        return this.transactionContext.getProgramResult();
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public void deleteContract(byte[] address) {
        this.abiStore.delete(address);
        this.codeStore.delete(address);
        this.accountStore.delete(address);
        this.contractStore.delete(address);
    }

    public static byte[] convertToTronAddress(byte[] address) {
        if (address.length == 20) {
            byte[] newAddress = new byte[21];
            byte[] temp = new byte[]{DecodeUtil.addressPreFixByte};
            System.arraycopy(temp, 0, newAddress, 0, temp.length);
            System.arraycopy(address, 0, newAddress, temp.length, address.length);
            address = newAddress;
        }
        return address;
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public TimeResultType getTimeResultType() {
        return this.timeResultType;
    }

    public void setTimeResultType(TimeResultType timeResultType) {
        this.timeResultType = timeResultType;
    }

    public boolean isNetFeeForBandwidth() {
        return this.netFeeForBandwidth;
    }

    public void setNetFeeForBandwidth(boolean netFeeForBandwidth) {
        this.netFeeForBandwidth = netFeeForBandwidth;
    }

    public static enum TimeResultType {
        NORMAL,
        LONG_RUNNING,
        OUT_OF_TIME;

    }
}

