/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.exception.BadItemException;
import org.tron.protos.Protocol;

public class TransactionRetCapsule
implements ProtoCapsule<Protocol.TransactionRet> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private Protocol.TransactionRet transactionRet;

    public TransactionRetCapsule(BlockCapsule blockCapsule) {
        this.transactionRet = Protocol.TransactionRet.newBuilder().build();
        if (Objects.isNull(blockCapsule)) {
            return;
        }
        Protocol.TransactionRet.Builder build = this.transactionRet.toBuilder().setBlockNumber(blockCapsule.getNum()).setBlockTimeStamp(blockCapsule.getTimeStamp());
        this.transactionRet = build.build();
    }

    public TransactionRetCapsule() {
        this.transactionRet = Protocol.TransactionRet.newBuilder().build();
    }

    public TransactionRetCapsule(byte[] data) throws BadItemException {
        try {
            this.transactionRet = Protocol.TransactionRet.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new BadItemException("TransactionInfoCapsule proto data parse exception");
        }
    }

    public void addTransactionInfo(Protocol.TransactionInfo result) {
        this.transactionRet = this.transactionRet.toBuilder().addTransactioninfo(result).build();
    }

    public void addAllTransactionInfos(List<Protocol.TransactionInfo> results) {
        this.transactionRet = this.transactionRet.toBuilder().addAllTransactioninfo(results).build();
    }

    @Override
    public byte[] getData() {
        if (Objects.isNull(this.transactionRet)) {
            return null;
        }
        return this.transactionRet.toByteArray();
    }

    @Override
    public Protocol.TransactionRet getInstance() {
        return this.transactionRet;
    }
}

