/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.ReceiptCapsule;
import org.tron.core.exception.BadItemException;
import org.tron.protos.Protocol;

public class TransactionInfoCapsule
implements ProtoCapsule<Protocol.TransactionInfo> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private Protocol.TransactionInfo transactionInfo;

    public TransactionInfoCapsule(Protocol.TransactionInfo trxRet) {
        this.transactionInfo = trxRet;
    }

    public TransactionInfoCapsule(byte[] data) throws BadItemException {
        try {
            this.transactionInfo = Protocol.TransactionInfo.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new BadItemException("TransactionInfoCapsule proto data parse exception");
        }
    }

    public TransactionInfoCapsule() {
        this.transactionInfo = Protocol.TransactionInfo.newBuilder().build();
    }

    public long getPackingFee() {
        return this.transactionInfo.getPackingFee();
    }

    public long getFee() {
        return this.transactionInfo.getFee();
    }

    public void setFee(long fee) {
        this.transactionInfo = this.transactionInfo.toBuilder().setFee(fee).build();
    }

    public byte[] getId() {
        return this.transactionInfo.getId().toByteArray();
    }

    public void setId(byte[] id) {
        this.transactionInfo = this.transactionInfo.toBuilder().setId(ByteString.copyFrom((byte[])id)).build();
    }

    public long getUnfreezeAmount() {
        return this.transactionInfo.getUnfreezeAmount();
    }

    public void setUnfreezeAmount(long amount) {
        this.transactionInfo = this.transactionInfo.toBuilder().setUnfreezeAmount(amount).build();
    }

    public long getWithdrawAmount() {
        return this.transactionInfo.getWithdrawAmount();
    }

    public void setWithdrawAmount(long amount) {
        this.transactionInfo = this.transactionInfo.toBuilder().setWithdrawAmount(amount).build();
    }

    public void setResult(Protocol.TransactionInfo.code result) {
        this.transactionInfo = this.transactionInfo.toBuilder().setResult(result).build();
    }

    public void setResMessage(String message) {
        this.transactionInfo = this.transactionInfo.toBuilder().setResMessage(ByteString.copyFromUtf8((String)message)).build();
    }

    public void addFee(long fee) {
        this.transactionInfo = this.transactionInfo.toBuilder().setFee(this.transactionInfo.getFee() + fee).build();
    }

    public long getBlockNumber() {
        return this.transactionInfo.getBlockNumber();
    }

    public void setBlockNumber(long num) {
        this.transactionInfo = this.transactionInfo.toBuilder().setBlockNumber(num).build();
    }

    public long getBlockTimeStamp() {
        return this.transactionInfo.getBlockTimeStamp();
    }

    public void setBlockTimeStamp(long time) {
        this.transactionInfo = this.transactionInfo.toBuilder().setBlockTimeStamp(time).build();
    }

    public void setContractResult(byte[] ret) {
        this.transactionInfo = this.transactionInfo.toBuilder().addContractResult(ByteString.copyFrom((byte[])ret)).build();
    }

    public void setContractAddress(byte[] contractAddress) {
        this.transactionInfo = this.transactionInfo.toBuilder().setContractAddress(ByteString.copyFrom((byte[])contractAddress)).build();
    }

    public void setReceipt(ReceiptCapsule receipt) {
        this.transactionInfo = this.transactionInfo.toBuilder().setReceipt(receipt.getReceipt()).build();
    }

    public void addAllLog(List<Protocol.TransactionInfo.Log> logs) {
        this.transactionInfo = this.transactionInfo.toBuilder().addAllLog(logs).build();
    }

    @Override
    public byte[] getData() {
        return this.transactionInfo.toByteArray();
    }

    @Override
    public Protocol.TransactionInfo getInstance() {
        return this.transactionInfo;
    }
}

