/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.capsule;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.store.MarketOrderStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.MarketContract;

public class MarketOrderCapsule
implements ProtoCapsule<Protocol.MarketOrder> {
    private static final Logger logger = LoggerFactory.getLogger((String)"capsule");
    private Protocol.MarketOrder order;

    public MarketOrderCapsule(Protocol.MarketOrder order) {
        this.order = order;
    }

    public MarketOrderCapsule(byte[] data) {
        try {
            this.order = Protocol.MarketOrder.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public MarketOrderCapsule(byte[] id, MarketContract.MarketSellAssetContract contract) {
        this.order = Protocol.MarketOrder.newBuilder().setOrderId(ByteString.copyFrom((byte[])id)).setOwnerAddress(contract.getOwnerAddress()).setSellTokenId(contract.getSellTokenId()).setSellTokenQuantity(contract.getSellTokenQuantity()).setBuyTokenId(contract.getBuyTokenId()).setBuyTokenQuantity(contract.getBuyTokenQuantity()).setSellTokenQuantityRemain(contract.getSellTokenQuantity()).setState(Protocol.MarketOrder.State.ACTIVE).setPrev(ByteString.copyFrom((byte[])new byte[0])).setNext(ByteString.copyFrom((byte[])new byte[0])).build();
    }

    public ByteString getID() {
        return this.order.getOrderId();
    }

    public void setID(ByteString id) {
        this.order = this.order.toBuilder().setOrderId(id).build();
    }

    public ByteString getOwnerAddress() {
        return this.order.getOwnerAddress();
    }

    public void setOwnerAddress(ByteString address) {
        this.order = this.order.toBuilder().setOwnerAddress(address).build();
    }

    public long getCreateTime() {
        return this.order.getCreateTime();
    }

    public void setCreateTime(long time) {
        this.order = this.order.toBuilder().setCreateTime(time).build();
    }

    public byte[] getSellTokenId() {
        return this.order.getSellTokenId().toByteArray();
    }

    public void setSellTokenId(byte[] id) {
        this.order = this.order.toBuilder().setSellTokenId(ByteString.copyFrom((byte[])id)).build();
    }

    public long getSellTokenQuantity() {
        return this.order.getSellTokenQuantity();
    }

    public void setSellTokenQuantity(long sellTokenQuantity) {
        this.order = this.order.toBuilder().setSellTokenQuantity(sellTokenQuantity).build();
    }

    public long getSellTokenQuantityRemain() {
        return this.order.getSellTokenQuantityRemain();
    }

    public void setSellTokenQuantityRemain(long sellTokenQuantityRemain) {
        this.order = this.order.toBuilder().setSellTokenQuantityRemain(sellTokenQuantityRemain).build();
    }

    public long getSellTokenQuantityReturn() {
        return this.order.getSellTokenQuantityReturn();
    }

    public void setSellTokenQuantityReturn() {
        this.order = this.order.toBuilder().setSellTokenQuantityReturn(this.order.getSellTokenQuantityRemain()).build();
    }

    public void setSellTokenQuantityReturn(long sellTokenQuantityReturn) {
        this.order = this.order.toBuilder().setSellTokenQuantityReturn(sellTokenQuantityReturn).build();
    }

    public byte[] getBuyTokenId() {
        return this.order.getBuyTokenId().toByteArray();
    }

    public void setBuyTokenId(byte[] id) {
        this.order = this.order.toBuilder().setBuyTokenId(ByteString.copyFrom((byte[])id)).build();
    }

    public long getBuyTokenQuantity() {
        return this.order.getBuyTokenQuantity();
    }

    public void setBuyTokenQuantity(long value) {
        this.order = this.order.toBuilder().setBuyTokenQuantity(value).build();
    }

    public Protocol.MarketOrder.State getSt() {
        return this.order.getState();
    }

    public void setState(Protocol.MarketOrder.State value) {
        this.order = this.order.toBuilder().setState(value).build();
    }

    public boolean isActive() {
        return this.order.getState() == Protocol.MarketOrder.State.ACTIVE;
    }

    public byte[] getNext() {
        return this.order.getNext().toByteArray();
    }

    public void setNext(byte[] next) {
        this.order = this.order.toBuilder().setNext(ByteString.copyFrom((byte[])next)).build();
    }

    public byte[] getPrev() {
        return this.order.getPrev().toByteArray();
    }

    public void setPrev(byte[] prev) {
        this.order = this.order.toBuilder().setPrev(ByteString.copyFrom((byte[])prev)).build();
    }

    public boolean isPreNull() {
        return this.getPrev() == null || this.getPrev().length == 0;
    }

    public boolean isNextNull() {
        return this.getNext() == null || this.getNext().length == 0;
    }

    public MarketOrderCapsule getPrevCapsule(MarketOrderStore orderStore) throws ItemNotFoundException {
        if (this.isPreNull()) {
            return null;
        }
        return orderStore.get(this.getPrev());
    }

    public MarketOrderCapsule getNextCapsule(MarketOrderStore orderStore) throws ItemNotFoundException {
        if (this.isNextNull()) {
            return null;
        }
        return orderStore.get(this.getNext());
    }

    @Override
    public byte[] getData() {
        return this.order.toByteArray();
    }

    @Override
    public Protocol.MarketOrder getInstance() {
        return this.order;
    }
}

