/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.GeneratedMessageV3;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.tron.common.parameter.CommonParameter;
import org.tron.core.actuator.Actuator;
import org.tron.protos.Protocol;
import org.tron.protos.contract.SmartContractOuterClass;

public class TransactionFactory {
    private static Map<Protocol.Transaction.Contract.ContractType, Class<? extends Actuator>> actuatorMap = new ConcurrentHashMap<Protocol.Transaction.Contract.ContractType, Class<? extends Actuator>>();
    private static Map<Protocol.Transaction.Contract.ContractType, Class<? extends GeneratedMessageV3>> contractMap = new ConcurrentHashMap<Protocol.Transaction.Contract.ContractType, Class<? extends GeneratedMessageV3>>();

    public static void register(Protocol.Transaction.Contract.ContractType type, Class<? extends Actuator> actuatorClass, Class<? extends GeneratedMessageV3> clazz) {
        Set actuatorSet = CommonParameter.getInstance().getActuatorSet();
        if (actuatorClass != null && !actuatorSet.isEmpty() && !actuatorSet.contains(actuatorClass.getSimpleName())) {
            return;
        }
        if (type != null && actuatorClass != null) {
            actuatorMap.put(type, actuatorClass);
        }
        if (type != null && clazz != null) {
            contractMap.put(type, clazz);
        }
    }

    public static Class<? extends Actuator> getActuator(Protocol.Transaction.Contract.ContractType type) {
        return actuatorMap.get(type);
    }

    public static Class<? extends GeneratedMessageV3> getContract(Protocol.Transaction.Contract.ContractType type) {
        return contractMap.get(type);
    }

    public static Map<Protocol.Transaction.Contract.ContractType, Class<? extends Actuator>> getActuatorMap() {
        return actuatorMap;
    }

    public static Map<Protocol.Transaction.Contract.ContractType, Class<? extends GeneratedMessageV3>> getContractMap() {
        return contractMap;
    }

    static {
        TransactionFactory.register(Protocol.Transaction.Contract.ContractType.CreateSmartContract, null, SmartContractOuterClass.CreateSmartContract.class);
        TransactionFactory.register(Protocol.Transaction.Contract.ContractType.TriggerSmartContract, null, SmartContractOuterClass.TriggerSmartContract.class);
    }
}

