/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.zksnark;

import java.util.ArrayDeque;
import java.util.Deque;
import org.tron.common.zksnark.IncrementalMerkleTreeContainer;
import org.tron.common.zksnark.MerklePath;
import org.tron.core.capsule.IncrementalMerkleTreeCapsule;
import org.tron.core.capsule.IncrementalMerkleVoucherCapsule;
import org.tron.core.exception.ZksnarkException;
import org.tron.protos.contract.ShieldContract;

public class IncrementalMerkleVoucherContainer {
    private static Integer DEPTH = IncrementalMerkleTreeContainer.getDEPTH();
    private IncrementalMerkleVoucherCapsule voucherCapsule;

    public IncrementalMerkleVoucherContainer(IncrementalMerkleVoucherCapsule voucherCapsule) {
        this.voucherCapsule = voucherCapsule;
    }

    public IncrementalMerkleVoucherContainer(IncrementalMerkleTreeContainer tree) {
        this.voucherCapsule = new IncrementalMerkleVoucherCapsule();
        this.voucherCapsule.setTree(tree.getTreeCapsule());
    }

    private Deque<ShieldContract.PedersenHash> partialPath() throws ZksnarkException {
        ArrayDeque<ShieldContract.PedersenHash> uncles = new ArrayDeque<ShieldContract.PedersenHash>(this.voucherCapsule.getFilled());
        if (this.cursorExist()) {
            uncles.add(this.voucherCapsule.getCursor().toMerkleTreeContainer().root(this.voucherCapsule.getCursorDepth()));
        }
        return uncles;
    }

    public void append(ShieldContract.PedersenHash obj) throws ZksnarkException {
        if (this.cursorExist()) {
            IncrementalMerkleTreeCapsule cursor = this.voucherCapsule.getCursor();
            cursor.toMerkleTreeContainer().append(obj);
            this.voucherCapsule.setCursor(cursor);
            long cursorDepth = this.voucherCapsule.getCursorDepth();
            if (this.voucherCapsule.getCursor().toMerkleTreeContainer().isComplete(cursorDepth)) {
                this.voucherCapsule.addFilled(this.voucherCapsule.getCursor().toMerkleTreeContainer().root(cursorDepth));
                this.voucherCapsule.clearCursor();
            }
        } else {
            long nextDepth = this.voucherCapsule.getTree().toMerkleTreeContainer().nextDepth(this.voucherCapsule.getFilled().size());
            this.voucherCapsule.setCursorDepth(nextDepth);
            if (nextDepth >= (long)DEPTH.intValue()) {
                throw new ZksnarkException("tree is full");
            }
            if (nextDepth == 0L) {
                this.voucherCapsule.addFilled(obj);
            } else {
                IncrementalMerkleTreeCapsule cursor = new IncrementalMerkleTreeCapsule();
                cursor.toMerkleTreeContainer().append(obj);
                this.voucherCapsule.setCursor(cursor);
            }
        }
    }

    public IncrementalMerkleVoucherCapsule getVoucherCapsule() {
        return this.voucherCapsule;
    }

    public MerklePath path() throws ZksnarkException {
        return this.voucherCapsule.getTree().toMerkleTreeContainer().path(this.partialPath());
    }

    public ShieldContract.PedersenHash element() throws ZksnarkException {
        return this.voucherCapsule.getTree().toMerkleTreeContainer().last();
    }

    public long position() {
        return this.voucherCapsule.getTree().toMerkleTreeContainer().size() - 1;
    }

    public ShieldContract.PedersenHash root() throws ZksnarkException {
        return this.voucherCapsule.getTree().toMerkleTreeContainer().root(DEPTH.intValue(), this.partialPath());
    }

    private boolean cursorExist() {
        return !this.voucherCapsule.getCursor().isEmptyTree();
    }

    public int size() {
        return this.voucherCapsule.getTree().toMerkleTreeContainer().size() + this.voucherCapsule.getFilled().size() + this.voucherCapsule.getCursor().toMerkleTreeContainer().size();
    }

    public void printSize() {
        System.out.println("TreeSize:" + this.voucherCapsule.getTree().toMerkleTreeContainer().size() + ",FillSize:" + this.voucherCapsule.getFilled().size() + ",CursorSize:" + this.voucherCapsule.getCursor().toMerkleTreeContainer().size());
    }

    public static Integer getDEPTH() {
        return DEPTH;
    }

    public static void setDEPTH(Integer DEPTH) {
        IncrementalMerkleVoucherContainer.DEPTH = DEPTH;
    }
}

