/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.zksnark;

import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteUtil;
import org.tron.common.zksnark.IncrementalMerkleVoucherContainer;
import org.tron.common.zksnark.MerklePath;
import org.tron.core.capsule.IncrementalMerkleTreeCapsule;
import org.tron.core.capsule.PedersenHashCapsule;
import org.tron.core.exception.ZksnarkException;
import org.tron.protos.contract.ShieldContract;

public class IncrementalMerkleTreeContainer {
    private static final Logger logger = LoggerFactory.getLogger(IncrementalMerkleTreeContainer.class);
    private static Integer DEPTH = 32;
    private IncrementalMerkleTreeCapsule treeCapsule;

    public IncrementalMerkleTreeContainer(IncrementalMerkleTreeCapsule treeCapsule) {
        this.treeCapsule = treeCapsule;
    }

    public static ShieldContract.PedersenHash emptyRoot() {
        return EmptyMerkleRoots.emptyMerkleRootsInstance.emptyRoot(DEPTH);
    }

    public IncrementalMerkleTreeCapsule getTreeCapsule() {
        return this.treeCapsule;
    }

    public void wfcheck() throws ZksnarkException {
        PedersenHashCapsule parentCompressCapsule;
        if (this.treeCapsule.getParents().size() >= DEPTH) {
            throw new ZksnarkException("tree has too many parents");
        }
        if (!this.treeCapsule.parentsIsEmpty().booleanValue() && !(parentCompressCapsule = new PedersenHashCapsule(this.treeCapsule.getParents().get(this.treeCapsule.getParents().size() - 1))).isPresent()) {
            throw new ZksnarkException("tree has non-canonical representation of parent");
        }
        if (!this.leftIsPresent() && this.rightIsPresent()) {
            throw new ZksnarkException("tree has non-canonical representation; right should not exist");
        }
        if (!this.leftIsPresent() && this.treeCapsule.getParents().size() > 0) {
            throw new ZksnarkException("tree has non-canonical representation; parents should be empty");
        }
    }

    public ShieldContract.PedersenHash last() throws ZksnarkException {
        if (this.rightIsPresent()) {
            return this.treeCapsule.getRight();
        }
        if (this.leftIsPresent()) {
            return this.treeCapsule.getLeft();
        }
        throw new ZksnarkException("tree has no cursor");
    }

    public int size() {
        int ret = 0;
        if (this.leftIsPresent()) {
            ++ret;
        }
        if (this.rightIsPresent()) {
            ++ret;
        }
        for (int i = 0; i < this.treeCapsule.getParents().size(); ++i) {
            PedersenHashCapsule parentCompressCapsule = new PedersenHashCapsule(this.treeCapsule.getParents().get(i));
            if (!parentCompressCapsule.isPresent()) continue;
            ret += 1 << i + 1;
        }
        return ret;
    }

    public void append(ShieldContract.PedersenHash obj) throws ZksnarkException {
        if (this.isComplete(DEPTH.intValue())) {
            throw new ZksnarkException("tree is full");
        }
        if (!this.leftIsPresent()) {
            this.treeCapsule.setLeft(obj);
        } else if (!this.rightIsPresent()) {
            this.treeCapsule.setRight(obj);
        } else {
            PedersenHashCapsule combined = PedersenHashCapsule.combine(this.treeCapsule.getLeft(), this.treeCapsule.getRight(), 0);
            this.treeCapsule.setLeft(obj);
            this.treeCapsule.clearRight();
            for (int i = 0; i < DEPTH; ++i) {
                if (i < this.treeCapsule.getParents().size()) {
                    PedersenHashCapsule parentCompressCapsule = new PedersenHashCapsule(this.treeCapsule.getParents().get(i));
                    if (!parentCompressCapsule.isPresent()) {
                        this.treeCapsule.setParents(i, combined.getInstance());
                        break;
                    }
                } else {
                    this.treeCapsule.addParents(combined.getInstance());
                    break;
                }
                combined = PedersenHashCapsule.combine(this.treeCapsule.getParents().get(i), combined.getInstance(), i + 1);
                this.treeCapsule.clearParents(i);
            }
        }
    }

    public boolean isComplete() {
        return this.isComplete(DEPTH.intValue());
    }

    public boolean isComplete(long depth) {
        if (!this.leftIsPresent() || !this.rightIsPresent()) {
            return false;
        }
        if ((long)this.treeCapsule.getParents().size() != depth - 1L) {
            return false;
        }
        for (ShieldContract.PedersenHash parent : this.treeCapsule.getParents()) {
            PedersenHashCapsule parentCompressCapsule = new PedersenHashCapsule(parent);
            if (parentCompressCapsule.isPresent()) continue;
            return false;
        }
        return true;
    }

    public int nextDepth(int skip) {
        if (!this.leftIsPresent()) {
            if (skip != 0) {
                --skip;
            } else {
                return 0;
            }
        }
        if (!this.rightIsPresent()) {
            if (skip != 0) {
                --skip;
            } else {
                return 0;
            }
        }
        int d = 1;
        for (ShieldContract.PedersenHash parent : this.treeCapsule.getParents()) {
            PedersenHashCapsule parentCompressCapsule = new PedersenHashCapsule(parent);
            if (!parentCompressCapsule.isPresent()) {
                if (skip != 0) {
                    --skip;
                } else {
                    return d;
                }
            }
            ++d;
        }
        return d + skip;
    }

    public ShieldContract.PedersenHash root() throws ZksnarkException {
        return this.root(DEPTH.intValue(), new ArrayDeque<ShieldContract.PedersenHash>());
    }

    public ShieldContract.PedersenHash root(long depth) throws ZksnarkException {
        ArrayDeque<ShieldContract.PedersenHash> fillerHashes = new ArrayDeque<ShieldContract.PedersenHash>();
        return this.root(depth, fillerHashes);
    }

    public ShieldContract.PedersenHash root(long depth, Deque<ShieldContract.PedersenHash> fillerHashes) throws ZksnarkException {
        PathFiller filler = new PathFiller(fillerHashes);
        ShieldContract.PedersenHash combineLeft = this.leftIsPresent() ? this.treeCapsule.getLeft() : filler.next(0);
        ShieldContract.PedersenHash combineRight = this.rightIsPresent() ? this.treeCapsule.getRight() : filler.next(0);
        PedersenHashCapsule root = PedersenHashCapsule.combine(combineLeft, combineRight, 0);
        int d = 1;
        for (ShieldContract.PedersenHash parent : this.treeCapsule.getParents()) {
            PedersenHashCapsule parentCompressCapsule = new PedersenHashCapsule(parent);
            if (parentCompressCapsule.isPresent()) {
                root = PedersenHashCapsule.combine(parent, root.getInstance(), d);
            } else {
                ShieldContract.PedersenHash next = filler.next(d);
                root = PedersenHashCapsule.combine(root.getInstance(), next, d);
            }
            ++d;
        }
        while ((long)d < depth) {
            PedersenHashCapsule result;
            ShieldContract.PedersenHash left = root.getInstance();
            ShieldContract.PedersenHash right = filler.next(d);
            root = result = PedersenHashCapsule.combine(left, right, d);
            ++d;
        }
        return root.getInstance();
    }

    public MerklePath path() throws ZksnarkException {
        ArrayDeque<ShieldContract.PedersenHash> fillerHashes = new ArrayDeque<ShieldContract.PedersenHash>();
        return this.path(fillerHashes);
    }

    public MerklePath path(Deque<ShieldContract.PedersenHash> fillerHashes) throws ZksnarkException {
        if (!this.leftIsPresent()) {
            throw new ZksnarkException("can't create an authentication path for the beginning of the tree");
        }
        PathFiller filler = new PathFiller(fillerHashes);
        ArrayList<ShieldContract.PedersenHash> path = new ArrayList<ShieldContract.PedersenHash>();
        ArrayList<Boolean> index = new ArrayList<Boolean>();
        if (this.rightIsPresent()) {
            index.add(true);
            path.add(this.treeCapsule.getLeft());
        } else {
            index.add(false);
            path.add(filler.next(0));
        }
        int d = 1;
        for (ShieldContract.PedersenHash parent : this.treeCapsule.getParents()) {
            PedersenHashCapsule parentCompressCapsule = new PedersenHashCapsule(parent);
            if (parentCompressCapsule.isPresent()) {
                index.add(true);
                path.add(parent);
            } else {
                index.add(false);
                path.add(filler.next(d));
            }
            ++d;
        }
        while (d < DEPTH) {
            index.add(false);
            path.add(filler.next(d));
            ++d;
        }
        List<List<Boolean>> merklePath = new ArrayList();
        for (ShieldContract.PedersenHash b : path) {
            merklePath.add(ByteUtil.convertBytesVectorToVector((byte[])b.getContent().toByteArray()));
        }
        merklePath = Lists.reverse(merklePath);
        index = Lists.reverse(index);
        return new MerklePath(merklePath, index);
    }

    public byte[] getMerkleTreeKey() throws ZksnarkException {
        return this.getRootArray();
    }

    public byte[] getRootArray() throws ZksnarkException {
        return this.root().getContent().toByteArray();
    }

    public IncrementalMerkleVoucherContainer toVoucher() {
        return new IncrementalMerkleVoucherContainer(this);
    }

    private boolean leftIsPresent() {
        return !this.treeCapsule.getLeft().getContent().isEmpty();
    }

    private boolean rightIsPresent() {
        return !this.treeCapsule.getRight().getContent().isEmpty();
    }

    public static Integer getDEPTH() {
        return DEPTH;
    }

    public static void setDEPTH(Integer DEPTH) {
        IncrementalMerkleTreeContainer.DEPTH = DEPTH;
    }

    public static class EmptyMerkleRoots {
        private static EmptyMerkleRoots emptyMerkleRootsInstance = new EmptyMerkleRoots();
        private List<PedersenHashCapsule> emptyRoots = new ArrayList<PedersenHashCapsule>();

        public EmptyMerkleRoots() {
            try {
                this.emptyRoots.add(PedersenHashCapsule.uncommitted());
                for (int d = 1; d <= DEPTH; ++d) {
                    ShieldContract.PedersenHash a = this.emptyRoots.get(d - 1).getInstance();
                    ShieldContract.PedersenHash b = this.emptyRoots.get(d - 1).getInstance();
                    this.emptyRoots.add(PedersenHashCapsule.combine(a, b, d - 1));
                }
            }
            catch (ZksnarkException e) {
                logger.error("generate EmptyMerkleRoots error!", (Throwable)e);
            }
        }

        public ShieldContract.PedersenHash emptyRoot(int depth) {
            return this.emptyRoots.get(depth).getInstance();
        }

        public static void setEmptyMerkleRootsInstance(EmptyMerkleRoots emptyMerkleRootsInstance) {
            EmptyMerkleRoots.emptyMerkleRootsInstance = emptyMerkleRootsInstance;
        }

        public static EmptyMerkleRoots getEmptyMerkleRootsInstance() {
            return emptyMerkleRootsInstance;
        }
    }

    public static class PathFiller {
        private Deque<ShieldContract.PedersenHash> queue;

        public PathFiller(Deque<ShieldContract.PedersenHash> queue) {
            this.queue = queue;
        }

        public ShieldContract.PedersenHash next(int depth) {
            if (this.queue.size() > 0) {
                return this.queue.poll();
            }
            return EmptyMerkleRoots.emptyMerkleRootsInstance.emptyRoot(depth);
        }
    }
}

