/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.storage.metric;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.tron.common.es.ExecutorServiceManager;
import org.tron.common.prometheus.Metrics;
import org.tron.core.db.common.DbSourceInter;
import org.tron.core.db2.common.DB;

@Component
public class DbStatService {
    private static final Logger logger = LoggerFactory.getLogger((String)"metrics");
    private final String esName = "db-stats";
    private final ScheduledExecutorService statExecutor = ExecutorServiceManager.newSingleThreadScheduledExecutor((String)"db-stats");

    public void register(DB<byte[], byte[]> db) {
        if (Metrics.enabled()) {
            this.statExecutor.scheduleWithFixedDelay(db::stat, 0L, 6L, TimeUnit.HOURS);
        }
    }

    public void register(DbSourceInter<byte[]> db) {
        if (Metrics.enabled()) {
            this.statExecutor.scheduleWithFixedDelay(db::stat, 0L, 6L, TimeUnit.HOURS);
        }
    }

    public void shutdown() {
        if (Metrics.enabled()) {
            ExecutorServiceManager.shutdownAndAwaitTermination((ExecutorService)this.statExecutor, (String)"db-stats");
        }
    }
}

