/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.tron.common.logsfilter.trigger.ContractTrigger;
import org.tron.common.runtime.CallCreate;
import org.tron.common.runtime.InternalTransaction;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.runtime.vm.LogInfo;
import org.tron.common.utils.ByteUtil;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.protos.Protocol;

public class ProgramResult {
    private long energyUsed = 0L;
    private long energyPenaltyTotal = 0L;
    private byte[] hReturn = ByteUtil.EMPTY_BYTE_ARRAY;
    private byte[] contractAddress = ByteUtil.EMPTY_BYTE_ARRAY;
    private RuntimeException exception;
    private boolean revert;
    private Set<DataWord> deleteAccounts;
    private List<InternalTransaction> internalTransactions;
    private List<LogInfo> logInfoList;
    private TransactionResultCapsule ret = new TransactionResultCapsule();
    private List<ContractTrigger> triggerList;
    private String runtimeError;
    private Protocol.Transaction.Result.contractResult resultCode;
    private List<CallCreate> callCreateList;

    public static ProgramResult createEmpty() {
        ProgramResult result = new ProgramResult();
        result.setHReturn(ByteUtil.EMPTY_BYTE_ARRAY);
        return result;
    }

    public void spendEnergy(long energy) {
        this.energyUsed += energy;
    }

    public void spendEnergyWithPenalty(long total, long penalty) {
        this.energyPenaltyTotal += penalty;
        this.energyUsed += total;
    }

    public void setRevert() {
        this.revert = true;
    }

    public boolean isRevert() {
        return this.revert;
    }

    public void refundEnergy(long energy) {
        this.energyUsed -= energy;
    }

    public void addTotalPenalty(long penalty) {
        this.energyPenaltyTotal += penalty;
    }

    public byte[] getContractAddress() {
        return Arrays.copyOf(this.contractAddress, this.contractAddress.length);
    }

    public void setContractAddress(byte[] contractAddress) {
        this.contractAddress = Arrays.copyOf(contractAddress, contractAddress.length);
    }

    public byte[] getHReturn() {
        return this.hReturn;
    }

    public void setHReturn(byte[] hReturn) {
        this.hReturn = hReturn;
    }

    public List<ContractTrigger> getTriggerList() {
        return this.triggerList != null ? this.triggerList : new LinkedList<ContractTrigger>();
    }

    public TransactionResultCapsule getRet() {
        return this.ret;
    }

    public void setRet(TransactionResultCapsule ret) {
        this.ret = ret;
    }

    public RuntimeException getException() {
        return this.exception;
    }

    public void setException(RuntimeException exception) {
        this.exception = exception;
    }

    public long getEnergyUsed() {
        return this.energyUsed;
    }

    public Set<DataWord> getDeleteAccounts() {
        if (this.deleteAccounts == null) {
            this.deleteAccounts = new HashSet<DataWord>();
        }
        return this.deleteAccounts;
    }

    public void addDeleteAccount(DataWord address) {
        this.getDeleteAccounts().add(address);
    }

    public void addDeleteAccounts(Set<DataWord> accounts) {
        if (!CollectionUtils.isEmpty(accounts)) {
            this.getDeleteAccounts().addAll(accounts);
        }
    }

    public List<LogInfo> getLogInfoList() {
        if (this.logInfoList == null) {
            this.logInfoList = new ArrayList<LogInfo>();
        }
        return this.logInfoList;
    }

    public void addLogInfo(LogInfo logInfo) {
        this.getLogInfoList().add(logInfo);
    }

    public void addLogInfos(List<LogInfo> logInfos) {
        if (!CollectionUtils.isEmpty(logInfos)) {
            this.getLogInfoList().addAll(logInfos);
        }
    }

    public List<CallCreate> getCallCreateList() {
        if (this.callCreateList == null) {
            this.callCreateList = new ArrayList<CallCreate>();
        }
        return this.callCreateList;
    }

    public void addCallCreate(byte[] data, byte[] destination, byte[] energyLimit, byte[] value) {
        this.getCallCreateList().add(new CallCreate(data, destination, energyLimit, value));
    }

    public List<InternalTransaction> getInternalTransactions() {
        if (this.internalTransactions == null) {
            this.internalTransactions = new ArrayList<InternalTransaction>();
        }
        return this.internalTransactions;
    }

    public InternalTransaction addInternalTransaction(byte[] parentHash, int deep, byte[] senderAddress, byte[] transferAddress, long value, byte[] data, String note, long nonce, Map<String, Long> token) {
        InternalTransaction transaction = new InternalTransaction(parentHash, deep, CollectionUtils.size(this.internalTransactions), senderAddress, transferAddress, value, data, note, nonce, token);
        this.getInternalTransactions().add(transaction);
        return transaction;
    }

    public void addInternalTransaction(InternalTransaction internalTransaction) {
        this.getInternalTransactions().add(internalTransaction);
    }

    public void addInternalTransactions(List<InternalTransaction> internalTransactions) {
        this.getInternalTransactions().addAll(internalTransactions);
    }

    public void rejectInternalTransactions() {
        for (InternalTransaction internalTx : this.getInternalTransactions()) {
            internalTx.reject();
        }
    }

    public void reset() {
        this.getDeleteAccounts().clear();
        this.getLogInfoList().clear();
    }

    public void merge(ProgramResult another) {
        this.addInternalTransactions(another.getInternalTransactions());
        this.addTotalPenalty(another.getEnergyPenaltyTotal());
        if (another.getException() == null && !another.isRevert()) {
            this.addDeleteAccounts(another.getDeleteAccounts());
            this.addLogInfos(another.getLogInfoList());
        }
    }

    public long getEnergyPenaltyTotal() {
        return this.energyPenaltyTotal;
    }

    public void setTriggerList(List<ContractTrigger> triggerList) {
        this.triggerList = triggerList;
    }

    public void setRuntimeError(String runtimeError) {
        this.runtimeError = runtimeError;
    }

    public String getRuntimeError() {
        return this.runtimeError;
    }

    public Protocol.Transaction.Result.contractResult getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(Protocol.Transaction.Result.contractResult resultCode) {
        this.resultCode = resultCode;
    }
}

