/*
 * Decompiled with CFR 0.152.
 */
package org.tron.common.overlay.message;

import com.google.protobuf.CodedInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.exception.P2pException;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.store.DynamicPropertiesStore;

public abstract class Message {
    protected static final Logger logger = LoggerFactory.getLogger((String)"Message");
    private static final Field field = ReflectionUtils.findField(CodedInputStream.class, (String)"shouldDiscardUnknownFields");
    private static DynamicPropertiesStore dynamicPropertiesStore;
    protected byte[] data;
    protected byte type;

    public Message() {
    }

    public Message(byte[] packed) {
        this.data = packed;
    }

    public Message(byte type, byte[] packed) {
        this.type = type;
        this.data = packed;
    }

    public static void compareBytes(byte[] src, byte[] dest) throws P2pException {
        if (src.length != dest.length) {
            throw new P2pException(P2pException.TypeEnum.PROTOBUF_ERROR, P2pException.TypeEnum.PROTOBUF_ERROR.getDesc());
        }
    }

    public static CodedInputStream getCodedInputStream(byte[] data) {
        CodedInputStream codedInputStream = CodedInputStream.newInstance((byte[])data);
        if (Message.isFilter()) {
            ReflectionUtils.setField((Field)field, (Object)codedInputStream, (Object)true);
        }
        return codedInputStream;
    }

    public static boolean isFilter() {
        return dynamicPropertiesStore.getAllowProtoFilterNum() == 1L;
    }

    public ByteBuf getSendData() {
        return Unpooled.wrappedBuffer((byte[])ArrayUtils.add((byte[])this.getData(), (int)0, (byte)this.type));
    }

    public byte[] getSendBytes() {
        return ArrayUtils.add((byte[])this.getData(), (int)0, (byte)this.type);
    }

    public Sha256Hash getMessageId() {
        return Sha256Hash.of((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])this.getData());
    }

    public byte[] getData() {
        return this.data;
    }

    public MessageTypes getType() {
        return MessageTypes.fromByte(this.type);
    }

    public abstract Class<?> getAnswerMessage();

    public String toString() {
        return "type: " + (Object)((Object)this.getType()) + "\n";
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message message = (Message)o;
        return Arrays.equals(this.data, message.data);
    }

    public static void setDynamicPropertiesStore(DynamicPropertiesStore dynamicPropertiesStore) {
        Message.dynamicPropertiesStore = dynamicPropertiesStore;
    }

    static {
        ReflectionUtils.makeAccessible((Field)field);
    }
}

