/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.program;

import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.crypto.Hash;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.runtime.InternalTransaction;
import org.tron.common.runtime.ProgramResult;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.utils.BIUtil;
import org.tron.common.utils.ByteUtil;
import org.tron.common.utils.FastByteComparisons;
import org.tron.common.utils.Utils;
import org.tron.common.utils.WalletUtil;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.ContractStateCapsule;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.capsule.VotesCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.db.BandwidthProcessor;
import org.tron.core.db.EnergyProcessor;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.TronException;
import org.tron.core.utils.TransactionUtil;
import org.tron.core.vm.EnergyCost;
import org.tron.core.vm.MessageCall;
import org.tron.core.vm.Op;
import org.tron.core.vm.OperationRegistry;
import org.tron.core.vm.PrecompiledContracts;
import org.tron.core.vm.VM;
import org.tron.core.vm.VMUtils;
import org.tron.core.vm.config.VMConfig;
import org.tron.core.vm.nativecontract.CancelAllUnfreezeV2Processor;
import org.tron.core.vm.nativecontract.DelegateResourceProcessor;
import org.tron.core.vm.nativecontract.FreezeBalanceProcessor;
import org.tron.core.vm.nativecontract.FreezeBalanceV2Processor;
import org.tron.core.vm.nativecontract.UnDelegateResourceProcessor;
import org.tron.core.vm.nativecontract.UnfreezeBalanceProcessor;
import org.tron.core.vm.nativecontract.UnfreezeBalanceV2Processor;
import org.tron.core.vm.nativecontract.VoteWitnessProcessor;
import org.tron.core.vm.nativecontract.WithdrawExpireUnfreezeProcessor;
import org.tron.core.vm.nativecontract.WithdrawRewardProcessor;
import org.tron.core.vm.nativecontract.param.CancelAllUnfreezeV2Param;
import org.tron.core.vm.nativecontract.param.DelegateResourceParam;
import org.tron.core.vm.nativecontract.param.FreezeBalanceParam;
import org.tron.core.vm.nativecontract.param.FreezeBalanceV2Param;
import org.tron.core.vm.nativecontract.param.UnDelegateResourceParam;
import org.tron.core.vm.nativecontract.param.UnfreezeBalanceParam;
import org.tron.core.vm.nativecontract.param.UnfreezeBalanceV2Param;
import org.tron.core.vm.nativecontract.param.VoteWitnessParam;
import org.tron.core.vm.nativecontract.param.WithdrawExpireUnfreezeParam;
import org.tron.core.vm.nativecontract.param.WithdrawRewardParam;
import org.tron.core.vm.program.ContractState;
import org.tron.core.vm.program.Memory;
import org.tron.core.vm.program.ProgramPrecompile;
import org.tron.core.vm.program.Stack;
import org.tron.core.vm.program.invoke.ProgramInvoke;
import org.tron.core.vm.program.invoke.ProgramInvokeFactory;
import org.tron.core.vm.program.listener.CompositeProgramListener;
import org.tron.core.vm.program.listener.ProgramListenerAware;
import org.tron.core.vm.program.listener.ProgramStorageChangeListener;
import org.tron.core.vm.repository.Key;
import org.tron.core.vm.repository.Repository;
import org.tron.core.vm.trace.ProgramTrace;
import org.tron.core.vm.trace.ProgramTraceListener;
import org.tron.core.vm.utils.MUtil;
import org.tron.core.vm.utils.VoteRewardUtil;
import org.tron.protos.Protocol;
import org.tron.protos.contract.Common;
import org.tron.protos.contract.SmartContractOuterClass;

public class Program {
    private static final Logger logger = LoggerFactory.getLogger((String)"VM");
    private static final int MAX_DEPTH = 64;
    private static final int MAX_STACK_SIZE = 1024;
    private static final String VALIDATE_FOR_SMART_CONTRACT_FAILURE = "validateForSmartContract failure:%s";
    private static final String INVALID_TOKEN_ID_MSG = "not valid token id";
    private static final String REFUND_ENERGY_FROM_MESSAGE_CALL = "refund energy from message call";
    private static final String CALL_PRE_COMPILED = "call pre-compiled";
    private static final int lruCacheSize = CommonParameter.getInstance().getSafeLruCacheSize();
    private static final LRUMap<Key, ProgramPrecompile> programPrecompileLRUMap = new LRUMap(lruCacheSize);
    private long nonce;
    private byte[] rootTransactionId;
    private InternalTransaction internalTransaction;
    private ProgramInvoke invoke;
    private ProgramOutListener listener;
    private ProgramTraceListener traceListener;
    private ProgramStorageChangeListener storageDiffListener = new ProgramStorageChangeListener();
    private CompositeProgramListener programListener = new CompositeProgramListener();
    private Stack stack;
    private Memory memory;
    private ContractState contractState;
    private byte[] returnDataBuffer;
    private ProgramResult result = new ProgramResult();
    private ProgramTrace trace = new ProgramTrace();
    private byte[] ops;
    private byte[] codeAddress;
    private int pc;
    private byte lastOp;
    private byte previouslyExecutedOp;
    private boolean stopped;
    private ProgramPrecompile programPrecompile;
    private int contractVersion;
    private DataWord adjustedCallEnergy;
    private long contextContractFactor;
    private long callPenaltyEnergy;

    public Program(byte[] ops, byte[] codeAddress, ProgramInvoke programInvoke, InternalTransaction internalTransaction) {
        this.invoke = programInvoke;
        this.internalTransaction = internalTransaction;
        this.ops = ArrayUtils.nullToEmpty((byte[])ops);
        this.codeAddress = codeAddress;
        this.traceListener = new ProgramTraceListener(VMConfig.vmTrace());
        this.memory = this.setupProgramListener(new Memory());
        this.stack = this.setupProgramListener(new Stack());
        this.contractState = this.setupProgramListener(new ContractState(programInvoke));
        this.trace = new ProgramTrace(programInvoke);
        this.nonce = internalTransaction.getNonce();
    }

    static String formatBinData(byte[] binData, int startPC) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < binData.length; i += 16) {
            ret.append(Utils.align((String)("" + Integer.toHexString(startPC + i) + ":"), (char)' ', (int)8, (boolean)false));
            ret.append(Hex.toHexString((byte[])binData, (int)i, (int)StrictMath.min(16, binData.length - i))).append('\n');
        }
        return ret.toString();
    }

    public byte[] getRootTransactionId() {
        return (byte[])this.rootTransactionId.clone();
    }

    public void setRootTransactionId(byte[] rootTransactionId) {
        this.rootTransactionId = (byte[])rootTransactionId.clone();
    }

    public void setContractVersion(int version) {
        this.contractVersion = version;
    }

    public int getContractVersion() {
        return this.contractVersion;
    }

    public void setAdjustedCallEnergy(DataWord adjustedCallEnergy) {
        this.adjustedCallEnergy = adjustedCallEnergy;
    }

    public DataWord getAdjustedCallEnergy() {
        return this.adjustedCallEnergy;
    }

    public long getNonce() {
        return this.nonce;
    }

    public void setNonce(long nonceValue) {
        this.nonce = nonceValue;
    }

    public ProgramPrecompile getProgramPrecompile() {
        if (this.isConstantCall()) {
            if (this.programPrecompile == null) {
                this.programPrecompile = ProgramPrecompile.compile(this.ops);
            }
            return this.programPrecompile;
        }
        if (this.programPrecompile == null) {
            Key key = this.getJumpDestAnalysisCacheKey();
            if (programPrecompileLRUMap.containsKey((Object)key)) {
                this.programPrecompile = (ProgramPrecompile)programPrecompileLRUMap.get((Object)key);
            } else {
                this.programPrecompile = ProgramPrecompile.compile(this.ops);
                programPrecompileLRUMap.put((Object)key, (Object)this.programPrecompile);
            }
        }
        return this.programPrecompile;
    }

    public int getCallDeep() {
        return this.invoke.getCallDeep();
    }

    private InternalTransaction addInternalTx(DataWord energyLimit, byte[] senderAddress, byte[] transferAddress, long value, byte[] data, String note, long nonce, Map<String, Long> tokenInfo) {
        InternalTransaction addedInternalTx = null;
        if (this.internalTransaction != null) {
            addedInternalTx = this.getResult().addInternalTransaction(this.internalTransaction.getHash(), this.getCallDeep(), senderAddress, transferAddress, value, data, note, nonce, tokenInfo);
        }
        return addedInternalTx;
    }

    private <T extends ProgramListenerAware> T setupProgramListener(T programListenerAware) {
        if (this.programListener.isEmpty()) {
            this.programListener.addListener(this.traceListener);
            this.programListener.addListener(this.storageDiffListener);
        }
        programListenerAware.setProgramListener(this.programListener);
        return programListenerAware;
    }

    public Map<DataWord, DataWord> getStorageDiff() {
        return this.storageDiffListener.getDiff();
    }

    public byte getOp(int pc) {
        return ArrayUtils.getLength((Object)this.ops) <= pc ? (byte)0 : this.ops[pc];
    }

    public byte getCurrentOp() {
        return ArrayUtils.isEmpty((byte[])this.ops) ? (byte)0 : this.ops[this.pc];
    }

    public int getCurrentOpIntValue() {
        return this.getCurrentOp() & 0xFF;
    }

    public void setLastOp(byte op) {
        this.lastOp = op;
    }

    public byte getPreviouslyExecutedOp() {
        return this.previouslyExecutedOp;
    }

    public void setPreviouslyExecutedOp(byte op) {
        this.previouslyExecutedOp = op;
    }

    public void stackPush(byte[] data) {
        this.stackPush(new DataWord(data));
    }

    public void stackPush(DataWord stackWord) {
        this.verifyStackOverflow(0, 1);
        this.stack.push(stackWord);
    }

    public void stackPushZero() {
        this.stackPush(DataWord.ZERO());
    }

    public void stackPushOne() {
        this.stackPush(DataWord.ONE());
    }

    public Stack getStack() {
        return this.stack;
    }

    public int getPC() {
        return this.pc;
    }

    public void setPC(DataWord pc) {
        this.setPC(pc.intValue());
    }

    public void setPC(int pc) {
        this.pc = pc;
        if (this.pc >= this.ops.length) {
            this.stop();
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void stop() {
        this.stopped = true;
    }

    public void setHReturn(byte[] buff) {
        this.getResult().setHReturn(buff);
    }

    public void step() {
        this.setPC(this.pc + 1);
    }

    public byte[] sweep(int n) {
        if (this.pc + n > this.ops.length) {
            this.stop();
        }
        byte[] data = Arrays.copyOfRange(this.ops, this.pc, this.pc + n);
        this.pc += n;
        if (this.pc >= this.ops.length) {
            this.stop();
        }
        return data;
    }

    public DataWord stackPop() {
        return this.stack.pop();
    }

    public void verifyStackSize(int stackSize) {
        if (this.stack.size() < stackSize) {
            throw Exception.tooSmallStack(stackSize, this.stack.size());
        }
    }

    public void verifyStackOverflow(int argsReqs, int returnReqs) {
        if (this.stack.size() - argsReqs + returnReqs > 1024) {
            throw new StackTooLargeException("Expected: overflow 1024 elements stack limit");
        }
    }

    public int getMemSize() {
        return this.memory.size();
    }

    public void memorySave(DataWord addrB, DataWord value) {
        this.memory.write(addrB.intValue(), value.getData(), value.getData().length, false);
    }

    public void memorySave(int addr, byte[] value) {
        this.memory.write(addr, value, value.length, false);
    }

    public void memorySave(int addr, int allocSize, byte[] value) {
        this.memory.extendAndWrite(addr, allocSize, value);
    }

    public void memorySaveLimited(int addr, byte[] data, int dataSize) {
        this.memory.write(addr, data, dataSize, true);
    }

    public void memoryExpand(DataWord outDataOffs, DataWord outDataSize) {
        if (!outDataSize.isZero()) {
            this.memory.extend(outDataOffs.intValue(), outDataSize.intValue());
        }
    }

    public DataWord memoryLoad(DataWord addr) {
        return this.memory.readWord(addr.intValue());
    }

    public DataWord memoryLoad(int address) {
        return this.memory.readWord(address);
    }

    public byte[] memoryChunk(int offset, int size) {
        return this.memory.read(offset, size);
    }

    public void allocateMemory(int offset, int size) {
        this.memory.extend(offset, size);
    }

    public void suicide(DataWord obtainerAddress) {
        byte[] Inheritor;
        long expireUnfrozenBalance;
        byte[] blackHoleAddress;
        byte[] owner = this.getContextAddress();
        byte[] obtainer = obtainerAddress.toTronAddress();
        if (VMConfig.allowTvmVote()) {
            this.withdrawRewardAndCancelVote(owner, this.getContractState());
        }
        long balance = this.getContractState().getBalance(owner);
        if (logger.isDebugEnabled()) {
            logger.debug("Transfer to: [{}] heritage: [{}]", (Object)Hex.toHexString((byte[])obtainer), (Object)balance);
        }
        this.increaseNonce();
        InternalTransaction internalTx = this.addInternalTx(null, owner, obtainer, balance, null, "suicide", this.nonce, this.getContractState().getAccount(owner).getAssetMapV2());
        if (FastByteComparisons.compareTo((byte[])owner, (int)0, (int)20, (byte[])obtainer, (int)0, (int)20) == 0) {
            this.getContractState().addBalance(owner, -balance);
            blackHoleAddress = this.getContractState().getBlackHoleAddress();
            if (VMConfig.allowTvmTransferTrc10()) {
                this.getContractState().addBalance(blackHoleAddress, balance);
                MUtil.transferAllToken(this.getContractState(), owner, blackHoleAddress);
            }
        } else {
            this.createAccountIfNotExist(this.getContractState(), obtainer);
            try {
                MUtil.transfer(this.getContractState(), owner, obtainer, balance);
                if (VMConfig.allowTvmTransferTrc10()) {
                    MUtil.transferAllToken(this.getContractState(), owner, obtainer);
                }
            }
            catch (ContractValidateException e) {
                if (VMConfig.allowTvmConstantinople()) {
                    throw new TransferException("transfer all token or transfer all trx failed in suicide: %s", e.getMessage());
                }
                throw new BytecodeExecutionException("transfer failure");
            }
        }
        if (VMConfig.allowTvmFreeze()) {
            blackHoleAddress = this.getContractState().getBlackHoleAddress();
            if (FastByteComparisons.isEqual((byte[])owner, (byte[])obtainer)) {
                this.transferDelegatedResourceToInheritor(owner, blackHoleAddress, this.getContractState());
            } else {
                this.transferDelegatedResourceToInheritor(owner, obtainer, this.getContractState());
            }
        }
        if (VMConfig.allowTvmFreezeV2() && (expireUnfrozenBalance = this.transferFrozenV2BalanceToInheritor(owner, Inheritor = FastByteComparisons.isEqual((byte[])owner, (byte[])obtainer) ? this.getContractState().getBlackHoleAddress() : obtainer, this.getContractState())) > 0L && internalTx != null) {
            internalTx.setValue(internalTx.getValue() + expireUnfrozenBalance);
        }
        this.getResult().addDeleteAccount(this.getContractAddress());
    }

    public Repository getContractState() {
        return this.contractState;
    }

    private void transferDelegatedResourceToInheritor(byte[] ownerAddr, byte[] inheritorAddr, Repository repo) {
        AccountCapsule ownerCapsule = repo.getAccount(ownerAddr);
        long frozenBalanceForBandwidthOfOwner = 0L;
        if (ownerCapsule.getFrozenCount() != 0) {
            frozenBalanceForBandwidthOfOwner = ((Protocol.Account.Frozen)ownerCapsule.getFrozenList().get(0)).getFrozenBalance();
        }
        repo.addTotalNetWeight(-frozenBalanceForBandwidthOfOwner / 1000000L);
        long frozenBalanceForEnergyOfOwner = ownerCapsule.getAccountResource().getFrozenBalanceForEnergy().getFrozenBalance();
        repo.addTotalEnergyWeight(-frozenBalanceForEnergyOfOwner / 1000000L);
        repo.addBalance(inheritorAddr, frozenBalanceForBandwidthOfOwner + frozenBalanceForEnergyOfOwner);
    }

    private long transferFrozenV2BalanceToInheritor(byte[] ownerAddr, byte[] inheritorAddr, Repository repo) {
        AccountCapsule ownerCapsule = repo.getAccount(ownerAddr);
        AccountCapsule inheritorCapsule = repo.getAccount(inheritorAddr);
        long now = repo.getHeadSlot();
        ownerCapsule.getFrozenV2List().stream().filter(freezeV2 -> freezeV2.getAmount() > 0L).forEach(freezeV2 -> {
            switch (freezeV2.getType()) {
                case BANDWIDTH: {
                    inheritorCapsule.addFrozenBalanceForBandwidthV2(freezeV2.getAmount());
                    break;
                }
                case ENERGY: {
                    inheritorCapsule.addFrozenBalanceForEnergyV2(freezeV2.getAmount());
                    break;
                }
                case TRON_POWER: {
                    inheritorCapsule.addFrozenForTronPowerV2(freezeV2.getAmount());
                }
            }
        });
        BandwidthProcessor bandwidthProcessor = new BandwidthProcessor(ChainBaseManager.getInstance());
        bandwidthProcessor.updateUsageForDelegated(ownerCapsule);
        ownerCapsule.setLatestConsumeTime(now);
        if (ownerCapsule.getNetUsage() > 0L) {
            bandwidthProcessor.unDelegateIncrease(inheritorCapsule, ownerCapsule, ownerCapsule.getNetUsage(), Common.ResourceCode.BANDWIDTH, now);
        }
        EnergyProcessor energyProcessor = new EnergyProcessor(repo.getDynamicPropertiesStore(), ChainBaseManager.getInstance().getAccountStore());
        energyProcessor.updateUsage(ownerCapsule);
        ownerCapsule.setLatestConsumeTimeForEnergy(now);
        if (ownerCapsule.getEnergyUsage() > 0L) {
            energyProcessor.unDelegateIncrease(inheritorCapsule, ownerCapsule, ownerCapsule.getEnergyUsage(), Common.ResourceCode.ENERGY, now);
        }
        long nowTimestamp = repo.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp();
        long expireUnfrozenBalance = ownerCapsule.getUnfrozenV2List().stream().filter(unFreezeV2 -> unFreezeV2.getUnfreezeAmount() > 0L && unFreezeV2.getUnfreezeExpireTime() <= nowTimestamp).mapToLong(Protocol.Account.UnFreezeV2::getUnfreezeAmount).sum();
        if (expireUnfrozenBalance > 0L) {
            inheritorCapsule.setBalance(inheritorCapsule.getBalance() + expireUnfrozenBalance);
            this.increaseNonce();
            this.addInternalTx(null, ownerAddr, inheritorAddr, expireUnfrozenBalance, null, "withdrawExpireUnfreezeWhileSuiciding", this.nonce, null);
        }
        this.clearOwnerFreezeV2(ownerCapsule);
        repo.updateAccount(ownerCapsule.createDbKey(), ownerCapsule);
        repo.updateAccount(inheritorCapsule.createDbKey(), inheritorCapsule);
        return expireUnfrozenBalance;
    }

    private void clearOwnerFreezeV2(AccountCapsule ownerCapsule) {
        ownerCapsule.clearFrozenV2();
        ownerCapsule.setNetUsage(0L);
        ownerCapsule.setNewWindowSize(Common.ResourceCode.BANDWIDTH, 0L);
        ownerCapsule.setEnergyUsage(0L);
        ownerCapsule.setNewWindowSize(Common.ResourceCode.ENERGY, 0L);
        ownerCapsule.clearUnfrozenV2();
    }

    private void withdrawRewardAndCancelVote(byte[] owner, Repository repo) {
        VoteRewardUtil.withdrawReward(owner, repo);
        AccountCapsule ownerCapsule = repo.getAccount(owner);
        if (!ownerCapsule.getVotesList().isEmpty()) {
            VotesCapsule votesCapsule = repo.getVotes(owner);
            if (votesCapsule == null) {
                votesCapsule = new VotesCapsule(ByteString.copyFrom((byte[])owner), ownerCapsule.getVotesList());
            } else {
                votesCapsule.clearNewVotes();
            }
            ownerCapsule.clearVotes();
            ownerCapsule.setOldTronPower(0L);
            repo.updateVotes(owner, votesCapsule);
        }
        try {
            long balance = ownerCapsule.getBalance();
            long allowance = ownerCapsule.getAllowance();
            ownerCapsule.setInstance(ownerCapsule.getInstance().toBuilder().setBalance(Math.addExact(balance, allowance)).setAllowance(0L).setLatestWithdrawTime(this.getTimestamp().longValue() * 1000L).build());
            repo.updateAccount(ownerCapsule.createDbKey(), ownerCapsule);
        }
        catch (ArithmeticException e) {
            throw new BytecodeExecutionException("Suicide: balance and allowance out of long range.");
        }
    }

    public boolean canSuicide() {
        byte[] owner = this.getContextAddress();
        AccountCapsule accountCapsule = this.getContractState().getAccount(owner);
        boolean freezeCheck = !VMConfig.allowTvmFreeze() || accountCapsule.getDelegatedFrozenBalanceForBandwidth() == 0L && accountCapsule.getDelegatedFrozenBalanceForEnergy() == 0L;
        boolean freezeV2Check = this.freezeV2Check(accountCapsule);
        return freezeCheck && freezeV2Check;
    }

    private boolean freezeV2Check(AccountCapsule accountCapsule) {
        if (!VMConfig.allowTvmFreezeV2()) {
            return true;
        }
        long now = this.getContractState().getDynamicPropertiesStore().getLatestBlockHeaderTimestamp();
        boolean isDelegatedResourceEmpty = accountCapsule.getDelegatedFrozenV2BalanceForBandwidth() == 0L && accountCapsule.getDelegatedFrozenV2BalanceForEnergy() == 0L;
        boolean isUnFrozenV2ListEmpty = CollectionUtils.isEmpty((Collection)accountCapsule.getUnfrozenV2List().stream().filter(unFreezeV2 -> unFreezeV2.getUnfreezeExpireTime() > now).collect(Collectors.toList()));
        return isDelegatedResourceEmpty && isUnFrozenV2ListEmpty;
    }

    public void createContract(DataWord value, DataWord memStart, DataWord memSize) {
        this.returnDataBuffer = null;
        if (this.getCallDeep() == 64) {
            this.stackPushZero();
            return;
        }
        byte[] programCode = this.memoryChunk(memStart.intValue(), memSize.intValue());
        byte[] newAddress = TransactionUtil.generateContractAddress(this.rootTransactionId, this.nonce);
        this.createContractImpl(value, programCode, newAddress, false);
    }

    private void createContractImpl(DataWord value, byte[] programCode, byte[] newAddress, boolean isCreate2) {
        SmartContractOuterClass.SmartContract.Builder builder;
        boolean contractAlreadyExists;
        byte[] senderAddress = this.getContextAddress();
        if (logger.isDebugEnabled()) {
            logger.debug("creating a new contract inside contract run: [{}]", (Object)Hex.toHexString((byte[])senderAddress));
        }
        long endowment = value.value().longValueExact();
        if (this.getContractState().getBalance(senderAddress) < endowment) {
            this.stackPushZero();
            return;
        }
        AccountCapsule existingAccount = this.getContractState().getAccount(newAddress);
        boolean bl = contractAlreadyExists = existingAccount != null;
        if (VMConfig.allowTvmConstantinople()) {
            contractAlreadyExists = contractAlreadyExists && this.isContractExist(existingAccount, this.getContractState());
        }
        Repository deposit = this.getContractState().newRepositoryChild();
        if (VMConfig.allowTvmConstantinople()) {
            if (existingAccount == null) {
                deposit.createAccount(newAddress, "CreatedByContract", Protocol.AccountType.Contract);
            } else if (!contractAlreadyExists) {
                existingAccount.updateAccountType(Protocol.AccountType.Contract);
                existingAccount.clearDelegatedResource();
                deposit.updateAccount(newAddress, existingAccount);
            }
            if (!contractAlreadyExists) {
                builder = SmartContractOuterClass.SmartContract.newBuilder();
                if (VMConfig.allowTvmCompatibleEvm()) {
                    builder.setVersion(this.getContractVersion());
                }
                builder.setContractAddress(ByteString.copyFrom((byte[])newAddress)).setConsumeUserResourcePercent(100L).setOriginAddress(ByteString.copyFrom((byte[])senderAddress));
                if (isCreate2) {
                    builder.setTrxHash(ByteString.copyFrom((byte[])this.rootTransactionId));
                }
                SmartContractOuterClass.SmartContract newSmartContract = builder.build();
                deposit.createContract(newAddress, new ContractCapsule(newSmartContract));
            }
        } else {
            deposit.createAccount(newAddress, "CreatedByContract", Protocol.AccountType.Contract);
            builder = SmartContractOuterClass.SmartContract.newBuilder();
            if (VMConfig.allowTvmCompatibleEvm()) {
                builder.setVersion(this.getContractVersion());
            }
            SmartContractOuterClass.SmartContract newSmartContract = builder.setContractAddress(ByteString.copyFrom((byte[])newAddress)).setConsumeUserResourcePercent(100L).setOriginAddress(ByteString.copyFrom((byte[])senderAddress)).build();
            deposit.createContract(newAddress, new ContractCapsule(newSmartContract));
            long oldBalance = deposit.getBalance(newAddress);
            deposit.addBalance(newAddress, oldBalance);
        }
        long newBalance = 0L;
        if (!this.byTestingSuite() && endowment > 0L) {
            try {
                VMUtils.validateForSmartContract(deposit, senderAddress, newAddress, endowment);
            }
            catch (ContractValidateException e) {
                throw new BytecodeExecutionException(VALIDATE_FOR_SMART_CONTRACT_FAILURE, e.getMessage());
            }
            deposit.addBalance(senderAddress, -endowment);
            newBalance = deposit.addBalance(newAddress, endowment);
        }
        DataWord energyLimit = this.getCreateEnergy(this.getEnergyLimitLeft());
        this.spendEnergy(energyLimit.longValue(), "internal call");
        this.increaseNonce();
        InternalTransaction internalTx = this.addInternalTx(null, senderAddress, newAddress, endowment, programCode, "create", this.nonce, null);
        long vmStartInUs = System.nanoTime() / 1000L;
        ProgramInvoke programInvoke = ProgramInvokeFactory.createProgramInvoke(this, new DataWord(newAddress), this.getContractAddress(), value, DataWord.ZERO(), DataWord.ZERO(), newBalance, null, deposit, false, this.byTestingSuite(), vmStartInUs, this.getVmShouldEndInUs(), energyLimit.longValueSafe());
        if (this.isConstantCall()) {
            programInvoke.setConstantCall();
        }
        ProgramResult createResult = ProgramResult.createEmpty();
        if (contractAlreadyExists) {
            createResult.setException((RuntimeException)new BytecodeExecutionException("Trying to create a contract with existing contract address: 0x" + Hex.toHexString((byte[])newAddress)));
        } else if (ArrayUtils.isNotEmpty((byte[])programCode)) {
            Program program = new Program(programCode, newAddress, programInvoke, internalTx);
            program.setRootTransactionId(this.rootTransactionId);
            if (VMConfig.allowTvmCompatibleEvm()) {
                program.setContractVersion(this.getContractVersion());
            }
            VM.play(program, OperationRegistry.getTable());
            createResult = program.getResult();
            this.getTrace().merge(program.getTrace());
            this.nonce = program.nonce;
        }
        byte[] code2 = createResult.getHReturn();
        if (code2.length != 0 && VMConfig.allowTvmLondon() && code2[0] == -17) {
            createResult.setException((RuntimeException)Exception.invalidCodeException());
        }
        long saveCodeEnergy = (long)ArrayUtils.getLength((Object)code2) * EnergyCost.getCreateData();
        long afterSpend = programInvoke.getEnergyLimit() - createResult.getEnergyUsed() - saveCodeEnergy;
        if (!createResult.isRevert()) {
            if (afterSpend < 0L) {
                createResult.setException((RuntimeException)Exception.notEnoughSpendEnergy("No energy to save just created contract code", saveCodeEnergy, programInvoke.getEnergyLimit() - createResult.getEnergyUsed()));
            } else {
                createResult.spendEnergy(saveCodeEnergy);
                deposit.saveCode(newAddress, code2);
            }
        }
        this.getResult().merge(createResult);
        if (createResult.getException() != null || createResult.isRevert()) {
            logger.debug("contract run halted by Exception: contract: [{}], exception: [{}]", (Object)Hex.toHexString((byte[])newAddress), (Object)createResult.getException());
            if (internalTx != null) {
                internalTx.reject();
            }
            createResult.rejectInternalTransactions();
            this.stackPushZero();
            if (createResult.getException() != null) {
                return;
            }
            this.returnDataBuffer = createResult.getHReturn();
        } else {
            if (!this.byTestingSuite()) {
                deposit.commit();
            }
            this.stackPush(new DataWord(newAddress));
        }
        this.refundEnergyAfterVM(energyLimit, createResult);
    }

    public void refundEnergyAfterVM(DataWord energyLimit, ProgramResult result) {
        long refundEnergy = energyLimit.longValueSafe() - result.getEnergyUsed();
        if (refundEnergy > 0L) {
            this.refundEnergy(refundEnergy, "remain energy from the internal call");
            if (logger.isDebugEnabled()) {
                logger.debug("The remaining energy is refunded, account: [{}], energy: [{}] ", (Object)Hex.toHexString((byte[])this.getContextAddress()), (Object)refundEnergy);
            }
        }
    }

    public void callToAddress(MessageCall msg) {
        AccountCapsule accountCapsule;
        long senderBalance;
        long endowment;
        this.returnDataBuffer = null;
        if (this.getCallDeep() == 64) {
            this.stackPushZero();
            this.refundEnergy(msg.getEnergy().longValue(), " call deep limit reach");
            return;
        }
        byte[] data = this.memoryChunk(msg.getInDataOffs().intValue(), msg.getInDataSize().intValue());
        byte[] codeAddress = msg.getCodeAddress().toTronAddress();
        byte[] senderAddress = this.getContextAddress();
        byte[] contextAddress = msg.getOpCode() == 242 || msg.getOpCode() == 244 ? senderAddress : codeAddress;
        if (logger.isDebugEnabled()) {
            logger.debug(Op.getNameOf(msg.getOpCode()) + " for existing contract: address: [{}], outDataOffs: [{}], outDataSize: [{}]  ", new Object[]{Hex.toHexString((byte[])contextAddress), msg.getOutDataOffs().longValue(), msg.getOutDataSize().longValue()});
        }
        Repository deposit = this.getContractState().newRepositoryChild();
        try {
            endowment = msg.getEndowment().value().longValueExact();
        }
        catch (ArithmeticException e) {
            if (VMConfig.allowTvmConstantinople()) {
                this.refundEnergy(msg.getEnergy().longValue(), "endowment out of long range");
                throw new TransferException("endowment out of long range", new Object[0]);
            }
            throw e;
        }
        byte[] tokenId = null;
        this.checkTokenId(msg);
        boolean isTokenTransfer = this.isTokenTransfer(msg);
        if (!isTokenTransfer) {
            senderBalance = deposit.getBalance(senderAddress);
            if (senderBalance < endowment) {
                this.stackPushZero();
                this.refundEnergy(msg.getEnergy().longValue(), REFUND_ENERGY_FROM_MESSAGE_CALL);
                return;
            }
        } else {
            tokenId = String.valueOf(msg.getTokenId().longValue()).getBytes();
            senderBalance = deposit.getTokenBalance(senderAddress, tokenId);
            if (senderBalance < endowment) {
                this.stackPushZero();
                this.refundEnergy(msg.getEnergy().longValue(), REFUND_ENERGY_FROM_MESSAGE_CALL);
                return;
            }
        }
        byte[] programCode = (accountCapsule = this.getContractState().getAccount(codeAddress)) != null ? this.getContractState().getCode(codeAddress) : ArrayUtils.EMPTY_BYTE_ARRAY;
        long contextBalance = 0L;
        if (this.byTestingSuite()) {
            this.getResult().addCallCreate(data, contextAddress, msg.getEnergy().getNoLeadZeroesData(), msg.getEndowment().getNoLeadZeroesData());
        } else if (!ArrayUtils.isEmpty((byte[])senderAddress) && !ArrayUtils.isEmpty((byte[])contextAddress) && senderAddress != contextAddress && endowment > 0L) {
            this.createAccountIfNotExist(deposit, contextAddress);
            if (!isTokenTransfer) {
                try {
                    VMUtils.validateForSmartContract(deposit, senderAddress, contextAddress, endowment);
                }
                catch (ContractValidateException e) {
                    if (VMConfig.allowTvmConstantinople()) {
                        this.refundEnergy(msg.getEnergy().longValue(), REFUND_ENERGY_FROM_MESSAGE_CALL);
                        throw new TransferException("transfer trx failed: %s", e.getMessage());
                    }
                    throw new BytecodeExecutionException(VALIDATE_FOR_SMART_CONTRACT_FAILURE, e.getMessage());
                }
                deposit.addBalance(senderAddress, -endowment);
                contextBalance = deposit.addBalance(contextAddress, endowment);
            } else {
                try {
                    VMUtils.validateForSmartContract(deposit, senderAddress, contextAddress, tokenId, endowment);
                }
                catch (ContractValidateException e) {
                    if (VMConfig.allowTvmConstantinople()) {
                        this.refundEnergy(msg.getEnergy().longValue(), REFUND_ENERGY_FROM_MESSAGE_CALL);
                        throw new TransferException("transfer trc10 failed: %s", e.getMessage());
                    }
                    throw new BytecodeExecutionException(VALIDATE_FOR_SMART_CONTRACT_FAILURE, e.getMessage());
                }
                deposit.addTokenBalance(senderAddress, tokenId, -endowment);
                deposit.addTokenBalance(contextAddress, tokenId, endowment);
            }
        }
        this.increaseNonce();
        HashMap<String, Long> tokenInfo = new HashMap<String, Long>();
        if (isTokenTransfer) {
            tokenInfo.put(new String(ByteUtil.stripLeadingZeroes((byte[])tokenId)), endowment);
        }
        InternalTransaction internalTx = this.addInternalTx(null, senderAddress, contextAddress, !isTokenTransfer ? endowment : 0L, data, "call", this.nonce, !isTokenTransfer ? null : tokenInfo);
        ProgramResult callResult = null;
        if (ArrayUtils.isNotEmpty((byte[])programCode)) {
            long vmStartInUs = System.nanoTime() / 1000L;
            DataWord callValue = msg.getOpCode() == 244 ? this.getCallValue() : msg.getEndowment();
            ProgramInvoke programInvoke = ProgramInvokeFactory.createProgramInvoke(this, new DataWord(contextAddress), msg.getOpCode() == 244 ? this.getCallerAddress() : this.getContractAddress(), !isTokenTransfer ? callValue : DataWord.ZERO(), !isTokenTransfer ? DataWord.ZERO() : callValue, !isTokenTransfer ? DataWord.ZERO() : msg.getTokenId(), contextBalance, data, deposit, msg.getOpCode() == 250 || this.isStaticCall(), this.byTestingSuite(), vmStartInUs, this.getVmShouldEndInUs(), msg.getEnergy().longValueSafe());
            if (this.isConstantCall()) {
                programInvoke.setConstantCall();
            }
            Program program = new Program(programCode, codeAddress, programInvoke, internalTx);
            program.setRootTransactionId(this.rootTransactionId);
            if (VMConfig.allowTvmCompatibleEvm()) {
                program.setContractVersion(this.invoke.getDeposit().getContract(codeAddress).getContractVersion());
            }
            VM.play(program, OperationRegistry.getTable());
            callResult = program.getResult();
            this.getTrace().merge(program.getTrace());
            this.getResult().merge(callResult);
            this.nonce = program.nonce;
            if (callResult.getException() != null || callResult.isRevert()) {
                logger.debug("contract run halted by Exception: contract: [{}], exception: [{}]", (Object)Hex.toHexString((byte[])contextAddress), (Object)callResult.getException());
                internalTx.reject();
                callResult.rejectInternalTransactions();
                this.stackPushZero();
                if (callResult.getException() != null) {
                    return;
                }
            } else {
                deposit.commit();
                this.stackPushOne();
            }
            if (this.byTestingSuite()) {
                logger.debug("Testing run, skipping storage diff listener");
            }
        } else {
            deposit.commit();
            this.stackPushOne();
        }
        if (callResult != null) {
            byte[] buffer = callResult.getHReturn();
            int offset = msg.getOutDataOffs().intValue();
            int size = msg.getOutDataSize().intValue();
            this.memorySaveLimited(offset, buffer, size);
            this.returnDataBuffer = buffer;
        }
        if (callResult != null) {
            BigInteger refundEnergy = msg.getEnergy().value().subtract(BIUtil.toBI((long)callResult.getEnergyUsed()));
            if (BIUtil.isPositive((BigInteger)refundEnergy)) {
                this.refundEnergy(refundEnergy.longValueExact(), "remaining energy from the internal call");
                if (logger.isDebugEnabled()) {
                    logger.debug("The remaining energy refunded, account: [{}], energy: [{}] ", (Object)Hex.toHexString((byte[])senderAddress), (Object)refundEnergy.toString());
                }
            }
        } else {
            this.refundEnergy(msg.getEnergy().longValue(), "remaining energy from the internal call");
        }
    }

    public void increaseNonce() {
        ++this.nonce;
    }

    public void resetNonce() {
        this.nonce = 0L;
    }

    public void spendEnergy(long energyValue, String opName) {
        if (this.getEnergylimitLeftLong() < energyValue) {
            throw new OutOfEnergyException("Not enough energy for '%s' operation executing: curInvokeEnergyLimit[%d], curOpEnergy[%d], usedEnergy[%d]", opName, this.invoke.getEnergyLimit(), energyValue, this.getResult().getEnergyUsed());
        }
        this.getResult().spendEnergy(energyValue);
    }

    public void spendEnergyWithPenalty(long total, long penalty, String opName) {
        if (this.getEnergylimitLeftLong() < total) {
            throw new OutOfEnergyException("Not enough energy for '%s' operation executing: curInvokeEnergyLimit[%d], curOpEnergy[%d], penaltyEnergy[%d], usedEnergy[%d]", opName, this.invoke.getEnergyLimit(), total - penalty, penalty, this.getResult().getEnergyUsed());
        }
        this.getResult().spendEnergyWithPenalty(total, penalty);
    }

    public void checkCPUTimeLimit(String opName) {
        if (CommonParameter.getInstance().isDebug()) {
            return;
        }
        if (CommonParameter.getInstance().isSolidityNode()) {
            return;
        }
        long vmNowInUs = System.nanoTime() / 1000L;
        if (vmNowInUs > this.getVmShouldEndInUs()) {
            logger.info("minTimeRatio: {}, maxTimeRatio: {}, vm should end time in us: {}, vm now time in us: {}, vm start time in us: {}", new Object[]{CommonParameter.getInstance().getMinTimeRatio(), CommonParameter.getInstance().getMaxTimeRatio(), this.getVmShouldEndInUs(), vmNowInUs, this.getVmStartInUs()});
            throw Exception.notEnoughTime(opName);
        }
    }

    public void spendAllEnergy() {
        this.spendEnergy(this.getEnergyLimitLeft().longValue(), "Spending all remaining");
    }

    public void refundEnergy(long energyValue, String cause) {
        logger.debug("[{}] Refund for cause: [{}], energy: [{}]", new Object[]{this.invoke.hashCode(), cause, energyValue});
        this.getResult().refundEnergy(energyValue);
    }

    public void storageSave(DataWord word1, DataWord word2) {
        DataWord keyWord = word1.clone();
        DataWord valWord = word2.clone();
        this.getContractState().putStorageValue(this.getContextAddress(), keyWord, valWord);
    }

    public byte[] getCode() {
        return (byte[])this.ops.clone();
    }

    public byte[] getCodeAt(DataWord address) {
        byte[] code2 = this.invoke.getDeposit().getCode(address.toTronAddress());
        return ArrayUtils.nullToEmpty((byte[])code2);
    }

    public byte[] getCodeHashAt(DataWord address) {
        byte[] tronAddr = address.toTronAddress();
        AccountCapsule account = this.getContractState().getAccount(tronAddr);
        if (account != null) {
            byte[] codeHash;
            ContractCapsule contract = this.getContractState().getContract(tronAddr);
            if (contract != null) {
                codeHash = contract.getCodeHash();
                if (ByteUtil.isNullOrZeroArray((byte[])codeHash)) {
                    byte[] code2 = this.getCodeAt(address);
                    codeHash = Hash.sha3((byte[])code2);
                    contract.setCodeHash(codeHash);
                    this.getContractState().updateContract(tronAddr, contract);
                }
            } else {
                codeHash = Hash.sha3((byte[])new byte[0]);
            }
            return codeHash;
        }
        return ArrayUtils.EMPTY_BYTE_ARRAY;
    }

    public byte[] getCodeHash() {
        byte[] codeHash;
        ContractCapsule contract = this.getContractState().getContract(this.codeAddress);
        if (contract == null) {
            codeHash = Hash.sha3((byte[])this.ops);
        } else {
            codeHash = contract.getCodeHash();
            if (ByteUtil.isNullOrZeroArray((byte[])codeHash)) {
                codeHash = Hash.sha3((byte[])this.ops);
            }
        }
        return codeHash;
    }

    private Key getJumpDestAnalysisCacheKey() {
        return Key.create(ByteUtil.merge((byte[][])new byte[][]{this.codeAddress, this.getCodeHash()}));
    }

    public byte[] getContextAddress() {
        return this.invoke.getContractAddress().toTronAddress();
    }

    public DataWord getContractAddress() {
        return this.invoke.getContractAddress().clone();
    }

    public DataWord getBlockHash(int index) {
        if ((long)index < this.getNumber().longValue() && (long)index >= Math.max(256L, this.getNumber().longValue()) - 256L) {
            BlockCapsule blockCapsule = this.contractState.getBlockByNum(index);
            if (Objects.nonNull(blockCapsule)) {
                return new DataWord(blockCapsule.getBlockId().getBytes()).clone();
            }
            return DataWord.ZERO.clone();
        }
        return DataWord.ZERO.clone();
    }

    public DataWord getBalance(DataWord address) {
        long balance = this.getContractState().getBalance(address.toTronAddress());
        return new DataWord(balance);
    }

    public DataWord getRewardBalance(DataWord address) {
        long rewardBalance = VoteRewardUtil.queryReward(address.toTronAddress(), this.getContractState());
        return new DataWord(rewardBalance);
    }

    public DataWord isContract(DataWord address) {
        ContractCapsule contract = this.getContractState().getContract(address.toTronAddress());
        return contract != null ? DataWord.ONE() : DataWord.ZERO();
    }

    public DataWord isSRCandidate(DataWord address) {
        WitnessCapsule witnessCapsule = this.getContractState().getWitness(address.toTronAddress());
        return witnessCapsule != null ? DataWord.ONE() : DataWord.ZERO();
    }

    public DataWord getOriginAddress() {
        return this.invoke.getOriginAddress().clone();
    }

    public DataWord getCallerAddress() {
        return this.invoke.getCallerAddress().clone();
    }

    public DataWord getChainId() {
        byte[] chainId = this.getContractState().getBlockByNum(0L).getBlockId().getBytes();
        if (VMConfig.allowTvmCompatibleEvm() || VMConfig.allowOptimizedReturnValueOfChainId()) {
            chainId = Arrays.copyOfRange(chainId, chainId.length - 4, chainId.length);
        }
        return new DataWord(chainId).clone();
    }

    public long getEnergylimitLeftLong() {
        return this.invoke.getEnergyLimit() - this.getResult().getEnergyUsed();
    }

    public DataWord getEnergyLimitLeft() {
        return new DataWord(this.invoke.getEnergyLimit() - this.getResult().getEnergyUsed());
    }

    public long getVmShouldEndInUs() {
        return this.invoke.getVmShouldEndInUs();
    }

    public DataWord getCallValue() {
        return this.invoke.getCallValue().clone();
    }

    public DataWord getDataSize() {
        return this.invoke.getDataSize().clone();
    }

    public DataWord getDataValue(DataWord index) {
        return this.invoke.getDataValue(index);
    }

    public byte[] getDataCopy(DataWord offset, DataWord length) {
        return this.invoke.getDataCopy(offset, length);
    }

    public DataWord getReturnDataBufferSize() {
        return new DataWord(this.getReturnDataBufferSizeI());
    }

    private int getReturnDataBufferSizeI() {
        return this.returnDataBuffer == null ? 0 : this.returnDataBuffer.length;
    }

    public byte[] getReturnDataBufferData(DataWord off, DataWord size) {
        if ((long)off.intValueSafe() + (long)size.intValueSafe() > (long)this.getReturnDataBufferSizeI()) {
            return null;
        }
        return this.returnDataBuffer == null ? new byte[]{} : Arrays.copyOfRange(this.returnDataBuffer, off.intValueSafe(), off.intValueSafe() + size.intValueSafe());
    }

    public DataWord storageLoad(DataWord key) {
        DataWord ret = this.getContractState().getStorageValue(this.getContextAddress(), key.clone());
        return ret == null ? null : ret.clone();
    }

    public DataWord getTokenBalance(DataWord address, DataWord tokenId) {
        this.checkTokenIdInTokenBalance(tokenId);
        long ret = this.getContractState().getTokenBalance(address.toTronAddress(), String.valueOf(tokenId.longValue()).getBytes());
        return new DataWord(ret);
    }

    public DataWord getTokenValue() {
        return this.invoke.getTokenValue().clone();
    }

    public DataWord getTokenId() {
        return this.invoke.getTokenId().clone();
    }

    public DataWord getPrevHash() {
        return this.invoke.getPrevHash().clone();
    }

    public DataWord getCoinbase() {
        return this.invoke.getCoinbase().clone();
    }

    public DataWord getTimestamp() {
        return this.invoke.getTimestamp().clone();
    }

    public DataWord getNumber() {
        return this.invoke.getNumber().clone();
    }

    public DataWord getDifficulty() {
        return this.invoke.getDifficulty().clone();
    }

    public boolean isStaticCall() {
        return this.invoke.isStaticCall();
    }

    public boolean isConstantCall() {
        return this.invoke.isConstantCall();
    }

    public ProgramResult getResult() {
        return this.result;
    }

    public void setRuntimeFailure(RuntimeException e) {
        this.getResult().setException(e);
    }

    public String memoryToString() {
        return this.memory.toString();
    }

    public void fullTrace() {
        if (logger.isTraceEnabled() || this.listener != null) {
            byte[] txData;
            StringBuilder stackData = new StringBuilder();
            for (int i = 0; i < this.stack.size(); ++i) {
                stackData.append(" ").append(this.stack.get(i));
                if (i >= this.stack.size() - 1) continue;
                stackData.append("\n");
            }
            if (stackData.length() > 0) {
                stackData.insert(0, "\n");
            }
            StringBuilder memoryData = new StringBuilder();
            StringBuilder oneLine = new StringBuilder();
            if (this.memory.size() > 320) {
                memoryData.append("... Memory Folded.... ").append("(").append(this.memory.size()).append(") bytes");
            } else {
                for (int i = 0; i < this.memory.size(); ++i) {
                    byte value = this.memory.readByte(i);
                    oneLine.append(ByteUtil.oneByteToHexString((byte)value)).append(" ");
                    if ((i + 1) % 16 != 0) continue;
                    String tmp = String.format("[%4s]-[%4s]", Integer.toString(i - 15, 16), Integer.toString(i, 16)).replace(" ", "0");
                    memoryData.append("").append(tmp).append(" ");
                    memoryData.append((CharSequence)oneLine);
                    if (i < this.memory.size()) {
                        memoryData.append("\n");
                    }
                    oneLine.setLength(0);
                }
            }
            if (memoryData.length() > 0) {
                memoryData.insert(0, "\n");
            }
            StringBuilder opsString = new StringBuilder();
            for (int i = 0; i < this.ops.length; ++i) {
                String tmpString = Integer.toString(this.ops[i] & 0xFF, 16);
                String string = tmpString = tmpString.length() == 1 ? "0" + tmpString : tmpString;
                if (i != this.pc) {
                    opsString.append(tmpString);
                    continue;
                }
                opsString.append(" >>").append(tmpString).append("");
            }
            if (this.pc >= this.ops.length) {
                opsString.append(" >>");
            }
            if (opsString.length() > 0) {
                opsString.insert(0, "\n ");
            }
            logger.trace(" -- OPS --     {}", (Object)opsString);
            logger.trace(" -- STACK --   {}", (Object)stackData);
            logger.trace(" -- MEMORY --  {}", (Object)memoryData);
            logger.trace("\n  Spent Drop: [{}]/[{}]\n  Left Energy:  [{}]\n", new Object[]{this.getResult().getEnergyUsed(), this.invoke.getEnergyLimit(), this.getEnergyLimitLeft().longValue()});
            StringBuilder globalOutput = new StringBuilder("\n");
            if (stackData.length() > 0) {
                stackData.append("\n");
            }
            if (this.pc != 0) {
                globalOutput.append("[Op: ").append(Op.getNameOf(this.lastOp)).append("]\n");
            }
            globalOutput.append(" -- OPS --     ").append((CharSequence)opsString).append("\n");
            globalOutput.append(" -- STACK --   ").append((CharSequence)stackData).append("\n");
            globalOutput.append(" -- MEMORY --  ").append((CharSequence)memoryData).append("\n");
            if (this.getResult().getHReturn() != null) {
                globalOutput.append("\n  HReturn: ").append(Hex.toHexString((byte[])this.getResult().getHReturn()));
            }
            if (!Arrays.equals(txData = this.invoke.getDataCopy(DataWord.ZERO, this.getDataSize()), this.ops)) {
                globalOutput.append("\n  msg.data: ").append(Hex.toHexString((byte[])txData));
            }
            globalOutput.append("\n\n  Spent Energy: ").append(this.getResult().getEnergyUsed());
            if (this.listener != null) {
                this.listener.output(globalOutput.toString());
            }
        }
    }

    public void saveOpTrace() {
        if (this.pc < this.ops.length) {
            this.trace.addOp(this.ops[this.pc], this.pc, this.getCallDeep(), this.getEnergyLimitLeft(), this.traceListener.resetActions());
        }
    }

    public ProgramTrace getTrace() {
        return this.trace;
    }

    public void createContract2(DataWord value, DataWord memStart, DataWord memSize, DataWord salt) {
        if (VMConfig.allowTvmCompatibleEvm() && this.getCallDeep() == 64) {
            this.stackPushZero();
            return;
        }
        byte[] senderAddress = VMConfig.allowTvmIstanbul() ? this.getContextAddress() : this.getCallerAddress().toTronAddress();
        byte[] programCode = this.memoryChunk(memStart.intValue(), memSize.intValue());
        byte[] contractAddress = WalletUtil.generateContractAddress2((byte[])senderAddress, (byte[])salt.getData(), (byte[])programCode);
        this.createContractImpl(value, programCode, contractAddress, true);
    }

    public void addListener(ProgramOutListener listener) {
        this.listener = listener;
    }

    public int verifyJumpDest(DataWord nextPC) {
        if (nextPC.bytesOccupied() > 4) {
            throw Exception.badJumpDestination(-1);
        }
        int ret = nextPC.intValue();
        if (!this.getProgramPrecompile().hasJumpDest(ret)) {
            throw Exception.badJumpDestination(ret);
        }
        return ret;
    }

    public void callToPrecompiledAddress(MessageCall msg, PrecompiledContracts.PrecompiledContract contract) {
        long requiredEnergy;
        this.returnDataBuffer = null;
        if (this.getCallDeep() == 64) {
            this.stackPushZero();
            this.refundEnergy(msg.getEnergy().longValue(), " call deep limit reach");
            return;
        }
        Repository deposit = this.getContractState().newRepositoryChild();
        byte[] senderAddress = this.getContextAddress();
        byte[] contextAddress = msg.getOpCode() == 242 || msg.getOpCode() == 244 ? senderAddress : msg.getCodeAddress().toTronAddress();
        long endowment = msg.getEndowment().value().longValueExact();
        long senderBalance = 0L;
        byte[] tokenId = null;
        this.checkTokenId(msg);
        boolean isTokenTransfer = this.isTokenTransfer(msg);
        if (!isTokenTransfer) {
            senderBalance = deposit.getBalance(senderAddress);
        } else {
            tokenId = String.valueOf(msg.getTokenId().longValue()).getBytes();
            senderBalance = deposit.getTokenBalance(senderAddress, tokenId);
        }
        if (senderBalance < endowment) {
            this.stackPushZero();
            this.refundEnergy(msg.getEnergy().longValue(), REFUND_ENERGY_FROM_MESSAGE_CALL);
            return;
        }
        byte[] data = this.memoryChunk(msg.getInDataOffs().intValue(), msg.getInDataSize().intValue());
        if (!ArrayUtils.isEmpty((byte[])senderAddress) && !ArrayUtils.isEmpty((byte[])contextAddress) && senderAddress != contextAddress && msg.getEndowment().value().longValueExact() > 0L) {
            if (!isTokenTransfer) {
                try {
                    MUtil.transfer(deposit, senderAddress, contextAddress, msg.getEndowment().value().longValueExact());
                }
                catch (ContractValidateException e) {
                    throw new BytecodeExecutionException("transfer failure");
                }
            }
            try {
                VMUtils.validateForSmartContract(deposit, senderAddress, contextAddress, tokenId, endowment);
            }
            catch (ContractValidateException e) {
                throw new BytecodeExecutionException(VALIDATE_FOR_SMART_CONTRACT_FAILURE, e.getMessage());
            }
            deposit.addTokenBalance(senderAddress, tokenId, -endowment);
            deposit.addTokenBalance(contextAddress, tokenId, endowment);
        }
        if ((requiredEnergy = contract.getEnergyForData(data)) > msg.getEnergy().longValue()) {
            this.refundEnergy(0L, CALL_PRE_COMPILED);
            this.stackPushZero();
        } else {
            if (msg.getOpCode() == 244) {
                contract.setCallerAddress(this.getCallerAddress().toTronAddress());
            } else {
                contract.setCallerAddress(this.getContextAddress());
            }
            contract.setRepository(deposit);
            contract.setResult(this.result);
            contract.setConstantCall(this.isConstantCall());
            contract.setVmShouldEndInUs(this.getVmShouldEndInUs());
            Pair<Boolean, byte[]> out = contract.execute(data);
            if (((Boolean)out.getLeft()).booleanValue()) {
                this.refundEnergy(msg.getEnergy().longValue() - requiredEnergy, CALL_PRE_COMPILED);
                this.stackPushOne();
                this.returnDataBuffer = (byte[])out.getRight();
                deposit.commit();
            } else {
                this.refundEnergy(0L, CALL_PRE_COMPILED);
                this.stackPushZero();
                if (Objects.nonNull(this.result.getException())) {
                    throw this.result.getException();
                }
            }
            this.memorySave(msg.getOutDataOffs().intValue(), (byte[])out.getRight());
        }
    }

    public boolean byTestingSuite() {
        return this.invoke.byTestingSuite();
    }

    public void checkTokenId(MessageCall msg) {
        if (VMConfig.allowMultiSign()) {
            long tokenId;
            try {
                tokenId = msg.getTokenId().sValue().longValueExact();
            }
            catch (ArithmeticException e) {
                if (VMConfig.allowTvmConstantinople()) {
                    this.refundEnergy(msg.getEnergy().longValue(), REFUND_ENERGY_FROM_MESSAGE_CALL);
                    throw new TransferException(VALIDATE_FOR_SMART_CONTRACT_FAILURE, INVALID_TOKEN_ID_MSG);
                }
                throw e;
            }
            if (tokenId <= 1000000L && tokenId != 0L || tokenId == 0L && msg.isTokenTransferMsg()) {
                if (VMConfig.allowTvmConstantinople()) {
                    this.refundEnergy(msg.getEnergy().longValue(), REFUND_ENERGY_FROM_MESSAGE_CALL);
                    throw new TransferException(VALIDATE_FOR_SMART_CONTRACT_FAILURE, INVALID_TOKEN_ID_MSG);
                }
                throw new BytecodeExecutionException(String.format(VALIDATE_FOR_SMART_CONTRACT_FAILURE, INVALID_TOKEN_ID_MSG));
            }
        }
    }

    public boolean isTokenTransfer(MessageCall msg) {
        if (VMConfig.allowMultiSign()) {
            return msg.isTokenTransferMsg();
        }
        return msg.getTokenId().longValue() != 0L;
    }

    public void checkTokenIdInTokenBalance(DataWord tokenIdDataWord) {
        if (VMConfig.allowMultiSign()) {
            long tokenId;
            try {
                tokenId = tokenIdDataWord.sValue().longValueExact();
            }
            catch (ArithmeticException e) {
                if (VMConfig.allowTvmConstantinople()) {
                    throw new TransferException(VALIDATE_FOR_SMART_CONTRACT_FAILURE, INVALID_TOKEN_ID_MSG);
                }
                throw e;
            }
            if (tokenId <= 1000000L) {
                throw new BytecodeExecutionException(String.format(VALIDATE_FOR_SMART_CONTRACT_FAILURE, INVALID_TOKEN_ID_MSG));
            }
        }
    }

    public DataWord getCallEnergy(DataWord requestedEnergy, DataWord availableEnergy) {
        if (VMConfig.allowTvmCompatibleEvm() && this.getContractVersion() == 1) {
            DataWord availableEnergyReduce = availableEnergy.clone();
            availableEnergyReduce.div(new DataWord(64));
            availableEnergy.sub(availableEnergyReduce);
        }
        return requestedEnergy.compareTo(availableEnergy) > 0 ? availableEnergy : requestedEnergy;
    }

    public DataWord getCreateEnergy(DataWord availableEnergy) {
        if (VMConfig.allowTvmCompatibleEvm() && this.getContractVersion() == 1) {
            DataWord availableEnergyReduce = availableEnergy.clone();
            availableEnergyReduce.div(new DataWord(64));
            availableEnergy.sub(availableEnergyReduce);
        }
        return availableEnergy;
    }

    public byte[] getMemory() {
        return this.memory.read(0, this.memory.size());
    }

    public void initMem(byte[] data) {
        this.memory.write(0, data, data.length, false);
    }

    public long getVmStartInUs() {
        return this.invoke.getVmStartInUs();
    }

    private boolean isContractExist(AccountCapsule existingAddr, Repository deposit) {
        return deposit.getContract(existingAddr.getAddress().toByteArray()) != null;
    }

    private void createAccountIfNotExist(Repository deposit, byte[] contextAddress) {
        AccountCapsule sender;
        if (VMConfig.allowTvmSolidity059() && (sender = deposit.getAccount(contextAddress)) == null) {
            deposit.createNormalAccount(contextAddress);
        }
    }

    public boolean freeze(DataWord receiverAddress, DataWord frozenBalance, DataWord resourceType) {
        Repository repository = this.getContractState().newRepositoryChild();
        byte[] owner = this.getContextAddress();
        byte[] receiver = receiverAddress.toTronAddress();
        this.increaseNonce();
        InternalTransaction internalTx = this.addInternalTx(null, owner, receiver, frozenBalance.longValue(), null, "freezeFor" + this.convertResourceToString(resourceType), this.nonce, null);
        FreezeBalanceParam param = new FreezeBalanceParam();
        param.setOwnerAddress(owner);
        param.setReceiverAddress(receiver);
        boolean needCheckFrozenTime = CommonParameter.getInstance().getCheckFrozenTime() == 1;
        param.setFrozenDuration(needCheckFrozenTime ? (long)repository.getDynamicPropertiesStore().getMinFrozenTime() : 0L);
        param.setResourceType(this.parseResourceCode(resourceType));
        try {
            FreezeBalanceProcessor processor = new FreezeBalanceProcessor();
            param.setFrozenBalance(frozenBalance.sValue().longValueExact());
            processor.validate(param, repository);
            processor.execute(param, repository);
            repository.commit();
            return true;
        }
        catch (ContractValidateException e) {
            logger.warn("TVM Freeze: validate failure. Reason: {}", (Object)e.getMessage());
        }
        catch (ArithmeticException e) {
            logger.warn("TVM Freeze: frozenBalance out of long range.");
        }
        if (internalTx != null) {
            internalTx.reject();
        }
        return false;
    }

    public boolean unfreeze(DataWord receiverAddress, DataWord resourceType) {
        Repository repository = this.getContractState().newRepositoryChild();
        byte[] owner = this.getContextAddress();
        byte[] receiver = receiverAddress.toTronAddress();
        this.increaseNonce();
        InternalTransaction internalTx = this.addInternalTx(null, owner, receiver, 0L, null, "unfreezeFor" + this.convertResourceToString(resourceType), this.nonce, null);
        UnfreezeBalanceParam param = new UnfreezeBalanceParam();
        param.setOwnerAddress(owner);
        param.setReceiverAddress(receiver);
        param.setResourceType(this.parseResourceCode(resourceType));
        try {
            UnfreezeBalanceProcessor processor = new UnfreezeBalanceProcessor();
            processor.validate(param, repository);
            long unfreezeBalance = processor.execute(param, repository);
            repository.commit();
            if (internalTx != null) {
                internalTx.setValue(unfreezeBalance);
            }
            return true;
        }
        catch (ContractValidateException e) {
            logger.warn("TVM Unfreeze: validate failure. Reason: {}", (Object)e.getMessage());
            if (internalTx != null) {
                internalTx.reject();
            }
            return false;
        }
    }

    public long freezeExpireTime(DataWord targetAddress, DataWord resourceType) {
        byte[] owner = this.getContextAddress();
        byte[] target = targetAddress.toTronAddress();
        int resourceCode = resourceType.intValue();
        if (FastByteComparisons.isEqual((byte[])owner, (byte[])target)) {
            AccountCapsule ownerCapsule = this.getContractState().getAccount(owner);
            if (resourceCode == 0) {
                if (ownerCapsule.getFrozenCount() != 0 && ((Protocol.Account.Frozen)ownerCapsule.getFrozenList().get(0)).getFrozenBalance() != 0L) {
                    return ((Protocol.Account.Frozen)ownerCapsule.getFrozenList().get(0)).getExpireTime();
                }
            } else if (resourceCode == 1 && ownerCapsule.getAccountResource().getFrozenBalanceForEnergy().getFrozenBalance() != 0L) {
                return ownerCapsule.getAccountResource().getFrozenBalanceForEnergy().getExpireTime();
            }
        } else {
            byte[] key = DelegatedResourceCapsule.createDbKey((byte[])owner, (byte[])target);
            DelegatedResourceCapsule delegatedResourceCapsule = this.getContractState().getDelegatedResource(key);
            if (delegatedResourceCapsule != null) {
                if (resourceCode == 0) {
                    if (delegatedResourceCapsule.getFrozenBalanceForBandwidth() != 0L) {
                        return delegatedResourceCapsule.getExpireTimeForBandwidth();
                    }
                } else if (resourceCode == 1 && delegatedResourceCapsule.getFrozenBalanceForEnergy() != 0L) {
                    return delegatedResourceCapsule.getExpireTimeForEnergy();
                }
            }
        }
        return 0L;
    }

    public boolean freezeBalanceV2(DataWord frozenBalance, DataWord resourceType) {
        Repository repository = this.getContractState().newRepositoryChild();
        byte[] owner = this.getContextAddress();
        this.increaseNonce();
        InternalTransaction internalTx = this.addInternalTx(null, owner, owner, frozenBalance.longValue(), null, "freezeBalanceV2For" + this.convertResourceToString(resourceType), this.nonce, null);
        try {
            FreezeBalanceV2Param param = new FreezeBalanceV2Param();
            param.setOwnerAddress(owner);
            param.setResourceType(this.parseResourceCodeV2(resourceType));
            param.setFrozenBalance(frozenBalance.sValue().longValueExact());
            FreezeBalanceV2Processor processor = new FreezeBalanceV2Processor();
            processor.validate(param, repository);
            processor.execute(param, repository);
            repository.commit();
            return true;
        }
        catch (ContractValidateException e) {
            logger.warn("TVM FreezeBalanceV2: validate failure. Reason: {}", (Object)e.getMessage());
        }
        catch (ArithmeticException e) {
            logger.warn("TVM FreezeBalanceV2: frozenBalance out of long range.");
        }
        if (internalTx != null) {
            internalTx.reject();
        }
        return false;
    }

    public boolean unfreezeBalanceV2(DataWord unfreezeBalance, DataWord resourceType) {
        Repository repository = this.getContractState().newRepositoryChild();
        byte[] owner = this.getContextAddress();
        this.increaseNonce();
        InternalTransaction internalTx = this.addInternalTx(null, owner, owner, unfreezeBalance.longValue(), null, "unfreezeBalanceV2For" + this.convertResourceToString(resourceType), this.nonce, null);
        try {
            UnfreezeBalanceV2Param param = new UnfreezeBalanceV2Param();
            param.setOwnerAddress(owner);
            param.setUnfreezeBalance(unfreezeBalance.sValue().longValueExact());
            param.setResourceType(this.parseResourceCodeV2(resourceType));
            UnfreezeBalanceV2Processor processor = new UnfreezeBalanceV2Processor();
            processor.validate(param, repository);
            long unfreezeExpireBalance = processor.execute(param, repository);
            repository.commit();
            if (unfreezeExpireBalance > 0L) {
                this.increaseNonce();
                this.addInternalTx(null, owner, owner, unfreezeExpireBalance, null, "withdrawExpireUnfreezeWhileUnfreezing", this.nonce, null);
            }
            return true;
        }
        catch (ContractValidateException e) {
            logger.warn("TVM UnfreezeBalanceV2: validate failure. Reason: {}", (Object)e.getMessage());
        }
        catch (ArithmeticException e) {
            logger.warn("TVM UnfreezeBalanceV2: balance out of long range.");
        }
        if (internalTx != null) {
            internalTx.reject();
        }
        return false;
    }

    public long withdrawExpireUnfreeze() {
        Repository repository = this.getContractState().newRepositoryChild();
        byte[] owner = this.getContextAddress();
        this.increaseNonce();
        InternalTransaction internalTx = this.addInternalTx(null, owner, owner, 0L, null, "withdrawExpireUnfreeze", this.nonce, null);
        try {
            WithdrawExpireUnfreezeParam param = new WithdrawExpireUnfreezeParam();
            param.setOwnerAddress(owner);
            WithdrawExpireUnfreezeProcessor processor = new WithdrawExpireUnfreezeProcessor();
            processor.validate(param, repository);
            long expireUnfreezeBalance = processor.execute(param, repository);
            repository.commit();
            if (internalTx != null) {
                internalTx.setValue(expireUnfreezeBalance);
            }
            return expireUnfreezeBalance;
        }
        catch (ContractValidateException e) {
            logger.warn("TVM WithdrawExpireUnfreeze: validate failure. Reason: {}", (Object)e.getMessage());
        }
        catch (ContractExeException e) {
            logger.warn("TVM WithdrawExpireUnfreeze: execute failure. Reason: {}", (Object)e.getMessage());
        }
        if (internalTx != null) {
            internalTx.reject();
        }
        return 0L;
    }

    public boolean cancelAllUnfreezeV2Action() {
        Repository repository = this.getContractState().newRepositoryChild();
        byte[] owner = this.getContextAddress();
        this.increaseNonce();
        InternalTransaction internalTx = this.addInternalTx(null, owner, owner, 0L, null, "cancelAllUnfreezeV2", this.nonce, null);
        try {
            CancelAllUnfreezeV2Param param = new CancelAllUnfreezeV2Param();
            param.setOwnerAddress(owner);
            CancelAllUnfreezeV2Processor processor = new CancelAllUnfreezeV2Processor();
            processor.validate(param, repository);
            long withdrawExpireBalance = processor.execute(param, repository);
            repository.commit();
            if (withdrawExpireBalance > 0L) {
                this.increaseNonce();
                this.addInternalTx(null, owner, owner, withdrawExpireBalance, null, "withdrawExpireUnfreezeWhileCanceling", this.nonce, null);
            }
            return true;
        }
        catch (ContractValidateException e) {
            logger.warn("TVM CancelAllUnfreezeV2: validate failure. Reason: {}", (Object)e.getMessage());
        }
        catch (ContractExeException e) {
            logger.warn("TVM CancelAllUnfreezeV2: execute failure. Reason: {}", (Object)e.getMessage());
        }
        if (internalTx != null) {
            internalTx.reject();
        }
        return false;
    }

    public boolean delegateResource(DataWord receiverAddress, DataWord delegateBalance, DataWord resourceType) {
        Repository repository = this.getContractState().newRepositoryChild();
        byte[] owner = this.getContextAddress();
        byte[] receiver = receiverAddress.toTronAddress();
        this.increaseNonce();
        InternalTransaction internalTx = this.addInternalTx(null, owner, receiver, delegateBalance.longValue(), null, "delegateResourceOf" + this.convertResourceToString(resourceType), this.nonce, null);
        try {
            DelegateResourceParam param = new DelegateResourceParam();
            param.setOwnerAddress(owner);
            param.setReceiverAddress(receiver);
            param.setDelegateBalance(delegateBalance.sValue().longValueExact());
            param.setResourceType(this.parseResourceCodeV2(resourceType));
            DelegateResourceProcessor processor = new DelegateResourceProcessor();
            processor.validate(param, repository);
            processor.execute(param, repository);
            repository.commit();
            return true;
        }
        catch (ContractValidateException e) {
            logger.warn("TVM DelegateResource: validate failure. Reason: {}", (Object)e.getMessage());
        }
        catch (ArithmeticException e) {
            logger.warn("TVM DelegateResource: balance out of long range.");
        }
        if (internalTx != null) {
            internalTx.reject();
        }
        return false;
    }

    public boolean unDelegateResource(DataWord receiverAddress, DataWord unDelegateBalance, DataWord resourceType) {
        Repository repository = this.getContractState().newRepositoryChild();
        byte[] owner = this.getContextAddress();
        byte[] receiver = receiverAddress.toTronAddress();
        this.increaseNonce();
        InternalTransaction internalTx = this.addInternalTx(null, owner, receiver, unDelegateBalance.longValue(), null, "unDelegateResourceOf" + this.convertResourceToString(resourceType), this.nonce, null);
        try {
            UnDelegateResourceParam param = new UnDelegateResourceParam();
            param.setOwnerAddress(owner);
            param.setReceiverAddress(receiver);
            param.setUnDelegateBalance(unDelegateBalance.sValue().longValueExact());
            param.setResourceType(this.parseResourceCodeV2(resourceType));
            UnDelegateResourceProcessor processor = new UnDelegateResourceProcessor();
            processor.validate(param, repository);
            processor.execute(param, repository);
            repository.commit();
            return true;
        }
        catch (ContractValidateException e) {
            logger.warn("TVM UnDelegateResource: validate failure. Reason: {}", (Object)e.getMessage());
        }
        catch (ArithmeticException e) {
            logger.warn("TVM UnDelegateResource: balance out of long range.");
        }
        if (internalTx != null) {
            internalTx.reject();
        }
        return false;
    }

    private Common.ResourceCode parseResourceCode(DataWord resourceType) {
        switch (resourceType.intValue()) {
            case 0: {
                return Common.ResourceCode.BANDWIDTH;
            }
            case 1: {
                return Common.ResourceCode.ENERGY;
            }
        }
        return Common.ResourceCode.UNRECOGNIZED;
    }

    private Common.ResourceCode parseResourceCodeV2(DataWord resourceType) {
        try {
            byte type = resourceType.sValue().byteValueExact();
            switch (type) {
                case 0: {
                    return Common.ResourceCode.BANDWIDTH;
                }
                case 1: {
                    return Common.ResourceCode.ENERGY;
                }
                case 2: {
                    return Common.ResourceCode.TRON_POWER;
                }
            }
            return Common.ResourceCode.UNRECOGNIZED;
        }
        catch (ArithmeticException e) {
            logger.warn("TVM ParseResourceCodeV2: invalid resource code: {}", (Object)resourceType.sValue());
            return Common.ResourceCode.UNRECOGNIZED;
        }
    }

    private String convertResourceToString(DataWord resourceType) {
        switch (resourceType.intValue()) {
            case 0: {
                return "Bandwidth";
            }
            case 1: {
                return "Energy";
            }
            case 2: {
                return "TronPower";
            }
        }
        return "UnknownType";
    }

    public boolean voteWitness(int witnessArrayOffset, int witnessArrayLength, int amountArrayOffset, int amountArrayLength) {
        Repository repository = this.getContractState().newRepositoryChild();
        byte[] owner = this.getContextAddress();
        this.increaseNonce();
        InternalTransaction internalTx = this.addInternalTx(null, owner, null, 0L, null, "voteWitness", this.nonce, null);
        if (this.memoryLoad(witnessArrayOffset).intValueSafe() != witnessArrayLength || this.memoryLoad(amountArrayOffset).intValueSafe() != amountArrayLength) {
            logger.warn("TVM VoteWitness: memory array length do not match length parameter!");
            throw new BytecodeExecutionException("TVM VoteWitness: memory array length do not match length parameter!");
        }
        if (witnessArrayLength != amountArrayLength) {
            logger.warn("TVM VoteWitness: witness array length {} does not match amount array length {}", (Object)witnessArrayLength, (Object)amountArrayLength);
            return false;
        }
        try {
            VoteWitnessParam param = new VoteWitnessParam();
            param.setVoterAddress(owner);
            byte[] witnessArrayData = this.memoryChunk(Math.addExact(witnessArrayOffset, 32), Math.multiplyExact(witnessArrayLength, 32));
            byte[] amountArrayData = this.memoryChunk(Math.addExact(amountArrayOffset, 32), Math.multiplyExact(amountArrayLength, 32));
            for (int i = 0; i < witnessArrayLength; ++i) {
                DataWord witness = new DataWord(Arrays.copyOfRange(witnessArrayData, i * 32, (i + 1) * 32));
                DataWord amount = new DataWord(Arrays.copyOfRange(amountArrayData, i * 32, (i + 1) * 32));
                param.addVote(witness.toTronAddress(), amount.sValue().longValueExact());
            }
            if (internalTx != null) {
                internalTx.setExtra(param.toJsonStr());
            }
            VoteWitnessProcessor processor = new VoteWitnessProcessor();
            processor.validate(param, repository);
            processor.execute(param, repository);
            repository.commit();
            return true;
        }
        catch (ContractValidateException e) {
            logger.warn("TVM VoteWitness: validate failure. Reason: {}", (Object)e.getMessage());
        }
        catch (ContractExeException e) {
            logger.warn("TVM VoteWitness: execute failure. Reason: {}", (Object)e.getMessage());
        }
        catch (ArithmeticException e) {
            logger.warn("TVM VoteWitness: int or long out of range. caused by: {}", (Object)e.getMessage());
        }
        if (internalTx != null) {
            internalTx.reject();
        }
        return false;
    }

    public long withdrawReward() {
        Repository repository = this.getContractState().newRepositoryChild();
        byte[] owner = this.getContextAddress();
        this.increaseNonce();
        InternalTransaction internalTx = this.addInternalTx(null, owner, owner, 0L, null, "withdrawReward", this.nonce, null);
        WithdrawRewardParam param = new WithdrawRewardParam();
        param.setOwnerAddress(owner);
        param.setNowInMs(this.getTimestamp().longValue() * 1000L);
        try {
            WithdrawRewardProcessor processor = new WithdrawRewardProcessor();
            processor.validate(param, repository);
            long allowance = processor.execute(param, repository);
            repository.commit();
            if (internalTx != null) {
                internalTx.setValue(allowance);
            }
            return allowance;
        }
        catch (ContractValidateException e) {
            logger.warn("TVM WithdrawReward: validate failure. Reason: {}", (Object)e.getMessage());
        }
        catch (ContractExeException e) {
            logger.warn("TVM WithdrawReward: execute failure. Reason: {}", (Object)e.getMessage());
        }
        if (internalTx != null) {
            internalTx.reject();
        }
        return 0L;
    }

    public long updateContextContractFactor() {
        ContractStateCapsule contractStateCapsule = this.contractState.getContractState(this.getContextAddress());
        if (contractStateCapsule == null) {
            contractStateCapsule = new ContractStateCapsule(this.contractState.getDynamicPropertiesStore().getCurrentCycleNumber());
            this.contractState.updateContractState(this.getContextAddress(), contractStateCapsule);
        } else if (contractStateCapsule.catchUpToCycle(this.contractState.getDynamicPropertiesStore().getCurrentCycleNumber(), VMConfig.getDynamicEnergyThreshold(), VMConfig.getDynamicEnergyIncreaseFactor(), VMConfig.getDynamicEnergyMaxFactor())) {
            this.contractState.updateContractState(this.getContextAddress(), contractStateCapsule);
        }
        this.contextContractFactor = contractStateCapsule.getEnergyFactor() + 10000L;
        return this.contextContractFactor;
    }

    public void addContextContractUsage(long value) {
        ContractStateCapsule contractStateCapsule = this.contractState.getContractState(this.getContextAddress());
        contractStateCapsule.addEnergyUsage(value);
        this.contractState.updateContractState(this.getContextAddress(), contractStateCapsule);
    }

    public long getContextContractFactor() {
        return this.contextContractFactor;
    }

    public void setContextContractFactor(long contextContractFactor) {
        this.contextContractFactor = contextContractFactor;
    }

    public long getCallPenaltyEnergy() {
        return this.callPenaltyEnergy;
    }

    public void setCallPenaltyEnergy(long callPenaltyEnergy) {
        this.callPenaltyEnergy = callPenaltyEnergy;
    }

    public class StackTooLargeException
    extends BytecodeExecutionException {
        public StackTooLargeException(String message) {
            super(message);
        }
    }

    public static class Exception {
        private Exception() {
        }

        public static OutOfEnergyException notEnoughSpendEnergy(String hint, long needEnergy, long leftEnergy) {
            return new OutOfEnergyException("Not enough energy for '%s' executing: needEnergy[%d], leftEnergy[%d];", hint, needEnergy, leftEnergy);
        }

        public static OutOfTimeException notEnoughTime(String op) {
            return new OutOfTimeException("CPU timeout for '%s' operation executing", op);
        }

        public static OutOfTimeException alreadyTimeOut() {
            return new OutOfTimeException("Already Time Out", new Object[0]);
        }

        public static OutOfMemoryException memoryOverflow(int op) {
            return new OutOfMemoryException("Out of Memory when '%s' operation executing", Op.getNameOf(op));
        }

        public static OutOfStorageException notEnoughStorage() {
            return new OutOfStorageException("Not enough ContractState resource", new Object[0]);
        }

        public static PrecompiledContractException contractValidateException(TronException e) {
            return new PrecompiledContractException(e.getMessage(), new Object[0]);
        }

        public static PrecompiledContractException contractExecuteException(TronException e) {
            return new PrecompiledContractException(e.getMessage(), new Object[0]);
        }

        public static OutOfEnergyException energyOverflow(BigInteger actualEnergy, BigInteger energyLimit) {
            return new OutOfEnergyException("Energy value overflow: actualEnergy[%d], energyLimit[%d];", actualEnergy.longValueExact(), energyLimit.longValueExact());
        }

        public static IllegalOperationException invalidOpCode(byte ... opCode) {
            return new IllegalOperationException("Invalid operation code: opCode[%s];", Hex.toHexString((byte[])opCode, (int)0, (int)1));
        }

        public static InvalidCodeException invalidCodeException() {
            return new InvalidCodeException("invalid code: must not begin with 0xef");
        }

        public static BadJumpDestinationException badJumpDestination(int pc) {
            return new BadJumpDestinationException("Operation with pc isn't 'JUMPDEST': PC[%d];", pc);
        }

        public static StackTooSmallException tooSmallStack(int expectedSize, int actualSize) {
            return new StackTooSmallException("Expected stack size %d but actual %d;", expectedSize, actualSize);
        }
    }

    public static class StaticCallModificationException
    extends BytecodeExecutionException {
        public StaticCallModificationException() {
            super("Attempt to call a state modifying opcode inside STATICCALL");
        }
    }

    public static class JVMStackOverFlowException
    extends BytecodeExecutionException {
        public JVMStackOverFlowException() {
            super("StackOverflowError:  exceed default JVM stack size!");
        }
    }

    public static class ReturnDataCopyIllegalBoundsException
    extends BytecodeExecutionException {
        public ReturnDataCopyIllegalBoundsException(DataWord off, DataWord size, long returnDataSize) {
            super(String.format("Illegal RETURNDATACOPY arguments: offset (%s) + size (%s) > RETURNDATASIZE (%d)", off, size, returnDataSize));
        }
    }

    public static class StackTooSmallException
    extends BytecodeExecutionException {
        public StackTooSmallException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class BadJumpDestinationException
    extends BytecodeExecutionException {
        public BadJumpDestinationException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class InvalidCodeException
    extends BytecodeExecutionException {
        public InvalidCodeException(String message) {
            super(message);
        }
    }

    public static class IllegalOperationException
    extends BytecodeExecutionException {
        public IllegalOperationException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class PrecompiledContractException
    extends BytecodeExecutionException {
        public PrecompiledContractException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class OutOfStorageException
    extends BytecodeExecutionException {
        public OutOfStorageException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class OutOfMemoryException
    extends BytecodeExecutionException {
        public OutOfMemoryException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class OutOfTimeException
    extends BytecodeExecutionException {
        public OutOfTimeException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class OutOfEnergyException
    extends BytecodeExecutionException {
        public OutOfEnergyException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class TransferException
    extends BytecodeExecutionException {
        public TransferException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class AssetIssueException
    extends BytecodeExecutionException {
        public AssetIssueException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    public static class BytecodeExecutionException
    extends RuntimeException {
        public BytecodeExecutionException(String message) {
            super(message);
        }

        public BytecodeExecutionException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }

    static class ByteCodeIterator {
        private byte[] code;
        private int pc;

        public ByteCodeIterator(byte[] code2) {
            this.code = code2;
        }

        public int getPC() {
            return this.pc;
        }

        public void setPC(int pc) {
            this.pc = pc;
        }
    }

    public static interface ProgramOutListener {
        public void output(String var1);
    }
}

