/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.tron.core.vm.JumpTable;
import org.tron.core.vm.Op;
import org.tron.core.vm.Operation;
import org.tron.core.vm.config.VMConfig;
import org.tron.core.vm.program.Program;

public class VM {
    private static final Logger logger = LoggerFactory.getLogger((String)"VM");
    private static final Set<Integer> CALL_OPS = ImmutableSet.of((Object)241, (Object)250, (Object)244, (Object)242, (Object)208);

    public static void play(Program program, JumpTable jumpTable) {
        try {
            long factor = 10000L;
            long energyUsage = 0L;
            if (VMConfig.allowDynamicEnergy()) {
                factor = program.updateContextContractFactor();
            }
            while (!program.isStopped()) {
                if (VMConfig.vmTrace()) {
                    program.saveOpTrace();
                }
                try {
                    Operation op = jumpTable.get(program.getCurrentOpIntValue());
                    if (!op.isEnabled()) {
                        throw Program.Exception.invalidOpCode(program.getCurrentOp());
                    }
                    program.setLastOp((byte)op.getOpcode());
                    program.verifyStackSize(op.getRequire());
                    program.verifyStackOverflow(op.getRequire(), op.getRet());
                    String opName = Op.getNameOf(op.getOpcode());
                    long energy = op.getEnergyCost(program);
                    if (VMConfig.allowDynamicEnergy()) {
                        long actualEnergy = energy;
                        if (CALL_OPS.contains(op.getOpcode())) {
                            actualEnergy = energy - program.getAdjustedCallEnergy().longValueSafe() - program.getCallPenaltyEnergy();
                        }
                        energyUsage += actualEnergy;
                        if (factor > 10000L) {
                            long penalty;
                            if (CALL_OPS.contains(op.getOpcode())) {
                                penalty = program.getCallPenaltyEnergy();
                            } else {
                                penalty = energy * factor / 10000L - energy;
                                if (penalty < 0L) {
                                    penalty = 0L;
                                }
                                energy += penalty;
                            }
                            program.spendEnergyWithPenalty(energy, penalty, opName);
                        } else {
                            program.spendEnergy(energy, opName);
                        }
                    } else {
                        program.spendEnergy(energy, opName);
                    }
                    program.checkCPUTimeLimit(opName);
                    op.execute(program);
                    program.setPreviouslyExecutedOp((byte)op.getOpcode());
                }
                catch (RuntimeException e) {
                    logger.info("VM halted: [{}]", (Object)e.getMessage());
                    if (!(e instanceof Program.TransferException)) {
                        program.spendAllEnergy();
                    }
                    program.stop();
                    throw e;
                }
                finally {
                    program.fullTrace();
                }
            }
            if (VMConfig.allowDynamicEnergy()) {
                program.addContextContractUsage(energyUsage);
            }
        }
        catch (Program.JVMStackOverFlowException | Program.OutOfTimeException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (StringUtils.isEmpty((Object)e.getMessage())) {
                logger.warn("Unknown Exception occurred, tx id: {}", (Object)Hex.toHexString((byte[])program.getRootTransactionId()), (Object)e);
                program.setRuntimeFailure(new RuntimeException("Unknown Exception"));
            } else {
                program.setRuntimeFailure(e);
            }
        }
        catch (StackOverflowError soe) {
            logger.info("\n !!! StackOverflowError: update your java run command with -Xss !!!\n", (Throwable)soe);
            throw new Program.JVMStackOverFlowException();
        }
    }
}

