/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.WitnessStore;
import org.tron.core.utils.TransactionUtil;
import org.tron.protos.Protocol;
import org.tron.protos.contract.WitnessContract;

public class WitnessUpdateActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public WitnessUpdateActuator() {
        super(Protocol.Transaction.Contract.ContractType.WitnessUpdateContract, WitnessContract.WitnessUpdateContract.class);
    }

    private void updateWitness(WitnessContract.WitnessUpdateContract contract) {
        WitnessStore witnessStore = this.chainBaseManager.getWitnessStore();
        WitnessCapsule witnessCapsule = witnessStore.get(contract.getOwnerAddress().toByteArray());
        witnessCapsule.setUrl(contract.getUpdateUrl().toStringUtf8());
        witnessStore.put(witnessCapsule.createDbKey(), (ProtoCapsule)witnessCapsule);
    }

    public boolean execute(Object result) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        try {
            WitnessContract.WitnessUpdateContract witnessUpdateContract = (WitnessContract.WitnessUpdateContract)this.any.unpack(WitnessContract.WitnessUpdateContract.class);
            this.updateWitness(witnessUpdateContract);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        WitnessContract.WitnessUpdateContract contract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or witness store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        WitnessStore witnessStore = this.chainBaseManager.getWitnessStore();
        if (!this.any.is(WitnessContract.WitnessUpdateContract.class)) {
            throw new ContractValidateException("contract type error, expected type [WitnessUpdateContract],real type[" + this.any.getClass() + "]");
        }
        try {
            contract = (WitnessContract.WitnessUpdateContract)this.any.unpack(WitnessContract.WitnessUpdateContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        if (!accountStore.has(ownerAddress)) {
            throw new ContractValidateException("account does not exist");
        }
        if (!TransactionUtil.validUrl(contract.getUpdateUrl().toByteArray())) {
            throw new ContractValidateException("Invalid url");
        }
        if (!witnessStore.has(ownerAddress)) {
            throw new ContractValidateException("Witness does not exist");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((WitnessContract.WitnessUpdateContract)this.any.unpack(WitnessContract.WitnessUpdateContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

