/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.trace;

import org.tron.common.runtime.vm.DataWord;
import org.tron.core.vm.program.listener.ProgramListenerAdaptor;
import org.tron.core.vm.trace.OpActions;

public class ProgramTraceListener
extends ProgramListenerAdaptor {
    private final boolean enabled;
    private OpActions actions = new OpActions();

    public ProgramTraceListener(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void onMemoryExtend(int delta) {
        if (this.enabled) {
            this.actions.addMemoryExtend(delta);
        }
    }

    @Override
    public void onMemoryWrite(int address, byte[] data, int size) {
        if (this.enabled) {
            this.actions.addMemoryWrite(address, data, size);
        }
    }

    @Override
    public void onStackPop() {
        if (this.enabled) {
            this.actions.addStackPop();
        }
    }

    @Override
    public void onStackPush(DataWord value) {
        if (this.enabled) {
            this.actions.addStackPush(value);
        }
    }

    @Override
    public void onStackSwap(int from, int to) {
        if (this.enabled) {
            this.actions.addStackSwap(from, to);
        }
    }

    @Override
    public void onStoragePut(DataWord key, DataWord value) {
        if (this.enabled) {
            if (value.equals((Object)DataWord.ZERO)) {
                this.actions.addStorageRemove(key);
            } else {
                this.actions.addStoragePut(key, value);
            }
        }
    }

    @Override
    public void onStorageClear() {
        if (this.enabled) {
            this.actions.addStorageClear();
        }
    }

    public OpActions resetActions() {
        OpActions actions = this.actions;
        this.actions = new OpActions();
        return actions;
    }
}

