/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.repository;

public class Type
implements Cloneable {
    public static final int NORMAL = 0;
    public static final int DIRTY = 1;
    public static final int CREATE = 2;
    public static final int UNKNOWN = -4;
    protected int type = 0;

    public Type() {
    }

    public Type(int type) {
        this.type |= type;
    }

    private Type(Type t) {
        this.type = t.type;
    }

    public Type clone() {
        return new Type(this);
    }

    public boolean isDirty() {
        return (this.type & 1) == 1;
    }

    public boolean isNormal() {
        return this.type == 0;
    }

    public boolean isCreate() {
        return (this.type & 2) == 2;
    }

    public boolean shouldCommit() {
        return this.type != 0;
    }

    public Type setType(int type) {
        if (this.isValidType(type)) {
            this.type = type;
        }
        return this;
    }

    public boolean isValidType(int type) {
        return (type & 0xFFFFFFFC) == 0;
    }

    public int addType(int type) {
        if (this.isValidType(type)) {
            this.type |= type;
        }
        return this.type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Type other = (Type)obj;
        return this.type == other.type;
    }

    public int hashCode() {
        return new Integer(this.type).hashCode();
    }

    public String toString() {
        return "Type{type=" + this.type + '}';
    }
}

