/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.nativecontract;

import com.google.common.math.LongMath;
import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.StringUtil;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.VotesCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.vm.nativecontract.param.VoteWitnessParam;
import org.tron.core.vm.repository.Repository;
import org.tron.core.vm.utils.VoteRewardUtil;
import org.tron.protos.Protocol;

public class VoteWitnessProcessor {
    private static final Logger logger = LoggerFactory.getLogger((String)"VMProcessor");

    public void validate(VoteWitnessParam param, Repository repo) throws ContractValidateException {
        if (repo == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        if (param.getVotes().size() > 30) {
            throw new ContractValidateException("VoteNumber more than maxVoteNumber 30");
        }
    }

    public void execute(VoteWitnessParam param, Repository repo) throws ContractExeException {
        byte[] ownerAddress = param.getVoterAddress();
        VoteRewardUtil.withdrawReward(ownerAddress, repo);
        AccountCapsule accountCapsule = repo.getAccount(ownerAddress);
        VotesCapsule votesCapsule = repo.getVotes(ownerAddress);
        if (votesCapsule == null) {
            votesCapsule = new VotesCapsule(ByteString.copyFrom((byte[])ownerAddress), accountCapsule.getVotesList());
        }
        accountCapsule.clearVotes();
        votesCapsule.clearNewVotes();
        HashMap<ByteString, Long> voteMap = new HashMap<ByteString, Long>();
        Iterator<Protocol.Vote> iterator = param.getVotes().iterator();
        try {
            long sum = 0L;
            while (iterator.hasNext()) {
                Protocol.Vote vote = iterator.next();
                byte[] witnessAddress = vote.getVoteAddress().toByteArray();
                if (repo.getWitness(witnessAddress) == null) {
                    throw new ContractExeException("Witness[" + StringUtil.encode58Check((byte[])witnessAddress) + "] not exists");
                }
                long voteCount = vote.getVoteCount();
                if (voteCount < 0L) {
                    throw new ContractExeException("Vote count must not be less than 0");
                }
                if (voteCount == 0L) {
                    iterator.remove();
                    continue;
                }
                sum = LongMath.checkedAdd((long)sum, (long)voteCount);
                voteMap.put(vote.getVoteAddress(), LongMath.checkedAdd((long)voteMap.getOrDefault(vote.getVoteAddress(), 0L), (long)voteCount));
            }
            long tronPower = repo.getDynamicPropertiesStore().supportUnfreezeDelay() && repo.getDynamicPropertiesStore().supportAllowNewResourceModel() ? accountCapsule.getAllTronPower() : accountCapsule.getTronPower();
            if ((sum = LongMath.checkedMultiply((long)sum, (long)1000000L)) > tronPower) {
                throw new ContractExeException("The total number of votes[" + sum + "] is greater than the tronPower[" + tronPower + "]");
            }
        }
        catch (ArithmeticException e) {
            throw new ContractExeException(e.getMessage());
        }
        for (Map.Entry entry : voteMap.entrySet()) {
            accountCapsule.addVotes((ByteString)entry.getKey(), ((Long)entry.getValue()).longValue());
            votesCapsule.addNewVotes((ByteString)entry.getKey(), ((Long)entry.getValue()).longValue());
        }
        repo.updateAccount(accountCapsule.createDbKey(), accountCapsule);
        repo.updateVotes(ownerAddress, votesCapsule);
    }
}

