/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.nativecontract;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.FastByteComparisons;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.capsule.VotesCapsule;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.vm.config.VMConfig;
import org.tron.core.vm.nativecontract.param.UnfreezeBalanceParam;
import org.tron.core.vm.repository.Repository;
import org.tron.core.vm.utils.VoteRewardUtil;
import org.tron.protos.Protocol;

public class UnfreezeBalanceProcessor {
    private static final Logger logger = LoggerFactory.getLogger((String)"VMProcessor");

    public void validate(UnfreezeBalanceParam param, Repository repo) throws ContractValidateException {
        block17: {
            long now;
            AccountCapsule ownerCapsule;
            block16: {
                if (repo == null) {
                    throw new ContractValidateException("No account store or dynamic store!");
                }
                byte[] ownerAddress = param.getOwnerAddress();
                ownerCapsule = repo.getAccount(ownerAddress);
                byte[] receiverAddress = param.getReceiverAddress();
                now = repo.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp();
                if (FastByteComparisons.isEqual((byte[])ownerAddress, (byte[])receiverAddress)) break block16;
                param.setDelegating(true);
                byte[] key = DelegatedResourceCapsule.createDbKey((byte[])ownerAddress, (byte[])receiverAddress);
                DelegatedResourceCapsule delegatedResourceCapsule = repo.getDelegatedResource(key);
                if (delegatedResourceCapsule == null) {
                    throw new ContractValidateException("delegated Resource does not exist");
                }
                switch (param.getResourceType()) {
                    case BANDWIDTH: {
                        if (delegatedResourceCapsule.getFrozenBalanceForBandwidth() <= 0L) {
                            throw new ContractValidateException("no delegatedFrozenBalance(BANDWIDTH)");
                        }
                        if (delegatedResourceCapsule.getExpireTimeForBandwidth() > now) {
                            throw new ContractValidateException("It's not time to unfreeze(BANDWIDTH).");
                        }
                        break block17;
                    }
                    case ENERGY: {
                        if (delegatedResourceCapsule.getFrozenBalanceForEnergy() <= 0L) {
                            throw new ContractValidateException("no delegateFrozenBalance(Energy)");
                        }
                        if (delegatedResourceCapsule.getExpireTimeForEnergy() > now) {
                            throw new ContractValidateException("It's not time to unfreeze(Energy).");
                        }
                        break block17;
                    }
                    default: {
                        throw new ContractValidateException("Unknown ResourceCode, valid ResourceCode[BANDWIDTH\u3001ENERGY]");
                    }
                }
            }
            switch (param.getResourceType()) {
                case BANDWIDTH: {
                    if (ownerCapsule.getFrozenCount() <= 0) {
                        throw new ContractValidateException("no frozenBalance(BANDWIDTH)");
                    }
                    long allowedUnfreezeCount = ownerCapsule.getFrozenList().stream().filter(frozen -> frozen.getExpireTime() <= now).count();
                    if (allowedUnfreezeCount > 0L) break;
                    throw new ContractValidateException("It's not time to unfreeze(BANDWIDTH).");
                }
                case ENERGY: {
                    Protocol.Account.Frozen frozenForEnergy = ownerCapsule.getAccountResource().getFrozenBalanceForEnergy();
                    if (frozenForEnergy.getFrozenBalance() <= 0L) {
                        throw new ContractValidateException("no frozenBalance(Energy)");
                    }
                    if (frozenForEnergy.getExpireTime() <= now) break;
                    throw new ContractValidateException("It's not time to unfreeze(Energy).");
                }
                default: {
                    throw new ContractValidateException("Unknown ResourceCode, valid ResourceCode[BANDWIDTH\u3001ENERGY]");
                }
            }
        }
    }

    public long execute(UnfreezeBalanceParam param, Repository repo) {
        byte[] ownerAddress = param.getOwnerAddress();
        byte[] receiverAddress = param.getReceiverAddress();
        AccountCapsule accountCapsule = repo.getAccount(ownerAddress);
        long oldBalance = accountCapsule.getBalance();
        long unfreezeBalance = 0L;
        if (param.isDelegating()) {
            byte[] key = DelegatedResourceCapsule.createDbKey((byte[])ownerAddress, (byte[])receiverAddress);
            DelegatedResourceCapsule delegatedResourceCapsule = repo.getDelegatedResource(key);
            switch (param.getResourceType()) {
                case BANDWIDTH: {
                    unfreezeBalance = delegatedResourceCapsule.getFrozenBalanceForBandwidth();
                    delegatedResourceCapsule.setFrozenBalanceForBandwidth(0L, 0L);
                    accountCapsule.addDelegatedFrozenBalanceForBandwidth(-unfreezeBalance);
                    break;
                }
                case ENERGY: {
                    unfreezeBalance = delegatedResourceCapsule.getFrozenBalanceForEnergy();
                    delegatedResourceCapsule.setFrozenBalanceForEnergy(0L, 0L);
                    accountCapsule.addDelegatedFrozenBalanceForEnergy(-unfreezeBalance);
                    break;
                }
            }
            repo.updateDelegatedResource(key, delegatedResourceCapsule);
            AccountCapsule receiverCapsule = repo.getAccount(receiverAddress);
            if (receiverCapsule != null) {
                switch (param.getResourceType()) {
                    case BANDWIDTH: {
                        receiverCapsule.safeAddAcquiredDelegatedFrozenBalanceForBandwidth(-unfreezeBalance);
                        break;
                    }
                    case ENERGY: {
                        receiverCapsule.safeAddAcquiredDelegatedFrozenBalanceForEnergy(-unfreezeBalance);
                        break;
                    }
                }
                repo.updateAccount(receiverCapsule.createDbKey(), receiverCapsule);
            }
            accountCapsule.setBalance(oldBalance + unfreezeBalance);
        } else {
            switch (param.getResourceType()) {
                case BANDWIDTH: {
                    ArrayList frozenList = Lists.newArrayList();
                    frozenList.addAll(accountCapsule.getFrozenList());
                    Iterator iterator = frozenList.iterator();
                    long now = repo.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp();
                    while (iterator.hasNext()) {
                        Protocol.Account.Frozen next = (Protocol.Account.Frozen)iterator.next();
                        if (next.getExpireTime() > now) continue;
                        unfreezeBalance += next.getFrozenBalance();
                        iterator.remove();
                    }
                    accountCapsule.setInstance(accountCapsule.getInstance().toBuilder().setBalance(oldBalance + unfreezeBalance).clearFrozen().addAllFrozen((Iterable)frozenList).build());
                    break;
                }
                case ENERGY: {
                    unfreezeBalance = accountCapsule.getAccountResource().getFrozenBalanceForEnergy().getFrozenBalance();
                    Protocol.Account.AccountResource newAccountResource = accountCapsule.getAccountResource().toBuilder().clearFrozenBalanceForEnergy().build();
                    accountCapsule.setInstance(accountCapsule.getInstance().toBuilder().setBalance(oldBalance + unfreezeBalance).setAccountResource(newAccountResource).build());
                    break;
                }
            }
        }
        switch (param.getResourceType()) {
            case BANDWIDTH: {
                repo.addTotalNetWeight(-unfreezeBalance / 1000000L);
                break;
            }
            case ENERGY: {
                repo.addTotalEnergyWeight(-unfreezeBalance / 1000000L);
                break;
            }
        }
        repo.updateAccount(accountCapsule.createDbKey(), accountCapsule);
        if (VMConfig.allowTvmVote() && !accountCapsule.getVotesList().isEmpty()) {
            long usedTronPower = 0L;
            for (Protocol.Vote vote : accountCapsule.getVotesList()) {
                usedTronPower += vote.getVoteCount();
            }
            if (accountCapsule.getTronPower() < usedTronPower * 1000000L) {
                VoteRewardUtil.withdrawReward(ownerAddress, repo);
                VotesCapsule votesCapsule = repo.getVotes(ownerAddress);
                accountCapsule = repo.getAccount(ownerAddress);
                if (votesCapsule == null) {
                    votesCapsule = new VotesCapsule(ByteString.copyFrom((byte[])ownerAddress), accountCapsule.getVotesList());
                } else {
                    votesCapsule.clearNewVotes();
                }
                accountCapsule.clearVotes();
                repo.updateVotes(ownerAddress, votesCapsule);
                repo.updateAccount(ownerAddress, accountCapsule);
            }
        }
        return unfreezeBalance;
    }
}

