/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.parameter.CommonParameter;
import org.tron.core.capsule.ReceiptCapsule;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.StoreFactory;
import org.tron.core.vm.config.VMConfig;

public class ConfigLoader {
    private static final Logger logger = LoggerFactory.getLogger((String)"VMConfigLoader");
    public static boolean disable = false;

    public static void load(StoreFactory storeFactory) {
        if (!disable) {
            DynamicPropertiesStore ds = storeFactory.getChainBaseManager().getDynamicPropertiesStore();
            VMConfig.setVmTrace(CommonParameter.getInstance().isVmTrace());
            if (ds != null) {
                VMConfig.initVmHardFork(ReceiptCapsule.checkForEnergyLimit((DynamicPropertiesStore)ds));
                VMConfig.initAllowMultiSign(ds.getAllowMultiSign());
                VMConfig.initAllowTvmTransferTrc10(ds.getAllowTvmTransferTrc10());
                VMConfig.initAllowTvmConstantinople(ds.getAllowTvmConstantinople());
                VMConfig.initAllowTvmSolidity059(ds.getAllowTvmSolidity059());
                VMConfig.initAllowShieldedTRC20Transaction(ds.getAllowShieldedTRC20Transaction());
                VMConfig.initAllowTvmIstanbul(ds.getAllowTvmIstanbul());
                VMConfig.initAllowTvmFreeze(ds.getAllowTvmFreeze());
                VMConfig.initAllowTvmVote(ds.getAllowTvmVote());
                VMConfig.initAllowTvmLondon(ds.getAllowTvmLondon());
                VMConfig.initAllowTvmCompatibleEvm(ds.getAllowTvmCompatibleEvm());
                VMConfig.initAllowHigherLimitForMaxCpuTimeOfOneTx(ds.getAllowHigherLimitForMaxCpuTimeOfOneTx());
                VMConfig.initAllowTvmFreezeV2(ds.supportUnfreezeDelay() ? 1L : 0L);
                VMConfig.initAllowOptimizedReturnValueOfChainId(ds.getAllowOptimizedReturnValueOfChainId());
                VMConfig.initAllowDynamicEnergy(ds.getAllowDynamicEnergy());
                VMConfig.initDynamicEnergyThreshold(ds.getDynamicEnergyThreshold());
                VMConfig.initDynamicEnergyIncreaseFactor(ds.getDynamicEnergyIncreaseFactor());
                VMConfig.initDynamicEnergyMaxFactor(ds.getDynamicEnergyMaxFactor());
                VMConfig.initAllowTvmShangHai(ds.getAllowTvmShangHai());
            }
        }
    }
}

