/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm;

import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.crypto.Blake2bfMessageDigest;
import org.tron.common.crypto.Hash;
import org.tron.common.crypto.SignUtils;
import org.tron.common.crypto.SignatureInterface;
import org.tron.common.crypto.zksnark.BN128;
import org.tron.common.crypto.zksnark.BN128Fp;
import org.tron.common.crypto.zksnark.BN128G1;
import org.tron.common.crypto.zksnark.BN128G2;
import org.tron.common.crypto.zksnark.Fp;
import org.tron.common.crypto.zksnark.PairingCheck;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.runtime.ProgramResult;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.utils.BIUtil;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.ByteUtil;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.zksnark.JLibrustzcash;
import org.tron.common.zksnark.LibrustzcashParam;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.db.TransactionTrace;
import org.tron.core.exception.ZksnarkException;
import org.tron.core.vm.ChainParameterEnum;
import org.tron.core.vm.config.VMConfig;
import org.tron.core.vm.program.Program;
import org.tron.core.vm.repository.Repository;
import org.tron.core.vm.utils.FreezeV2Util;
import org.tron.core.vm.utils.MUtil;
import org.tron.core.vm.utils.VoteRewardUtil;
import org.tron.protos.Protocol;

public class PrecompiledContracts {
    private static final Logger logger = LoggerFactory.getLogger((String)"VM");
    private static final ECRecover ecRecover = new ECRecover();
    private static final Sha256 sha256 = new Sha256();
    private static final Ripempd160 ripempd160 = new Ripempd160();
    private static final Identity identity = new Identity();
    private static final ModExp modExp = new ModExp();
    private static final BN128Addition altBN128Add = new BN128Addition();
    private static final BN128Multiplication altBN128Mul = new BN128Multiplication();
    private static final BN128Pairing altBN128Pairing = new BN128Pairing();
    private static final BatchValidateSign batchValidateSign = new BatchValidateSign();
    private static final ValidateMultiSign validateMultiSign = new ValidateMultiSign();
    private static final VerifyMintProof verifyMintProof = new VerifyMintProof();
    private static final VerifyTransferProof verifyTransferProof = new VerifyTransferProof();
    private static final VerifyBurnProof verifyBurnProof = new VerifyBurnProof();
    private static final MerkleHash merkleHash = new MerkleHash();
    private static final RewardBalance rewardBalance = new RewardBalance();
    private static final IsSrCandidate isSrCandidate = new IsSrCandidate();
    private static final VoteCount voteCount = new VoteCount();
    private static final UsedVoteCount usedVoteCount = new UsedVoteCount();
    private static final ReceivedVoteCount receivedVoteCount = new ReceivedVoteCount();
    private static final TotalVoteCount totalVoteCount = new TotalVoteCount();
    private static final EthRipemd160 ethRipemd160 = new EthRipemd160();
    private static final Blake2F blake2F = new Blake2F();
    private static final GetChainParameter getChainParameter = new GetChainParameter();
    private static final AvailableUnfreezeV2Size availableUnfreezeV2Size = new AvailableUnfreezeV2Size();
    private static final UnfreezableBalanceV2 unfreezableBalanceV2 = new UnfreezableBalanceV2();
    private static final ExpireUnfreezeBalanceV2 expireUnfreezeBalanceV2 = new ExpireUnfreezeBalanceV2();
    private static final DelegatableResource delegatableResource = new DelegatableResource();
    private static final ResourceV2 resourceV2 = new ResourceV2();
    private static final CheckUnDelegateResource checkUnDelegateResource = new CheckUnDelegateResource();
    private static final ResourceUsage resourceUsage = new ResourceUsage();
    private static final TotalResource totalResource = new TotalResource();
    private static final TotalDelegatedResource totalDelegatedResource = new TotalDelegatedResource();
    private static final TotalAcquiredResource totalAcquiredResource = new TotalAcquiredResource();
    private static final DataWord ecRecoverAddr = new DataWord("0000000000000000000000000000000000000000000000000000000000000001");
    private static final DataWord sha256Addr = new DataWord("0000000000000000000000000000000000000000000000000000000000000002");
    private static final DataWord ripempd160Addr = new DataWord("0000000000000000000000000000000000000000000000000000000000000003");
    private static final DataWord identityAddr = new DataWord("0000000000000000000000000000000000000000000000000000000000000004");
    private static final DataWord modExpAddr = new DataWord("0000000000000000000000000000000000000000000000000000000000000005");
    private static final DataWord altBN128AddAddr = new DataWord("0000000000000000000000000000000000000000000000000000000000000006");
    private static final DataWord altBN128MulAddr = new DataWord("0000000000000000000000000000000000000000000000000000000000000007");
    private static final DataWord altBN128PairingAddr = new DataWord("0000000000000000000000000000000000000000000000000000000000000008");
    private static final DataWord batchValidateSignAddr = new DataWord("0000000000000000000000000000000000000000000000000000000000000009");
    private static final DataWord validateMultiSignAddr = new DataWord("000000000000000000000000000000000000000000000000000000000000000a");
    private static final DataWord verifyMintProofAddr = new DataWord("0000000000000000000000000000000000000000000000000000000001000001");
    private static final DataWord verifyTransferProofAddr = new DataWord("0000000000000000000000000000000000000000000000000000000001000002");
    private static final DataWord verifyBurnProofAddr = new DataWord("0000000000000000000000000000000000000000000000000000000001000003");
    private static final DataWord merkleHashAddr = new DataWord("0000000000000000000000000000000000000000000000000000000001000004");
    private static final DataWord rewardBalanceAddr = new DataWord("0000000000000000000000000000000000000000000000000000000001000005");
    private static final DataWord isSrCandidateAddr = new DataWord("0000000000000000000000000000000000000000000000000000000001000006");
    private static final DataWord voteCountAddr = new DataWord("0000000000000000000000000000000000000000000000000000000001000007");
    private static final DataWord usedVoteCountAddr = new DataWord("0000000000000000000000000000000000000000000000000000000001000008");
    private static final DataWord receivedVoteCountAddr = new DataWord("0000000000000000000000000000000000000000000000000000000001000009");
    private static final DataWord totalVoteCountAddr = new DataWord("000000000000000000000000000000000000000000000000000000000100000a");
    private static final DataWord getChainParameterAddr = new DataWord("000000000000000000000000000000000000000000000000000000000100000b");
    private static final DataWord availableUnfreezeV2SizeAddr = new DataWord("000000000000000000000000000000000000000000000000000000000100000c");
    private static final DataWord unfreezableBalanceV2Addr = new DataWord("000000000000000000000000000000000000000000000000000000000100000d");
    private static final DataWord expireUnfreezeBalanceV2Addr = new DataWord("000000000000000000000000000000000000000000000000000000000100000e");
    private static final DataWord delegatableResourceAddr = new DataWord("000000000000000000000000000000000000000000000000000000000100000f");
    private static final DataWord resourceV2Addr = new DataWord("0000000000000000000000000000000000000000000000000000000001000010");
    private static final DataWord checkUnDelegateResourceAddr = new DataWord("0000000000000000000000000000000000000000000000000000000001000011");
    private static final DataWord resourceUsageAddr = new DataWord("0000000000000000000000000000000000000000000000000000000001000012");
    private static final DataWord totalResourceAddr = new DataWord("0000000000000000000000000000000000000000000000000000000001000013");
    private static final DataWord totalDelegatedResourceAddr = new DataWord("0000000000000000000000000000000000000000000000000000000001000014");
    private static final DataWord totalAcquiredResourceAddr = new DataWord("0000000000000000000000000000000000000000000000000000000001000015");
    private static final DataWord ethRipemd160Addr = new DataWord("0000000000000000000000000000000000000000000000000000000000020003");
    private static final DataWord blake2FAddr = new DataWord("0000000000000000000000000000000000000000000000000000000000020009");

    public static PrecompiledContract getContractForAddress(DataWord address) {
        if (address == null) {
            return identity;
        }
        if (address.equals((Object)ecRecoverAddr)) {
            return ecRecover;
        }
        if (address.equals((Object)sha256Addr)) {
            return sha256;
        }
        if (address.equals((Object)ripempd160Addr)) {
            return ripempd160;
        }
        if (address.equals((Object)identityAddr)) {
            return identity;
        }
        if (address.equals((Object)modExpAddr)) {
            return modExp;
        }
        if (address.equals((Object)altBN128AddAddr)) {
            return altBN128Add;
        }
        if (address.equals((Object)altBN128MulAddr)) {
            return altBN128Mul;
        }
        if (address.equals((Object)altBN128PairingAddr)) {
            return altBN128Pairing;
        }
        if (VMConfig.allowTvmSolidity059() && address.equals((Object)batchValidateSignAddr)) {
            return batchValidateSign;
        }
        if (VMConfig.allowTvmSolidity059() && address.equals((Object)validateMultiSignAddr)) {
            return validateMultiSign;
        }
        if (VMConfig.allowShieldedTRC20Transaction() && address.equals((Object)verifyMintProofAddr)) {
            return verifyMintProof;
        }
        if (VMConfig.allowShieldedTRC20Transaction() && address.equals((Object)verifyTransferProofAddr)) {
            return verifyTransferProof;
        }
        if (VMConfig.allowShieldedTRC20Transaction() && address.equals((Object)verifyBurnProofAddr)) {
            return verifyBurnProof;
        }
        if (VMConfig.allowShieldedTRC20Transaction() && address.equals((Object)merkleHashAddr)) {
            return merkleHash;
        }
        if (VMConfig.allowTvmVote() && address.equals((Object)rewardBalanceAddr)) {
            return rewardBalance;
        }
        if (VMConfig.allowTvmVote() && address.equals((Object)isSrCandidateAddr)) {
            return isSrCandidate;
        }
        if (VMConfig.allowTvmVote() && address.equals((Object)voteCountAddr)) {
            return voteCount;
        }
        if (VMConfig.allowTvmVote() && address.equals((Object)usedVoteCountAddr)) {
            return usedVoteCount;
        }
        if (VMConfig.allowTvmVote() && address.equals((Object)receivedVoteCountAddr)) {
            return receivedVoteCount;
        }
        if (VMConfig.allowTvmVote() && address.equals((Object)totalVoteCountAddr)) {
            return totalVoteCount;
        }
        if (VMConfig.allowTvmCompatibleEvm() && address.equals((Object)ethRipemd160Addr)) {
            return ethRipemd160;
        }
        if (VMConfig.allowTvmCompatibleEvm() && address.equals((Object)blake2FAddr)) {
            return blake2F;
        }
        if (VMConfig.allowTvmFreezeV2()) {
            if (address.equals((Object)getChainParameterAddr)) {
                return getChainParameter;
            }
            if (address.equals((Object)availableUnfreezeV2SizeAddr)) {
                return availableUnfreezeV2Size;
            }
            if (address.equals((Object)unfreezableBalanceV2Addr)) {
                return unfreezableBalanceV2;
            }
            if (address.equals((Object)expireUnfreezeBalanceV2Addr)) {
                return expireUnfreezeBalanceV2;
            }
            if (address.equals((Object)delegatableResourceAddr)) {
                return delegatableResource;
            }
            if (address.equals((Object)resourceV2Addr)) {
                return resourceV2;
            }
            if (address.equals((Object)checkUnDelegateResourceAddr)) {
                return checkUnDelegateResource;
            }
            if (address.equals((Object)resourceUsageAddr)) {
                return resourceUsage;
            }
            if (address.equals((Object)totalResourceAddr)) {
                return totalResource;
            }
            if (address.equals((Object)totalDelegatedResourceAddr)) {
                return totalDelegatedResource;
            }
            if (address.equals((Object)totalAcquiredResourceAddr)) {
                return totalAcquiredResource;
            }
        }
        return null;
    }

    private static byte[] encodeRes(byte[] w1, byte[] w2) {
        byte[] res = new byte[64];
        w1 = ByteUtil.stripLeadingZeroes((byte[])w1);
        w2 = ByteUtil.stripLeadingZeroes((byte[])w2);
        System.arraycopy(w1, 0, res, 32 - w1.length, w1.length);
        System.arraycopy(w2, 0, res, 64 - w2.length, w2.length);
        return res;
    }

    private static byte[] encodeMultiRes(byte[] ... words) {
        if (words == null) {
            return null;
        }
        if (words.length == 1) {
            return words[0];
        }
        byte[] res = new byte[words.length * 32];
        for (int i = 0; i < words.length; ++i) {
            byte[] word = ByteUtil.stripLeadingZeroes((byte[])words[i]);
            System.arraycopy(word, 0, res, 32 * (i + 1) - word.length, word.length);
        }
        return res;
    }

    private static byte[] recoverAddrBySign(byte[] sign, byte[] hash) {
        byte[] out = null;
        if (ArrayUtils.isEmpty((byte[])sign) || sign.length < 65) {
            return new byte[0];
        }
        try {
            SignatureInterface signature;
            byte[] r = Arrays.copyOfRange(sign, 0, 32);
            byte[] s = Arrays.copyOfRange(sign, 32, 64);
            byte v = sign[64];
            if (v < 27) {
                v = (byte)(v + 27);
            }
            if ((signature = SignUtils.fromComponents((byte[])r, (byte[])s, (byte)v, (boolean)CommonParameter.getInstance().isECKeyCryptoEngine())).validateComponents()) {
                out = SignUtils.signatureToAddress((byte[])hash, (SignatureInterface)signature, (boolean)CommonParameter.getInstance().isECKeyCryptoEngine());
            }
        }
        catch (Throwable any) {
            logger.info("ECRecover error", (Object)any.getMessage());
        }
        return out;
    }

    private static byte[][] extractBytes32Array(DataWord[] words, int offset) {
        int len = words[offset].intValueSafe();
        byte[][] bytes32Array = new byte[len][];
        for (int i = 0; i < len; ++i) {
            bytes32Array[i] = words[offset + i + 1].getData();
        }
        return bytes32Array;
    }

    private static byte[][] extractBytesArray(DataWord[] words, int offset, byte[] data) {
        if (offset > words.length - 1) {
            return new byte[0][];
        }
        int len = words[offset].intValueSafe();
        byte[][] bytesArray = new byte[len][];
        for (int i = 0; i < len; ++i) {
            int bytesOffset = words[offset + i + 1].intValueSafe() / 32;
            int bytesLen = words[offset + bytesOffset + 1].intValueSafe();
            bytesArray[i] = PrecompiledContracts.extractBytes(data, (bytesOffset + offset + 2) * 32, bytesLen);
        }
        return bytesArray;
    }

    private static byte[] extractBytes(byte[] data, int offset, int len) {
        return Arrays.copyOfRange(data, offset, offset + len);
    }

    public static class TotalAcquiredResource
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 50L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null || data.length != 64) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            DataWord[] words = DataWord.parseArray((byte[])data);
            byte[] address = words[0].toTronAddress();
            long type = words[1].longValueSafe();
            AccountCapsule accountCapsule = this.getDeposit().getAccount(address);
            if (accountCapsule == null) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            long acquiredResource = 0L;
            if (type == 0L) {
                acquiredResource = accountCapsule.getTotalAcquiredDelegatedFrozenBalanceForBandwidth();
            } else if (type == 1L) {
                acquiredResource = accountCapsule.getTotalAcquiredDelegatedFrozenBalanceForEnergy();
            }
            return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)acquiredResource));
        }
    }

    public static class TotalDelegatedResource
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 50L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null || data.length != 64) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            DataWord[] words = DataWord.parseArray((byte[])data);
            byte[] address = words[0].toTronAddress();
            long type = words[1].longValueSafe();
            AccountCapsule accountCapsule = this.getDeposit().getAccount(address);
            if (accountCapsule == null) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            long delegatedResource = 0L;
            if (type == 0L) {
                delegatedResource = accountCapsule.getTotalDelegatedFrozenBalanceForBandwidth();
            } else if (type == 1L) {
                delegatedResource = accountCapsule.getTotalDelegatedFrozenBalanceForEnergy();
            }
            return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)delegatedResource));
        }
    }

    public static class TotalResource
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 50L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null || data.length != 64) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            DataWord[] words = DataWord.parseArray((byte[])data);
            byte[] address = words[0].toTronAddress();
            long type = words[1].longValueSafe();
            AccountCapsule accountCapsule = this.getDeposit().getAccount(address);
            if (accountCapsule == null) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            long totalResource = 0L;
            if (type == 0L) {
                totalResource = accountCapsule.getAllFrozenBalanceForBandwidth();
            } else if (type == 1L) {
                totalResource = accountCapsule.getAllFrozenBalanceForEnergy();
            }
            return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)totalResource));
        }
    }

    public static class ResourceUsage
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 50L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            long type;
            if (data == null || data.length != 64) {
                return Pair.of((Object)true, (Object)PrecompiledContracts.encodeRes(DataWord.ZERO().getData(), DataWord.ZERO().getData()));
            }
            DataWord[] words = DataWord.parseArray((byte[])data);
            byte[] address = words[0].toTronAddress();
            Pair<Long, Long> values = FreezeV2Util.queryFrozenBalanceUsage(address, type = words[1].longValueSafe(), this.getDeposit());
            if (values == null || values.getLeft() == null || values.getRight() == null) {
                return Pair.of((Object)true, (Object)PrecompiledContracts.encodeRes(DataWord.ZERO().getData(), DataWord.ZERO().getData()));
            }
            return Pair.of((Object)true, (Object)PrecompiledContracts.encodeRes(ByteUtil.longTo32Bytes((long)((Long)values.getLeft())), ByteUtil.longTo32Bytes((long)((Long)values.getRight()))));
        }
    }

    public static class CheckUnDelegateResource
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 50L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            long type;
            long amount;
            if (data == null || data.length != 96) {
                return Pair.of((Object)true, (Object)PrecompiledContracts.encodeMultiRes(new byte[][]{DataWord.ZERO().getData(), DataWord.ZERO().getData(), DataWord.ZERO().getData()}));
            }
            DataWord[] words = DataWord.parseArray((byte[])data);
            byte[] target = words[0].toTronAddress();
            Triple<Long, Long, Long> values = FreezeV2Util.checkUndelegateResource(target, amount = words[1].longValueSafe(), type = words[2].longValueSafe(), this.getDeposit());
            if (values == null || values.getLeft() == null || values.getMiddle() == null || values.getRight() == null) {
                return Pair.of((Object)true, (Object)PrecompiledContracts.encodeMultiRes(new byte[][]{DataWord.ZERO().getData(), DataWord.ZERO().getData(), DataWord.ZERO().getData()}));
            }
            return Pair.of((Object)true, (Object)PrecompiledContracts.encodeMultiRes(new byte[][]{ByteUtil.longTo32Bytes((long)((Long)values.getLeft())), ByteUtil.longTo32Bytes((long)((Long)values.getMiddle())), ByteUtil.longTo32Bytes((long)((Long)values.getRight()))}));
        }
    }

    public static class ResourceV2
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 50L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null || data.length != 96) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            DataWord[] words = DataWord.parseArray((byte[])data);
            byte[] target = words[0].toTronAddress();
            byte[] from = words[1].toTronAddress();
            long type = words[2].longValueSafe();
            long balance = Arrays.equals(from, target) ? FreezeV2Util.queryUnfreezableBalanceV2(from, type, this.getDeposit()) : FreezeV2Util.queryResourceV2(from, target, type, this.getDeposit());
            return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)balance));
        }
    }

    public static class DelegatableResource
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 50L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null || data.length != 64) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            DataWord[] words = DataWord.parseArray((byte[])data);
            byte[] address = words[0].toTronAddress();
            long type = words[1].longValueSafe();
            long result = FreezeV2Util.queryDelegatableResource(address, type, this.getDeposit());
            return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)result));
        }
    }

    public static class ExpireUnfreezeBalanceV2
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 50L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null || data.length != 64) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            DataWord[] words = DataWord.parseArray((byte[])data);
            byte[] address = words[0].toTronAddress();
            long time = words[1].longValueSafe();
            if (time < 0L) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            time = time >= 9223372036854775L ? Long.MAX_VALUE : (time *= 1000L);
            long balance = FreezeV2Util.queryExpireUnfreezeBalanceV2(address, time, this.getDeposit());
            return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)balance));
        }
    }

    public static class UnfreezableBalanceV2
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 50L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null || data.length != 64) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            DataWord[] words = DataWord.parseArray((byte[])data);
            byte[] address = words[0].toTronAddress();
            long type = words[1].longValueSafe();
            long balance = FreezeV2Util.queryUnfreezableBalanceV2(address, type, this.getDeposit());
            return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)balance));
        }
    }

    public static class AvailableUnfreezeV2Size
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 50L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null || data.length != 32) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            byte[] address = new DataWord(data).toTronAddress();
            long result = FreezeV2Util.queryAvailableUnfreezeV2Size(address, this.getDeposit());
            return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)result));
        }
    }

    public static class GetChainParameter
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 50L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null || data.length != 32) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            long code2 = new DataWord(data).longValueSafe();
            long res = ChainParameterEnum.fromCode(code2).getAction().apply(this.getDeposit());
            return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)res));
        }
    }

    public static class Blake2F
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            if (data.length != 213 || (data[212] & 0xFE) != 0) {
                return 0L;
            }
            byte[] roundsBytes = Arrays.copyOfRange(data, 0, 4);
            BigInteger rounds = new BigInteger(1, roundsBytes);
            return rounds.longValue();
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            byte[] result;
            if (data.length != 213) {
                logger.warn("Incorrect input length.  Expected {} and got {}", (Object)213, (Object)data.length);
                return Pair.of((Object)false, (Object)DataWord.ZERO().getData());
            }
            if ((data[212] & 0xFE) != 0) {
                logger.warn("Incorrect finalization flag, expected 0 or 1 and got {}", (Object)data[212]);
                return Pair.of((Object)false, (Object)DataWord.ZERO().getData());
            }
            Blake2bfMessageDigest digest = new Blake2bfMessageDigest();
            try {
                digest.update(data);
                result = digest.digest();
            }
            catch (Exception e) {
                return Pair.of((Object)true, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
            }
            return Pair.of((Object)true, (Object)result);
        }
    }

    public static class EthRipemd160
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            if (data == null) {
                return 600L;
            }
            return 600L + (long)((data.length + 31) / 32) * 120L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            byte[] result = data == null ? Hash.ripemd160((byte[])ByteUtil.EMPTY_BYTE_ARRAY) : Hash.ripemd160((byte[])data);
            return Pair.of((Object)true, (Object)new DataWord(result).getData());
        }
    }

    public static class TotalVoteCount
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 20L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null || data.length != 32) {
                return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)0L));
            }
            byte[] address = new DataWord(data).toTronAddress();
            AccountCapsule accountCapsule = this.getDeposit().getAccount(address);
            long tronPower = accountCapsule == null ? 0L : (this.getDeposit().getDynamicPropertiesStore().supportUnfreezeDelay() && this.getDeposit().getDynamicPropertiesStore().supportAllowNewResourceModel() ? accountCapsule.getAllTronPower() : accountCapsule.getTronPower());
            return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)(tronPower / 1000000L)));
        }
    }

    public static class ReceivedVoteCount
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 20L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null || data.length != 32) {
                return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)0L));
            }
            byte[] address = new DataWord(data).toTronAddress();
            WitnessCapsule witnessCapsule = this.getDeposit().getWitness(address);
            long voteCount = witnessCapsule != null ? witnessCapsule.getVoteCount() : 0L;
            return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)voteCount));
        }
    }

    public static class UsedVoteCount
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 20L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null || data.length != 32) {
                return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)0L));
            }
            byte[] address = new DataWord(data).toTronAddress();
            AccountCapsule accountCapsule = this.getDeposit().getAccount(address);
            long usedVoteCount = 0L;
            if (accountCapsule != null && !accountCapsule.getVotesList().isEmpty()) {
                for (Protocol.Vote vote : accountCapsule.getVotesList()) {
                    usedVoteCount += vote.getVoteCount();
                }
            }
            return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)usedVoteCount));
        }
    }

    public static class VoteCount
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 500L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null || data.length != 64) {
                return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)0L));
            }
            DataWord[] words = DataWord.parseArray((byte[])data);
            byte[] address = words[0].toTronAddress();
            AccountCapsule accountCapsule = this.getDeposit().getAccount(address);
            long voteCount = 0L;
            if (accountCapsule != null && !accountCapsule.getVotesList().isEmpty()) {
                ByteString witness = ByteString.copyFrom((byte[])words[1].toTronAddress());
                for (Protocol.Vote vote : accountCapsule.getVotesList()) {
                    if (!witness.equals((Object)vote.getVoteAddress())) continue;
                    voteCount += vote.getVoteCount();
                }
            }
            return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)voteCount));
        }
    }

    public static class IsSrCandidate
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 20L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null || data.length != 32) {
                return Pair.of((Object)true, (Object)this.dataBoolean(false));
            }
            byte[] address = new DataWord(data).toTronAddress();
            WitnessCapsule witnessCapsule = this.getDeposit().getWitness(address);
            if (witnessCapsule != null) {
                return Pair.of((Object)true, (Object)this.dataBoolean(true));
            }
            return Pair.of((Object)true, (Object)this.dataBoolean(false));
        }
    }

    public static class RewardBalance
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 500L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            long rewardBalance = VoteRewardUtil.queryReward(TransactionTrace.convertToTronAddress((byte[])this.getCallerAddress()), this.getDeposit());
            return Pair.of((Object)true, (Object)ByteUtil.longTo32Bytes((long)rewardBalance));
        }
    }

    public static class MerkleHash
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            return 500L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            byte[] left = new byte[32];
            byte[] right = new byte[32];
            byte[] hash = new byte[32];
            boolean res = true;
            try {
                int level = this.parseInt(data);
                System.arraycopy(data, 32, left, 0, 32);
                System.arraycopy(data, 64, right, 0, 32);
                JLibrustzcash.librustzcashMerkleHash((LibrustzcashParam.MerkleHashParams)new LibrustzcashParam.MerkleHashParams(level, left, right, hash));
            }
            catch (Throwable any) {
                res = false;
                logger.info("Compute MerkleHash failed:{}", (Object)any.getMessage());
            }
            if (res) {
                return Pair.of((Object)true, (Object)hash);
            }
            return Pair.of((Object)false, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
        }

        private int parseInt(byte[] data) {
            byte[] bytes = ByteUtil.parseBytes((byte[])data, (int)0, (int)32);
            return new DataWord(bytes).intValueSafe();
        }
    }

    public static class VerifyBurnProof
    extends VerifyProof {
        private static final int SIZE = 512;

        @Override
        public long getEnergyForData(byte[] data) {
            return 150000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            boolean result;
            if (data == null) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            if (data.length != 512) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            long ctx = JLibrustzcash.librustzcashSaplingVerificationCtxInit();
            try {
                byte[] nullifier = new byte[32];
                byte[] anchor = new byte[32];
                byte[] cv = new byte[32];
                byte[] rk = new byte[32];
                byte[] proof = new byte[192];
                byte[] spendAuthSig = new byte[64];
                byte[] bindingSig = new byte[64];
                byte[] signHash = new byte[32];
                System.arraycopy(data, 0, nullifier, 0, 32);
                System.arraycopy(data, 32, anchor, 0, 32);
                System.arraycopy(data, 64, cv, 0, 32);
                System.arraycopy(data, 96, rk, 0, 32);
                System.arraycopy(data, 128, proof, 0, 192);
                System.arraycopy(data, 320, spendAuthSig, 0, 64);
                long value = this.parseLong(data, 384);
                System.arraycopy(data, 416, bindingSig, 0, 64);
                System.arraycopy(data, 480, signHash, 0, 32);
                result = JLibrustzcash.librustzcashSaplingCheckSpend((LibrustzcashParam.CheckSpendParams)new LibrustzcashParam.CheckSpendParams(ctx, cv, anchor, nullifier, rk, proof, spendAuthSig, signHash));
                result = result && JLibrustzcash.librustzcashSaplingFinalCheck((LibrustzcashParam.FinalCheckParams)new LibrustzcashParam.FinalCheckParams(ctx, value, bindingSig, signHash));
            }
            catch (Throwable any) {
                result = false;
                String errorMsg = any.getMessage();
                if (errorMsg == null && any.getCause() != null) {
                    errorMsg = any.getCause().getMessage();
                }
                logger.info("VerifyBurnProof exception " + errorMsg);
            }
            finally {
                JLibrustzcash.librustzcashSaplingVerificationCtxFree((long)ctx);
            }
            return Pair.of((Object)true, (Object)this.dataBoolean(result));
        }
    }

    public static class VerifyTransferProof
    extends VerifyProof {
        private static final Integer[] SIZE = new Integer[]{2080, 2368, 2464, 2752};
        private static final ExecutorService workersInConstantCall = Executors.newFixedThreadPool(5);
        private static final ExecutorService workersInNonConstantCall = Executors.newFixedThreadPool(5);

        @Override
        public long getEnergyForData(byte[] data) {
            return 200000L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            if (!Arrays.asList(SIZE).contains(data.length)) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            try {
                int i;
                int i2;
                byte[] bindingSig = new byte[64];
                byte[] signHash = new byte[32];
                byte[][] frontier = new byte[33][32];
                int spendOffset = this.parseInt(data, 0);
                int spendAuthSigOffset = this.parseInt(data, 32);
                int receiveOffset = this.parseInt(data, 64);
                System.arraycopy(data, 96, bindingSig, 0, 64);
                System.arraycopy(data, 160, signHash, 0, 32);
                long value = this.parseLong(data, 192);
                for (int i4 = 0; i4 < 33; ++i4) {
                    System.arraycopy(data, i4 * 32 + 224, frontier[i4], 0, 32);
                }
                long leafCount = this.parseLong(data, 1280);
                if (leafCount >= 0xFFFFFFFFL) {
                    return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
                }
                int spendCount = this.parseInt(data, spendOffset);
                int spendAuthSigCount = this.parseInt(data, spendAuthSigOffset);
                int receiveCount = this.parseInt(data, receiveOffset);
                if (spendCount != spendAuthSigCount || spendCount < 1 || spendCount > 2 || receiveCount < 1 || receiveCount > 2) {
                    return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
                }
                byte[][] anchor = new byte[spendCount][32];
                byte[][] nullifier = new byte[spendCount][32];
                byte[][] spendCv = new byte[spendCount][32];
                byte[][] rk = new byte[spendCount][32];
                byte[][] spendProof = new byte[spendCount][192];
                byte[][] spendAuthSig = new byte[spendCount][64];
                byte[][] receiveCm = new byte[receiveCount][32];
                byte[][] receiveCv = new byte[receiveCount][32];
                byte[][] receiveEpk = new byte[receiveCount][32];
                byte[][] receiveProof = new byte[receiveCount][192];
                spendOffset += 32;
                for (int i3 = 0; i3 < spendCount; ++i3) {
                    System.arraycopy(data, spendOffset + 320 * i3, nullifier[i3], 0, 32);
                    System.arraycopy(data, spendOffset + 320 * i3 + 32, anchor[i3], 0, 32);
                    System.arraycopy(data, spendOffset + 320 * i3 + 64, spendCv[i3], 0, 32);
                    System.arraycopy(data, spendOffset + 320 * i3 + 96, rk[i3], 0, 32);
                    System.arraycopy(data, spendOffset + 320 * i3 + 128, spendProof[i3], 0, 192);
                }
                spendAuthSigOffset += 32;
                for (i2 = 0; i2 < spendCount; ++i2) {
                    System.arraycopy(data, spendAuthSigOffset + 64 * i2, spendAuthSig[i2], 0, 64);
                }
                receiveOffset += 32;
                for (i2 = 0; i2 < receiveCount; ++i2) {
                    System.arraycopy(data, receiveOffset + 288 * i2, receiveCm[i2], 0, 32);
                    System.arraycopy(data, receiveOffset + 288 * i2 + 32, receiveCv[i2], 0, 32);
                    System.arraycopy(data, receiveOffset + 288 * i2 + 64, receiveEpk[i2], 0, 32);
                    System.arraycopy(data, receiveOffset + 288 * i2 + 96, receiveProof[i2], 0, 192);
                }
                byte[] spendCvs = new byte[spendCount * 32];
                byte[] receiveCvs = new byte[receiveCount * 32];
                for (int i22 = 0; i22 < spendCount; ++i22) {
                    System.arraycopy(spendCv[i22], 0, spendCvs, 32 * i22, 32);
                }
                for (int i3 = 0; i3 < receiveCount; ++i3) {
                    System.arraycopy(receiveCv[i3], 0, receiveCvs, 32 * i3, 32);
                }
                HashSet<String> nfSet = new HashSet<String>();
                for (byte[] nf : nullifier) {
                    if (nfSet.contains(ByteArray.toHexString((byte[])nf))) {
                        return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
                    }
                    nfSet.add(ByteArray.toHexString((byte[])nf));
                }
                HashSet<String> cmSet = new HashSet<String>();
                for (byte[] cm : receiveCm) {
                    if (cmSet.contains(ByteArray.toHexString((byte[])cm))) {
                        return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
                    }
                    cmSet.add(ByteArray.toHexString((byte[])cm));
                }
                int threadCount = spendCount + receiveCount + 1;
                CountDownLatch countDownLatch = new CountDownLatch(threadCount);
                ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>(threadCount);
                ExecutorService workers = this.isConstantCall() ? workersInConstantCall : workersInNonConstantCall;
                for (i = 0; i < spendCount; ++i) {
                    Future<Boolean> futureCheckSpend = workers.submit(new SaplingCheckSpendTask(countDownLatch, spendCv[i], anchor[i], nullifier[i], rk[i], spendProof[i], spendAuthSig[i], signHash));
                    futures.add(futureCheckSpend);
                }
                for (i = 0; i < receiveCount; ++i) {
                    Future<Boolean> futureCheckOutput = workers.submit(new SaplingCheckOutputTask(countDownLatch, receiveCv[i], receiveCm[i], receiveEpk[i], receiveProof[i]));
                    futures.add(futureCheckOutput);
                }
                Future<Boolean> futureCheckBindingSig = workers.submit(new SaplingCheckBingdingSig(countDownLatch, value, bindingSig, signHash, spendCvs, spendCount * 32, receiveCvs, receiveCount * 32));
                futures.add(futureCheckBindingSig);
                boolean withNoTimeout = countDownLatch.await(this.getCPUTimeLeftInNanoSecond(), TimeUnit.NANOSECONDS);
                boolean checkResult = true;
                for (Future future : futures) {
                    boolean eachTaskResult = (Boolean)future.get();
                    checkResult = checkResult && eachTaskResult;
                }
                if (checkResult) {
                    return this.insertLeaves(frontier, leafCount, receiveCm);
                }
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.info("VerifyTransferProof exception: " + e.getMessage());
            }
            catch (Throwable any) {
                String errorMsg = any.getMessage();
                if (errorMsg == null && any.getCause() != null) {
                    errorMsg = any.getCause().getMessage();
                }
                logger.info("VerifyTransferProof exception: " + errorMsg);
            }
            return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
        }

        private static class SaplingCheckBingdingSig
        implements Callable<Boolean> {
            private long valueBalance;
            private int spendCvLen;
            private int receiveCvLen;
            private byte[] bindingSig;
            private byte[] signHash;
            private byte[] spendCvs;
            private byte[] receiveCvs;
            private CountDownLatch countDownLatch;

            SaplingCheckBingdingSig(CountDownLatch countDownLatch, long valueBalance, byte[] bindingSig, byte[] signHash, byte[] spendCvs, int spendCvLen, byte[] receiveCvs, int receiveCvLen) {
                this.valueBalance = valueBalance;
                this.bindingSig = bindingSig;
                this.signHash = signHash;
                this.spendCvs = spendCvs;
                this.spendCvLen = spendCvLen;
                this.receiveCvs = receiveCvs;
                this.receiveCvLen = receiveCvLen;
                this.countDownLatch = countDownLatch;
            }

            @Override
            public Boolean call() throws ZksnarkException {
                boolean result;
                try {
                    result = JLibrustzcash.librustzcashSaplingFinalCheckNew((LibrustzcashParam.FinalCheckNewParams)new LibrustzcashParam.FinalCheckNewParams(this.valueBalance, this.bindingSig, this.signHash, this.spendCvs, this.spendCvLen, this.receiveCvs, this.receiveCvLen));
                }
                catch (ZksnarkException e) {
                    throw e;
                }
                finally {
                    this.countDownLatch.countDown();
                }
                return result;
            }
        }

        private static class SaplingCheckOutputTask
        implements Callable<Boolean> {
            private byte[] cv;
            private byte[] cm;
            private byte[] ephemeralKey;
            private byte[] zkproof;
            private CountDownLatch countDownLatch;

            SaplingCheckOutputTask(CountDownLatch countDownLatch, byte[] cv, byte[] cm, byte[] ephemeralKey, byte[] zkproof) {
                this.cv = cv;
                this.cm = cm;
                this.ephemeralKey = ephemeralKey;
                this.zkproof = zkproof;
                this.countDownLatch = countDownLatch;
            }

            @Override
            public Boolean call() throws ZksnarkException {
                boolean result;
                try {
                    result = JLibrustzcash.librustzcashSaplingCheckOutputNew((LibrustzcashParam.CheckOutputNewParams)new LibrustzcashParam.CheckOutputNewParams(this.cv, this.cm, this.ephemeralKey, this.zkproof));
                }
                catch (ZksnarkException e) {
                    throw e;
                }
                finally {
                    this.countDownLatch.countDown();
                }
                return result;
            }
        }

        private static class SaplingCheckSpendTask
        implements Callable<Boolean> {
            private byte[] cv;
            private byte[] anchor;
            private byte[] nullifier;
            private byte[] rk;
            private byte[] zkproof;
            private byte[] spendAuthSig;
            private byte[] signHash;
            private CountDownLatch countDownLatch;

            SaplingCheckSpendTask(CountDownLatch countDownLatch, byte[] cv, byte[] anchor, byte[] nullifier, byte[] rk, byte[] zkproof, byte[] spendAuthSig, byte[] signHash) {
                this.cv = cv;
                this.anchor = anchor;
                this.nullifier = nullifier;
                this.rk = rk;
                this.zkproof = zkproof;
                this.spendAuthSig = spendAuthSig;
                this.signHash = signHash;
                this.countDownLatch = countDownLatch;
            }

            @Override
            public Boolean call() throws ZksnarkException {
                boolean result;
                try {
                    result = JLibrustzcash.librustzcashSaplingCheckSpendNew((LibrustzcashParam.CheckSpendNewParams)new LibrustzcashParam.CheckSpendNewParams(this.cv, this.anchor, this.nullifier, this.rk, this.zkproof, this.spendAuthSig, this.signHash));
                }
                catch (ZksnarkException e) {
                    throw e;
                }
                finally {
                    this.countDownLatch.countDown();
                }
                return result;
            }
        }
    }

    public static class VerifyMintProof
    extends VerifyProof {
        private static final int SIZE = 1504;

        @Override
        public long getEnergyForData(byte[] data) {
            return 150000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            if (data.length != 1504) {
                return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
            }
            long ctx = JLibrustzcash.librustzcashSaplingVerificationCtxInit();
            try {
                byte[] cm = new byte[32];
                byte[] cv = new byte[32];
                byte[] epk = new byte[32];
                byte[] proof = new byte[192];
                byte[] bindingSig = new byte[64];
                byte[] signHash = new byte[32];
                byte[][] frontier = new byte[33][32];
                System.arraycopy(data, 0, cm, 0, 32);
                System.arraycopy(data, 32, cv, 0, 32);
                System.arraycopy(data, 64, epk, 0, 32);
                System.arraycopy(data, 96, proof, 0, 192);
                System.arraycopy(data, 288, bindingSig, 0, 64);
                long value = this.parseLong(data, 352);
                System.arraycopy(data, 384, signHash, 0, 32);
                for (int i = 0; i < 33; ++i) {
                    System.arraycopy(data, i * 32 + 416, frontier[i], 0, 32);
                }
                long leafCount = this.parseLong(data, 1472);
                if (leafCount >= 0x100000000L) {
                    Pair pair = Pair.of((Object)true, (Object)DataWord.ZERO().getData());
                    return pair;
                }
                boolean result = JLibrustzcash.librustzcashSaplingCheckOutput((LibrustzcashParam.CheckOutputParams)new LibrustzcashParam.CheckOutputParams(ctx, cv, cm, epk, proof));
                long valueBalance = -value;
                boolean bl = result = result && JLibrustzcash.librustzcashSaplingFinalCheck((LibrustzcashParam.FinalCheckParams)new LibrustzcashParam.FinalCheckParams(ctx, valueBalance, bindingSig, signHash));
                if (result) {
                    byte[][] leafValue = new byte[1][32];
                    System.arraycopy(cm, 0, leafValue[0], 0, 32);
                    Pair<Boolean, byte[]> pair = this.insertLeaves(frontier, leafCount, leafValue);
                    return pair;
                }
                Pair pair = Pair.of((Object)true, (Object)DataWord.ZERO().getData());
                return pair;
            }
            catch (Throwable any) {
                String errorMsg = any.getMessage();
                if (errorMsg == null && any.getCause() != null) {
                    errorMsg = any.getCause().getMessage();
                }
                logger.info("VerifyMintProof exception " + errorMsg);
            }
            finally {
                JLibrustzcash.librustzcashSaplingVerificationCtxFree((long)ctx);
            }
            return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
        }
    }

    public static abstract class VerifyProof
    extends PrecompiledContract {
        protected static final long TREE_WIDTH = 0x100000000L;
        protected static final byte[][] UNCOMMITTED = new byte[32][32];

        protected long parseLong(byte[] data, int idx) {
            byte[] bytes = ByteUtil.parseBytes((byte[])data, (int)idx, (int)32);
            return new DataWord(bytes).longValueSafe();
        }

        protected int parseInt(byte[] data, int idx) {
            byte[] bytes = ByteUtil.parseBytes((byte[])data, (int)idx, (int)32);
            return new DataWord(bytes).intValueSafe();
        }

        private int getFrontierSlot(long leafIndex) {
            int slot = 0;
            if (leafIndex % 2L != 0L) {
                int exp1 = 1;
                long pow1 = 2L;
                long pow2 = pow1 << 1;
                while (slot == 0) {
                    if ((leafIndex + 1L - pow1) % pow2 == 0L) {
                        slot = exp1;
                        continue;
                    }
                    pow1 = pow2;
                    pow2 <<= 1;
                    ++exp1;
                }
            }
            return slot;
        }

        protected Pair<Boolean, byte[]> insertLeaves(byte[][] frontier, long leafCount, byte[][] leafValue) {
            long nodeIndex = 0L;
            boolean success = true;
            byte[] hash = new byte[32];
            byte[] nodeValue = new byte[32];
            int cmCount = leafValue.length;
            int[] slot = new int[cmCount];
            for (int i = 0; i < cmCount; ++i) {
                slot[i] = this.getFrontierSlot(leafCount + (long)i);
            }
            int resultArrayLength = 32;
            for (int i = 0; i < cmCount; ++i) {
                resultArrayLength += (slot[i] + 1) * 32;
            }
            byte[] result = new byte[resultArrayLength];
            try {
                byte[] rightInput;
                byte[] leftInput;
                int offset = 0;
                for (int i = 0; i < cmCount; ++i) {
                    byte[] slotArray = DataWord.of((byte)((byte)(slot[i] & 0xFF))).getData();
                    System.arraycopy(slotArray, 0, result, offset, 32);
                    offset += 32;
                    nodeIndex = (long)i + leafCount + 0x100000000L - 1L;
                    System.arraycopy(leafValue[i], 0, nodeValue, 0, 32);
                    if (slot[i] == 0) {
                        System.arraycopy(nodeValue, 0, frontier[0], 0, 32);
                        continue;
                    }
                    for (int level = 1; level <= slot[i]; ++level) {
                        if (nodeIndex % 2L == 0L) {
                            leftInput = frontier[level - 1];
                            rightInput = nodeValue;
                            nodeIndex = (nodeIndex - 1L) / 2L;
                        } else {
                            leftInput = nodeValue;
                            rightInput = UNCOMMITTED[level - 1];
                            nodeIndex /= 2L;
                        }
                        JLibrustzcash.librustzcashMerkleHash((LibrustzcashParam.MerkleHashParams)new LibrustzcashParam.MerkleHashParams(level - 1, leftInput, rightInput, hash));
                        System.arraycopy(hash, 0, nodeValue, 0, 32);
                        System.arraycopy(hash, 0, result, offset, 32);
                        offset += 32;
                    }
                    System.arraycopy(nodeValue, 0, frontier[slot[i]], 0, 32);
                }
                for (int level = slot[cmCount - 1] + 1; level <= 32; ++level) {
                    if (nodeIndex % 2L == 0L) {
                        leftInput = frontier[level - 1];
                        rightInput = nodeValue;
                        nodeIndex = (nodeIndex - 1L) / 2L;
                    } else {
                        leftInput = nodeValue;
                        rightInput = UNCOMMITTED[level - 1];
                        nodeIndex /= 2L;
                    }
                    JLibrustzcash.librustzcashMerkleHash((LibrustzcashParam.MerkleHashParams)new LibrustzcashParam.MerkleHashParams(level - 1, leftInput, rightInput, hash));
                    System.arraycopy(hash, 0, nodeValue, 0, 32);
                }
                System.arraycopy(nodeValue, 0, result, offset, 32);
            }
            catch (Throwable any) {
                success = false;
                String errorMsg = any.getMessage();
                if (errorMsg == null && any.getCause() != null) {
                    errorMsg = any.getCause().getMessage();
                }
                logger.info("Insert leaves failed: " + errorMsg);
            }
            if (success) {
                return Pair.of((Object)true, (Object)ByteUtil.merge((byte[][])new byte[][]{DataWord.ONE().getData(), result}));
            }
            return Pair.of((Object)true, (Object)DataWord.ZERO().getData());
        }

        static {
            VerifyProof.UNCOMMITTED[0] = ByteArray.fromHexString((String)"0100000000000000000000000000000000000000000000000000000000000000");
            try {
                for (int i = 0; i < 31; ++i) {
                    JLibrustzcash.librustzcashMerkleHash((LibrustzcashParam.MerkleHashParams)new LibrustzcashParam.MerkleHashParams(i, UNCOMMITTED[i], UNCOMMITTED[i], UNCOMMITTED[i + 1]));
                }
            }
            catch (Throwable any) {
                logger.info("Initialize UNCOMMITTED array failed:{}", (Object)any.getMessage());
            }
        }
    }

    public static class BatchValidateSign
    extends PrecompiledContract {
        private static final ExecutorService workers = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() / 2 + 1);
        private static final int ENGERYPERSIGN = 1500;
        private static final int MAX_SIZE = 16;

        @Override
        public long getEnergyForData(byte[] data) {
            long cnt = (data.length / 32 - 5) / 6;
            return cnt * 1500L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            try {
                return this.doExecute(data);
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                return Pair.of((Object)true, (Object)new byte[32]);
            }
        }

        private Pair<Boolean, byte[]> doExecute(byte[] data) throws InterruptedException, ExecutionException {
            DataWord[] words = DataWord.parseArray((byte[])data);
            byte[] hash = words[0].getData();
            byte[][] signatures = PrecompiledContracts.extractBytesArray(words, words[1].intValueSafe() / 32, data);
            byte[][] addresses = PrecompiledContracts.extractBytes32Array(words, words[2].intValueSafe() / 32);
            int cnt = signatures.length;
            if (cnt == 0 || cnt > 16 || signatures.length != addresses.length) {
                return Pair.of((Object)true, (Object)DATA_FALSE);
            }
            byte[] res = new byte[32];
            if (this.isConstantCall()) {
                for (int i = 0; i < cnt; ++i) {
                    if (!DataWord.equalAddressByteArray((byte[])addresses[i], (byte[])PrecompiledContracts.recoverAddrBySign(signatures[i], hash))) continue;
                    res[i] = 1;
                }
            } else {
                CountDownLatch countDownLatch = new CountDownLatch(cnt);
                ArrayList<Future<RecoverAddrResult>> futures = new ArrayList<Future<RecoverAddrResult>>(cnt);
                for (int i = 0; i < cnt; ++i) {
                    Future<RecoverAddrResult> future = workers.submit(new RecoverAddrTask(countDownLatch, hash, signatures[i], i));
                    futures.add(future);
                }
                boolean withNoTimeout = countDownLatch.await(this.getCPUTimeLeftInNanoSecond(), TimeUnit.NANOSECONDS);
                if (!withNoTimeout) {
                    logger.info("BatchValidateSign timeout");
                    throw Program.Exception.notEnoughTime("call BatchValidateSign precompile method");
                }
                for (Future future : futures) {
                    RecoverAddrResult result = (RecoverAddrResult)future.get();
                    int index = result.nonce;
                    if (!DataWord.equalAddressByteArray((byte[])result.addr, (byte[])addresses[index])) continue;
                    res[index] = 1;
                }
            }
            return Pair.of((Object)true, (Object)res);
        }

        private static class RecoverAddrResult {
            private byte[] addr;
            private int nonce;

            public RecoverAddrResult(byte[] addr, int nonce) {
                this.addr = addr;
                this.nonce = nonce;
            }
        }

        private static class RecoverAddrTask
        implements Callable<RecoverAddrResult> {
            private CountDownLatch countDownLatch;
            private byte[] hash;
            private byte[] signature;
            private int nonce;

            @Override
            public RecoverAddrResult call() {
                try {
                    RecoverAddrResult recoverAddrResult = new RecoverAddrResult(PrecompiledContracts.recoverAddrBySign(this.signature, this.hash), this.nonce);
                    return recoverAddrResult;
                }
                finally {
                    this.countDownLatch.countDown();
                }
            }

            public RecoverAddrTask(CountDownLatch countDownLatch, byte[] hash, byte[] signature, int nonce) {
                this.countDownLatch = countDownLatch;
                this.hash = hash;
                this.signature = signature;
                this.nonce = nonce;
            }
        }
    }

    public static class ValidateMultiSign
    extends PrecompiledContract {
        private static final int ENGERYPERSIGN = 1500;
        private static final int MAX_SIZE = 5;

        @Override
        public long getEnergyForData(byte[] data) {
            long cnt = (data.length / 32 - 5) / 5;
            return cnt * 1500L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] rawData) {
            DataWord[] words = DataWord.parseArray((byte[])rawData);
            byte[] address = words[0].toTronAddress();
            int permissionId = words[1].intValueSafe();
            byte[] data = words[2].getData();
            byte[] combine = ByteUtil.merge((byte[][])new byte[][]{address, ByteArray.fromInt((int)permissionId), data});
            byte[] hash = Sha256Hash.hash((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])combine);
            byte[][] signatures = PrecompiledContracts.extractBytesArray(words, words[3].intValueSafe() / 32, rawData);
            if (signatures.length == 0 || signatures.length > 5) {
                return Pair.of((Object)true, (Object)DATA_FALSE);
            }
            AccountCapsule account = this.getDeposit().getAccount(address);
            if (account != null) {
                try {
                    Protocol.Permission permission = account.getPermissionById(permissionId);
                    if (permission != null) {
                        long totalWeight = 0L;
                        ArrayList<byte[]> executedSignList = new ArrayList<byte[]>();
                        for (byte[] sign : signatures) {
                            long weight;
                            byte[] recoveredAddr = PrecompiledContracts.recoverAddrBySign(sign, hash);
                            sign = ByteUtil.merge((byte[][])new byte[][]{recoveredAddr, sign});
                            if (ByteArray.matrixContains(executedSignList, (byte[])recoveredAddr)) {
                                if (ByteArray.matrixContains(executedSignList, (byte[])sign)) continue;
                                MUtil.checkCPUTime();
                            }
                            if ((weight = TransactionCapsule.getWeight((Protocol.Permission)permission, (byte[])recoveredAddr)) == 0L) {
                                return Pair.of((Object)true, (Object)DATA_FALSE);
                            }
                            totalWeight += weight;
                            executedSignList.add(sign);
                            executedSignList.add(recoveredAddr);
                        }
                        if (totalWeight >= permission.getThreshold()) {
                            return Pair.of((Object)true, (Object)this.dataOne());
                        }
                    }
                }
                catch (Throwable t) {
                    if (t instanceof Program.OutOfTimeException) {
                        throw t;
                    }
                    logger.info("ValidateMultiSign error:{}", (Object)t.getMessage());
                }
            }
            return Pair.of((Object)true, (Object)DATA_FALSE);
        }
    }

    public static class BN128Pairing
    extends PrecompiledContract {
        private static final int PAIR_SIZE = 192;

        @Override
        public long getEnergyForData(byte[] data) {
            if (VMConfig.allowTvmIstanbul()) {
                return this.getEnergyForDataIstanbul(data);
            }
            if (data == null) {
                return 100000L;
            }
            return 80000L * (long)(data.length / 192) + 100000L;
        }

        private long getEnergyForDataIstanbul(byte[] data) {
            if (data == null) {
                return 45000L;
            }
            return 34000L * (long)(data.length / 192) + 45000L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null) {
                data = ByteUtil.EMPTY_BYTE_ARRAY;
            }
            if (data.length % 192 > 0) {
                return Pair.of((Object)false, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
            }
            PairingCheck check = PairingCheck.create();
            for (int offset = 0; offset < data.length; offset += 192) {
                Pair<BN128G1, BN128G2> pair = this.decodePair(data, offset);
                if (pair == null) {
                    return Pair.of((Object)false, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
                }
                check.addPair((BN128G1)pair.getLeft(), (BN128G2)pair.getRight());
            }
            check.run();
            int result = check.result();
            return Pair.of((Object)true, (Object)new DataWord(result).getData());
        }

        private Pair<BN128G1, BN128G2> decodePair(byte[] in, int offset) {
            byte[] y;
            byte[] x = ByteUtil.parseWord((byte[])in, (int)offset, (int)0);
            BN128G1 p1 = BN128G1.create((byte[])x, (byte[])(y = ByteUtil.parseWord((byte[])in, (int)offset, (int)1)));
            if (p1 == null) {
                return null;
            }
            byte[] b = ByteUtil.parseWord((byte[])in, (int)offset, (int)2);
            byte[] a = ByteUtil.parseWord((byte[])in, (int)offset, (int)3);
            byte[] d = ByteUtil.parseWord((byte[])in, (int)offset, (int)4);
            byte[] c = ByteUtil.parseWord((byte[])in, (int)offset, (int)5);
            BN128G2 p2 = BN128G2.create((byte[])a, (byte[])b, (byte[])c, (byte[])d);
            if (p2 == null) {
                return null;
            }
            return Pair.of((Object)p1, (Object)p2);
        }
    }

    public static class BN128Multiplication
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            if (VMConfig.allowTvmIstanbul()) {
                return this.getEnergyForDataIstanbul(data);
            }
            return 40000L;
        }

        private long getEnergyForDataIstanbul(byte[] data) {
            return 6000L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null) {
                data = ByteUtil.EMPTY_BYTE_ARRAY;
            }
            byte[] x = ByteUtil.parseWord((byte[])data, (int)0);
            byte[] y = ByteUtil.parseWord((byte[])data, (int)1);
            byte[] s = ByteUtil.parseWord((byte[])data, (int)2);
            BN128 p = BN128Fp.create((byte[])x, (byte[])y);
            if (p == null) {
                return Pair.of((Object)false, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
            }
            BN128 res = p.mul(BIUtil.toBI((byte[])s)).toEthNotation();
            return Pair.of((Object)true, (Object)PrecompiledContracts.encodeRes(((Fp)res.x()).bytes(), ((Fp)res.y()).bytes()));
        }
    }

    public static class BN128Addition
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            if (VMConfig.allowTvmIstanbul()) {
                return this.getEnergyForDataIstanbul(data);
            }
            return 500L;
        }

        private long getEnergyForDataIstanbul(byte[] data) {
            return 150L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null) {
                data = ByteUtil.EMPTY_BYTE_ARRAY;
            }
            byte[] x1 = ByteUtil.parseWord((byte[])data, (int)0);
            byte[] y1 = ByteUtil.parseWord((byte[])data, (int)1);
            byte[] x2 = ByteUtil.parseWord((byte[])data, (int)2);
            byte[] y2 = ByteUtil.parseWord((byte[])data, (int)3);
            BN128 p1 = BN128Fp.create((byte[])x1, (byte[])y1);
            if (p1 == null) {
                return Pair.of((Object)false, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
            }
            BN128 p2 = BN128Fp.create((byte[])x2, (byte[])y2);
            if (p2 == null) {
                return Pair.of((Object)false, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
            }
            BN128 res = p1.add(p2).toEthNotation();
            return Pair.of((Object)true, (Object)PrecompiledContracts.encodeRes(((Fp)res.x()).bytes(), ((Fp)res.y()).bytes()));
        }
    }

    public static class ModExp
    extends PrecompiledContract {
        private static final BigInteger GQUAD_DIVISOR = BigInteger.valueOf(20L);
        private static final int ARGS_OFFSET = 96;

        @Override
        public long getEnergyForData(byte[] data) {
            if (data == null) {
                data = ByteUtil.EMPTY_BYTE_ARRAY;
            }
            int baseLen = this.parseLen(data, 0);
            int expLen = this.parseLen(data, 1);
            int modLen = this.parseLen(data, 2);
            byte[] expHighBytes = ByteUtil.parseBytes((byte[])data, (int)BIUtil.addSafely((int)96, (int)baseLen), (int)Math.min(expLen, 32));
            long multComplexity = this.getMultComplexity(Math.max(baseLen, modLen));
            long adjExpLen = this.getAdjustedExponentLength(expHighBytes, expLen);
            BigInteger energy = BigInteger.valueOf(multComplexity).multiply(BigInteger.valueOf(Math.max(adjExpLen, 1L))).divide(GQUAD_DIVISOR);
            return BIUtil.isLessThan((BigInteger)energy, (BigInteger)BigInteger.valueOf(Long.MAX_VALUE)) ? energy.longValueExact() : Long.MAX_VALUE;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null) {
                return Pair.of((Object)true, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
            }
            int baseLen = this.parseLen(data, 0);
            int expLen = this.parseLen(data, 1);
            int modLen = this.parseLen(data, 2);
            BigInteger base = this.parseArg(data, 96, baseLen);
            BigInteger exp = this.parseArg(data, BIUtil.addSafely((int)96, (int)baseLen), expLen);
            BigInteger mod = this.parseArg(data, BIUtil.addSafely((int)BIUtil.addSafely((int)96, (int)baseLen), (int)expLen), modLen);
            if (BIUtil.isZero((BigInteger)mod)) {
                return Pair.of((Object)true, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
            }
            byte[] res = ByteUtil.stripLeadingZeroes((byte[])base.modPow(exp, mod).toByteArray());
            if (res.length < modLen) {
                byte[] adjRes = new byte[modLen];
                System.arraycopy(res, 0, adjRes, modLen - res.length, res.length);
                return Pair.of((Object)true, (Object)adjRes);
            }
            return Pair.of((Object)true, (Object)res);
        }

        private long getMultComplexity(long x) {
            long x2 = x * x;
            if (x <= 64L) {
                return x2;
            }
            if (x <= 1024L) {
                return x2 / 4L + 96L * x - 3072L;
            }
            return x2 / 16L + 480L * x - 199680L;
        }

        private long getAdjustedExponentLength(byte[] expHighBytes, long expLen) {
            int leadingZeros = ByteUtil.numberOfLeadingZeros((byte[])expHighBytes);
            int highestBit = 8 * expHighBytes.length - leadingZeros;
            if (highestBit > 0) {
                --highestBit;
            }
            if (expLen <= 32L) {
                return highestBit;
            }
            return 8L * (expLen - 32L) + (long)highestBit;
        }

        private int parseLen(byte[] data, int idx) {
            byte[] bytes = ByteUtil.parseBytes((byte[])data, (int)(32 * idx), (int)32);
            return new DataWord(bytes).intValueSafe();
        }

        private BigInteger parseArg(byte[] data, int offset, int len) {
            byte[] bytes = ByteUtil.parseBytes((byte[])data, (int)offset, (int)len);
            return ByteUtil.bytesToBigInteger((byte[])bytes);
        }
    }

    public static class ECRecover
    extends PrecompiledContract {
        private static boolean validateV(byte[] v) {
            for (int i = 0; i < v.length - 1; ++i) {
                if (v[i] == 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public long getEnergyForData(byte[] data) {
            return 3000L;
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            byte[] h = new byte[32];
            byte[] v = new byte[32];
            byte[] r = new byte[32];
            byte[] s = new byte[32];
            DataWord out = null;
            try {
                System.arraycopy(data, 0, h, 0, 32);
                System.arraycopy(data, 32, v, 0, 32);
                System.arraycopy(data, 64, r, 0, 32);
                int sLength = data.length < 128 ? data.length - 96 : 32;
                System.arraycopy(data, 96, s, 0, sLength);
                SignatureInterface signature = SignUtils.fromComponents((byte[])r, (byte[])s, (byte)v[31], (boolean)CommonParameter.getInstance().isECKeyCryptoEngine());
                if (ECRecover.validateV(v) && signature.validateComponents()) {
                    out = new DataWord(SignUtils.signatureToAddress((byte[])h, (SignatureInterface)signature, (boolean)CommonParameter.getInstance().isECKeyCryptoEngine()));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (out == null) {
                return Pair.of((Object)true, (Object)ByteUtil.EMPTY_BYTE_ARRAY);
            }
            return Pair.of((Object)true, (Object)out.getData());
        }
    }

    public static class Ripempd160
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            if (data == null) {
                return 600L;
            }
            return 600L + (long)((data.length + 31) / 32 * 120);
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            byte[] target = new byte[20];
            if (data == null) {
                data = ByteUtil.EMPTY_BYTE_ARRAY;
            }
            byte[] orig = Sha256Hash.hash((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])data);
            System.arraycopy(orig, 0, target, 0, 20);
            return Pair.of((Object)true, (Object)Sha256Hash.hash((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])target));
        }
    }

    public static class Sha256
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            if (data == null) {
                return 60L;
            }
            return 60L + (long)((data.length + 31) / 32 * 12);
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            if (data == null) {
                return Pair.of((Object)true, (Object)Sha256Hash.hash((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])ByteUtil.EMPTY_BYTE_ARRAY));
            }
            return Pair.of((Object)true, (Object)Sha256Hash.hash((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])data));
        }
    }

    public static class Identity
    extends PrecompiledContract {
        @Override
        public long getEnergyForData(byte[] data) {
            if (data == null) {
                return 15L;
            }
            return 15L + (long)((data.length + 31) / 32 * 3);
        }

        @Override
        public Pair<Boolean, byte[]> execute(byte[] data) {
            return Pair.of((Object)true, (Object)data);
        }
    }

    public static abstract class PrecompiledContract {
        protected static final byte[] DATA_FALSE = new byte[32];
        private byte[] callerAddress;
        private Repository deposit;
        private ProgramResult result;
        private boolean isConstantCall;
        private long vmShouldEndInUs;

        public abstract long getEnergyForData(byte[] var1);

        public abstract Pair<Boolean, byte[]> execute(byte[] var1);

        public void setRepository(Repository deposit) {
            this.deposit = deposit;
        }

        public byte[] getCallerAddress() {
            return (byte[])this.callerAddress.clone();
        }

        public void setCallerAddress(byte[] callerAddress) {
            this.callerAddress = (byte[])callerAddress.clone();
        }

        public Repository getDeposit() {
            return this.deposit;
        }

        public ProgramResult getResult() {
            return this.result;
        }

        public void setResult(ProgramResult result) {
            this.result = result;
        }

        protected long getCPUTimeLeftInNanoSecond() {
            long left = this.getVmShouldEndInUs() * 1000L - System.nanoTime();
            if (left <= 0L) {
                throw Program.Exception.notEnoughTime("call");
            }
            return left;
        }

        protected byte[] dataOne() {
            byte[] ret = new byte[32];
            ret[31] = 1;
            return ret;
        }

        protected byte[] dataBoolean(boolean result) {
            if (result) {
                return DataWord.ONE().getData();
            }
            return DataWord.ZERO().getData();
        }

        public void setConstantCall(boolean isConstantCall) {
            this.isConstantCall = isConstantCall;
        }

        public boolean isConstantCall() {
            return this.isConstantCall;
        }

        public long getVmShouldEndInUs() {
            return this.vmShouldEndInUs;
        }

        public void setVmShouldEndInUs(long vmShouldEndInUs) {
            this.vmShouldEndInUs = vmShouldEndInUs;
        }
    }
}

