/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.logsfilter.trigger.ContractTrigger;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.runtime.InternalTransaction;
import org.tron.common.runtime.ProgramResult;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.utils.StorageUtils;
import org.tron.common.utils.StringUtil;
import org.tron.common.utils.WalletUtil;
import org.tron.core.ChainBaseManager;
import org.tron.core.actuator.Actuator2;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.ReceiptCapsule;
import org.tron.core.db.EnergyProcessor;
import org.tron.core.db.TransactionContext;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.utils.TransactionUtil;
import org.tron.core.vm.EnergyCost;
import org.tron.core.vm.LogInfoTriggerParser;
import org.tron.core.vm.OperationRegistry;
import org.tron.core.vm.VM;
import org.tron.core.vm.VMUtils;
import org.tron.core.vm.config.ConfigLoader;
import org.tron.core.vm.config.VMConfig;
import org.tron.core.vm.program.Program;
import org.tron.core.vm.program.ProgramPrecompile;
import org.tron.core.vm.program.invoke.ProgramInvoke;
import org.tron.core.vm.program.invoke.ProgramInvokeFactory;
import org.tron.core.vm.repository.Repository;
import org.tron.core.vm.repository.RepositoryImpl;
import org.tron.core.vm.utils.MUtil;
import org.tron.protos.Protocol;
import org.tron.protos.contract.Common;
import org.tron.protos.contract.SmartContractOuterClass;

public class VMActuator
implements Actuator2 {
    private static final Logger logger = LoggerFactory.getLogger((String)"VM");
    private Protocol.Transaction trx;
    private BlockCapsule blockCap;
    private Repository rootRepository;
    private Program program;
    private InternalTransaction rootInternalTx;
    private ReceiptCapsule receipt;
    private InternalTransaction.TrxType trxType;
    private InternalTransaction.ExecutorType executorType;
    private boolean isConstantCall;
    private long maxEnergyLimit;
    private boolean enableEventListener;
    private LogInfoTriggerParser logInfoTriggerParser;

    public VMActuator(boolean isConstantCall) {
        this.isConstantCall = isConstantCall;
        this.maxEnergyLimit = CommonParameter.getInstance().maxEnergyLimitForConstant;
    }

    private static long getEnergyFee(long callerEnergyUsage, long callerEnergyFrozen, long callerEnergyTotal) {
        if (callerEnergyTotal <= 0L) {
            return 0L;
        }
        return BigInteger.valueOf(callerEnergyFrozen).multiply(BigInteger.valueOf(callerEnergyUsage)).divide(BigInteger.valueOf(callerEnergyTotal)).longValueExact();
    }

    public void validate(Object object) throws ContractValidateException {
        TransactionContext context = (TransactionContext)object;
        if (Objects.isNull(context)) {
            throw new RuntimeException("TransactionContext is null");
        }
        ConfigLoader.load(context.getStoreFactory());
        OperationRegistry.init();
        this.trx = context.getTrxCap().getInstance();
        if (this.isConstantCall && this.trx.getRawData().getFeeLimit() > 0L) {
            this.maxEnergyLimit = Math.min(this.maxEnergyLimit, this.trx.getRawData().getFeeLimit() / context.getStoreFactory().getChainBaseManager().getDynamicPropertiesStore().getEnergyFee());
        }
        this.blockCap = context.getBlockCap();
        if ((VMConfig.allowTvmFreeze() || VMConfig.allowTvmFreezeV2()) && context.getTrxCap().getTrxTrace() != null) {
            this.receipt = context.getTrxCap().getTrxTrace().getReceipt();
        }
        Protocol.Transaction.Contract.ContractType contractType = this.trx.getRawData().getContract(0).getType();
        this.rootRepository = RepositoryImpl.createRoot(context.getStoreFactory());
        this.enableEventListener = context.isEventPluginLoaded();
        if (Objects.nonNull(this.blockCap)) {
            this.executorType = InternalTransaction.ExecutorType.ET_NORMAL_TYPE;
        } else {
            this.blockCap = new BlockCapsule(Protocol.Block.newBuilder().build());
            this.executorType = InternalTransaction.ExecutorType.ET_PRE_TYPE;
        }
        if (this.isConstantCall) {
            this.executorType = InternalTransaction.ExecutorType.ET_PRE_TYPE;
        }
        switch (contractType.getNumber()) {
            case 31: {
                this.trxType = InternalTransaction.TrxType.TRX_CONTRACT_CALL_TYPE;
                this.call();
                break;
            }
            case 30: {
                this.trxType = InternalTransaction.TrxType.TRX_CONTRACT_CREATION_TYPE;
                this.create();
                break;
            }
            default: {
                throw new ContractValidateException("Unknown contract type");
            }
        }
    }

    public void execute(Object object) throws ContractExeException {
        TransactionContext context = (TransactionContext)object;
        if (Objects.isNull(context)) {
            throw new RuntimeException("TransactionContext is null");
        }
        ProgramResult result = context.getProgramResult();
        try {
            if (this.program != null) {
                if (null != this.blockCap && this.blockCap.generatedByMyself && this.blockCap.hasWitnessSignature() && null != TransactionUtil.getContractRet(this.trx) && Protocol.Transaction.Result.contractResult.OUT_OF_TIME == TransactionUtil.getContractRet(this.trx)) {
                    result = this.program.getResult();
                    this.program.spendAllEnergy();
                    Program.OutOfTimeException e = Program.Exception.alreadyTimeOut();
                    result.setRuntimeError(e.getMessage());
                    result.setException((RuntimeException)e);
                    throw e;
                }
                VM.play(this.program, OperationRegistry.getTable());
                result = this.program.getResult();
                if (InternalTransaction.TrxType.TRX_CONTRACT_CREATION_TYPE == this.trxType && !result.isRevert()) {
                    byte[] code2 = this.program.getResult().getHReturn();
                    if (code2.length != 0 && VMConfig.allowTvmLondon() && code2[0] == -17 && null == result.getException()) {
                        result.setException((RuntimeException)Program.Exception.invalidCodeException());
                    }
                    long saveCodeEnergy = (long)ArrayUtils.getLength((Object)code2) * EnergyCost.getCreateData();
                    long afterSpend = this.program.getEnergyLimitLeft().longValue() - saveCodeEnergy;
                    if (afterSpend < 0L) {
                        if (null == result.getException()) {
                            result.setException((RuntimeException)Program.Exception.notEnoughSpendEnergy("save just created contract code", saveCodeEnergy, this.program.getEnergyLimitLeft().longValue()));
                        }
                    } else {
                        result.spendEnergy(saveCodeEnergy);
                        if (VMConfig.allowTvmConstantinople()) {
                            this.rootRepository.saveCode(this.program.getContractAddress().getNoLeadZeroesData(), code2);
                        }
                    }
                }
                if (this.isConstantCall) {
                    if (result.getException() != null) {
                        result.setRuntimeError(result.getException().getMessage());
                        result.rejectInternalTransactions();
                    }
                    context.setProgramResult(result);
                    return;
                }
                if (result.getException() != null || result.isRevert()) {
                    result.getDeleteAccounts().clear();
                    result.getLogInfoList().clear();
                    result.rejectInternalTransactions();
                    if (result.getException() != null) {
                        if (!(result.getException() instanceof Program.TransferException)) {
                            this.program.spendAllEnergy();
                        }
                        result.setRuntimeError(result.getException().getMessage());
                        throw result.getException();
                    }
                    result.setRuntimeError("REVERT opcode executed");
                } else {
                    this.rootRepository.commit();
                    if (this.logInfoTriggerParser != null) {
                        List<ContractTrigger> triggers = this.logInfoTriggerParser.parseLogInfos(this.program.getResult().getLogInfoList(), this.rootRepository);
                        this.program.getResult().setTriggerList((List)triggers);
                    }
                }
            } else {
                this.rootRepository.commit();
            }
            for (DataWord account : result.getDeleteAccounts()) {
                RepositoryImpl.removeLruCache(account.toTronAddress());
            }
        }
        catch (Program.JVMStackOverFlowException e) {
            this.program.spendAllEnergy();
            result = this.program.getResult();
            result.setException((RuntimeException)e);
            result.rejectInternalTransactions();
            result.setRuntimeError(result.getException().getMessage());
            logger.info("JVMStackOverFlowException: {}", (Object)result.getException().getMessage());
        }
        catch (Program.OutOfTimeException e) {
            this.program.spendAllEnergy();
            result = this.program.getResult();
            result.setException((RuntimeException)e);
            result.rejectInternalTransactions();
            result.setRuntimeError(result.getException().getMessage());
            logger.info("timeout: {}", (Object)result.getException().getMessage());
        }
        catch (Throwable e) {
            if (!(e instanceof Program.TransferException)) {
                this.program.spendAllEnergy();
            }
            result = this.program.getResult();
            result.rejectInternalTransactions();
            if (Objects.isNull(result.getException())) {
                logger.error(e.getMessage(), e);
                result.setException(new RuntimeException("Unknown Throwable"));
            }
            if (StringUtils.isEmpty((CharSequence)result.getRuntimeError())) {
                result.setRuntimeError(result.getException().getMessage());
            }
            logger.info("runtime result is :{}", (Object)result.getException().getMessage());
        }
        context.setProgramResult(result);
        if (VMConfig.vmTrace() && this.program != null) {
            String traceContent = this.program.getTrace().result(result.getHReturn()).error(result.getException()).toString();
            if (VMConfig.vmTraceCompressed()) {
                traceContent = VMUtils.zipAndEncode(traceContent);
            }
            String txHash = Hex.toHexString((byte[])this.rootInternalTx.getHash());
            VMUtils.saveProgramTraceFile(txHash, traceContent);
        }
    }

    private void create() throws ContractValidateException {
        if (!this.rootRepository.getDynamicPropertiesStore().supportVM()) {
            throw new ContractValidateException("vm work is off, need to be opened by the committee");
        }
        SmartContractOuterClass.CreateSmartContract contract = ContractCapsule.getSmartContractFromTransaction((Protocol.Transaction)this.trx);
        if (contract == null) {
            throw new ContractValidateException("Cannot get CreateSmartContract from transaction");
        }
        SmartContractOuterClass.SmartContract newSmartContract = VMConfig.allowTvmCompatibleEvm() ? contract.getNewContract().toBuilder().setVersion(1).build() : contract.getNewContract().toBuilder().clearVersion().build();
        if (!contract.getOwnerAddress().equals((Object)newSmartContract.getOriginAddress())) {
            logger.info("OwnerAddress not equals OriginAddress");
            throw new ContractValidateException("OwnerAddress is not equals OriginAddress");
        }
        byte[] contractName = newSmartContract.getName().getBytes();
        if (contractName.length > 32) {
            throw new ContractValidateException("contractName's length cannot be greater than 32");
        }
        long percent = contract.getNewContract().getConsumeUserResourcePercent();
        if (percent < 0L || percent > 100L) {
            throw new ContractValidateException("percent must be >= 0 and <= 100");
        }
        byte[] contractAddress = WalletUtil.generateContractAddress((Protocol.Transaction)this.trx);
        if (this.rootRepository.getAccount(contractAddress) != null) {
            throw new ContractValidateException("Trying to create a contract with existing contract address: " + StringUtil.encode58Check((byte[])contractAddress));
        }
        newSmartContract = newSmartContract.toBuilder().setContractAddress(ByteString.copyFrom((byte[])contractAddress)).build();
        long callValue = newSmartContract.getCallValue();
        long tokenValue = 0L;
        long tokenId = 0L;
        if (VMConfig.allowTvmTransferTrc10()) {
            tokenValue = contract.getCallTokenValue();
            tokenId = contract.getTokenId();
        }
        byte[] callerAddress = contract.getOwnerAddress().toByteArray();
        try {
            long energyLimit;
            long feeLimit = this.trx.getRawData().getFeeLimit();
            if (feeLimit < 0L || feeLimit > this.rootRepository.getDynamicPropertiesStore().getMaxFeeLimit()) {
                logger.info("invalid feeLimit {}", (Object)feeLimit);
                throw new ContractValidateException("feeLimit must be >= 0 and <= " + this.rootRepository.getDynamicPropertiesStore().getMaxFeeLimit());
            }
            AccountCapsule creator = this.rootRepository.getAccount(newSmartContract.getOriginAddress().toByteArray());
            if (this.isConstantCall) {
                energyLimit = this.maxEnergyLimit;
            } else if (StorageUtils.getEnergyLimitHardFork()) {
                if (callValue < 0L) {
                    throw new ContractValidateException("callValue must be >= 0");
                }
                if (tokenValue < 0L) {
                    throw new ContractValidateException("tokenValue must be >= 0");
                }
                if (newSmartContract.getOriginEnergyLimit() <= 0L) {
                    throw new ContractValidateException("The originEnergyLimit must be > 0");
                }
                energyLimit = this.getAccountEnergyLimitWithFixRatio(creator, feeLimit, callValue);
            } else {
                energyLimit = this.getAccountEnergyLimitWithFloatRatio(creator, feeLimit, callValue);
            }
            this.checkTokenValueAndId(tokenValue, tokenId);
            byte[] ops = newSmartContract.getBytecode().toByteArray();
            this.rootInternalTx = new InternalTransaction(this.trx, this.trxType);
            long maxCpuTimeOfOneTx = this.rootRepository.getDynamicPropertiesStore().getMaxCpuTimeOfOneTx() * 1000L;
            long thisTxCPULimitInUs = (long)((double)maxCpuTimeOfOneTx * this.getCpuLimitInUsRatio());
            long vmStartInUs = System.nanoTime() / 1000L;
            long vmShouldEndInUs = vmStartInUs + thisTxCPULimitInUs;
            ProgramInvoke programInvoke = ProgramInvokeFactory.createProgramInvoke(InternalTransaction.TrxType.TRX_CONTRACT_CREATION_TYPE, this.executorType, this.trx, tokenValue, tokenId, this.blockCap.getInstance(), this.rootRepository, vmStartInUs, vmShouldEndInUs, energyLimit);
            if (this.isConstantCall) {
                programInvoke.setConstantCall();
            }
            this.program = new Program(ops, contractAddress, programInvoke, this.rootInternalTx);
            if (VMConfig.allowTvmCompatibleEvm()) {
                this.program.setContractVersion(1);
            }
            byte[] txId = TransactionUtil.getTransactionId(this.trx).getBytes();
            this.program.setRootTransactionId(txId);
            if (this.enableEventListener && this.isCheckTransaction()) {
                this.logInfoTriggerParser = new LogInfoTriggerParser(this.blockCap.getNum(), this.blockCap.getTimeStamp(), txId, callerAddress);
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            throw new ContractValidateException(e.getMessage());
        }
        this.program.getResult().setContractAddress(contractAddress);
        this.rootRepository.createAccount(contractAddress, newSmartContract.getName(), Protocol.AccountType.Contract);
        this.rootRepository.createContract(contractAddress, new ContractCapsule(newSmartContract));
        byte[] code2 = newSmartContract.getBytecode().toByteArray();
        if (!VMConfig.allowTvmConstantinople()) {
            this.rootRepository.saveCode(contractAddress, ProgramPrecompile.getCode(code2));
        }
        if (callValue > 0L) {
            MUtil.transfer(this.rootRepository, callerAddress, contractAddress, callValue);
        }
        if (VMConfig.allowTvmTransferTrc10() && tokenValue > 0L) {
            MUtil.transferToken(this.rootRepository, callerAddress, contractAddress, String.valueOf(tokenId), tokenValue);
        }
    }

    private void call() throws ContractValidateException {
        if (!this.rootRepository.getDynamicPropertiesStore().supportVM()) {
            logger.info("vm work is off, need to be opened by the committee");
            throw new ContractValidateException("VM work is off, need to be opened by the committee");
        }
        SmartContractOuterClass.TriggerSmartContract contract = ContractCapsule.getTriggerContractFromTransaction((Protocol.Transaction)this.trx);
        if (contract == null) {
            return;
        }
        if (contract.getContractAddress() == null) {
            throw new ContractValidateException("Cannot get contract address from TriggerContract");
        }
        byte[] contractAddress = contract.getContractAddress().toByteArray();
        ContractCapsule deployedContract = this.rootRepository.getContract(contractAddress);
        if (null == deployedContract) {
            logger.info("No contract or not a smart contract");
            throw new ContractValidateException("No contract or not a smart contract");
        }
        long callValue = contract.getCallValue();
        long tokenValue = 0L;
        long tokenId = 0L;
        if (VMConfig.allowTvmTransferTrc10()) {
            tokenValue = contract.getCallTokenValue();
            tokenId = contract.getTokenId();
        }
        if (StorageUtils.getEnergyLimitHardFork()) {
            if (callValue < 0L) {
                throw new ContractValidateException("callValue must be >= 0");
            }
            if (tokenValue < 0L) {
                throw new ContractValidateException("tokenValue must be >= 0");
            }
        }
        byte[] callerAddress = contract.getOwnerAddress().toByteArray();
        this.checkTokenValueAndId(tokenValue, tokenId);
        byte[] code2 = this.rootRepository.getCode(contractAddress);
        if (ArrayUtils.isNotEmpty((byte[])code2)) {
            long energyLimit;
            long feeLimit = this.trx.getRawData().getFeeLimit();
            if (feeLimit < 0L || feeLimit > this.rootRepository.getDynamicPropertiesStore().getMaxFeeLimit()) {
                logger.info("invalid feeLimit {}", (Object)feeLimit);
                throw new ContractValidateException("feeLimit must be >= 0 and <= " + this.rootRepository.getDynamicPropertiesStore().getMaxFeeLimit());
            }
            AccountCapsule caller = this.rootRepository.getAccount(callerAddress);
            if (this.isConstantCall) {
                energyLimit = this.maxEnergyLimit;
            } else {
                AccountCapsule creator = this.rootRepository.getAccount(deployedContract.getInstance().getOriginAddress().toByteArray());
                energyLimit = this.getTotalEnergyLimit(creator, caller, contract, feeLimit, callValue);
            }
            long maxCpuTimeOfOneTx = this.rootRepository.getDynamicPropertiesStore().getMaxCpuTimeOfOneTx() * 1000L;
            long thisTxCPULimitInUs = (long)((double)maxCpuTimeOfOneTx * this.getCpuLimitInUsRatio());
            long vmStartInUs = System.nanoTime() / 1000L;
            long vmShouldEndInUs = vmStartInUs + thisTxCPULimitInUs;
            ProgramInvoke programInvoke = ProgramInvokeFactory.createProgramInvoke(InternalTransaction.TrxType.TRX_CONTRACT_CALL_TYPE, this.executorType, this.trx, tokenValue, tokenId, this.blockCap.getInstance(), this.rootRepository, vmStartInUs, vmShouldEndInUs, energyLimit);
            if (this.isConstantCall) {
                programInvoke.setConstantCall();
            }
            this.rootInternalTx = new InternalTransaction(this.trx, this.trxType);
            this.program = new Program(code2, contractAddress, programInvoke, this.rootInternalTx);
            if (VMConfig.allowTvmCompatibleEvm()) {
                this.program.setContractVersion(deployedContract.getContractVersion());
            }
            byte[] txId = TransactionUtil.getTransactionId(this.trx).getBytes();
            this.program.setRootTransactionId(txId);
            if (this.enableEventListener && this.isCheckTransaction()) {
                this.logInfoTriggerParser = new LogInfoTriggerParser(this.blockCap.getNum(), this.blockCap.getTimeStamp(), txId, callerAddress);
            }
        }
        this.program.getResult().setContractAddress(contractAddress);
        if (callValue > 0L) {
            MUtil.transfer(this.rootRepository, callerAddress, contractAddress, callValue);
        }
        if (VMConfig.allowTvmTransferTrc10() && tokenValue > 0L) {
            MUtil.transferToken(this.rootRepository, callerAddress, contractAddress, String.valueOf(tokenId), tokenValue);
        }
    }

    public long getAccountEnergyLimitWithFixRatio(AccountCapsule account, long feeLimit, long callValue) {
        long sunPerEnergy = 100L;
        if (this.rootRepository.getDynamicPropertiesStore().getEnergyFee() > 0L) {
            sunPerEnergy = this.rootRepository.getDynamicPropertiesStore().getEnergyFee();
        }
        long leftFrozenEnergy = this.rootRepository.getAccountLeftEnergyFromFreeze(account);
        if (VMConfig.allowTvmFreeze() || VMConfig.allowTvmFreezeV2()) {
            this.receipt.setCallerEnergyLeft(leftFrozenEnergy);
        }
        long energyFromBalance = Math.max(account.getBalance() - callValue, 0L) / sunPerEnergy;
        long availableEnergy = Math.addExact(leftFrozenEnergy, energyFromBalance);
        long energyFromFeeLimit = feeLimit / sunPerEnergy;
        if (VMConfig.allowTvmFreezeV2()) {
            long now = this.rootRepository.getHeadSlot();
            EnergyProcessor energyProcessor = new EnergyProcessor(this.rootRepository.getDynamicPropertiesStore(), ChainBaseManager.getInstance().getAccountStore());
            energyProcessor.updateUsage(account);
            account.setLatestConsumeTimeForEnergy(now);
            this.receipt.setCallerEnergyUsage(account.getEnergyUsage());
            this.receipt.setCallerEnergyWindowSize(account.getWindowSize(Common.ResourceCode.ENERGY));
            this.receipt.setCallerEnergyWindowSizeV2(account.getWindowSizeV2(Common.ResourceCode.ENERGY));
            account.setEnergyUsage(energyProcessor.increase(account, Common.ResourceCode.ENERGY, account.getEnergyUsage(), Math.min(leftFrozenEnergy, energyFromFeeLimit), now, now));
            this.receipt.setCallerEnergyMergedUsage(account.getEnergyUsage());
            this.receipt.setCallerEnergyMergedWindowSize(account.getWindowSize(Common.ResourceCode.ENERGY));
            this.rootRepository.updateAccount(account.createDbKey(), account);
        }
        return Math.min(availableEnergy, energyFromFeeLimit);
    }

    private long getAccountEnergyLimitWithFloatRatio(AccountCapsule account, long feeLimit, long callValue) {
        long totalEnergyFromFreeze;
        long leftBalanceForEnergyFreeze;
        long sunPerEnergy = 100L;
        if (this.rootRepository.getDynamicPropertiesStore().getEnergyFee() > 0L) {
            sunPerEnergy = this.rootRepository.getDynamicPropertiesStore().getEnergyFee();
        }
        long leftEnergyFromFreeze = this.rootRepository.getAccountLeftEnergyFromFreeze(account);
        callValue = Math.max(callValue, 0L);
        long energyFromBalance = Math.floorDiv(Math.max(account.getBalance() - callValue, 0L), sunPerEnergy);
        long totalBalanceForEnergyFreeze = account.getAllFrozenBalanceForEnergy();
        long energyFromFeeLimit = 0L == totalBalanceForEnergyFreeze ? feeLimit / sunPerEnergy : ((leftBalanceForEnergyFreeze = VMActuator.getEnergyFee(totalBalanceForEnergyFreeze, leftEnergyFromFreeze, totalEnergyFromFreeze = this.rootRepository.calculateGlobalEnergyLimit(account))) >= feeLimit ? BigInteger.valueOf(totalEnergyFromFreeze).multiply(BigInteger.valueOf(feeLimit)).divide(BigInteger.valueOf(totalBalanceForEnergyFreeze)).longValueExact() : Math.addExact(leftEnergyFromFreeze, (feeLimit - leftBalanceForEnergyFreeze) / sunPerEnergy));
        return Math.min(Math.addExact(leftEnergyFromFreeze, energyFromBalance), energyFromFeeLimit);
    }

    public long getTotalEnergyLimit(AccountCapsule creator, AccountCapsule caller, SmartContractOuterClass.TriggerSmartContract contract, long feeLimit, long callValue) throws ContractValidateException {
        if (Objects.isNull(creator) && VMConfig.allowTvmConstantinople()) {
            return this.getAccountEnergyLimitWithFixRatio(caller, feeLimit, callValue);
        }
        if (StorageUtils.getEnergyLimitHardFork()) {
            return this.getTotalEnergyLimitWithFixRatio(creator, caller, contract, feeLimit, callValue);
        }
        return this.getTotalEnergyLimitWithFloatRatio(creator, caller, contract, feeLimit, callValue);
    }

    public void checkTokenValueAndId(long tokenValue, long tokenId) throws ContractValidateException {
        if (VMConfig.allowTvmTransferTrc10() && VMConfig.allowMultiSign()) {
            if (tokenId <= 1000000L && tokenId != 0L) {
                throw new ContractValidateException("tokenId must be > 1000000");
            }
            if (tokenValue > 0L && tokenId == 0L) {
                throw new ContractValidateException("invalid arguments with tokenValue = " + tokenValue + ", tokenId = " + tokenId);
            }
        }
    }

    private double getCpuLimitInUsRatio() {
        double cpuLimitRatio = InternalTransaction.ExecutorType.ET_NORMAL_TYPE == this.executorType ? (this.blockCap != null && this.blockCap.generatedByMyself && !this.blockCap.hasWitnessSignature() ? 1.0 : (this.trx.getRet(0).getContractRet() == Protocol.Transaction.Result.contractResult.OUT_OF_TIME ? CommonParameter.getInstance().getMinTimeRatio() : CommonParameter.getInstance().getMaxTimeRatio())) : 1.0;
        return cpuLimitRatio;
    }

    public long getTotalEnergyLimitWithFixRatio(AccountCapsule creator, AccountCapsule caller, SmartContractOuterClass.TriggerSmartContract contract, long feeLimit, long callValue) throws ContractValidateException {
        long callerEnergyLimit = this.getAccountEnergyLimitWithFixRatio(caller, feeLimit, callValue);
        if (Arrays.equals(creator.getAddress().toByteArray(), caller.getAddress().toByteArray())) {
            return callerEnergyLimit;
        }
        long creatorEnergyLimit = 0L;
        ContractCapsule contractCapsule = this.rootRepository.getContract(contract.getContractAddress().toByteArray());
        long consumeUserResourcePercent = contractCapsule.getConsumeUserResourcePercent();
        long originEnergyLimit = contractCapsule.getOriginEnergyLimit();
        if (originEnergyLimit < 0L) {
            throw new ContractValidateException("originEnergyLimit can't be < 0");
        }
        long originEnergyLeft = 0L;
        if (consumeUserResourcePercent < 100L) {
            originEnergyLeft = this.rootRepository.getAccountLeftEnergyFromFreeze(creator);
            if (VMConfig.allowTvmFreeze() || VMConfig.allowTvmFreezeV2()) {
                this.receipt.setOriginEnergyLeft(originEnergyLeft);
            }
        }
        if (consumeUserResourcePercent <= 0L) {
            creatorEnergyLimit = Math.min(originEnergyLeft, originEnergyLimit);
        } else if (consumeUserResourcePercent < 100L) {
            creatorEnergyLimit = Math.min(BigInteger.valueOf(callerEnergyLimit).multiply(BigInteger.valueOf(100L - consumeUserResourcePercent)).divide(BigInteger.valueOf(consumeUserResourcePercent)).longValueExact(), Math.min(originEnergyLeft, originEnergyLimit));
        }
        if (VMConfig.allowTvmFreezeV2()) {
            long now = this.rootRepository.getHeadSlot();
            EnergyProcessor energyProcessor = new EnergyProcessor(this.rootRepository.getDynamicPropertiesStore(), ChainBaseManager.getInstance().getAccountStore());
            energyProcessor.updateUsage(creator);
            creator.setLatestConsumeTimeForEnergy(now);
            this.receipt.setOriginEnergyUsage(creator.getEnergyUsage());
            this.receipt.setOriginEnergyWindowSize(creator.getWindowSize(Common.ResourceCode.ENERGY));
            this.receipt.setOriginEnergyWindowSizeV2(creator.getWindowSizeV2(Common.ResourceCode.ENERGY));
            creator.setEnergyUsage(energyProcessor.increase(creator, Common.ResourceCode.ENERGY, creator.getEnergyUsage(), creatorEnergyLimit, now, now));
            this.receipt.setOriginEnergyMergedUsage(creator.getEnergyUsage());
            this.receipt.setOriginEnergyMergedWindowSize(creator.getWindowSize(Common.ResourceCode.ENERGY));
            this.rootRepository.updateAccount(creator.createDbKey(), creator);
        }
        return Math.addExact(callerEnergyLimit, creatorEnergyLimit);
    }

    private long getTotalEnergyLimitWithFloatRatio(AccountCapsule creator, AccountCapsule caller, SmartContractOuterClass.TriggerSmartContract contract, long feeLimit, long callValue) {
        ContractCapsule contractCapsule;
        long consumeUserResourcePercent;
        long callerEnergyLimit = this.getAccountEnergyLimitWithFloatRatio(caller, feeLimit, callValue);
        if (Arrays.equals(creator.getAddress().toByteArray(), caller.getAddress().toByteArray())) {
            return callerEnergyLimit;
        }
        long creatorEnergyLimit = this.rootRepository.getAccountLeftEnergyFromFreeze(creator);
        if (creatorEnergyLimit * (consumeUserResourcePercent = (contractCapsule = this.rootRepository.getContract(contract.getContractAddress().toByteArray())).getConsumeUserResourcePercent()) > (100L - consumeUserResourcePercent) * callerEnergyLimit) {
            return Math.floorDiv(callerEnergyLimit * 100L, consumeUserResourcePercent);
        }
        return Math.addExact(callerEnergyLimit, creatorEnergyLimit);
    }

    private boolean isCheckTransaction() {
        return this.blockCap != null && !this.blockCap.getInstance().getBlockHeader().getWitnessSignature().isEmpty();
    }

    public InternalTransaction.TrxType getTrxType() {
        return this.trxType;
    }

    public void setTrxType(InternalTransaction.TrxType trxType) {
        this.trxType = trxType;
    }

    public boolean isConstantCall() {
        return this.isConstantCall;
    }

    public void setConstantCall(boolean isConstantCall) {
        this.isConstantCall = isConstantCall;
    }

    public void setEnableEventListener(boolean enableEventListener) {
        this.enableEventListener = enableEventListener;
    }
}

