/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DelegationStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.WitnessStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.StorageContract;

public class UpdateBrokerageActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public UpdateBrokerageActuator() {
        super(Protocol.Transaction.Contract.ContractType.UpdateBrokerageContract, StorageContract.UpdateBrokerageContract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        StorageContract.UpdateBrokerageContract updateBrokerageContract;
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        DelegationStore delegationStore = this.chainBaseManager.getDelegationStore();
        try {
            updateBrokerageContract = (StorageContract.UpdateBrokerageContract)this.any.unpack(StorageContract.UpdateBrokerageContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        byte[] ownerAddress = updateBrokerageContract.getOwnerAddress().toByteArray();
        int brokerage = updateBrokerageContract.getBrokerage();
        delegationStore.setBrokerage(ownerAddress, brokerage);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    public boolean validate() throws ContractValidateException {
        StorageContract.UpdateBrokerageContract updateBrokerageContract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        WitnessStore witnessStore = this.chainBaseManager.getWitnessStore();
        if (!dynamicStore.allowChangeDelegation()) {
            throw new ContractValidateException("contract type error, unexpected type [UpdateBrokerageContract]");
        }
        if (!this.any.is(StorageContract.UpdateBrokerageContract.class)) {
            throw new ContractValidateException("contract type error, expected type [UpdateBrokerageContract], real type[" + this.any.getClass() + "]");
        }
        try {
            updateBrokerageContract = (StorageContract.UpdateBrokerageContract)this.any.unpack(StorageContract.UpdateBrokerageContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = updateBrokerageContract.getOwnerAddress().toByteArray();
        int brokerage = updateBrokerageContract.getBrokerage();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        if (brokerage < 0 || brokerage > 100) {
            throw new ContractValidateException("Invalid brokerage");
        }
        WitnessCapsule witnessCapsule = witnessStore.get(ownerAddress);
        if (witnessCapsule == null) {
            throw new ContractValidateException("Not existed witness:" + Hex.toHexString((byte[])ownerAddress));
        }
        AccountCapsule account = accountStore.get(ownerAddress);
        if (account == null) {
            throw new ContractValidateException("Account does not exist");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((StorageContract.UpdateBrokerageContract)this.any.unpack(StorageContract.UpdateBrokerageContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

