/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.utils.TransactionUtil;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AccountContract;

public class UpdateAccountActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public UpdateAccountActuator() {
        super(Protocol.Transaction.Contract.ContractType.AccountUpdateContract, AccountContract.AccountUpdateContract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        AccountContract.AccountUpdateContract accountUpdateContract;
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        try {
            accountUpdateContract = (AccountContract.AccountUpdateContract)this.any.unpack(AccountContract.AccountUpdateContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        byte[] ownerAddress = accountUpdateContract.getOwnerAddress().toByteArray();
        AccountCapsule account = this.chainBaseManager.getAccountStore().get(ownerAddress);
        account.setAccountName(accountUpdateContract.getAccountName().toByteArray());
        this.chainBaseManager.getAccountStore().put(ownerAddress, account);
        this.chainBaseManager.getAccountIndexStore().put(account);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    public boolean validate() throws ContractValidateException {
        AccountContract.AccountUpdateContract accountUpdateContract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        if (!this.any.is(AccountContract.AccountUpdateContract.class)) {
            throw new ContractValidateException("contract type error, expected type [AccountUpdateContract], real type[" + this.any.getClass() + "]");
        }
        try {
            accountUpdateContract = (AccountContract.AccountUpdateContract)this.any.unpack(AccountContract.AccountUpdateContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = accountUpdateContract.getOwnerAddress().toByteArray();
        byte[] accountName = accountUpdateContract.getAccountName().toByteArray();
        if (!TransactionUtil.validAccountName(accountName)) {
            throw new ContractValidateException("Invalid accountName");
        }
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        AccountCapsule account = this.chainBaseManager.getAccountStore().get(ownerAddress);
        if (account == null) {
            throw new ContractValidateException("Account does not exist");
        }
        if (account.getAccountName() != null && !account.getAccountName().isEmpty() && this.chainBaseManager.getDynamicPropertiesStore().getAllowUpdateAccountName() == 0L) {
            throw new ContractValidateException("This account name is already existed");
        }
        if (this.chainBaseManager.getAccountIndexStore().has(accountName) && this.chainBaseManager.getDynamicPropertiesStore().getAllowUpdateAccountName() == 0L) {
            throw new ContractValidateException("This name is existed");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((AccountContract.AccountUpdateContract)this.any.unpack(AccountContract.AccountUpdateContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

