/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.VotesCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.service.MortgageService;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.VotesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.BalanceContract;
import org.tron.protos.contract.Common;

public class UnfreezeBalanceV2Actuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");
    private static final int UNFREEZE_MAX_TIMES = 32;

    public UnfreezeBalanceV2Actuator() {
        super(Protocol.Transaction.Contract.ContractType.UnfreezeBalanceV2Contract, BalanceContract.UnfreezeBalanceV2Contract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        BalanceContract.UnfreezeBalanceV2Contract unfreezeBalanceV2Contract;
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        MortgageService mortgageService = this.chainBaseManager.getMortgageService();
        try {
            unfreezeBalanceV2Contract = (BalanceContract.UnfreezeBalanceV2Contract)this.any.unpack(BalanceContract.UnfreezeBalanceV2Contract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        byte[] ownerAddress = unfreezeBalanceV2Contract.getOwnerAddress().toByteArray();
        long now = dynamicStore.getLatestBlockHeaderTimestamp();
        mortgageService.withdrawReward(ownerAddress);
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        long unfreezeAmount = this.unfreezeExpire(accountCapsule, now);
        long unfreezeBalance = unfreezeBalanceV2Contract.getUnfreezeBalance();
        if (dynamicStore.supportAllowNewResourceModel() && accountCapsule.oldTronPowerIsNotInitialized()) {
            accountCapsule.initializeOldTronPower();
        }
        Common.ResourceCode freezeType = unfreezeBalanceV2Contract.getResource();
        long expireTime = this.calcUnfreezeExpireTime(now);
        accountCapsule.addUnfrozenV2List(freezeType, unfreezeBalance, expireTime);
        this.updateTotalResourceWeight(accountCapsule, unfreezeBalanceV2Contract, unfreezeBalance);
        this.updateVote(accountCapsule, unfreezeBalanceV2Contract, ownerAddress);
        if (dynamicStore.supportAllowNewResourceModel() && !accountCapsule.oldTronPowerIsInvalid()) {
            accountCapsule.invalidateOldTronPower();
        }
        accountStore.put(ownerAddress, accountCapsule);
        ret.setWithdrawExpireAmount(unfreezeAmount);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    public boolean validate() throws ContractValidateException {
        BalanceContract.UnfreezeBalanceV2Contract unfreezeBalanceV2Contract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        if (!this.any.is(BalanceContract.UnfreezeBalanceV2Contract.class)) {
            throw new ContractValidateException("contract type error, expected type [UnfreezeBalanceContract], real type[" + this.any.getClass() + "]");
        }
        if (!dynamicStore.supportUnfreezeDelay()) {
            throw new ContractValidateException("Not support UnfreezeV2 transaction, need to be opened by the committee");
        }
        try {
            unfreezeBalanceV2Contract = (BalanceContract.UnfreezeBalanceV2Contract)this.any.unpack(BalanceContract.UnfreezeBalanceV2Contract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = unfreezeBalanceV2Contract.getOwnerAddress().toByteArray();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        if (accountCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] does not exist");
        }
        long now = dynamicStore.getLatestBlockHeaderTimestamp();
        switch (unfreezeBalanceV2Contract.getResource()) {
            case BANDWIDTH: {
                if (this.checkExistFrozenBalance(accountCapsule, Common.ResourceCode.BANDWIDTH)) break;
                throw new ContractValidateException("no frozenBalance(BANDWIDTH)");
            }
            case ENERGY: {
                if (this.checkExistFrozenBalance(accountCapsule, Common.ResourceCode.ENERGY)) break;
                throw new ContractValidateException("no frozenBalance(Energy)");
            }
            case TRON_POWER: {
                if (dynamicStore.supportAllowNewResourceModel()) {
                    if (this.checkExistFrozenBalance(accountCapsule, Common.ResourceCode.TRON_POWER)) break;
                    throw new ContractValidateException("no frozenBalance(TronPower)");
                }
                throw new ContractValidateException("ResourceCode error.valid ResourceCode[BANDWIDTH\u3001Energy]");
            }
            default: {
                if (dynamicStore.supportAllowNewResourceModel()) {
                    throw new ContractValidateException("ResourceCode error.valid ResourceCode[BANDWIDTH\u3001Energy\u3001TRON_POWER]");
                }
                throw new ContractValidateException("ResourceCode error.valid ResourceCode[BANDWIDTH\u3001Energy]");
            }
        }
        if (!this.checkUnfreezeBalance(accountCapsule, unfreezeBalanceV2Contract, unfreezeBalanceV2Contract.getResource())) {
            throw new ContractValidateException("Invalid unfreeze_balance, [" + unfreezeBalanceV2Contract.getUnfreezeBalance() + "] is error");
        }
        int unfreezingCount = accountCapsule.getUnfreezingV2Count(now);
        if (32 <= unfreezingCount) {
            throw new ContractValidateException("Invalid unfreeze operation, unfreezing times is over limit");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((BalanceContract.UnfreezeBalanceV2Contract)this.any.unpack(BalanceContract.UnfreezeBalanceV2Contract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }

    public boolean checkExistFrozenBalance(AccountCapsule accountCapsule, Common.ResourceCode freezeType) {
        List frozenV2List = accountCapsule.getFrozenV2List();
        for (Protocol.Account.FreezeV2 frozenV2 : frozenV2List) {
            if (!frozenV2.getType().equals((Object)freezeType) || frozenV2.getAmount() <= 0L) continue;
            return true;
        }
        return false;
    }

    public boolean checkUnfreezeBalance(AccountCapsule accountCapsule, BalanceContract.UnfreezeBalanceV2Contract unfreezeBalanceV2Contract, Common.ResourceCode freezeType) {
        boolean checkOk = false;
        long frozenAmount = 0L;
        List freezeV2List = accountCapsule.getFrozenV2List();
        for (Protocol.Account.FreezeV2 freezeV2 : freezeV2List) {
            if (!freezeV2.getType().equals((Object)freezeType)) continue;
            frozenAmount = freezeV2.getAmount();
            break;
        }
        if (unfreezeBalanceV2Contract.getUnfreezeBalance() > 0L && unfreezeBalanceV2Contract.getUnfreezeBalance() <= frozenAmount) {
            checkOk = true;
        }
        return checkOk;
    }

    public long calcUnfreezeExpireTime(long now) {
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        long unfreezeDelayDays = dynamicStore.getUnfreezeDelayDays();
        return now + unfreezeDelayDays * 86400000L;
    }

    public void updateAccountFrozenInfo(Common.ResourceCode freezeType, AccountCapsule accountCapsule, long unfreezeBalance) {
        List freezeV2List = accountCapsule.getFrozenV2List();
        for (int i = 0; i < freezeV2List.size(); ++i) {
            if (!((Protocol.Account.FreezeV2)freezeV2List.get(i)).getType().equals((Object)freezeType)) continue;
            Protocol.Account.FreezeV2 freezeV2 = Protocol.Account.FreezeV2.newBuilder().setAmount(((Protocol.Account.FreezeV2)freezeV2List.get(i)).getAmount() - unfreezeBalance).setType(((Protocol.Account.FreezeV2)freezeV2List.get(i)).getType()).build();
            accountCapsule.updateFrozenV2List(i, freezeV2);
            break;
        }
    }

    public long unfreezeExpire(AccountCapsule accountCapsule, long now) {
        long unfreezeBalance = 0L;
        ArrayList unFrozenV2List = Lists.newArrayList();
        unFrozenV2List.addAll(accountCapsule.getUnfrozenV2List());
        Iterator iterator = unFrozenV2List.iterator();
        while (iterator.hasNext()) {
            Protocol.Account.UnFreezeV2 next = (Protocol.Account.UnFreezeV2)iterator.next();
            if (next.getUnfreezeExpireTime() > now) continue;
            unfreezeBalance += next.getUnfreezeAmount();
            iterator.remove();
        }
        accountCapsule.setInstance(accountCapsule.getInstance().toBuilder().setBalance(accountCapsule.getBalance() + unfreezeBalance).clearUnfrozenV2().addAllUnfrozenV2((Iterable)unFrozenV2List).build());
        return unfreezeBalance;
    }

    public void updateTotalResourceWeight(AccountCapsule accountCapsule, BalanceContract.UnfreezeBalanceV2Contract unfreezeBalanceV2Contract, long unfreezeBalance) {
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        switch (unfreezeBalanceV2Contract.getResource()) {
            case BANDWIDTH: {
                long oldNetWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.BANDWIDTH) / 1000000L;
                accountCapsule.addFrozenBalanceForBandwidthV2(-unfreezeBalance);
                long newNetWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.BANDWIDTH) / 1000000L;
                dynamicStore.addTotalNetWeight(newNetWeight - oldNetWeight);
                break;
            }
            case ENERGY: {
                long oldEnergyWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.ENERGY) / 1000000L;
                accountCapsule.addFrozenBalanceForEnergyV2(-unfreezeBalance);
                long newEnergyWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.ENERGY) / 1000000L;
                dynamicStore.addTotalEnergyWeight(newEnergyWeight - oldEnergyWeight);
                break;
            }
            case TRON_POWER: {
                long oldTPWeight = accountCapsule.getTronPowerFrozenV2Balance() / 1000000L;
                accountCapsule.addFrozenForTronPowerV2(-unfreezeBalance);
                long newTPWeight = accountCapsule.getTronPowerFrozenV2Balance() / 1000000L;
                dynamicStore.addTotalTronPowerWeight(newTPWeight - oldTPWeight);
                break;
            }
        }
    }

    private void updateVote(AccountCapsule accountCapsule, BalanceContract.UnfreezeBalanceV2Contract unfreezeBalanceV2Contract, byte[] ownerAddress) {
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        VotesStore votesStore = this.chainBaseManager.getVotesStore();
        if (accountCapsule.getVotesList().isEmpty()) {
            return;
        }
        if (dynamicStore.supportAllowNewResourceModel()) {
            if (accountCapsule.oldTronPowerIsInvalid()) {
                switch (unfreezeBalanceV2Contract.getResource()) {
                    case BANDWIDTH: 
                    case ENERGY: {
                        return;
                    }
                }
            } else {
                VotesCapsule votesCapsule = !votesStore.has(ownerAddress) ? new VotesCapsule(unfreezeBalanceV2Contract.getOwnerAddress(), accountCapsule.getVotesList()) : votesStore.get(ownerAddress);
                accountCapsule.clearVotes();
                votesCapsule.clearNewVotes();
                votesStore.put(ownerAddress, (ProtoCapsule)votesCapsule);
                return;
            }
        }
        long totalVote = 0L;
        for (Protocol.Vote vote : accountCapsule.getVotesList()) {
            totalVote += vote.getVoteCount();
        }
        long ownedTronPower = dynamicStore.supportAllowNewResourceModel() ? accountCapsule.getAllTronPower() : accountCapsule.getTronPower();
        if (ownedTronPower >= totalVote * 1000000L) {
            return;
        }
        if (totalVote == 0L) {
            return;
        }
        VotesCapsule votesCapsule = !votesStore.has(ownerAddress) ? new VotesCapsule(unfreezeBalanceV2Contract.getOwnerAddress(), accountCapsule.getVotesList()) : votesStore.get(ownerAddress);
        votesCapsule.clearNewVotes();
        for (Protocol.Vote vote : accountCapsule.getVotesList()) {
            long newVoteCount = (long)((double)vote.getVoteCount() / (double)totalVote * (double)ownedTronPower / 1000000.0);
            if (newVoteCount <= 0L) continue;
            votesCapsule.addNewVotes(vote.getVoteAddress(), newVoteCount);
        }
        votesStore.put(ownerAddress, (ProtoCapsule)votesCapsule);
        accountCapsule.clearVotes();
        for (Protocol.Vote vote : votesCapsule.getNewVotes()) {
            accountCapsule.addVotes(vote.getVoteAddress(), vote.getVoteCount());
        }
    }

    public static int getUNFREEZE_MAX_TIMES() {
        return 32;
    }
}

