/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.db.BandwidthProcessor;
import org.tron.core.db.EnergyProcessor;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DelegatedResourceAccountIndexStore;
import org.tron.core.store.DelegatedResourceStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.BalanceContract;
import org.tron.protos.contract.Common;

public class UnDelegateResourceActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public UnDelegateResourceActuator() {
        super(Protocol.Transaction.Contract.ContractType.UnDelegateResourceContract, BalanceContract.UnDelegateResourceContract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        BalanceContract.UnDelegateResourceContract unDelegateResourceContract;
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        DelegatedResourceStore delegatedResourceStore = this.chainBaseManager.getDelegatedResourceStore();
        DelegatedResourceAccountIndexStore delegatedResourceAccountIndexStore = this.chainBaseManager.getDelegatedResourceAccountIndexStore();
        try {
            unDelegateResourceContract = (BalanceContract.UnDelegateResourceContract)this.any.unpack(BalanceContract.UnDelegateResourceContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        long unDelegateBalance = unDelegateResourceContract.getBalance();
        byte[] ownerAddress = unDelegateResourceContract.getOwnerAddress().toByteArray();
        byte[] receiverAddress = unDelegateResourceContract.getReceiverAddress().toByteArray();
        AccountCapsule receiverCapsule = accountStore.get(receiverAddress);
        long transferUsage = 0L;
        if (receiverCapsule != null) {
            long now = this.chainBaseManager.getHeadSlot();
            switch (unDelegateResourceContract.getResource()) {
                case BANDWIDTH: {
                    BandwidthProcessor bandwidthProcessor = new BandwidthProcessor(this.chainBaseManager);
                    bandwidthProcessor.updateUsageForDelegated(receiverCapsule);
                    if (receiverCapsule.getAcquiredDelegatedFrozenV2BalanceForBandwidth() < unDelegateBalance) {
                        receiverCapsule.setAcquiredDelegatedFrozenV2BalanceForBandwidth(0L);
                    } else {
                        long unDelegateMaxUsage = (long)((double)unDelegateBalance / 1000000.0 * ((double)dynamicStore.getTotalNetLimit() / (double)dynamicStore.getTotalNetWeight()));
                        transferUsage = (long)((double)receiverCapsule.getNetUsage() * ((double)unDelegateBalance / (double)receiverCapsule.getAllFrozenBalanceForBandwidth()));
                        transferUsage = Math.min(unDelegateMaxUsage, transferUsage);
                        receiverCapsule.addAcquiredDelegatedFrozenV2BalanceForBandwidth(-unDelegateBalance);
                    }
                    long newNetUsage = receiverCapsule.getNetUsage() - transferUsage;
                    receiverCapsule.setNetUsage(newNetUsage);
                    receiverCapsule.setLatestConsumeTime(now);
                    break;
                }
                case ENERGY: {
                    EnergyProcessor energyProcessor = new EnergyProcessor(dynamicStore, accountStore);
                    energyProcessor.updateUsage(receiverCapsule);
                    if (receiverCapsule.getAcquiredDelegatedFrozenV2BalanceForEnergy() < unDelegateBalance) {
                        receiverCapsule.setAcquiredDelegatedFrozenV2BalanceForEnergy(0L);
                    } else {
                        long unDelegateMaxUsage = (long)((double)unDelegateBalance / 1000000.0 * ((double)dynamicStore.getTotalEnergyCurrentLimit() / (double)dynamicStore.getTotalEnergyWeight()));
                        transferUsage = (long)((double)receiverCapsule.getEnergyUsage() * ((double)unDelegateBalance / (double)receiverCapsule.getAllFrozenBalanceForEnergy()));
                        transferUsage = Math.min(unDelegateMaxUsage, transferUsage);
                        receiverCapsule.addAcquiredDelegatedFrozenV2BalanceForEnergy(-unDelegateBalance);
                    }
                    long newEnergyUsage = receiverCapsule.getEnergyUsage() - transferUsage;
                    receiverCapsule.setEnergyUsage(newEnergyUsage);
                    receiverCapsule.setLatestConsumeTimeForEnergy(now);
                    break;
                }
            }
            accountStore.put(receiverCapsule.createDbKey(), receiverCapsule);
        }
        delegatedResourceStore.unLockExpireResource(ownerAddress, receiverAddress, dynamicStore.getLatestBlockHeaderTimestamp());
        byte[] unlockKey = DelegatedResourceCapsule.createDbKeyV2((byte[])ownerAddress, (byte[])receiverAddress, (boolean)false);
        DelegatedResourceCapsule unlockResource = delegatedResourceStore.get(unlockKey);
        AccountCapsule ownerCapsule = accountStore.get(ownerAddress);
        switch (unDelegateResourceContract.getResource()) {
            case BANDWIDTH: {
                unlockResource.addFrozenBalanceForBandwidth(-unDelegateBalance, 0L);
                ownerCapsule.addDelegatedFrozenV2BalanceForBandwidth(-unDelegateBalance);
                ownerCapsule.addFrozenBalanceForBandwidthV2(unDelegateBalance);
                BandwidthProcessor processor = new BandwidthProcessor(this.chainBaseManager);
                long now = this.chainBaseManager.getHeadSlot();
                if (!Objects.nonNull(receiverCapsule) || transferUsage <= 0L) break;
                ownerCapsule.setNetUsage(processor.unDelegateIncrease(ownerCapsule, receiverCapsule, transferUsage, Common.ResourceCode.BANDWIDTH, now));
                ownerCapsule.setLatestConsumeTime(now);
                break;
            }
            case ENERGY: {
                unlockResource.addFrozenBalanceForEnergy(-unDelegateBalance, 0L);
                ownerCapsule.addDelegatedFrozenV2BalanceForEnergy(-unDelegateBalance);
                ownerCapsule.addFrozenBalanceForEnergyV2(unDelegateBalance);
                EnergyProcessor processor = new EnergyProcessor(dynamicStore, accountStore);
                long now = this.chainBaseManager.getHeadSlot();
                if (!Objects.nonNull(receiverCapsule) || transferUsage <= 0L) break;
                ownerCapsule.setEnergyUsage(processor.unDelegateIncrease(ownerCapsule, receiverCapsule, transferUsage, Common.ResourceCode.ENERGY, now));
                ownerCapsule.setLatestConsumeTimeForEnergy(now);
                break;
            }
        }
        if (unlockResource.getFrozenBalanceForBandwidth() == 0L && unlockResource.getFrozenBalanceForEnergy() == 0L) {
            delegatedResourceStore.delete(unlockKey);
            unlockResource = null;
        } else {
            delegatedResourceStore.put(unlockKey, (ProtoCapsule)unlockResource);
        }
        byte[] lockKey = DelegatedResourceCapsule.createDbKeyV2((byte[])ownerAddress, (byte[])receiverAddress, (boolean)true);
        DelegatedResourceCapsule lockResource = delegatedResourceStore.get(lockKey);
        if (lockResource == null && unlockResource == null) {
            delegatedResourceAccountIndexStore.unDelegateV2(ownerAddress, receiverAddress);
        }
        accountStore.put(ownerAddress, ownerCapsule);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    public boolean validate() throws ContractValidateException {
        BalanceContract.UnDelegateResourceContract unDelegateResourceContract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        DelegatedResourceStore delegatedResourceStore = this.chainBaseManager.getDelegatedResourceStore();
        if (!dynamicStore.supportDR()) {
            throw new ContractValidateException("No support for resource delegate");
        }
        if (!dynamicStore.supportUnfreezeDelay()) {
            throw new ContractValidateException("Not support unDelegate resource transaction, need to be opened by the committee");
        }
        if (!this.any.is(BalanceContract.UnDelegateResourceContract.class)) {
            throw new ContractValidateException("contract type error, expected type [UnDelegateResourceContract], real type[" + this.any.getClass() + "]");
        }
        try {
            unDelegateResourceContract = (BalanceContract.UnDelegateResourceContract)this.any.unpack(BalanceContract.UnDelegateResourceContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = unDelegateResourceContract.getOwnerAddress().toByteArray();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule ownerCapsule = accountStore.get(ownerAddress);
        if (ownerCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] does not exist");
        }
        byte[] receiverAddress = unDelegateResourceContract.getReceiverAddress().toByteArray();
        if (ArrayUtils.isEmpty((byte[])receiverAddress) || !DecodeUtil.addressValid((byte[])receiverAddress)) {
            throw new ContractValidateException("Invalid receiverAddress");
        }
        if (Arrays.equals(receiverAddress, ownerAddress)) {
            throw new ContractValidateException("receiverAddress must not be the same as ownerAddress");
        }
        long now = dynamicStore.getLatestBlockHeaderTimestamp();
        byte[] key = DelegatedResourceCapsule.createDbKeyV2((byte[])ownerAddress, (byte[])receiverAddress, (boolean)false);
        DelegatedResourceCapsule unlockResourceCapsule = delegatedResourceStore.get(key);
        byte[] lockKey = DelegatedResourceCapsule.createDbKeyV2((byte[])ownerAddress, (byte[])receiverAddress, (boolean)true);
        DelegatedResourceCapsule lockResourceCapsule = delegatedResourceStore.get(lockKey);
        if (unlockResourceCapsule == null && lockResourceCapsule == null) {
            throw new ContractValidateException("delegated Resource does not exist");
        }
        long unDelegateBalance = unDelegateResourceContract.getBalance();
        if (unDelegateBalance <= 0L) {
            throw new ContractValidateException("unDelegateBalance must be more than 0 TRX");
        }
        switch (unDelegateResourceContract.getResource()) {
            case BANDWIDTH: {
                long delegateBalance = 0L;
                if (unlockResourceCapsule != null) {
                    delegateBalance += unlockResourceCapsule.getFrozenBalanceForBandwidth();
                }
                if (lockResourceCapsule != null && lockResourceCapsule.getExpireTimeForBandwidth() < now) {
                    delegateBalance += lockResourceCapsule.getFrozenBalanceForBandwidth();
                }
                if (delegateBalance >= unDelegateBalance) break;
                throw new ContractValidateException("insufficient delegatedFrozenBalance(BANDWIDTH), request=" + unDelegateBalance + ", unlock_balance=" + delegateBalance);
            }
            case ENERGY: {
                long delegateBalance = 0L;
                if (unlockResourceCapsule != null) {
                    delegateBalance += unlockResourceCapsule.getFrozenBalanceForEnergy();
                }
                if (lockResourceCapsule != null && lockResourceCapsule.getExpireTimeForEnergy() < now) {
                    delegateBalance += lockResourceCapsule.getFrozenBalanceForEnergy();
                }
                if (delegateBalance >= unDelegateBalance) break;
                throw new ContractValidateException("insufficient delegateFrozenBalance(Energy), request=" + unDelegateBalance + ", unlock_balance=" + delegateBalance);
            }
            default: {
                throw new ContractValidateException("ResourceCode error.valid ResourceCode[BANDWIDTH\u3001Energy]");
            }
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((BalanceContract.UnDelegateResourceContract)this.any.unpack(BalanceContract.UnDelegateResourceContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

