/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.ProposalCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.utils.ProposalUtil;
import org.tron.protos.Protocol;
import org.tron.protos.contract.ProposalContract;

public class ProposalCreateActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public ProposalCreateActuator() {
        super(Protocol.Transaction.Contract.ContractType.ProposalCreateContract, ProposalContract.ProposalCreateContract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        try {
            ProposalContract.ProposalCreateContract proposalCreateContract = (ProposalContract.ProposalCreateContract)this.any.unpack(ProposalContract.ProposalCreateContract.class);
            long id = this.chainBaseManager.getDynamicPropertiesStore().getLatestProposalNum() + 1L;
            ProposalCapsule proposalCapsule = new ProposalCapsule(proposalCreateContract.getOwnerAddress(), id);
            proposalCapsule.setParameters(proposalCreateContract.getParametersMap());
            long now = this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp();
            long maintenanceTimeInterval = this.chainBaseManager.getDynamicPropertiesStore().getMaintenanceTimeInterval();
            proposalCapsule.setCreateTime(now);
            long currentMaintenanceTime = this.chainBaseManager.getDynamicPropertiesStore().getNextMaintenanceTime();
            long now3 = now + CommonParameter.getInstance().getProposalExpireTime();
            long round = (now3 - currentMaintenanceTime) / maintenanceTimeInterval;
            long expirationTime = currentMaintenanceTime + (round + 1L) * maintenanceTimeInterval;
            proposalCapsule.setExpirationTime(expirationTime);
            this.chainBaseManager.getProposalStore().put(proposalCapsule.createDbKey(), (ProtoCapsule)proposalCapsule);
            this.chainBaseManager.getDynamicPropertiesStore().saveLatestProposalNum(id);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        ProposalContract.ProposalCreateContract contract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No dbManager!");
        }
        if (!this.any.is(ProposalContract.ProposalCreateContract.class)) {
            throw new ContractValidateException("contract type error,expected type [ProposalCreateContract],real type[" + this.any.getClass() + "]");
        }
        try {
            contract = (ProposalContract.ProposalCreateContract)this.any.unpack(ProposalContract.ProposalCreateContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        if (!this.chainBaseManager.getAccountStore().has(ownerAddress)) {
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        if (!this.chainBaseManager.getWitnessStore().has(ownerAddress)) {
            throw new ContractValidateException("Witness[" + readableOwnerAddress + "] not exists");
        }
        if (contract.getParametersMap().size() == 0) {
            throw new ContractValidateException("This proposal has no parameter.");
        }
        for (Map.Entry<Long, Long> entry : contract.getParametersMap().entrySet()) {
            this.validateValue(entry);
        }
        return true;
    }

    private void validateValue(Map.Entry<Long, Long> entry) throws ContractValidateException {
        ProposalUtil.validator(this.chainBaseManager.getDynamicPropertiesStore(), this.forkController, entry.getKey(), entry.getValue());
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((ProposalContract.ProposalCreateContract)this.any.unpack(ProposalContract.ProposalCreateContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

