/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.Commons;
import org.tron.common.utils.DecodeUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.AssetIssueV2Store;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.utils.TransactionUtil;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AssetIssueContractOuterClass;

public class AssetIssueActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public AssetIssueActuator() {
        super(Protocol.Transaction.Contract.ContractType.AssetIssueContract, AssetIssueContractOuterClass.AssetIssueContract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        AssetIssueStore assetIssueStore = this.chainBaseManager.getAssetIssueStore();
        AssetIssueV2Store assetIssueV2Store = this.chainBaseManager.getAssetIssueV2Store();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        try {
            AssetIssueContractOuterClass.AssetIssueContract assetIssueContract = (AssetIssueContractOuterClass.AssetIssueContract)this.any.unpack(AssetIssueContractOuterClass.AssetIssueContract.class);
            byte[] ownerAddress = assetIssueContract.getOwnerAddress().toByteArray();
            AssetIssueCapsule assetIssueCapsule = new AssetIssueCapsule(assetIssueContract);
            AssetIssueCapsule assetIssueCapsuleV2 = new AssetIssueCapsule(assetIssueContract);
            long tokenIdNum = dynamicStore.getTokenIdNum();
            assetIssueCapsule.setId(Long.toString(++tokenIdNum));
            assetIssueCapsuleV2.setId(Long.toString(tokenIdNum));
            dynamicStore.saveTokenIdNum(tokenIdNum);
            if (dynamicStore.getAllowSameTokenName() == 0L) {
                assetIssueCapsuleV2.setPrecision(0);
                assetIssueStore.put(assetIssueCapsule.createDbKey(), (ProtoCapsule)assetIssueCapsule);
                assetIssueV2Store.put(assetIssueCapsuleV2.createDbV2Key(), (ProtoCapsule)assetIssueCapsuleV2);
            } else {
                assetIssueV2Store.put(assetIssueCapsuleV2.createDbV2Key(), (ProtoCapsule)assetIssueCapsuleV2);
            }
            Commons.adjustBalance((AccountStore)accountStore, (byte[])ownerAddress, (long)(-fee));
            if (dynamicStore.supportBlackHoleOptimization()) {
                dynamicStore.burnTrx(fee);
            } else {
                Commons.adjustBalance((AccountStore)accountStore, (AccountCapsule)accountStore.getBlackhole(), (long)fee);
            }
            AccountCapsule accountCapsule = accountStore.get(ownerAddress);
            List frozenSupplyList = assetIssueContract.getFrozenSupplyList();
            Iterator iterator = frozenSupplyList.iterator();
            long remainSupply = assetIssueContract.getTotalSupply();
            ArrayList<Protocol.Account.Frozen> frozenList = new ArrayList<Protocol.Account.Frozen>();
            long startTime = assetIssueContract.getStartTime();
            while (iterator.hasNext()) {
                AssetIssueContractOuterClass.AssetIssueContract.FrozenSupply next = (AssetIssueContractOuterClass.AssetIssueContract.FrozenSupply)iterator.next();
                long expireTime = startTime + next.getFrozenDays() * 86400000L;
                Protocol.Account.Frozen newFrozen = Protocol.Account.Frozen.newBuilder().setFrozenBalance(next.getFrozenAmount()).setExpireTime(expireTime).build();
                frozenList.add(newFrozen);
                remainSupply -= next.getFrozenAmount();
            }
            if (dynamicStore.getAllowSameTokenName() == 0L) {
                accountCapsule.addAsset(assetIssueCapsule.createDbKey(), remainSupply);
            }
            accountCapsule.setAssetIssuedName(assetIssueCapsule.createDbKey());
            accountCapsule.setAssetIssuedID(assetIssueCapsule.createDbV2Key());
            accountCapsule.addAssetV2(assetIssueCapsuleV2.createDbV2Key(), remainSupply);
            accountCapsule.setInstance(accountCapsule.getInstance().toBuilder().addAllFrozenSupply(frozenList).build());
            accountStore.put(ownerAddress, accountCapsule);
            ret.setAssetIssueID(Long.toString(tokenIdNum));
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException | ArithmeticException | BalanceInsufficientException e) {
            logger.debug(e.getMessage(), e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        String name;
        AssetIssueContractOuterClass.AssetIssueContract assetIssueContract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        AssetIssueStore assetIssueStore = this.chainBaseManager.getAssetIssueStore();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        if (!this.any.is(AssetIssueContractOuterClass.AssetIssueContract.class)) {
            throw new ContractValidateException("contract type error,expected type [AssetIssueContract],real type[" + this.any.getClass() + "]");
        }
        try {
            assetIssueContract = (AssetIssueContractOuterClass.AssetIssueContract)this.any.unpack(AssetIssueContractOuterClass.AssetIssueContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = assetIssueContract.getOwnerAddress().toByteArray();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        if (!TransactionUtil.validAssetName(assetIssueContract.getName().toByteArray())) {
            throw new ContractValidateException("Invalid assetName");
        }
        if (dynamicStore.getAllowSameTokenName() != 0L && "trx".equals(name = assetIssueContract.getName().toStringUtf8().toLowerCase())) {
            throw new ContractValidateException("assetName can't be trx");
        }
        int precision = assetIssueContract.getPrecision();
        if (precision != 0 && dynamicStore.getAllowSameTokenName() != 0L && (precision < 0 || precision > 6)) {
            throw new ContractValidateException("precision cannot exceed 6");
        }
        if (!assetIssueContract.getAbbr().isEmpty() && !TransactionUtil.validAssetName(assetIssueContract.getAbbr().toByteArray())) {
            throw new ContractValidateException("Invalid abbreviation for token");
        }
        if (!TransactionUtil.validUrl(assetIssueContract.getUrl().toByteArray())) {
            throw new ContractValidateException("Invalid url");
        }
        if (!TransactionUtil.validAssetDescription(assetIssueContract.getDescription().toByteArray())) {
            throw new ContractValidateException("Invalid description");
        }
        if (assetIssueContract.getStartTime() == 0L) {
            throw new ContractValidateException("Start time should be not empty");
        }
        if (assetIssueContract.getEndTime() == 0L) {
            throw new ContractValidateException("End time should be not empty");
        }
        if (assetIssueContract.getEndTime() <= assetIssueContract.getStartTime()) {
            throw new ContractValidateException("End time should be greater than start time");
        }
        if (assetIssueContract.getStartTime() <= dynamicStore.getLatestBlockHeaderTimestamp()) {
            throw new ContractValidateException("Start time should be greater than HeadBlockTime");
        }
        if (dynamicStore.getAllowSameTokenName() == 0L && assetIssueStore.get(assetIssueContract.getName().toByteArray()) != null) {
            throw new ContractValidateException("Token exists");
        }
        if (assetIssueContract.getTotalSupply() <= 0L) {
            throw new ContractValidateException("TotalSupply must greater than 0!");
        }
        if (assetIssueContract.getTrxNum() <= 0) {
            throw new ContractValidateException("TrxNum must greater than 0!");
        }
        if (assetIssueContract.getNum() <= 0) {
            throw new ContractValidateException("Num must greater than 0!");
        }
        if (assetIssueContract.getPublicFreeAssetNetUsage() != 0L) {
            throw new ContractValidateException("PublicFreeAssetNetUsage must be 0!");
        }
        if (assetIssueContract.getFrozenSupplyCount() > dynamicStore.getMaxFrozenSupplyNumber()) {
            throw new ContractValidateException("Frozen supply list length is too long");
        }
        if (assetIssueContract.getFreeAssetNetLimit() < 0L || assetIssueContract.getFreeAssetNetLimit() >= dynamicStore.getOneDayNetLimit()) {
            throw new ContractValidateException("Invalid FreeAssetNetLimit");
        }
        if (assetIssueContract.getPublicFreeAssetNetLimit() < 0L || assetIssueContract.getPublicFreeAssetNetLimit() >= dynamicStore.getOneDayNetLimit()) {
            throw new ContractValidateException("Invalid PublicFreeAssetNetLimit");
        }
        long remainSupply = assetIssueContract.getTotalSupply();
        long minFrozenSupplyTime = dynamicStore.getMinFrozenSupplyTime();
        long maxFrozenSupplyTime = dynamicStore.getMaxFrozenSupplyTime();
        List frozenList = assetIssueContract.getFrozenSupplyList();
        for (AssetIssueContractOuterClass.AssetIssueContract.FrozenSupply next : frozenList) {
            if (next.getFrozenAmount() <= 0L) {
                throw new ContractValidateException("Frozen supply must be greater than 0!");
            }
            if (next.getFrozenAmount() > remainSupply) {
                throw new ContractValidateException("Frozen supply cannot exceed total supply");
            }
            if (next.getFrozenDays() < minFrozenSupplyTime || next.getFrozenDays() > maxFrozenSupplyTime) {
                throw new ContractValidateException("frozenDuration must be less than " + maxFrozenSupplyTime + " days and more than " + minFrozenSupplyTime + " days");
            }
            remainSupply -= next.getFrozenAmount();
        }
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        if (accountCapsule == null) {
            throw new ContractValidateException("Account not exists");
        }
        if (!accountCapsule.getAssetIssuedName().isEmpty()) {
            throw new ContractValidateException("An account can only issue one asset");
        }
        if (accountCapsule.getBalance() < this.calcFee()) {
            throw new ContractValidateException("No enough balance for fee!");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((AssetIssueContractOuterClass.AssetIssueContract)this.any.unpack(AssetIssueContractOuterClass.AssetIssueContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return this.chainBaseManager.getDynamicPropertiesStore().getAssetIssueFee();
    }
}

