/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ForkController;
import org.tron.core.ChainBaseManager;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.actuator.Actuator;
import org.tron.core.actuator.TransactionFactory;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.StoreFactory;
import org.tron.protos.Protocol;

public class ActuatorCreator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");
    private ForkController forkController = new ForkController();
    private ChainBaseManager chainBaseManager;

    private ActuatorCreator(StoreFactory storeFactory) {
        this.chainBaseManager = storeFactory.getChainBaseManager();
        this.forkController.init(storeFactory.getChainBaseManager());
    }

    public static ActuatorCreator getINSTANCE() {
        if (ActuatorCreatorInner.instance == null) {
            ActuatorCreatorInner.instance = new ActuatorCreator(StoreFactory.getInstance());
        }
        return ActuatorCreatorInner.instance;
    }

    public static void init() {
        ActuatorCreatorInner.instance = new ActuatorCreator(StoreFactory.getInstance());
    }

    public List<Actuator> createActuator(TransactionCapsule transactionCapsule) throws ContractValidateException {
        ArrayList actuatorList = Lists.newArrayList();
        if (null == transactionCapsule || null == transactionCapsule.getInstance()) {
            logger.info("TransactionCapsule or Transaction is null");
            return actuatorList;
        }
        Protocol.Transaction.raw rawData = transactionCapsule.getInstance().getRawData();
        for (Protocol.Transaction.Contract contract : rawData.getContractList()) {
            try {
                actuatorList.add(this.getActuatorByContract(contract, transactionCapsule));
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                throw new ContractValidateException(e.getMessage());
            }
        }
        return actuatorList;
    }

    private Actuator getActuatorByContract(Protocol.Transaction.Contract contract, TransactionCapsule tx) throws IllegalAccessException, InstantiationException, ContractValidateException {
        Class clazz = TransactionFactory.getActuator((Protocol.Transaction.Contract.ContractType)contract.getType());
        if (clazz == null) {
            throw new ContractValidateException("not exist contract " + contract);
        }
        AbstractActuator abstractActuator = (AbstractActuator)clazz.newInstance();
        abstractActuator.setChainBaseManager(this.chainBaseManager).setContract(contract).setForkUtils(this.forkController).setTx(tx);
        return abstractActuator;
    }

    private static class ActuatorCreatorInner {
        private static ActuatorCreator instance;

        private ActuatorCreatorInner() {
        }
    }
}

