/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import com.github.triniwiz.canvas.TNSImageAssetFormat;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 :2\u00020\u0001:\u000389:B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0004J\u0006\u0010\u001c\u001a\u00020\u001bJ\u0006\u0010\u001d\u001a\u00020\u001bJ\u000e\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0004J\u0016\u0010 \u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\"J\u000e\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\bJ\u0016\u0010)\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"J\u0016\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u00020\bJ\u0016\u00100\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"J\u0016\u00101\u001a\u00020\f2\u0006\u0010(\u001a\u00020\b2\u0006\u00102\u001a\u000203J\u001e\u00104\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\b2\u0006\u00102\u001a\u0002032\u0006\u0010!\u001a\u00020\"J\u0016\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0010\u00a8\u0006;"}, d2={"Lcom/github/triniwiz/canvas/TNSImageAsset;", "", "()V", "bytes", "", "getBytes", "()[B", "error", "", "getError", "()Ljava/lang/String;", "hasResourceError", "", "height", "", "getHeight", "()I", "nativeImageAsset", "", "getNativeImageAsset$canvas_release", "()J", "setNativeImageAsset$canvas_release", "(J)V", "resourceError", "width", "getWidth", "finalize", "", "flipX", "flipY", "loadImageFromBytes", "buffer", "loadImageFromBytesAsync", "callback", "Lcom/github/triniwiz/canvas/TNSImageAsset$Callback;", "loadImageFromImage", "bitmap", "Landroid/graphics/Bitmap;", "loadImageFromImageAsync", "loadImageFromPath", "path", "loadImageFromPathAsync", "loadImageFromResource", "id", "context", "Landroid/content/Context;", "loadImageFromUrl", "url", "loadImageFromUrlAsync", "save", "format", "Lcom/github/triniwiz/canvas/TNSImageAssetFormat;", "saveAsync", "scale", "x", "y", "ByteArrayOutputStream2", "Callback", "Companion", "canvas_release"})
public final class TNSImageAsset {
    private long nativeImageAsset = com.github.triniwiz.canvas.TNSImageAsset$Companion.access$nativeInit(Companion);
    private boolean hasResourceError;
    private String resourceError;
    private static final ExecutorService executorService;
    @NotNull
    public static final Companion Companion;

    public final long getNativeImageAsset$canvas_release() {
        return this.nativeImageAsset;
    }

    public final void setNativeImageAsset$canvas_release(long l) {
        this.nativeImageAsset = l;
    }

    public final int getWidth() {
        return this.nativeImageAsset == 0L ? 0 : TNSImageAsset.Companion.nativeGetWidth(this.nativeImageAsset);
    }

    public final int getHeight() {
        return this.nativeImageAsset == 0L ? 0 : TNSImageAsset.Companion.nativeGetHeight(this.nativeImageAsset);
    }

    @NotNull
    public final byte[] getBytes() {
        return TNSImageAsset.Companion.nativeGetBytes(this.nativeImageAsset);
    }

    @Nullable
    public final String getError() {
        if (this.nativeImageAsset == 0L) {
            return null;
        }
        if (this.hasResourceError) {
            return this.resourceError;
        }
        return !TNSImageAsset.Companion.nativeHasError(this.nativeImageAsset) ? null : TNSImageAsset.Companion.nativeGetError(this.nativeImageAsset);
    }

    public final void scale(int x, int y) {
        if (this.nativeImageAsset == 0L) {
            return;
        }
        TNSImageAsset.Companion.nativeScale(this.nativeImageAsset, x, y);
    }

    public final void flipX() {
        if (this.nativeImageAsset == 0L) {
            return;
        }
        TNSImageAsset.Companion.nativeFlipX(this.nativeImageAsset);
    }

    public final void flipY() {
        if (this.nativeImageAsset == 0L) {
            return;
        }
        TNSImageAsset.Companion.nativeFlipY(this.nativeImageAsset);
    }

    public final boolean save(@NotNull String path, @NotNull TNSImageAssetFormat format) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        return this.nativeImageAsset == 0L ? false : TNSImageAsset.Companion.nativeSave(this.nativeImageAsset, path, format.getFormat());
    }

    public final void saveAsync(@NotNull String path, @NotNull TNSImageAssetFormat format, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        executorService.submit(new Runnable(this, path, format, callback){
            final /* synthetic */ TNSImageAsset this$0;
            final /* synthetic */ String $path;
            final /* synthetic */ TNSImageAssetFormat $format;
            final /* synthetic */ Callback $callback;

            public final void run() {
                if (this.this$0.save(this.$path, this.$format)) {
                    this.$callback.onSuccess(true);
                } else {
                    this.$callback.onError(this.this$0.getError());
                }
            }
            {
                this.this$0 = tNSImageAsset;
                this.$path = string;
                this.$format = tNSImageAssetFormat;
                this.$callback = callback;
            }
        });
    }

    public final boolean loadImageFromResource(int id, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            BitmapDrawable bitmapDrawable;
            Drawable drawable = Build.VERSION.SDK_INT >= 21 ? context.getResources().getDrawable(id, null) : context.getResources().getDrawable(id);
            TNSImageAsset tNSImageAsset = this;
            Drawable drawable2 = drawable;
            if (!(drawable2 instanceof BitmapDrawable)) {
                drawable2 = null;
            }
            if ((bitmapDrawable = (BitmapDrawable)drawable2) == null || (bitmapDrawable = bitmapDrawable.getBitmap()) == null) {
                TNSImageAsset tNSImageAsset2 = this;
                boolean bl = false;
                boolean bl2 = false;
                TNSImageAsset tNSImageAsset3 = tNSImageAsset2;
                TNSImageAsset tNSImageAsset4 = tNSImageAsset;
                boolean bl3 = false;
                Drawable drawable3 = drawable;
                Intrinsics.checkNotNullExpressionValue((Object)drawable3, (String)"drawable");
                Bitmap bitmap = Bitmap.createBitmap((int)drawable3.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                drawable.draw(canvas);
                Bitmap bitmap2 = bitmap;
                tNSImageAsset = tNSImageAsset4;
                bitmapDrawable = bitmap2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)bitmapDrawable, (String)"(drawable as? BitmapDraw\u2026canvas)\n\t\t\t\t\tbitmap\n\t\t\t\t}");
            return tNSImageAsset.loadImageFromImage((Bitmap)bitmapDrawable);
        }
        catch (Exception e) {
            this.hasResourceError = true;
            this.resourceError = e.toString();
            return !this.hasResourceError;
        }
    }

    public final boolean loadImageFromPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.nativeImageAsset == 0L ? false : TNSImageAsset.Companion.nativeLoadAssetPath(this.nativeImageAsset, path);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean loadImageFromUrl(@NotNull String url) {
        void result;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.resourceError = null;
        CountDownLatch lock = new CountDownLatch(1);
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        executorService.execute(new Runnable(this, url, (Ref.BooleanRef)result, lock){
            final /* synthetic */ TNSImageAsset this$0;
            final /* synthetic */ String $url;
            final /* synthetic */ Ref.BooleanRef $result;
            final /* synthetic */ CountDownLatch $lock;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                try {
                    URL urlSrc = new URL(this.$url);
                    ByteArrayOutputStream2 bs = new ByteArrayOutputStream2();
                    Closeable closeable = urlSrc.openStream();
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        long l;
                        InputStream input = (InputStream)closeable;
                        boolean bl3 = false;
                        Closeable closeable2 = bs;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Throwable throwable2 = null;
                        try {
                            ByteArrayOutputStream2 output = (ByteArrayOutputStream2)closeable2;
                            boolean bl6 = false;
                            InputStream inputStream = input;
                            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"input");
                            l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)output, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                        long l2 = l;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    this.$result.element = this.this$0.loadImageFromBytes(bs.buf());
                }
                catch (Exception e) {
                    TNSImageAsset.access$setResourceError$p(this.this$0, e.getMessage());
                    this.$result.element = false;
                }
                this.$lock.countDown();
            }
            {
                this.this$0 = tNSImageAsset;
                this.$url = string;
                this.$result = booleanRef;
                this.$lock = countDownLatch;
            }
        });
        try {
            lock.await();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result.element;
    }

    public final void loadImageFromUrlAsync(@NotNull String url, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.resourceError = null;
        executorService.execute(new Runnable(this, url, callback){
            final /* synthetic */ TNSImageAsset this$0;
            final /* synthetic */ String $url;
            final /* synthetic */ Callback $callback;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                try {
                    URL urlSrc = new URL(this.$url);
                    ByteArrayOutputStream2 bs = new ByteArrayOutputStream2();
                    Closeable closeable = urlSrc.openStream();
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        long l;
                        InputStream input = (InputStream)closeable;
                        boolean bl3 = false;
                        Closeable closeable2 = bs;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Throwable throwable2 = null;
                        try {
                            ByteArrayOutputStream2 output = (ByteArrayOutputStream2)closeable2;
                            boolean bl6 = false;
                            InputStream inputStream = input;
                            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"input");
                            l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)output, (int)0, (int)2, null);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                        long l2 = l;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    boolean loaded = this.this$0.loadImageFromBytes(bs.buf());
                    if (loaded) {
                        this.$callback.onSuccess(true);
                    } else {
                        this.$callback.onError(this.this$0.getError());
                    }
                }
                catch (Exception e) {
                    TNSImageAsset.access$setResourceError$p(this.this$0, e.getMessage());
                    this.$callback.onError(this.this$0.getError());
                }
            }
            {
                this.this$0 = tNSImageAsset;
                this.$url = string;
                this.$callback = callback;
            }
        });
    }

    public final void loadImageFromPathAsync(@NotNull String path, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        executorService.submit(new Runnable(this, path, callback){
            final /* synthetic */ TNSImageAsset this$0;
            final /* synthetic */ String $path;
            final /* synthetic */ Callback $callback;

            public final void run() {
                if (com.github.triniwiz.canvas.TNSImageAsset$Companion.access$nativeLoadAssetPath(TNSImageAsset.Companion, this.this$0.getNativeImageAsset$canvas_release(), this.$path)) {
                    this.$callback.onSuccess(true);
                } else {
                    this.$callback.onError(this.this$0.getError());
                }
            }
            {
                this.this$0 = tNSImageAsset;
                this.$path = string;
                this.$callback = callback;
            }
        });
    }

    public final boolean loadImageFromBytes(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.nativeImageAsset == 0L ? false : TNSImageAsset.Companion.nativeLoadAssetBytes(this.nativeImageAsset, buffer);
    }

    public final void loadImageFromBytesAsync(@NotNull byte[] buffer, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        executorService.submit(new Runnable(this, buffer, callback){
            final /* synthetic */ TNSImageAsset this$0;
            final /* synthetic */ byte[] $buffer;
            final /* synthetic */ Callback $callback;

            public final void run() {
                if (com.github.triniwiz.canvas.TNSImageAsset$Companion.access$nativeLoadAssetBytes(TNSImageAsset.Companion, this.this$0.getNativeImageAsset$canvas_release(), this.$buffer)) {
                    this.$callback.onSuccess(true);
                } else {
                    this.$callback.onError(this.this$0.getError());
                }
            }
            {
                this.this$0 = tNSImageAsset;
                this.$buffer = byArray;
                this.$callback = callback;
            }
        });
    }

    public final boolean loadImageFromImage(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        if (this.nativeImageAsset == 0L) {
            return false;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
        byte[] byArray = os.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"os.toByteArray()");
        return this.loadImageFromBytes(byArray);
    }

    public final void loadImageFromImageAsync(@NotNull Bitmap bitmap, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        executorService.submit(new Runnable(this, bitmap, callback){
            final /* synthetic */ TNSImageAsset this$0;
            final /* synthetic */ Bitmap $bitmap;
            final /* synthetic */ Callback $callback;

            public final void run() {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.$bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
                byte[] byArray = os.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"os.toByteArray()");
                if (this.this$0.loadImageFromBytes(byArray)) {
                    this.$callback.onSuccess(true);
                } else {
                    this.$callback.onError(this.this$0.getError());
                }
            }
            {
                this.this$0 = tNSImageAsset;
                this.$bitmap = bitmap;
                this.$callback = callback;
            }
        });
    }

    protected final void finalize() throws Throwable {
        TNSImageAsset.Companion.nativeDestroy(this.nativeImageAsset);
        this.nativeImageAsset = 0L;
    }

    static {
        Companion = new Companion(null);
        executorService = Executors.newCachedThreadPool();
    }

    public static final /* synthetic */ String access$getResourceError$p(TNSImageAsset $this) {
        return $this.resourceError;
    }

    public static final /* synthetic */ void access$setResourceError$p(TNSImageAsset $this, String string) {
        $this.resourceError = string;
    }

    @JvmStatic
    private static final native long nativeInit();

    @JvmStatic
    private static final native int nativeGetWidth(long var0);

    @JvmStatic
    private static final native int nativeGetHeight(long var0);

    @JvmStatic
    private static final native boolean nativeFlipX(long var0);

    @JvmStatic
    private static final native boolean nativeFlipY(long var0);

    @JvmStatic
    private static final native byte[] nativeGetBytes(long var0);

    @JvmStatic
    private static final native boolean nativeScale(long var0, int var2, int var3);

    @JvmStatic
    private static final native String nativeGetError(long var0);

    @JvmStatic
    private static final native boolean nativeHasError(long var0);

    @JvmStatic
    private static final native boolean nativeSave(long var0, String var2, int var3);

    @JvmStatic
    private static final native boolean nativeLoadAssetPath(long var0, String var2);

    @JvmStatic
    private static final native boolean nativeLoadAssetBytes(long var0, byte[] var2);

    @JvmStatic
    private static final native void nativeDestroy(long var0);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\u0012\u0010\u0006\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H&\u00a8\u0006\b"}, d2={"Lcom/github/triniwiz/canvas/TNSImageAsset$Callback;", "", "onError", "", "error", "", "onSuccess", "value", "canvas_release"})
    public static interface Callback {
        public void onSuccess(@Nullable Object var1);

        public void onError(@Nullable String var1);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/github/triniwiz/canvas/TNSImageAsset$ByteArrayOutputStream2;", "Ljava/io/ByteArrayOutputStream;", "()V", "size", "", "(I)V", "buf", "", "canvas_release"})
    public static final class ByteArrayOutputStream2
    extends ByteArrayOutputStream {
        @NotNull
        public final synchronized byte[] buf() {
            Intrinsics.checkNotNullExpressionValue((Object)this.buf, (String)"buf");
            return this.buf;
        }

        public ByteArrayOutputStream2() {
        }

        public ByteArrayOutputStream2(int size) {
            super(size);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0083 J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0083 J\u0011\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0083 J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0083 J\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0083 J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0083 J\u0011\u0010\u0013\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0083 J\u0011\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0083 J\t\u0010\u0015\u001a\u00020\tH\u0083 J\u0019\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u000eH\u0083 J\u0019\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0010H\u0083 J!\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0012H\u0083 J!\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0012H\u0083 R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/github/triniwiz/canvas/TNSImageAsset$Companion;", "", "()V", "executorService", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "nativeDestroy", "", "asset", "", "nativeFlipX", "", "nativeFlipY", "nativeGetBytes", "", "nativeGetError", "", "nativeGetHeight", "", "nativeGetWidth", "nativeHasError", "nativeInit", "nativeLoadAssetBytes", "buffer", "nativeLoadAssetPath", "path", "nativeSave", "format", "nativeScale", "x", "y", "canvas_release"})
    public static final class Companion {
        @JvmStatic
        private final long nativeInit() {
            return TNSImageAsset.nativeInit();
        }

        @JvmStatic
        private final int nativeGetWidth(long l) {
            return TNSImageAsset.nativeGetWidth(l);
        }

        @JvmStatic
        private final int nativeGetHeight(long l) {
            return TNSImageAsset.nativeGetHeight(l);
        }

        @JvmStatic
        private final boolean nativeFlipX(long l) {
            return TNSImageAsset.nativeFlipX(l);
        }

        @JvmStatic
        private final boolean nativeFlipY(long l) {
            return TNSImageAsset.nativeFlipY(l);
        }

        @JvmStatic
        private final byte[] nativeGetBytes(long l) {
            return TNSImageAsset.nativeGetBytes(l);
        }

        @JvmStatic
        private final boolean nativeScale(long l, int n, int n2) {
            return TNSImageAsset.nativeScale(l, n, n2);
        }

        @JvmStatic
        private final String nativeGetError(long l) {
            return TNSImageAsset.nativeGetError(l);
        }

        @JvmStatic
        private final boolean nativeHasError(long l) {
            return TNSImageAsset.nativeHasError(l);
        }

        @JvmStatic
        private final boolean nativeSave(long l, String string, int n) {
            return TNSImageAsset.nativeSave(l, string, n);
        }

        @JvmStatic
        private final boolean nativeLoadAssetPath(long l, String string) {
            return TNSImageAsset.nativeLoadAssetPath(l, string);
        }

        @JvmStatic
        private final boolean nativeLoadAssetBytes(long l, byte[] byArray) {
            return TNSImageAsset.nativeLoadAssetBytes(l, byArray);
        }

        @JvmStatic
        private final void nativeDestroy(long l) {
            TNSImageAsset.nativeDestroy(l);
        }

        private Companion() {
        }

        public static final /* synthetic */ long access$nativeInit(Companion $this) {
            return $this.nativeInit();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

