/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.TextureView;
import com.github.triniwiz.canvas.GLContext;
import com.github.triniwiz.canvas.TNSCanvas;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\"J \u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\nH\u0016J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&H\u0016J \u0010*\u001a\u00020\"2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\nH\u0016J\u0010\u0010+\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010,\u001a\u00020\"2\b\u0010-\u001a\u0004\u0018\u00010.J\u0016\u0010/\u001a\u00020\"2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\nJ\u0010\u00100\u001a\u00020\"2\b\u00101\u001a\u0004\u0018\u00010\u0015J\u0006\u00102\u001a\u00020\"R\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00063"}, d2={"Lcom/github/triniwiz/canvas/GLView;", "Landroid/view/TextureView;", "Landroid/view/TextureView$SurfaceTextureListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "drawingBufferHeight", "", "drawingBufferWidth", "<set-?>", "Lcom/github/triniwiz/canvas/GLContext;", "gLContext", "getGLContext", "()Lcom/github/triniwiz/canvas/GLContext;", "isCreated", "", "isCreatedWithZeroSized", "mListener", "Lcom/github/triniwiz/canvas/TNSCanvas$Listener;", "starting", "getStarting", "()Z", "setStarting", "(Z)V", "startupLock", "Ljava/util/concurrent/CountDownLatch;", "getStartupLock", "()Ljava/util/concurrent/CountDownLatch;", "setStartupLock", "(Ljava/util/concurrent/CountDownLatch;)V", "flush", "", "init", "onSurfaceTextureAvailable", "surface", "Landroid/graphics/SurfaceTexture;", "width", "height", "onSurfaceTextureDestroyed", "onSurfaceTextureSizeChanged", "onSurfaceTextureUpdated", "queueEvent", "runnable", "Ljava/lang/Runnable;", "resize", "setListener", "listener", "setupContext", "canvas_release"})
public final class GLView
extends TextureView
implements TextureView.SurfaceTextureListener {
    private boolean isCreated;
    private boolean isCreatedWithZeroSized;
    @Nullable
    private GLContext gLContext;
    private TNSCanvas.Listener mListener;
    @JvmField
    public int drawingBufferWidth;
    @JvmField
    public int drawingBufferHeight;
    private boolean starting;
    @Nullable
    private CountDownLatch startupLock;

    @Nullable
    public final GLContext getGLContext() {
        return this.gLContext;
    }

    public final void resize(int width, int height) {
        this.drawingBufferWidth = width;
        this.drawingBufferHeight = height;
        GLContext gLContext = this.gLContext;
        Intrinsics.checkNotNull((Object)gLContext);
        gLContext.resize(width, height);
    }

    public final void init() {
        this.setOpaque(false);
        this.setSurfaceTextureListener(this);
        this.gLContext = new GLContext();
        Intrinsics.checkNotNull((Object)this.gLContext);
        this.gLContext.glView = new WeakReference<GLView>(this);
    }

    public final boolean getStarting() {
        return this.starting;
    }

    public final void setStarting(boolean bl) {
        this.starting = bl;
    }

    @Nullable
    public final CountDownLatch getStartupLock() {
        return this.startupLock;
    }

    public final void setStartupLock(@Nullable CountDownLatch countDownLatch) {
        this.startupLock = countDownLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setupContext() {
        GLContext gLContext = this.gLContext;
        Intrinsics.checkNotNull((Object)gLContext);
        if (gLContext.mGLThread != null) {
            GLContext gLContext2 = this.gLContext;
            Intrinsics.checkNotNull((Object)gLContext2);
            GLContext.GLThread gLThread = gLContext2.mGLThread;
            Intrinsics.checkNotNull((Object)gLThread);
            if (gLThread.isStarted) {
                return;
            }
        }
        GLContext gLContext3 = this.gLContext;
        Intrinsics.checkNotNull((Object)gLContext3);
        if (gLContext3.mGLThread == null) {
            GLContext gLContext4 = this.gLContext;
            Intrinsics.checkNotNull((Object)gLContext4);
            gLContext4.init(null);
        }
        if (!this.starting) {
            this.starting = true;
            this.startupLock = new CountDownLatch(1);
            GLContext gLContext5 = this.gLContext;
            Intrinsics.checkNotNull((Object)gLContext5);
            gLContext5.startGLThread();
            try {
                CountDownLatch countDownLatch = this.startupLock;
                Intrinsics.checkNotNull((Object)countDownLatch);
                countDownLatch.await(1500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.starting = false;
                this.startupLock = null;
            }
        }
    }

    public final void flush() {
        GLContext gLContext = this.gLContext;
        Intrinsics.checkNotNull((Object)gLContext);
        gLContext.flush();
    }

    public final void queueEvent(@Nullable Runnable runnable) {
        GLContext gLContext = this.gLContext;
        Intrinsics.checkNotNull((Object)gLContext);
        Runnable runnable2 = runnable;
        Intrinsics.checkNotNull((Object)runnable2);
        gLContext.queueEvent(runnable2);
    }

    public final void setListener(@Nullable TNSCanvas.Listener listener) {
        this.mListener = listener;
    }

    public void onSurfaceTextureAvailable(@NotNull SurfaceTexture surface, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        this.drawingBufferHeight = height;
        this.drawingBufferWidth = width;
        if (!this.isCreated) {
            if (width == 0 || height == 0) {
                this.isCreatedWithZeroSized = true;
            }
            if (!this.isCreatedWithZeroSized) {
                GLContext gLContext = this.gLContext;
                Intrinsics.checkNotNull((Object)gLContext);
                gLContext.init(surface);
                if (this.mListener != null) {
                    TNSCanvas.Listener listener = this.mListener;
                    Intrinsics.checkNotNull((Object)listener);
                    listener.contextReady();
                }
            }
            this.isCreated = true;
        }
    }

    public void onSurfaceTextureSizeChanged(@NotNull SurfaceTexture surface, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        this.drawingBufferHeight = height;
        this.drawingBufferWidth = width;
        if (!this.isCreatedWithZeroSized) {
            // empty if block
        }
        if (this.isCreatedWithZeroSized && (width != 0 || height != 0)) {
            GLContext gLContext = this.gLContext;
            Intrinsics.checkNotNull((Object)gLContext);
            gLContext.init(surface);
            this.isCreatedWithZeroSized = false;
            if (this.mListener != null) {
                TNSCanvas.Listener listener = this.mListener;
                Intrinsics.checkNotNull((Object)listener);
                listener.contextReady();
            }
        }
    }

    public boolean onSurfaceTextureDestroyed(@NotNull SurfaceTexture surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        this.isCreated = false;
        return true;
    }

    public void onSurfaceTextureUpdated(@NotNull SurfaceTexture surface) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
    }

    public GLView(@Nullable Context context) {
        Context context2 = context;
        Intrinsics.checkNotNull((Object)context2);
        super(context2);
        this.init();
    }

    public GLView(@Nullable Context context, @Nullable AttributeSet attrs) {
        Context context2 = context;
        Intrinsics.checkNotNull((Object)context2);
        super(context2, attrs);
        this.init();
    }
}

