/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.github.triniwiz.canvas.CanvasView;
import java.lang.ref.WeakReference;

public class CPUView
extends View {
    Bitmap view;
    WeakReference<CanvasView> canvasView;
    Handler handler;

    public CPUView(Context context) {
        super(context);
        this.init();
    }

    public CPUView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.handler = new Handler(Looper.getMainLooper());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != 0 && h != 0) {
            this.view = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            CanvasView canvas = (CanvasView)((Object)this.canvasView.get());
            if (canvas != null && canvas.canvas == 0L) {
                canvas.canvas = CanvasView.nativeInit(true, 0, w, h, 0.0f, CanvasView.getDirection());
                if (canvas.listener != null) {
                    canvas.listener.contextReady();
                }
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.view != null) {
            canvas.drawBitmap(this.view, 0.0f, 0.0f, null);
        }
    }

    public void flush() {
        final CanvasView canvas = (CanvasView)((Object)this.canvasView.get());
        if (this.view != null && canvas != null && canvas.canvas != 0L) {
            canvas.canvas = CanvasView.nativeCpuFlush(canvas.canvas, this.view);
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    CPUView.this.invalidate();
                    canvas.pendingInvalidate = false;
                }
            });
        }
    }
}

