/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.os.Build;
import androidx.annotation.Nullable;
import com.github.triniwiz.canvas.CanvasRenderingContext;
import com.github.triniwiz.canvas.CanvasView;
import com.github.triniwiz.canvas.FramebufferAttachmentParameter;
import com.github.triniwiz.canvas.ImageAsset;
import com.github.triniwiz.canvas.WebGLActiveInfo;
import com.github.triniwiz.canvas.WebGLShaderPrecisionFormat;
import com.github.triniwiz.canvas.extensions.ANGLE_instanced_arrays;
import com.github.triniwiz.canvas.extensions.EXT_blend_minmax;
import com.github.triniwiz.canvas.extensions.EXT_color_buffer_half_float;
import com.github.triniwiz.canvas.extensions.EXT_disjoint_timer_query;
import com.github.triniwiz.canvas.extensions.EXT_sRGB;
import com.github.triniwiz.canvas.extensions.EXT_shader_texture_lod;
import com.github.triniwiz.canvas.extensions.EXT_texture_filter_anisotropic;
import com.github.triniwiz.canvas.extensions.OES_element_index_uint;
import com.github.triniwiz.canvas.extensions.OES_standard_derivatives;
import com.github.triniwiz.canvas.extensions.OES_texture_float;
import com.github.triniwiz.canvas.extensions.OES_texture_float_linear;
import com.github.triniwiz.canvas.extensions.OES_texture_half_float;
import com.github.triniwiz.canvas.extensions.OES_texture_half_float_linear;
import com.github.triniwiz.canvas.extensions.OES_vertex_array_object;
import com.github.triniwiz.canvas.extensions.WEBGL_color_buffer_float;
import com.github.triniwiz.canvas.extensions.WEBGL_compressed_texture_atc;
import com.github.triniwiz.canvas.extensions.WEBGL_compressed_texture_etc;
import com.github.triniwiz.canvas.extensions.WEBGL_compressed_texture_etc1;
import com.github.triniwiz.canvas.extensions.WEBGL_compressed_texture_pvrtc;
import com.github.triniwiz.canvas.extensions.WEBGL_compressed_texture_s3tc;
import com.github.triniwiz.canvas.extensions.WEBGL_depth_texture;
import com.github.triniwiz.canvas.extensions.WEBGL_draw_buffers;
import com.github.triniwiz.canvas.extensions.WEBGL_lose_context;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class WebGLRenderingContext
implements CanvasRenderingContext {
    private CanvasView canvas;
    static final int SIZE_OF_BYTE = 1;
    static final int SIZE_OF_SHORT = 2;
    static final int SIZE_OF_INT = 4;
    static final int SIZE_OF_LONG = 8;
    static final int SIZE_OF_FLOAT = 4;
    static final int SIZE_OF_DOUBLE = 2;
    static final int SIZE_OF_CHAR = 2;
    private boolean alpha = true;
    private boolean antialias = true;
    private boolean depth = true;
    private boolean failIfMajorPerformanceCaveat = false;
    private String powerPreference = "default";
    private boolean premultipliedAlpha = true;
    private boolean preserveDrawingBuffer = false;
    private boolean stencil = false;
    private boolean desynchronized = false;
    boolean flipYWebGL = false;
    private boolean premultiplyAlphaWebGL = false;
    private int colorSpaceConversionWebGL = -1;
    public final int DEPTH_BUFFER_BIT = 256;
    public final int COLOR_BUFFER_BIT = 16384;
    public final int STENCIL_BUFFER_BIT = 1024;
    public final int POINTS = 0;
    public final int LINES = 1;
    public final int LINE_LOOP = 2;
    public final int LINE_STRIP = 3;
    public final int TRIANGLES = 4;
    public final int TRIANGLE_STRIP = 5;
    public final int TRIANGLE_FAN = 6;
    public final int ONE = 1;
    public final int ZERO = 0;
    public final int SRC_COLOR = 768;
    public final int ONE_MINUS_SRC_COLOR = 769;
    public final int SRC_ALPHA = 770;
    public final int ONE_MINUS_SRC_ALPHA = 771;
    public final int DST_ALPHA = 772;
    public final int ONE_MINUS_DST_ALPHA = 773;
    public final int DST_COLOR = 774;
    public final int ONE_MINUS_DST_COLOR = 775;
    public final int SRC_ALPHA_SATURATE = 776;
    public final int CONSTANT_COLOR = 32769;
    public final int ONE_MINUS_CONSTANT_COLOR = 32770;
    public final int CONSTANT_ALPHA = 32771;
    public final int ONE_MINUS_CONSTANT_ALPHA = 32772;
    public final int FUNC_ADD = 32774;
    public final int FUNC_SUBTRACT = 32778;
    public final int FUNC_REVERSE_SUBTRACT = 32779;
    public final int BLEND_EQUATION = 32777;
    public final int BLEND_EQUATION_RGB = 32777;
    public final int BLEND_EQUATION_ALPHA = 34877;
    public final int BLEND_DST_RGB = 32968;
    public final int BLEND_SRC_RGB = 32969;
    public final int BLEND_DST_ALPHA = 32970;
    public final int BLEND_SRC_ALPHA = 32971;
    public final int BLEND_COLOR = 32773;
    public final int ARRAY_BUFFER_BINDING = 34964;
    public final int ELEMENT_ARRAY_BUFFER_BINDING = 34965;
    public final int LINE_WIDTH = 2849;
    public final int ALIASED_POINT_SIZE_RANGE = 33901;
    public final int ALIASED_LINE_WIDTH_RANGE = 33902;
    public final int CULL_FACE_MODE = 2885;
    public final int FRONT_FACE = 2886;
    public final int DEPTH_RANGE = 2928;
    public final int DEPTH_WRITEMASK = 2930;
    public final int DEPTH_CLEAR_VALUE = 2931;
    public final int DEPTH_FUNC = 2932;
    public final int STENCIL_CLEAR_VALUE = 2961;
    public final int STENCIL_FUNC = 2962;
    public final int STENCIL_FAIL = 2964;
    public final int STENCIL_PASS_DEPTH_FAIL = 2965;
    public final int STENCIL_PASS_DEPTH_PASS = 2966;
    public final int STENCIL_REF = 2967;
    public final int STENCIL_VALUE_MASK = 2963;
    public final int STENCIL_WRITEMASK = 2968;
    public final int STENCIL_BACK_FUNC = 34816;
    public final int STENCIL_BACK_FAIL = 34817;
    public final int STENCIL_BACK_PASS_DEPTH_FAIL = 34818;
    public final int STENCIL_BACK_PASS_DEPTH_PASS = 34819;
    public final int STENCIL_BACK_REF = 36003;
    public final int STENCIL_BACK_VALUE_MASK = 36004;
    public final int STENCIL_BACK_WRITEMASK = 36005;
    public final int VIEWPORT = 2978;
    public final int SCISSOR_BOX = 3088;
    public final int COLOR_CLEAR_VALUE = 3106;
    public final int COLOR_WRITEMASK = 3107;
    public final int UNPACK_ALIGNMENT = 3317;
    public final int PACK_ALIGNMENT = 3333;
    public final int MAX_TEXTURE_SIZE = 3379;
    public final int MAX_VIEWPORT_DIMS = 3386;
    public final int SUBPIXEL_BITS = 3408;
    public final int RED_BITS = 3410;
    public final int GREEN_BITS = 3411;
    public final int BLUE_BITS = 3412;
    public final int ALPHA_BITS = 3413;
    public final int DEPTH_BITS = 3414;
    public final int STENCIL_BITS = 3415;
    public final int POLYGON_OFFSET_UNITS = 10752;
    public final int POLYGON_OFFSET_FACTOR = 32824;
    public final int TEXTURE_BINDING_2D = 32873;
    public final int SAMPLE_BUFFERS = 32936;
    public final int SAMPLES = 32937;
    public final int SAMPLE_COVERAGE_VALUE = 32938;
    public final int SAMPLE_COVERAGE_INVERT = 32939;
    public final int COMPRESSED_TEXTURE_FORMATS = 34467;
    public final int VENDOR = 7936;
    public final int RENDERER = 7937;
    public final int VERSION = 7938;
    public final int IMPLEMENTATION_COLOR_READ_TYPE = 35738;
    public final int IMPLEMENTATION_COLOR_READ_FORMAT = 35739;
    public final int BROWSER_DEFAULT_WEBGL = 37444;
    public final int STATIC_DRAW = 35044;
    public final int STREAM_DRAW = 35040;
    public final int DYNAMIC_DRAW = 35048;
    public final int ARRAY_BUFFER = 34962;
    public final int ELEMENT_ARRAY_BUFFER = 34963;
    public final int BUFFER_SIZE = 34660;
    public final int BUFFER_USAGE = 34661;
    public final int CURRENT_VERTEX_ATTRIB = 34342;
    public final int VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
    public final int VERTEX_ATTRIB_ARRAY_SIZE = 34339;
    public final int VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
    public final int VERTEX_ATTRIB_ARRAY_TYPE = 34341;
    public final int VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
    public final int VERTEX_ATTRIB_ARRAY_POINTER = 34373;
    public final int VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 34975;
    public final int CULL_FACE = 2884;
    public final int FRONT = 1028;
    public final int BACK = 1029;
    public final int FRONT_AND_BACK = 1032;
    public final int BLEND = 3042;
    public final int DEPTH_TEST = 2929;
    public final int DITHER = 3024;
    public final int POLYGON_OFFSET_FILL = 32823;
    public final int SAMPLE_ALPHA_TO_COVERAGE = 32926;
    public final int SAMPLE_COVERAGE = 32928;
    public final int SCISSOR_TEST = 3089;
    public final int STENCIL_TEST = 2960;
    public final int NO_ERROR = 0;
    public final int INVALID_ENUM = 1280;
    public final int INVALID_VALUE = 1281;
    public final int INVALID_OPERATION = 1282;
    public final int INVALID_FRAMEBUFFER_OPERATION = 1286;
    public final int OUT_OF_MEMORY = 1285;
    public final int CONTEXT_LOST_WEBGL = 37442;
    public final int CW = 2304;
    public final int CCW = 2305;
    public final int DONT_CARE = 4352;
    public final int FASTEST = 4353;
    public final int NICEST = 4354;
    public final int GENERATE_MIPMAP_HINT = 33170;
    public final int BYTE = 5120;
    public final int UNSIGNED_BYTE = 5121;
    public final int UNSIGNED_SHORT = 5123;
    public final int SHORT = 5122;
    public final int UNSIGNED_INT = 5125;
    public final int INT = 5124;
    public final int FLOAT = 5126;
    public final int DEPTH_COMPONENT = 6402;
    public final int ALPHA = 6406;
    public final int RGB = 6407;
    public final int RGBA = 6408;
    public final int LUMINANCE = 6409;
    public final int LUMINANCE_ALPHA = 6410;
    public final int UNSIGNED_SHORT_4_4_4_4 = 32819;
    public final int UNSIGNED_SHORT_5_5_5_1 = 32820;
    public final int UNSIGNED_SHORT_5_6_5 = 33635;
    public final int FRAGMENT_SHADER = 35632;
    public final int VERTEX_SHADER = 35633;
    public final int COMPILE_STATUS = 35713;
    public final int DELETE_STATUS = 35712;
    public final int LINK_STATUS = 35714;
    public final int VALIDATE_STATUS = 35715;
    public final int ATTACHED_SHADERS = 35717;
    public final int ACTIVE_ATTRIBUTES = 35721;
    public final int ACTIVE_UNIFORMS = 35718;
    public final int MAX_VERTEX_UNIFORM_VECTORS = 36347;
    public final int MAX_VARYING_VECTORS = 36348;
    public final int MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
    public final int MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
    public final int MAX_TEXTURE_IMAGE_UNITS = 34930;
    public final int MAX_VERTEX_ATTRIBS = 34921;
    public final int MAX_FRAGMENT_UNIFORM_VECTORS = 36349;
    public final int SHADER_TYPE = 35663;
    public final int SHADING_LANGUAGE_VERSION = 35724;
    public final int CURRENT_PROGRAM = 35725;
    public final int NEVER = 512;
    public final int LESS = 513;
    public final int EQUAL = 514;
    public final int LEQUAL = 515;
    public final int GREATER = 516;
    public final int NOTEQUAL = 517;
    public final int GEQUAL = 518;
    public final int ALWAYS = 519;
    public final int KEEP = 7680;
    public final int REPLACE = 7681;
    public final int INCR = 7682;
    public final int DECR = 7683;
    public final int INVERT = 5386;
    public final int INCR_WRAP = 34055;
    public final int DECR_WRAP = 34056;
    public final int NEAREST = 9728;
    public final int LINEAR = 9729;
    public final int NEAREST_MIPMAP_NEAREST = 9984;
    public final int LINEAR_MIPMAP_NEAREST = 9985;
    public final int NEAREST_MIPMAP_LINEAR = 9986;
    public final int LINEAR_MIPMAP_LINEAR = 9987;
    public final int TEXTURE_MAG_FILTER = 10240;
    public final int TEXTURE_MIN_FILTER = 10241;
    public final int TEXTURE_WRAP_S = 10242;
    public final int TEXTURE_WRAP_T = 10243;
    public final int TEXTURE_2D = 3553;
    public final int TEXTURE = 5890;
    public final int TEXTURE_CUBE_MAP = 34067;
    public final int TEXTURE_BINDING_CUBE_MAP = 34068;
    public final int TEXTURE_CUBE_MAP_POSITIVE_X = 34069;
    public final int TEXTURE_CUBE_MAP_NEGATIVE_X = 34070;
    public final int TEXTURE_CUBE_MAP_POSITIVE_Y = 34071;
    public final int TEXTURE_CUBE_MAP_NEGATIVE_Y = 34072;
    public final int TEXTURE_CUBE_MAP_POSITIVE_Z = 34073;
    public final int TEXTURE_CUBE_MAP_NEGATIVE_Z = 34074;
    public final int MAX_CUBE_MAP_TEXTURE_SIZE = 34076;
    public final int TEXTURE0 = 33984;
    public final int TEXTURE1 = 33985;
    public final int TEXTURE2 = 33986;
    public final int TEXTURE3 = 33987;
    public final int TEXTURE4 = 33988;
    public final int TEXTURE5 = 33989;
    public final int TEXTURE6 = 33990;
    public final int TEXTURE7 = 33991;
    public final int TEXTURE8 = 33992;
    public final int TEXTURE9 = 33993;
    public final int TEXTURE10 = 33994;
    public final int TEXTURE11 = 33995;
    public final int TEXTURE12 = 33996;
    public final int TEXTURE13 = 33997;
    public final int TEXTURE14 = 33998;
    public final int TEXTURE15 = 33999;
    public final int TEXTURE16 = 34000;
    public final int TEXTURE17 = 34001;
    public final int TEXTURE18 = 34002;
    public final int TEXTURE19 = 34003;
    public final int TEXTURE20 = 34004;
    public final int TEXTURE21 = 34005;
    public final int TEXTURE22 = 34006;
    public final int TEXTURE23 = 34007;
    public final int TEXTURE24 = 34008;
    public final int TEXTURE25 = 34009;
    public final int TEXTURE26 = 34010;
    public final int TEXTURE27 = 34011;
    public final int TEXTURE28 = 34012;
    public final int TEXTURE29 = 34013;
    public final int TEXTURE30 = 34014;
    public final int TEXTURE31 = 34015;
    public final int ACTIVE_TEXTURE = 34016;
    public final int REPEAT = 10497;
    public final int CLAMP_TO_EDGE = 33071;
    public final int MIRRORED_REPEAT = 33648;
    public final int FLOAT_VEC2 = 35664;
    public final int FLOAT_VEC3 = 35665;
    public final int FLOAT_VEC4 = 35666;
    public final int INT_VEC2 = 35667;
    public final int INT_VEC3 = 35668;
    public final int INT_VEC4 = 35669;
    public final int BOOL = 35670;
    public final int BOOL_VEC2 = 35671;
    public final int BOOL_VEC3 = 35672;
    public final int BOOL_VEC4 = 35673;
    public final int FLOAT_MAT2 = 35674;
    public final int FLOAT_MAT3 = 35675;
    public final int FLOAT_MAT4 = 35676;
    public final int SAMPLER_2D = 35678;
    public final int SAMPLER_CUBE = 35680;
    public final int LOW_FLOAT = 36336;
    public final int MEDIUM_FLOAT = 36337;
    public final int HIGH_FLOAT = 36338;
    public final int LOW_INT = 36339;
    public final int MEDIUM_INT = 36340;
    public final int HIGH_INT = 36341;
    public final int FRAMEBUFFER = 36160;
    public final int RENDERBUFFER = 36161;
    public final int RGBA4 = 32854;
    public final int RGB565 = 36194;
    public final int RGB5_A1 = 32855;
    public final int DEPTH_COMPONENT16 = 33189;
    public final int STENCIL_INDEX8 = 36168;
    public final int DEPTH_STENCIL = 34041;
    public final int RENDERBUFFER_WIDTH = 36162;
    public final int RENDERBUFFER_HEIGHT = 36163;
    public final int RENDERBUFFER_INTERNAL_FORMAT = 36164;
    public final int RENDERBUFFER_RED_SIZE = 36176;
    public final int RENDERBUFFER_GREEN_SIZE = 36177;
    public final int RENDERBUFFER_BLUE_SIZE = 36178;
    public final int RENDERBUFFER_ALPHA_SIZE = 36179;
    public final int RENDERBUFFER_DEPTH_SIZE = 36180;
    public final int RENDERBUFFER_STENCIL_SIZE = 36181;
    public final int FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 36048;
    public final int FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 36049;
    public final int FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 36050;
    public final int FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 36051;
    public final int COLOR_ATTACHMENT0 = 36064;
    public final int DEPTH_ATTACHMENT = 36096;
    public final int STENCIL_ATTACHMENT = 36128;
    public final int DEPTH_STENCIL_ATTACHMENT = 33306;
    public final int NONE = 0;
    public final int FRAMEBUFFER_COMPLETE = 36053;
    public final int FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
    public final int FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
    public final int FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;
    public final int FRAMEBUFFER_UNSUPPORTED = 36061;
    public final int FRAMEBUFFER_BINDING = 36006;
    public final int RENDERBUFFER_BINDING = 36007;
    public final int MAX_RENDERBUFFER_SIZE = 34024;
    public final int UNPACK_COLORSPACE_CONVERSION_WEBGL = 37443;
    public final int UNPACK_FLIP_Y_WEBGL = 37440;
    public final int UNPACK_PREMULTIPLY_ALPHA_WEBGL = 37441;

    native byte[] nativeBytesFromBitmap(Bitmap var1, boolean var2);

    native void nativeFlipInPlace(byte[] var1, int var2, int var3);

    native void nativeGetVertexAttribOffset(int var1, int var2, LongBuffer var3);

    native void nativeBindBuffer(int var1, int var2);

    public WebGLRenderingContext(CanvasView canvas) {
        this.canvas = canvas;
        this.depthMask(true);
    }

    public WebGLRenderingContext(CanvasView canvas, Map<String, Object> attrs) {
        this.canvas = canvas;
        this.depthMask(true);
    }

    public CanvasView getCanvas() {
        return this.canvas;
    }

    public int getDrawingBufferWidth() {
        return this.canvas.getWidth();
    }

    public int getDrawingBufferHeight() {
        return this.canvas.getHeight();
    }

    void runOnGLThread(Runnable runnable) {
        this.canvas.queueEvent(runnable);
    }

    byte[] bytesFromBitmap(Bitmap bitmap, boolean flipY) {
        return this.nativeBytesFromBitmap(bitmap, flipY);
    }

    void flipInPlace(byte[] storage, int width, int height) {
        this.nativeFlipInPlace(storage, width, height);
    }

    public void activeTexture(final int texture) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glActiveTexture((int)texture);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void attachShader(final int program, final int shader) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glAttachShader((int)program, (int)shader);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bindAttribLocation(final int program, final int index, final String name) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glBindAttribLocation((int)program, (int)index, (String)name);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bindBuffer(final int target, final int buffer) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                WebGLRenderingContext.this.nativeBindBuffer(target, buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bindBuffer(final int target, @Nullable Object buffer) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                WebGLRenderingContext.this.nativeBindBuffer(target, 0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bindFramebuffer(final int target, final int framebuffer) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glBindFramebuffer((int)target, (int)framebuffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bindRenderbuffer(final int target, final int renderbuffer) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glBindRenderbuffer((int)target, (int)renderbuffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bindTexture(final int target, final int texture) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glBindTexture((int)target, (int)texture);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void blendColor(final float red, final float green, final float blue, final float alpha) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glBlendColor((float)red, (float)green, (float)blue, (float)alpha);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void blendEquation(final int mode) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glBlendEquation((int)mode);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void blendEquationSeparate(final int modeRGB, final int modeAlpha) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glBlendEquationSeparate((int)modeRGB, (int)modeAlpha);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void blendFunc(final int sfactor, final int dfactor) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glBlendFunc((int)sfactor, (int)dfactor);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void blendFuncSeparate(final int srcRGB, final int dstRGB, final int srcAlpha, final int dstAlpha) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glBlendFuncSeparate((int)srcRGB, (int)dstRGB, (int)srcAlpha, (int)dstAlpha);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bufferData(final int target, final int size, final int usage) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glBufferData((int)target, (int)size, null, (int)usage);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bufferData(final int target, byte[] srcData, final int usage) {
        final CountDownLatch lock = new CountDownLatch(1);
        final ByteBuffer buffer = ByteBuffer.wrap(srcData);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glBufferData((int)target, (int)(buffer.capacity() * 1), (Buffer)buffer, (int)usage);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bufferData(final int target, short[] srcData, final int usage) {
        final CountDownLatch lock = new CountDownLatch(1);
        final ShortBuffer buffer = ShortBuffer.wrap(srcData);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glBufferData((int)target, (int)(buffer.capacity() * 2), (Buffer)buffer, (int)usage);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bufferData(final int target, float[] srcData, final int usage) {
        final CountDownLatch lock = new CountDownLatch(1);
        final FloatBuffer buffer = FloatBuffer.wrap(srcData);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glBufferData((int)target, (int)(buffer.capacity() * 4), (Buffer)buffer, (int)usage);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bufferData(final int target, int[] srcData, final int usage) {
        final CountDownLatch lock = new CountDownLatch(1);
        final IntBuffer buffer = IntBuffer.wrap(srcData);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glBufferData((int)target, (int)(buffer.capacity() * 4), (Buffer)buffer, (int)usage);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bufferSubData(final int target, final int offset, byte[] srcData) {
        final CountDownLatch lock = new CountDownLatch(1);
        final ByteBuffer buffer = ByteBuffer.wrap(srcData);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                int os = 1 * offset;
                GLES20.glBufferSubData((int)target, (int)os, (int)(buffer.capacity() * 1), (Buffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bufferSubData(final int target, final int offset, short[] srcData) {
        final CountDownLatch lock = new CountDownLatch(1);
        final ShortBuffer buffer = ShortBuffer.wrap(srcData);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                int os = 2 * offset;
                GLES20.glBufferSubData((int)target, (int)os, (int)(buffer.capacity() * 2), (Buffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bufferSubData(final int target, final int offset, int[] srcData) {
        final CountDownLatch lock = new CountDownLatch(1);
        final IntBuffer buffer = IntBuffer.wrap(srcData);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                int os = 4 * offset;
                GLES20.glBufferSubData((int)target, (int)os, (int)(buffer.capacity() * 4), (Buffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void bufferSubData(final int target, final int offset, float[] srcData) {
        final CountDownLatch lock = new CountDownLatch(1);
        final FloatBuffer buffer = FloatBuffer.wrap(srcData);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                int os = 4 * offset;
                GLES20.glBufferSubData((int)target, (int)os, (int)(buffer.capacity() * 4), (Buffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int checkFramebufferStatus(final int target) {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] status = new int[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                status[0] = GLES20.glCheckFramebufferStatus((int)target);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return status[0];
    }

    public void clear(final int mask) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glClear((int)mask);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void clearColor(final float red, final float green, final float blue, final float alpha) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void clearDepth(final float depth) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glClearDepthf((float)depth);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void clearStencil(final float stencil) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glClearStencil((int)((int)stencil));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void colorMask(final boolean red, final boolean green, final boolean blue, final boolean alpha) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glColorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void commit() {
    }

    public void compileShader(final int shader) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glCompileShader((int)shader);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void compressedTexImage2D(final int target, final int level, final int internalformat, final int width, final int height, final int border, byte[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        final ByteBuffer buffer = ByteBuffer.wrap(pixels);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glCompressedTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)(buffer.capacity() * 1), (Buffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void compressedTexImage2D(final int target, final int level, final int internalformat, final int width, final int height, final int border, short[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        final ShortBuffer buffer = ShortBuffer.wrap(pixels);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glCompressedTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)(buffer.capacity() * 2), (Buffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void compressedTexImage2D(final int target, final int level, final int internalformat, final int width, final int height, final int border, int[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        final IntBuffer buffer = IntBuffer.wrap(pixels);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glCompressedTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)(buffer.capacity() * 4), (Buffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void compressedTexImage2D(final int target, final int level, final int internalformat, final int width, final int height, final int border, float[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        final FloatBuffer buffer = FloatBuffer.wrap(pixels);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glCompressedTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)(buffer.capacity() * 4), (Buffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void compressedTexSubImage2D(final int target, final int level, final int xoffset, final int yoffset, final int width, final int height, final int format, byte[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        final ByteBuffer buffer = ByteBuffer.wrap(pixels);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glCompressedTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)(buffer.capacity() * 1), (Buffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void compressedTexSubImage2D(final int target, final int level, final int xoffset, final int yoffset, final int width, final int height, final int format, short[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        final ShortBuffer buffer = ShortBuffer.wrap(pixels);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glCompressedTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)(buffer.capacity() * 2), (Buffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void compressedTexSubImage2D(final int target, final int level, final int xoffset, final int yoffset, final int width, final int height, final int format, int[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        final IntBuffer buffer = IntBuffer.wrap(pixels);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glCompressedTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)(buffer.capacity() * 4), (Buffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void compressedTexSubImage2D(final int target, final int level, final int xoffset, final int yoffset, final int width, final int height, final int format, float[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        final FloatBuffer buffer = FloatBuffer.wrap(pixels);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glCompressedTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)(buffer.capacity() * 4), (Buffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void copyTexImage2D(final int target, final int level, final int internalformat, final int x, final int y, final int width, final int height, final int border) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glCopyTexImage2D((int)target, (int)level, (int)internalformat, (int)x, (int)y, (int)width, (int)height, (int)border);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void copyTexSubImage2D(final int target, final int level, final int xoffset, final int yoffset, final int x, final int y, final int width, final int height) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glCopyTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int createBuffer() {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] bufferId = new int[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glGenBuffers((int)1, (int[])bufferId, (int)0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return bufferId[0];
    }

    public int createFramebuffer() {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] frameBufferId = new int[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glGenFramebuffers((int)1, (int[])frameBufferId, (int)0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return frameBufferId[0];
    }

    public int createProgram() {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] program = new int[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                program[0] = GLES20.glCreateProgram();
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return program[0];
    }

    public int createRenderbuffer() {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] renderBufferId = new int[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glGenRenderbuffers((int)1, (int[])renderBufferId, (int)0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return renderBufferId[0];
    }

    public int createShader(final int type) {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] shader = new int[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                shader[0] = GLES20.glCreateShader((int)type);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return shader[0];
    }

    public int createTexture() {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] textureId = new int[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glGenTextures((int)1, (int[])textureId, (int)0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return textureId[0];
    }

    public void cullFace(final int mode) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glCullFace((int)mode);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void deleteBuffer(final int buffer) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                int[] id = new int[]{buffer};
                GLES20.glDeleteBuffers((int)1, (int[])id, (int)0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void deleteFramebuffer(final int frameBuffer) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                int[] id = new int[]{frameBuffer};
                GLES20.glDeleteFramebuffers((int)1, (int[])id, (int)0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void deleteProgram(final int program) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glDeleteProgram((int)program);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void deleteRenderbuffer(final int renderbuffer) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                int[] id = new int[]{renderbuffer};
                GLES20.glDeleteRenderbuffers((int)1, (int[])id, (int)0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void deleteShader(final int shader) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glDeleteShader((int)shader);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void deleteTexture(final int texture) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                int[] id = new int[]{texture};
                GLES20.glDeleteTextures((int)1, (int[])id, (int)0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void depthFunc(final int func) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glDepthFunc((int)func);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void depthMask(final boolean flag) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glDepthMask((boolean)flag);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void depthRange(final float zNear, final float zFar) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glDepthRangef((float)zNear, (float)zFar);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void detachShader(final int program, final int shader) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glDetachShader((int)program, (int)shader);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void disable(final int cap) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glDisable((int)cap);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void disableVertexAttribArray(final int index) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glDisableVertexAttribArray((int)index);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void drawArrays(final int mode, final int first, final int count) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glDrawArrays((int)mode, (int)first, (int)count);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void drawElements(final int mode, final int count, final int type, final int offset) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glDrawElements((int)mode, (int)count, (int)type, (int)offset);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void enable(final int cap) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glEnable((int)cap);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void enableVertexAttribArray(final int index) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glEnableVertexAttribArray((int)index);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void finish() {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glFinish();
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void flush() {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glFlush();
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void framebufferRenderbuffer(final int target, final int attachment, final int renderbuffertarget, final int renderbuffer) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderbuffertarget, (int)renderbuffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void framebufferTexture2D(final int target, final int attachment, final int textarget, final int texture, final int level) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void frontFace(final int mode) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glFrontFace((int)mode);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void generateMipmap(final int target) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glGenerateMipmap((int)target);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public WebGLActiveInfo getActiveAttrib(final int program, final int index) {
        final CountDownLatch lock = new CountDownLatch(1);
        final WebGLActiveInfo info = new WebGLActiveInfo();
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                IntBuffer length = IntBuffer.allocate(1);
                GLES20.glGetProgramiv((int)program, (int)35722, (IntBuffer)length);
                byte[] name = new byte[length.get(0)];
                int[] size = new int[1];
                int[] type = new int[1];
                int[] nameLength = new int[1];
                GLES20.glGetActiveAttrib((int)program, (int)index, (int)length.get(0), (int[])nameLength, (int)0, (int[])size, (int)0, (int[])type, (int)0, (byte[])name, (int)0);
                name = Arrays.copyOfRange(name, 0, nameLength[0]);
                info.name = new String(name);
                info.size = size[0];
                info.type = type[0];
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return info;
    }

    public WebGLActiveInfo getActiveUniform(final int program, final int index) {
        final CountDownLatch lock = new CountDownLatch(1);
        final WebGLActiveInfo info = new WebGLActiveInfo();
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                int[] length = new int[1];
                int[] size = new int[1];
                int[] type = new int[1];
                GLES20.glGetProgramiv((int)program, (int)35719, (int[])length, (int)0);
                byte[] name = new byte[length[0]];
                int[] nameLength = new int[1];
                GLES20.glGetActiveUniform((int)program, (int)index, (int)length[0], (int[])nameLength, (int)0, (int[])size, (int)0, (int[])type, (int)0, (byte[])name, (int)0);
                name = Arrays.copyOfRange(name, 0, nameLength[0]);
                info.name = new String(name);
                info.size = size[0];
                info.type = type[0];
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return info;
    }

    public int[] getAttachedShaders(final int program) {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[][] shadersList = new int[1][];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                int[] count = new int[1];
                GLES20.glGetProgramiv((int)program, (int)35717, (int[])count, (int)0);
                int[] shaders = new int[count[0]];
                int[] written = new int[1];
                GLES20.glGetAttachedShaders((int)program, (int)count[0], (int[])written, (int)0, (int[])shaders, (int)0);
                shadersList[0] = shaders;
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return shadersList[0];
    }

    public int getAttribLocation(final int program, final String name) {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] location = new int[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                location[0] = GLES20.glGetAttribLocation((int)program, (String)name);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return location[0];
    }

    public int getBufferParameter(final int target, final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] parameter = new int[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                IntBuffer params = IntBuffer.allocate(1);
                GLES20.glGetBufferParameteriv((int)target, (int)pname, (IntBuffer)params);
                parameter[0] = params.get(0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return parameter[0];
    }

    public Map<String, Object> getContextAttributes() {
        HashMap<String, Object> attrib = new HashMap<String, Object>();
        attrib.put("alpha", this.alpha);
        attrib.put("antialias", this.antialias);
        attrib.put("depth", this.depth);
        attrib.put("failIfMajorPerformanceCaveat", this.failIfMajorPerformanceCaveat);
        attrib.put("powerPreference", this.powerPreference);
        attrib.put("premultipliedAlpha", this.premultipliedAlpha);
        attrib.put("preserveDrawingBuffer", this.preserveDrawingBuffer);
        attrib.put("stencil", this.stencil);
        attrib.put("desynchronized", this.desynchronized);
        return attrib;
    }

    public int getError() {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] error = new int[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                error[0] = GLES20.glGetError();
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return error[0];
    }

    public Object getExtension(final String name) {
        final CountDownLatch lock = new CountDownLatch(1);
        final Object[] value = new Object[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                String extensions = GLES20.glGetString((int)7939);
                if (name.equals("EXT_blend_minmax") && extensions.contains("GL_EXT_blend_minmax")) {
                    value[0] = new EXT_blend_minmax();
                } else if (name.equals("EXT_color_buffer_half_float") && extensions.contains("GL_EXT_color_buffer_half_float")) {
                    value[0] = new EXT_color_buffer_half_float();
                } else if (name.equals("EXT_disjoint_timer_query") && extensions.contains("GL_EXT_disjoint_timer_query")) {
                    value[0] = Build.VERSION.SDK_INT >= 18 ? new EXT_disjoint_timer_query(WebGLRenderingContext.this.canvas) : null;
                } else if (name.equals("EXT_sRGB") && extensions.contains("GL_EXT_sRGB")) {
                    value[0] = new EXT_sRGB();
                } else if (name.equals("EXT_shader_texture_lod")) {
                    if (extensions.contains("GL_EXT_shader_texture_lod")) {
                        value[0] = new EXT_shader_texture_lod();
                    }
                } else if (name.equals("EXT_texture_filter_anisotropic") && extensions.contains("GL_EXT_texture_filter_anisotropic")) {
                    value[0] = new EXT_texture_filter_anisotropic();
                } else if (name.equals("OES_element_index_uint") && extensions.contains("GL_OES_element_index_uint")) {
                    value[0] = new OES_element_index_uint();
                } else if (name.equals("OES_standard_derivatives") && extensions.contains("GL_OES_standard_derivatives")) {
                    value[0] = new OES_standard_derivatives();
                } else if (name.equals("OES_texture_float") && extensions.contains("GL_OES_texture_float")) {
                    value[0] = new OES_texture_float();
                } else if (name.equals("OES_texture_float_linear") && extensions.contains("GL_OES_texture_float_linear")) {
                    value[0] = new OES_texture_float_linear();
                } else if (name.equals("OES_texture_half_float") && extensions.contains("GL_OES_texture_half_float")) {
                    value[0] = new OES_texture_half_float();
                } else if (name.equals("OES_texture_half_float_linear") && extensions.contains("GL_OES_texture_half_float_linear")) {
                    value[0] = new OES_texture_half_float_linear();
                } else if (name.equals("OES_vertex_array_object") && extensions.contains("GL_OES_vertex_array_object")) {
                    value[0] = Build.VERSION.SDK_INT >= 18 ? new OES_vertex_array_object(WebGLRenderingContext.this.canvas) : null;
                } else if (name.equals("WEBGL_color_buffer_float") && extensions.contains("GL_OES_packed_depth_stencil")) {
                    value[0] = new WEBGL_color_buffer_float();
                } else if (name.equals("WEBGL_compressed_texture_atc") && extensions.contains("GL_AMD_compressed_ATC_texture")) {
                    value[0] = new WEBGL_compressed_texture_atc();
                } else if (name.equals("WEBGL_compressed_texture_etc1") && extensions.contains("GL_OES_compressed_ETC1_RGB8_texture")) {
                    value[0] = new WEBGL_compressed_texture_etc1();
                } else if (name.equals("WEBGL_compressed_texture_s3tc") && extensions.contains("GL_EXT_texture_compression_dxt1") && extensions.contains("GL_EXT_texture_compression_s3tc")) {
                    value[0] = new WEBGL_compressed_texture_s3tc();
                } else if (name.equals("WEBGL_compressed_texture_etc")) {
                    value[0] = ((WebGLRenderingContext)WebGLRenderingContext.this).canvas.glVersion > 2 ? new WEBGL_compressed_texture_etc() : null;
                } else if (name.equals("WEBGL_compressed_texture_pvrtc") && extensions.contains("GL_IMG_texture_compression_pvrtc")) {
                    value[0] = new WEBGL_compressed_texture_pvrtc();
                } else if (name.equals("WEBGL_lose_context")) {
                    value[0] = new WEBGL_lose_context(WebGLRenderingContext.this.canvas);
                } else if (name.equals("ANGLE_instanced_arrays")) {
                    if (((WebGLRenderingContext)WebGLRenderingContext.this).canvas.glVersion > 2) {
                        value[0] = Build.VERSION.SDK_INT >= 18 ? new ANGLE_instanced_arrays() : null;
                    }
                } else {
                    value[0] = name.equals("WEBGL_depth_texture") && extensions.contains("GL_OES_depth_texture") && extensions.contains("GL_OES_packed_depth_stencil") ? new WEBGL_depth_texture() : (name.equals("WEBGL_draw_buffers") && extensions.contains("GL_EXT_draw_buffers") ? (((WebGLRenderingContext)WebGLRenderingContext.this).canvas.glVersion > 2 && Build.VERSION.SDK_INT >= 18 ? new WEBGL_draw_buffers() : null) : null);
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public FramebufferAttachmentParameter getFramebufferAttachmentParameter(final int target, final int attachment, final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final FramebufferAttachmentParameter result = new FramebufferAttachmentParameter();
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                IntBuffer params = IntBuffer.allocate(1);
                GLES20.glGetFramebufferAttachmentParameteriv((int)target, (int)attachment, (int)pname, (IntBuffer)params);
                if (attachment == 36049) {
                    IntBuffer name = IntBuffer.allocate(1);
                    GLES20.glGetFramebufferAttachmentParameteriv((int)target, (int)attachment, (int)36048, (IntBuffer)name);
                    switch (name.get(0)) {
                        case 36161: {
                            result.isRenderbuffer = true;
                            result.value = params.get(0);
                            break;
                        }
                        case 5890: {
                            result.isTexture = true;
                            result.value = params.get(0);
                            break;
                        }
                        default: {
                            result.value = params.get(0);
                            break;
                        }
                    }
                } else {
                    result.value = params.get(0);
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    private boolean boolConverter(int value) {
        return value == 1;
    }

    public synchronized Object getParameter(final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final Object[] parameter = new Object[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                switch (pname) {
                    case 2885: 
                    case 2886: 
                    case 2932: 
                    case 2961: 
                    case 2962: 
                    case 2963: 
                    case 2964: 
                    case 2965: 
                    case 2966: 
                    case 2967: 
                    case 2968: 
                    case 3317: 
                    case 3333: 
                    case 3379: 
                    case 3408: 
                    case 3410: 
                    case 3411: 
                    case 3412: 
                    case 3413: 
                    case 3414: 
                    case 3415: 
                    case 32777: 
                    case 32873: 
                    case 32936: 
                    case 32937: 
                    case 32968: 
                    case 32969: 
                    case 32970: 
                    case 32971: 
                    case 33170: 
                    case 34016: 
                    case 34024: 
                    case 34068: 
                    case 34076: 
                    case 34816: 
                    case 34817: 
                    case 34818: 
                    case 34819: 
                    case 34877: 
                    case 34921: 
                    case 34930: 
                    case 34964: 
                    case 34965: 
                    case 35660: 
                    case 35661: 
                    case 35725: 
                    case 35738: 
                    case 35739: 
                    case 36003: 
                    case 36004: 
                    case 36005: 
                    case 36006: 
                    case 36007: 
                    case 36347: 
                    case 36348: 
                    case 36349: {
                        IntBuffer param = IntBuffer.allocate(1);
                        GLES20.glGetIntegerv((int)pname, (IntBuffer)param);
                        if ((pname == 32873 || pname == 34068 || pname == 36007 || pname == 36006) && param.get(0) == 0) {
                            parameter[0] = null;
                            break;
                        }
                        parameter[0] = param.get(0);
                        break;
                    }
                    case 37443: {
                        int cs = WebGLRenderingContext.this.colorSpaceConversionWebGL;
                        if (cs == -1) {
                            cs = 37444;
                        }
                        parameter[0] = cs;
                        break;
                    }
                    case 2928: 
                    case 33901: 
                    case 33902: {
                        float[] param2 = new float[2];
                        GLES20.glGetFloatv((int)pname, (FloatBuffer)FloatBuffer.wrap(param2));
                        parameter[0] = param2;
                        break;
                    }
                    case 3106: 
                    case 32773: {
                        float[] param3 = new float[4];
                        GLES20.glGetFloatv((int)pname, (FloatBuffer)FloatBuffer.wrap(param3));
                        parameter[0] = param3;
                        break;
                    }
                    case 37440: {
                        parameter[0] = WebGLRenderingContext.this.flipYWebGL;
                        break;
                    }
                    case 37441: {
                        parameter[0] = WebGLRenderingContext.this.premultiplyAlphaWebGL;
                        break;
                    }
                    case 2884: 
                    case 2929: 
                    case 2930: 
                    case 2960: 
                    case 3024: 
                    case 3042: 
                    case 3089: 
                    case 32823: 
                    case 32939: {
                        IntBuffer param4 = IntBuffer.allocate(1);
                        GLES20.glGetBooleanv((int)pname, (IntBuffer)param4);
                        parameter[0] = WebGLRenderingContext.this.boolConverter(param4.get(0));
                        break;
                    }
                    case 3107: {
                        IntBuffer param5 = IntBuffer.allocate(4);
                        GLES20.glGetBooleanv((int)pname, (IntBuffer)param5);
                        boolean[] mask = new boolean[]{WebGLRenderingContext.this.boolConverter(param5.get(0)), WebGLRenderingContext.this.boolConverter(param5.get(1)), WebGLRenderingContext.this.boolConverter(param5.get(2)), WebGLRenderingContext.this.boolConverter(param5.get(3))};
                        parameter[0] = mask;
                        break;
                    }
                    case 34467: {
                        IntBuffer count = IntBuffer.allocate(1);
                        GLES20.glGetIntegerv((int)34466, (IntBuffer)count);
                        int[] formats = new int[count.get(0)];
                        GLES20.glGetIntegerv((int)34467, (IntBuffer)IntBuffer.wrap(formats));
                        parameter[0] = formats;
                        break;
                    }
                    case 2849: 
                    case 2931: 
                    case 10752: 
                    case 32824: 
                    case 32938: {
                        FloatBuffer param6 = FloatBuffer.allocate(1);
                        GLES20.glGetFloatv((int)pname, (FloatBuffer)param6);
                        parameter[0] = Float.valueOf(param6.get(0));
                        break;
                    }
                    case 3386: {
                        int[] dims = new int[2];
                        GLES20.glGetIntegerv((int)pname, (IntBuffer)IntBuffer.wrap(dims));
                        parameter[0] = dims;
                        break;
                    }
                    case 2978: 
                    case 3088: {
                        int[] params7 = new int[4];
                        GLES20.glGetIntegerv((int)pname, (IntBuffer)IntBuffer.wrap(params7));
                        parameter[0] = params7;
                        break;
                    }
                    case 7936: 
                    case 7937: 
                    case 7938: 
                    case 35724: {
                        parameter[0] = GLES20.glGetString((int)pname);
                        break;
                    }
                    default: {
                        parameter[0] = null;
                    }
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return parameter[0];
    }

    public String getProgramInfoLog(final int program) {
        final CountDownLatch lock = new CountDownLatch(1);
        final String[] infoLog = new String[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                infoLog[0] = GLES20.glGetProgramInfoLog((int)program);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return infoLog[0];
    }

    public Object getProgramParameter(final int program, final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final Object[] parameter = new Object[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                IntBuffer param = IntBuffer.allocate(1);
                GLES20.glGetProgramiv((int)program, (int)pname, (IntBuffer)param);
                switch (pname) {
                    case 35712: 
                    case 35714: 
                    case 35715: {
                        parameter[0] = WebGLRenderingContext.this.boolConverter(param.get(0));
                        break;
                    }
                    default: {
                        parameter[0] = param.get(0);
                    }
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return parameter[0];
    }

    public int getRenderbufferParameter(final int target, final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] parameter = new int[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                IntBuffer params = IntBuffer.allocate(1);
                GLES20.glGetRenderbufferParameteriv((int)target, (int)pname, (IntBuffer)params);
                parameter[0] = params.get(0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return parameter[0];
    }

    public String getShaderInfoLog(final int shader) {
        final CountDownLatch lock = new CountDownLatch(1);
        final String[] infoLog = new String[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                infoLog[0] = GLES20.glGetShaderInfoLog((int)shader);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return infoLog[0];
    }

    public Object getShaderParameter(final int shader, final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final Object[] parameter = new Object[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                IntBuffer params = IntBuffer.allocate(1);
                GLES20.glGetShaderiv((int)shader, (int)pname, (IntBuffer)params);
                switch (pname) {
                    case 35712: 
                    case 35713: {
                        parameter[0] = WebGLRenderingContext.this.boolConverter(params.get(0));
                        break;
                    }
                    default: {
                        parameter[0] = params.get(0);
                    }
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return parameter[0];
    }

    public WebGLShaderPrecisionFormat getShaderPrecisionFormat(final int shaderType, final int precisionType) {
        final CountDownLatch lock = new CountDownLatch(1);
        final WebGLShaderPrecisionFormat precisionFormat = new WebGLShaderPrecisionFormat();
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                IntBuffer range = IntBuffer.allocate(2);
                IntBuffer precision = IntBuffer.allocate(1);
                GLES20.glGetShaderPrecisionFormat((int)shaderType, (int)precisionType, (IntBuffer)range, (IntBuffer)precision);
                precisionFormat.rangeMin = range.get(0);
                precisionFormat.rangeMax = range.get(1);
                precisionFormat.precision = precision.get(0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return precisionFormat;
    }

    public String getShaderSource(final int shader) {
        final CountDownLatch lock = new CountDownLatch(1);
        final String[] source = new String[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                source[0] = GLES20.glGetShaderSource((int)shader);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return source[0];
    }

    public String[] getSupportedExtensions() {
        final CountDownLatch lock = new CountDownLatch(1);
        final ArrayList extensions = new ArrayList();
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                String glExtensions = GLES20.glGetString((int)7939);
                extensions.add(glExtensions.split(" "));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (String[])extensions.get(0);
    }

    public int getTexParameter(final int target, final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] parameters = new int[1];
        boolean[] hasError = new boolean[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                IntBuffer params = IntBuffer.allocate(1);
                GLES20.glGetTexParameteriv((int)target, (int)pname, (IntBuffer)params);
                parameters[0] = params.get(0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return parameters[0];
    }

    private float[] getFloatSlice(int count) {
        return new float[count];
    }

    private int[] getIntSlice(int count) {
        return new int[count];
    }

    public Object getUniform(final int program, final int location) {
        final CountDownLatch lock = new CountDownLatch(1);
        final Object[] uniform = new Object[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                int[] type = new int[1];
                GLES20.glGetActiveUniform((int)program, (int)location, (int)0, null, (int)0, null, (int)0, (int[])type, (int)0, null, (int)0);
                switch (type[0]) {
                    case 5126: {
                        float[] single = WebGLRenderingContext.this.getFloatSlice(1);
                        GLES20.glGetUniformfv((int)program, (int)location, (float[])single, (int)0);
                        uniform[0] = Float.valueOf(single[0]);
                        break;
                    }
                    case 35664: {
                        float[] vec2 = WebGLRenderingContext.this.getFloatSlice(2);
                        GLES20.glGetUniformfv((int)program, (int)location, (float[])vec2, (int)0);
                        uniform[0] = vec2;
                        break;
                    }
                    case 35665: {
                        float[] vec3 = WebGLRenderingContext.this.getFloatSlice(3);
                        GLES20.glGetUniformfv((int)program, (int)location, (float[])vec3, (int)0);
                        uniform[0] = vec3;
                        break;
                    }
                    case 35666: {
                        float[] vec4 = WebGLRenderingContext.this.getFloatSlice(4);
                        GLES20.glGetUniformfv((int)program, (int)location, (float[])vec4, (int)0);
                        uniform[0] = vec4;
                        break;
                    }
                    case 5124: 
                    case 35678: 
                    case 35680: {
                        int[] singleInt = WebGLRenderingContext.this.getIntSlice(1);
                        GLES20.glGetUniformiv((int)program, (int)location, (int[])singleInt, (int)0);
                        uniform[0] = singleInt[0];
                        break;
                    }
                    case 35667: {
                        int[] intVec2 = WebGLRenderingContext.this.getIntSlice(2);
                        GLES20.glGetUniformiv((int)program, (int)location, (int[])intVec2, (int)0);
                        uniform[0] = intVec2;
                        break;
                    }
                    case 35668: {
                        int[] intVec3 = WebGLRenderingContext.this.getIntSlice(3);
                        GLES20.glGetUniformiv((int)program, (int)location, (int[])intVec3, (int)0);
                        uniform[0] = intVec3;
                        break;
                    }
                    case 35669: {
                        int[] intVec4 = WebGLRenderingContext.this.getIntSlice(4);
                        GLES20.glGetUniformiv((int)program, (int)location, (int[])intVec4, (int)0);
                        uniform[0] = intVec4;
                        break;
                    }
                    case 35670: {
                        int[] singleBool = WebGLRenderingContext.this.getIntSlice(1);
                        GLES20.glGetUniformiv((int)program, (int)location, (int[])singleBool, (int)0);
                        uniform[0] = WebGLRenderingContext.this.boolConverter(singleBool[0]);
                        break;
                    }
                    case 35671: {
                        int[] boolVec2 = WebGLRenderingContext.this.getIntSlice(2);
                        boolean[] boolVec2Result = new boolean[2];
                        GLES20.glGetUniformiv((int)program, (int)location, (int[])boolVec2, (int)0);
                        boolVec2Result[0] = WebGLRenderingContext.this.boolConverter(boolVec2[0]);
                        boolVec2Result[1] = WebGLRenderingContext.this.boolConverter(boolVec2[1]);
                        uniform[0] = boolVec2Result;
                        break;
                    }
                    case 35672: {
                        int[] boolVec3 = WebGLRenderingContext.this.getIntSlice(3);
                        boolean[] boolVec3Result = new boolean[3];
                        GLES20.glGetUniformiv((int)program, (int)location, (int[])boolVec3, (int)0);
                        boolVec3Result[0] = WebGLRenderingContext.this.boolConverter(boolVec3[0]);
                        boolVec3Result[1] = WebGLRenderingContext.this.boolConverter(boolVec3[1]);
                        boolVec3Result[2] = WebGLRenderingContext.this.boolConverter(boolVec3[2]);
                        uniform[0] = boolVec3Result;
                        break;
                    }
                    case 35673: {
                        int[] boolVec4 = WebGLRenderingContext.this.getIntSlice(4);
                        boolean[] boolVec4Result = new boolean[4];
                        GLES20.glGetUniformiv((int)program, (int)location, (int[])boolVec4, (int)0);
                        boolVec4Result[0] = WebGLRenderingContext.this.boolConverter(boolVec4[0]);
                        boolVec4Result[1] = WebGLRenderingContext.this.boolConverter(boolVec4[1]);
                        boolVec4Result[2] = WebGLRenderingContext.this.boolConverter(boolVec4[2]);
                        boolVec4Result[3] = WebGLRenderingContext.this.boolConverter(boolVec4[3]);
                        uniform[0] = boolVec4Result;
                        break;
                    }
                    case 35674: {
                        float[] mat2 = WebGLRenderingContext.this.getFloatSlice(2);
                        GLES20.glGetUniformfv((int)program, (int)location, (float[])mat2, (int)0);
                        uniform[0] = mat2;
                        break;
                    }
                    case 35675: {
                        float[] mat3 = WebGLRenderingContext.this.getFloatSlice(3);
                        GLES20.glGetUniformfv((int)program, (int)location, (float[])mat3, (int)0);
                        uniform[0] = mat3;
                        break;
                    }
                    case 35676: {
                        float[] mat4 = WebGLRenderingContext.this.getFloatSlice(4);
                        GLES20.glGetUniformfv((int)program, (int)location, (float[])mat4, (int)0);
                        uniform[0] = mat4;
                    }
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return uniform[0];
    }

    public int getUniformLocation(final int program, final String name) {
        final CountDownLatch lock = new CountDownLatch(1);
        final int[] location = new int[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                location[0] = GLES20.glGetUniformLocation((int)program, (String)name);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return location[0];
    }

    public Object getVertexAttrib(final int index, final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final Object[] attrib = new Object[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                if (pname == 34342) {
                    float[] params = new float[4];
                    GLES20.glGetVertexAttribfv((int)index, (int)pname, (FloatBuffer)FloatBuffer.wrap(params));
                    attrib[0] = params;
                } else {
                    IntBuffer params = IntBuffer.allocate(1);
                    GLES20.glGetVertexAttribiv((int)index, (int)pname, (IntBuffer)params);
                    switch (pname) {
                        case 34338: 
                        case 34922: {
                            attrib[0] = WebGLRenderingContext.this.boolConverter(params.get(0));
                            break;
                        }
                        default: {
                            attrib[0] = params.get(0);
                        }
                    }
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return attrib[0];
    }

    public long getVertexAttribOffset(final int index, final int pname) {
        final CountDownLatch lock = new CountDownLatch(1);
        final long[] offset = new long[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                LongBuffer buffer = LongBuffer.allocate(1);
                WebGLRenderingContext.this.nativeGetVertexAttribOffset(index, pname, buffer);
                offset[0] = buffer.get(0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return offset[0];
    }

    public void hint(final int target, final int mode) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glHint((int)target, (int)mode);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isBuffer(final int buffer) {
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                value[0] = GLES20.glIsBuffer((int)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public boolean isContextLost() {
        return false;
    }

    public boolean isEnabled(final int cap) {
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                value[0] = GLES20.glIsEnabled((int)cap);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public boolean isFramebuffer(final int framebuffer) {
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                value[0] = GLES20.glIsFramebuffer((int)framebuffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public boolean isProgram(final int program) {
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                value[0] = GLES20.glIsProgram((int)program);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public boolean isRenderbuffer(final int renderbuffer) {
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                value[0] = GLES20.glIsRenderbuffer((int)renderbuffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public boolean isShader(final int shader) {
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                value[0] = GLES20.glIsShader((int)shader);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public boolean isTexture(final int texture) {
        final CountDownLatch lock = new CountDownLatch(1);
        final boolean[] value = new boolean[1];
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                value[0] = GLES20.glIsTexture((int)texture);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return value[0];
    }

    public void lineWidth(final float width) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glLineWidth((float)width);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void linkProgram(final int program) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glLinkProgram((int)program);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private int objectToInt(Object value, int defaultValue) {
        if (value != null) {
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private boolean objectToBoolean(Object value, boolean defaultValue) {
        if (value != null) {
            return Boolean.parseBoolean(value.toString());
        }
        return defaultValue;
    }

    private int objectToColorSpace(Object value, int defaultValue) {
        if (value != null) {
            try {
                int val = Integer.parseInt(value.toString());
                if (val == 37444 || val == 0) {
                    return val;
                }
                return 37444;
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public void pixelStorei(final int pname, final Object param) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                switch (pname) {
                    case 3317: 
                    case 3333: {
                        GLES20.glPixelStorei((int)pname, (int)WebGLRenderingContext.this.objectToInt(param, 4));
                        break;
                    }
                    case 37440: {
                        WebGLRenderingContext.this.flipYWebGL = WebGLRenderingContext.this.objectToBoolean(param, false);
                        break;
                    }
                    case 37441: {
                        WebGLRenderingContext.this.premultiplyAlphaWebGL = WebGLRenderingContext.this.objectToBoolean(param, false);
                        break;
                    }
                    case 37443: {
                        WebGLRenderingContext.this.colorSpaceConversionWebGL = WebGLRenderingContext.this.objectToColorSpace(param, 37444);
                        break;
                    }
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void polygonOffset(final float factor, final float units) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glPolygonOffset((float)factor, (float)units);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void readPixels(final int x, final int y, final int width, final int height, final int format, final int type, final byte[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (Buffer)ByteBuffer.wrap(pixels));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void readPixels(final int x, final int y, final int width, final int height, final int format, final int type, final short[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (Buffer)ShortBuffer.wrap(pixels));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void readPixels(final int x, final int y, final int width, final int height, final int format, final int type, final float[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (Buffer)FloatBuffer.wrap(pixels));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void readPixels(final int x, final int y, final int width, final int height, final int format, final int type, final int[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (Buffer)IntBuffer.wrap(pixels));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void renderbufferStorage(final int target, final int internalFormat, final int width, final int height) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glRenderbufferStorage((int)target, (int)internalFormat, (int)width, (int)height);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void sampleCoverage(final float value, final boolean invert) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glSampleCoverage((float)value, (boolean)invert);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void scissor(final int x, final int y, final int width, final int height) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glScissor((int)x, (int)y, (int)width, (int)height);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void shaderSource(final int shader, final String source) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glShaderSource((int)shader, (String)source);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stencilFunc(final int func, final int ref, final int mask) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glStencilFunc((int)func, (int)ref, (int)mask);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stencilFuncSeparate(final int face, final int func, final int ref, final int mask) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glStencilFuncSeparate((int)face, (int)func, (int)ref, (int)mask);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stencilMask(final int mask) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glStencilMask((int)mask);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stencilMaskSeparate(final int face, final int mask) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glStencilMaskSeparate((int)face, (int)mask);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stencilOp(final int fail, final int zfail, final int zpass) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glStencilOp((int)fail, (int)zfail, (int)zpass);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stencilOpSeparate(final int face, final int fail, final int zfail, final int zpass) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glStencilOpSeparate((int)face, (int)fail, (int)zfail, (int)zpass);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texImage2D(final int target, final int level, final int internalformat, final int width, final int height, final int border, final int format, final int type, final @Nullable byte[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                if (pixels != null) {
                    if (WebGLRenderingContext.this.flipYWebGL) {
                        WebGLRenderingContext.this.flipInPlace(pixels, width, height);
                    }
                    GLES20.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (Buffer)ByteBuffer.wrap(pixels));
                } else {
                    GLES20.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, null);
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texImage2D(final int target, final int level, final int internalformat, final int width, final int height, final int border, final int format, final int type, final short[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (Buffer)ShortBuffer.wrap(pixels));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texImage2D(final int target, final int level, final int internalformat, final int width, final int height, final int border, final int format, final int type, final int[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (Buffer)IntBuffer.wrap(pixels));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texImage2D(final int target, final int level, final int internalformat, final int width, final int height, final int border, final int format, final int type, final float[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (Buffer)FloatBuffer.wrap(pixels));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texImage2D(final int target, final int level, final int internalformat, final int format, final int type, final ImageAsset asset) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                byte[] raw = asset.getBytes();
                if (WebGLRenderingContext.this.flipYWebGL) {
                    // empty if block
                }
                GLES20.glTexImage2D((int)target, (int)level, (int)internalformat, (int)asset.getWidth(), (int)asset.getHeight(), (int)0, (int)format, (int)type, (Buffer)ByteBuffer.wrap(raw));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texImage2D(final int target, final int level, final int internalformat, final int format, final int type, final Bitmap pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                byte[] storage = WebGLRenderingContext.this.bytesFromBitmap(pixels, WebGLRenderingContext.this.flipYWebGL);
                GLES20.glTexImage2D((int)target, (int)level, (int)internalformat, (int)pixels.getWidth(), (int)pixels.getHeight(), (int)0, (int)format, (int)type, (Buffer)ByteBuffer.wrap(storage));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texParameterf(final int target, final int pname, final float param) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glTexParameterf((int)target, (int)pname, (float)param);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texParameteri(final int target, final int pname, final int param) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glTexParameteri((int)target, (int)pname, (int)param);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texSubImage2D(final int target, final int level, final int xoffset, final int yoffset, final int width, final int height, final int format, final int type, final @Nullable byte[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                if (pixels != null) {
                    if (WebGLRenderingContext.this.flipYWebGL) {
                        WebGLRenderingContext.this.flipInPlace(pixels, width, height);
                    }
                    GLES20.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (Buffer)ByteBuffer.wrap(pixels));
                } else {
                    GLES20.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, null);
                }
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texSubImage2D(final int target, final int level, final int xoffset, final int yoffset, final int width, final int height, final int format, final int type, final short[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (Buffer)ShortBuffer.wrap(pixels));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texSubImage2D(final int target, final int level, final int xoffset, final int yoffset, final int width, final int height, final int format, final int type, final int[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (Buffer)IntBuffer.wrap(pixels));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texSubImage2D(final int target, final int level, final int xoffset, final int yoffset, final int width, final int height, final int format, final int type, final float[] pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (Buffer)FloatBuffer.wrap(pixels));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texSubImage2D(final int target, final int level, final int xoffset, final int yoffset, final int format, final int type, final Bitmap pixels) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                byte[] storage = WebGLRenderingContext.this.bytesFromBitmap(pixels, WebGLRenderingContext.this.flipYWebGL);
                ByteBuffer buffer = ByteBuffer.wrap(storage);
                GLES20.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)pixels.getWidth(), (int)pixels.getHeight(), (int)format, (int)type, (Buffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void texSubImage2D(final int target, final int level, final int xoffset, final int yoffset, final int format, final int type, final ImageAsset asset) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                byte[] raw = asset.getBytes();
                if (WebGLRenderingContext.this.flipYWebGL) {
                    WebGLRenderingContext.this.flipInPlace(raw, asset.getWidth(), asset.getHeight());
                }
                GLES20.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)asset.getWidth(), (int)asset.getHeight(), (int)format, (int)type, (Buffer)ByteBuffer.wrap(raw));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform1f(final int location, final float v0) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform1f((int)location, (float)v0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform1fv(final int location, final float[] value) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                FloatBuffer buffer = FloatBuffer.wrap(value);
                GLES20.glUniform1fv((int)location, (int)1, (FloatBuffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform1i(final int location, final int v0) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform1i((int)location, (int)v0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform1iv(final int location, final int[] value) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                IntBuffer buffer = IntBuffer.wrap(value);
                GLES20.glUniform1iv((int)location, (int)1, (IntBuffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform2f(final int location, final float v0, final float v1) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform2f((int)location, (float)v0, (float)v1);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform2fv(final int location, final float[] value) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                FloatBuffer buffer = FloatBuffer.wrap(value);
                GLES20.glUniform1fv((int)location, (int)1, (FloatBuffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform2i(final int location, final int v0, final int v1) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform2i((int)location, (int)v0, (int)v1);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform2iv(final int location, final int[] value) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                IntBuffer buffer = IntBuffer.wrap(value);
                GLES20.glUniform2iv((int)location, (int)1, (IntBuffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform3f(final int location, final float v0, final float v1, final float v2) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform3f((int)location, (float)v0, (float)v1, (float)v2);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform3fv(final int location, final float[] value) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                FloatBuffer buffer = FloatBuffer.wrap(value);
                GLES20.glUniform3fv((int)location, (int)1, (FloatBuffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform3i(final int location, final int v0, final int v1, final int v2) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform3i((int)location, (int)v0, (int)v1, (int)v2);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform3iv(final int location, final int[] value) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                IntBuffer buffer = IntBuffer.wrap(value);
                GLES20.glUniform3iv((int)location, (int)1, (IntBuffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform4f(final int location, final float v0, final float v1, final float v2, final float v3) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform4f((int)location, (float)v0, (float)v1, (float)v2, (float)v3);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform4fv(final int location, final float[] value) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                FloatBuffer buffer = FloatBuffer.wrap(value);
                GLES20.glUniform4fv((int)location, (int)1, (FloatBuffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform4i(final int location, final int v0, final int v1, final int v2, final int v3) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform4i((int)location, (int)v0, (int)v1, (int)v2, (int)v3);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniform4iv(final int location, final int[] value) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                IntBuffer buffer = IntBuffer.wrap(value);
                GLES20.glUniform4iv((int)location, (int)1, (IntBuffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniformMatrix2fv(final int location, final boolean transpose, final float[] value) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                FloatBuffer buffer = FloatBuffer.wrap(value);
                GLES20.glUniformMatrix2fv((int)location, (int)1, (boolean)transpose, (FloatBuffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniformMatrix3fv(final int location, final boolean transpose, final float[] value) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                FloatBuffer buffer = FloatBuffer.wrap(value);
                GLES20.glUniformMatrix3fv((int)location, (int)1, (boolean)transpose, (FloatBuffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void uniformMatrix4fv(final int location, final boolean transpose, final float[] value) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                FloatBuffer buffer = FloatBuffer.wrap(value);
                GLES20.glUniformMatrix4fv((int)location, (int)1, (boolean)transpose, (FloatBuffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void useProgram(final int program) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glUseProgram((int)program);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void validateProgram(final int program) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glValidateProgram((int)program);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void vertexAttrib1f(final int index, final float v0) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glVertexAttrib1f((int)index, (float)v0);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void vertexAttrib2f(final int index, final float v0, final float v1) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glVertexAttrib2f((int)index, (float)v0, (float)v1);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void vertexAttrib3f(final int index, final float v0, final float v1, final float v2) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glVertexAttrib3f((int)index, (float)v0, (float)v1, (float)v2);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void vertexAttrib4f(final int index, final float v0, final float v1, final float v2, final float v3) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glVertexAttrib4f((int)index, (float)v0, (float)v1, (float)v2, (float)v3);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void vertexAttrib1fv(final int index, final float[] value) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                FloatBuffer buffer = FloatBuffer.wrap(value);
                GLES20.glVertexAttrib1fv((int)index, (FloatBuffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void vertexAttrib2fv(final int index, final float[] value) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                FloatBuffer buffer = FloatBuffer.wrap(value);
                GLES20.glVertexAttrib2fv((int)index, (FloatBuffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void vertexAttrib3fv(final int index, final float[] value) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                FloatBuffer buffer = FloatBuffer.wrap(value);
                GLES20.glVertexAttrib3fv((int)index, (FloatBuffer)buffer);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void vertexAttrib4fv(final int index, final float[] value) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glVertexAttrib4fv((int)index, (FloatBuffer)FloatBuffer.wrap(value));
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void vertexAttribPointer(final int index, final int size, final int type, final boolean normalized, final int stride, final int offset) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glVertexAttribPointer((int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (int)offset);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void viewport(final int x, final int y, final int width, final int height) {
        final CountDownLatch lock = new CountDownLatch(1);
        this.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                GLES20.glViewport((int)x, (int)y, (int)width, (int)height);
                lock.countDown();
            }
        });
        try {
            lock.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

