/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

import androidx.annotation.Nullable;
import com.github.triniwiz.canvas.CanvasDOMMatrix;

public class CanvasPath2D {
    long path;

    private static native long nativeInit();

    private static native long nativeInitWithPath(long var0);

    private static native long nativeInitWithData(String var0);

    private static native long nativeAddPath(long var0, long var2, long var4);

    private static native long nativeClosePath(long var0);

    private static native long nativeRect(long var0, float var2, float var3, float var4, float var5);

    private static native long nativeMoveTo(long var0, float var2, float var3);

    private static native long nativeLineTo(long var0, float var2, float var3);

    private static native long nativeArc(long var0, float var2, float var3, float var4, float var5, float var6, boolean var7);

    private static native long nativeArcTo(long var0, float var2, float var3, float var4, float var5, float var6);

    private static native long nativeBezierCurveTo(long var0, float var2, float var3, float var4, float var5, float var6, float var7);

    private static native long nativeEllipse(long var0, float var2, float var3, float var4, float var5, float var6, float var7, float var8, boolean var9);

    private static native long nativeQuadraticCurveTo(long var0, float var2, float var3, float var4, float var5);

    private static native void nativeFreePath(long var0);

    public CanvasPath2D() {
        this.path = CanvasPath2D.nativeInit();
    }

    public CanvasPath2D(CanvasPath2D path2D) {
        this.path = CanvasPath2D.nativeInitWithPath(path2D.path);
    }

    public CanvasPath2D(String data) {
        this.path = CanvasPath2D.nativeInitWithData(data);
    }

    public void addPath(CanvasPath2D path2D, @Nullable CanvasDOMMatrix matrix) {
        long m = 0L;
        if (matrix != null) {
            m = matrix.matrix;
        }
        this.path = CanvasPath2D.nativeAddPath(this.path, path2D.path, m);
    }

    public void closePath() {
        this.path = CanvasPath2D.nativeClosePath(this.path);
    }

    public void moveTo(float x, float y) {
        this.path = CanvasPath2D.nativeMoveTo(this.path, x, y);
    }

    public void rect(float x, float y, float width, float height) {
        this.path = CanvasPath2D.nativeRect(this.path, x, y, width, height);
    }

    public void lineTo(float x, float y) {
        this.path = CanvasPath2D.nativeLineTo(this.path, x, y);
    }

    public void arc(float x, float y, float radius, float startAngle, float endAngle, boolean anticlockwise) {
        this.path = CanvasPath2D.nativeArc(this.path, x, y, radius, startAngle, endAngle, anticlockwise);
    }

    public void arcTo(float x1, float y1, float x2, float y2, float radius) {
        this.path = CanvasPath2D.nativeArcTo(this.path, x1, y1, x2, y2, radius);
    }

    public void bezierCurveTo(float cp1x, float cp1y, float cp2x, float cp2y, float x, float y) {
        this.path = CanvasPath2D.nativeBezierCurveTo(this.path, cp1x, cp1y, cp2x, cp2y, x, y);
    }

    public void ellipse(float x, float y, float radiusX, float radiusY, float rotation, float startAngle, float endAngle, boolean anticlockwise) {
        this.path = CanvasPath2D.nativeEllipse(this.path, x, y, radiusX, radiusY, rotation, startAngle, endAngle, anticlockwise);
    }

    public void quadraticCurveTo(float cpx, float cpy, float x, float y) {
        this.path = CanvasPath2D.nativeQuadraticCurveTo(this.path, cpx, cpy, x, y);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        CanvasPath2D.nativeFreePath(this.path);
        this.path = 0L;
    }
}

