/*
 * Decompiled with CFR 0.152.
 */
package com.github.triniwiz.canvas;

public class CanvasDOMMatrix {
    long matrix = CanvasDOMMatrix.nativeInit();
    private float a;
    private float b;
    private float c;
    private float d;
    private float e;
    private float f;

    private static native long nativeInit();

    private static native long nativeSetMatrix(long var0, float[] var2);

    private static native float[] nativeGetMatrix(long var0);

    private static native void nativeFreeMatrix(long var0);

    public CanvasDOMMatrix() {
        this.refreshMatrix();
    }

    private void updateMatrix() {
        float[] values = new float[]{this.a, this.b, this.c, this.d, this.e, this.f};
        CanvasDOMMatrix.nativeSetMatrix(this.matrix, values);
    }

    private void refreshMatrix() {
        float[] values = CanvasDOMMatrix.nativeGetMatrix(this.matrix);
        this.a = values[0];
        this.b = values[1];
        this.c = values[2];
        this.d = values[3];
        this.e = values[4];
        this.f = values[5];
    }

    private void reload() {
        this.updateMatrix();
        this.refreshMatrix();
    }

    public float getA() {
        return this.a;
    }

    public void setA(float a) {
        this.a = a;
        this.reload();
    }

    public float getB() {
        return this.b;
    }

    public void setB(float b) {
        this.b = b;
        this.reload();
    }

    public float getC() {
        return this.c;
    }

    public void setC(float c) {
        this.c = c;
        this.reload();
    }

    public float getD() {
        return this.d;
    }

    public void setD(float d) {
        this.d = d;
        this.reload();
    }

    public float getE() {
        return this.e;
    }

    public void setE(float e) {
        this.e = e;
        this.reload();
    }

    public float getF() {
        return this.f;
    }

    public void setF(float f) {
        this.f = f;
        this.reload();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        CanvasDOMMatrix.nativeFreeMatrix(this.matrix);
        this.matrix = 0L;
    }
}

