/*
 * Decompiled with CFR 0.152.
 */
package cl.transbank.util;

import cl.transbank.util.HttpUtil;
import cl.transbank.util.JsonUtil;
import cl.transbank.util.JsonUtilImpl;
import cl.transbank.util.StringUtils;
import cl.transbank.webpay.exception.TransbankHttpApiException;
import cl.transbank.webpay.exception.WebpayException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;

public class HttpUtilImpl
implements HttpUtil {
    private static Logger logger = Logger.getLogger(HttpUtilImpl.class.getName());
    private static volatile HttpUtilImpl instance;
    private JsonUtil jsonUtil = JsonUtilImpl.getInstance();

    @Override
    public <T> T request(@NonNull URL url, HttpUtil.RequestMethod method, Object request, Map<String, String> headers, Class<T> clazz) throws IOException, WebpayException {
        if (url == null) {
            throw new NullPointerException("url is marked @NonNull but is null");
        }
        String jsonIn = this.getJsonUtil().jsonEncode(request);
        String jsonOut = this.request(url, method, jsonIn, headers, true);
        return this.getJsonUtil().jsonDecode(jsonOut, clazz);
    }

    @Override
    public String request(@NonNull URL url, HttpUtil.RequestMethod method, String query) throws IOException, WebpayException {
        if (url == null) {
            throw new NullPointerException("url is marked @NonNull but is null");
        }
        return this.request(url, method, query, (HttpUtil.ContentType)null, (Map<String, String>)null);
    }

    @Override
    public String request(@NonNull URL url, HttpUtil.RequestMethod method, String query, HttpUtil.ContentType contentType) throws IOException, WebpayException {
        if (url == null) {
            throw new NullPointerException("url is marked @NonNull but is null");
        }
        return this.request(url, method, query, contentType, null);
    }

    @Override
    public String request(@NonNull URL url, HttpUtil.RequestMethod method, String query, Map<String, String> headers) throws IOException, WebpayException {
        if (url == null) {
            throw new NullPointerException("url is marked @NonNull but is null");
        }
        return this.request(url, method, query, null, headers);
    }

    public String request(@NonNull URL url, HttpUtil.RequestMethod method, String query, Map<String, String> headers, boolean useException) throws IOException, WebpayException {
        if (url == null) {
            throw new NullPointerException("url is marked @NonNull but is null");
        }
        return this.request(url, method, query, null, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String request(@NonNull URL url, HttpUtil.RequestMethod method, String query, HttpUtil.ContentType contentType, Map<String, String> headers) throws IOException, WebpayException {
        if (url == null) {
            throw new NullPointerException("url is marked @NonNull but is null");
        }
        if (null == method) {
            method = HttpUtil.RequestMethod.GET;
        }
        if (null == contentType) {
            contentType = HttpUtil.ContentType.JSON;
        }
        HttpURLConnection conn = null;
        try {
            Map tempMap;
            logger.log(Level.FINE, String.format("HTTP URL : %s", url));
            logger.log(Level.FINE, String.format("HTTP Method : %s", new Object[]{method}));
            if (null != headers) {
                for (String key : headers.keySet()) {
                    if (StringUtils.isEmpty(key)) continue;
                    String value = headers.get(key);
                    if (key.equalsIgnoreCase("Tbk-Api-Key-Secret")) {
                        value = "NOT DISPLAYED BY SECURITY REASON";
                    }
                    logger.log(Level.FINE, String.format("HTTP Header [%s] : %s", key, value));
                }
            }
            logger.log(Level.FINE, String.format("HTTP Request Query : %s", query));
            switch (method) {
                case POST: {
                    conn = this.createPOSTConnection(url, query, contentType, headers);
                    break;
                }
                case DELETE: {
                    conn = this.createDeleteConnection(url, query, contentType, headers);
                    break;
                }
                case PUT: {
                    conn = this.createPUTConnection(url, query, contentType, headers);
                    break;
                }
                default: {
                    conn = this.createGETConnection(url, query, headers);
                }
            }
            int responseCode = conn.getResponseCode();
            logger.log(Level.FINE, String.format("HTTP Response Code : %s", responseCode));
            boolean isHttpErrorCode = responseCode < 200 || responseCode >= 300;
            InputStream input = !isHttpErrorCode ? conn.getInputStream() : conn.getErrorStream();
            String responseBody = HttpUtilImpl.getResponseBody(input);
            if (isHttpErrorCode) {
                String errorMessage = "Could not obtain a response message from Webpay API";
                if (responseBody != null) {
                    Map errorMap = this.getJsonUtil().jsonDecode(responseBody, HashMap.class);
                    errorMessage = errorMap.get("error_message");
                }
                if (null == errorMessage) {
                    errorMessage = "Unspecified message by Webpay API";
                }
                throw new TransbankHttpApiException(responseCode, errorMessage.toString());
            }
            if (responseBody != null && (tempMap = (Map)this.getJsonUtil().jsonDecode(responseBody, HashMap.class)).containsKey("error_message") && tempMap.get("error_message") != null) {
                throw new WebpayException(tempMap.get("error_message").toString());
            }
            String string = responseBody;
            return string;
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
    }

    private HttpURLConnection createPOSTConnection(URL url, String query, HttpUtil.ContentType contentType, Map<String, String> headers) throws IOException {
        return this.createSendingDataConnection(HttpUtil.RequestMethod.POST, url, query, contentType, headers);
    }

    private HttpURLConnection createGETConnection(URL url, String query, Map<String, String> headers) throws IOException {
        String getUrl = this.formatUrl(url.toString(), query);
        HttpURLConnection conn = (HttpURLConnection)new URL(getUrl).openConnection();
        conn.setRequestMethod(HttpUtil.RequestMethod.GET.toString());
        if (null != headers) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                conn.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        return conn;
    }

    private HttpURLConnection createDeleteConnection(URL url, String query, HttpUtil.ContentType contentType, Map<String, String> headers) throws IOException {
        return this.createSendingDataConnection(HttpUtil.RequestMethod.DELETE, url, query, contentType, headers);
    }

    private HttpURLConnection createPUTConnection(URL url, String query, HttpUtil.ContentType contentType, Map<String, String> headers) throws IOException {
        return this.createSendingDataConnection(HttpUtil.RequestMethod.PUT, url, query, contentType, headers);
    }

    private HttpURLConnection createSendingDataConnection(HttpUtil.RequestMethod method, URL url, String query, HttpUtil.ContentType contentType, Map<String, String> headers) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setUseCaches(false);
        conn.setDoOutput(true);
        conn.setRequestMethod(method.toString());
        conn.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
        conn.setRequestProperty("Accept", "application/json");
        conn.setRequestProperty("Content-Type", String.format("%s;charset=%s", contentType.getContentType(), StandardCharsets.UTF_8.name().toLowerCase()));
        if (null != headers) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                conn.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        try (OutputStream out = conn.getOutputStream();){
            out.write(query.getBytes(StandardCharsets.UTF_8));
        }
        return conn;
    }

    private String formatUrl(String url, String query) {
        if (null == query || query.trim().isEmpty()) {
            return url;
        }
        String separator = url.contains("?") ? "&" : "?";
        return String.format("%s%s%s", url, separator, query);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getResponseBody(InputStream responseStream) {
        try (Scanner scanner = new Scanner(responseStream, StandardCharsets.UTF_8.name());){
            String responseBody = scanner.useDelimiter("\\A").next();
            responseStream.close();
            logger.log(Level.FINE, String.format("HTTP Response Body : %s", responseBody));
            String string = responseBody;
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    private HttpUtilImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpUtilImpl getInstance() {
        if (null != instance) return instance;
        Class<HttpUtilImpl> clazz = HttpUtilImpl.class;
        synchronized (HttpUtilImpl.class) {
            instance = new HttpUtilImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setJsonUtil(JsonUtil jsonUtil) {
        this.jsonUtil = jsonUtil;
    }

    private JsonUtil getJsonUtil() {
        return this.jsonUtil;
    }
}

