/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Debug;
import android.os.FileObserver;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.internal.BinderHolder;
import com.topjohnwu.superuser.internal.HiddenAPIs;
import com.topjohnwu.superuser.internal.IRootServiceManager;
import com.topjohnwu.superuser.internal.RootServerMain;
import com.topjohnwu.superuser.internal.RootServiceManager;
import com.topjohnwu.superuser.internal.UiThreadHandler;
import com.topjohnwu.superuser.internal.Utils;
import com.topjohnwu.superuser.ipc.RootService;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class RootServiceServer
extends IRootServiceManager.Stub
implements Runnable {
    private static RootServiceServer mInstance;
    private final FileObserver observer;
    private final Map<ComponentName, ServiceRecord> services = new ArrayMap();
    private final SparseArray<ClientProcess> clients = new SparseArray();
    private final boolean isDaemon;

    public static RootServiceServer getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new RootServiceServer(context);
        }
        return mInstance;
    }

    private RootServiceServer(Context context) {
        Shell.enableVerboseLogging = System.getenv("LIBSU_VERBOSE_LOGGING") != null;
        Utils.context = context;
        if (System.getenv("LIBSU_DEBUGGER") != null) {
            HiddenAPIs.setAppName(context.getPackageName() + ":root");
            Utils.log((String)"IPC", (Object)"Waiting for debugger to be attached...");
            while (!Debug.isDebuggerConnected()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Utils.log((String)"IPC", (Object)"Debugger attached!");
        }
        this.observer = new AppObserver(new File(context.getPackageCodePath()));
        this.observer.startWatching();
        if (context instanceof Callable) {
            try {
                Object[] objs = (Object[])((Callable)context).call();
                this.isDaemon = (Boolean)objs[1];
                if (this.isDaemon) {
                    HiddenAPIs.addService(RootServerMain.getServiceName(context.getPackageName()), (IBinder)this);
                }
                this.broadcast((Integer)objs[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("Expected Context to be Callable");
        }
        if (!this.isDaemon) {
            UiThreadHandler.handler.postDelayed((Runnable)this, 10000L);
        }
    }

    @Override
    public void run() {
        if (this.clients.size() == 0) {
            this.exit("No active clients");
        }
    }

    @Override
    public void connect(IBinder binder) {
        int uid = RootServiceServer.getCallingUid();
        UiThreadHandler.run(() -> this.connectInternal(uid, binder));
    }

    private void connectInternal(int uid, IBinder binder) {
        if (this.clients.get(uid) != null) {
            return;
        }
        try {
            this.clients.put(uid, (Object)new ClientProcess(binder, uid));
            UiThreadHandler.handler.removeCallbacks((Runnable)this);
        }
        catch (RemoteException e) {
            Utils.err((String)"IPC", (Throwable)e);
        }
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void broadcast(int uid) {
        uid = RootServiceServer.getCallingUid() == 0 ? uid : RootServiceServer.getCallingUid();
        Utils.log((String)"IPC", (Object)("broadcast to uid=" + uid));
        Intent intent = RootServiceManager.getBroadcastIntent((IBinder)this, this.isDaemon);
        if (Build.VERSION.SDK_INT >= 24) {
            UserHandle h = UserHandle.getUserHandleForUid((int)uid);
            Utils.context.sendBroadcastAsUser(intent, h);
        } else {
            Utils.context.sendBroadcast(intent);
        }
    }

    @Override
    public IBinder bind(Intent intent) {
        IBinder[] b = new IBinder[1];
        int uid = RootServiceServer.getCallingUid();
        UiThreadHandler.runAndWait(() -> {
            try {
                b[0] = this.bindInternal(uid, intent);
            }
            catch (Exception e) {
                Utils.err((String)"IPC", (Throwable)e);
            }
        });
        return b[0];
    }

    @Override
    public void unbind(ComponentName name) {
        int uid = RootServiceServer.getCallingUid();
        UiThreadHandler.run(() -> {
            Utils.log((String)"IPC", (Object)(name.getClassName() + " unbind"));
            this.unbindService(uid, name);
        });
    }

    @Override
    public void stop(ComponentName name, int uid) {
        int clientUid = RootServiceServer.getCallingUid() == 0 ? uid : RootServiceServer.getCallingUid();
        UiThreadHandler.run(() -> {
            Utils.log((String)"IPC", (Object)(name.getClassName() + " stop"));
            this.unbindService(-1, name);
            this.broadcast(clientUid);
        });
    }

    public void selfStop(ComponentName name) {
        UiThreadHandler.run(() -> {
            Utils.log((String)"IPC", (Object)(name.getClassName() + " selfStop"));
            this.unbindService(-1, name);
        });
    }

    public void register(RootService service) {
        ServiceRecord s = new ServiceRecord(service);
        this.services.put(service.getComponentName(), s);
    }

    private IBinder bindInternal(int uid, Intent intent) throws Exception {
        ClientProcess c = (ClientProcess)this.clients.get(uid);
        if (c == null) {
            return null;
        }
        ComponentName name = intent.getComponent();
        ServiceRecord s = this.services.get(name);
        if (s == null) {
            Context context = Utils.context;
            Class<?> clz = context.getClassLoader().loadClass(name.getClassName());
            Constructor<?> ctor = clz.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            HiddenAPIs.attachBaseContext(ctor.newInstance(new Object[0]), context);
            s = this.services.get(name);
            if (s == null) {
                return null;
            }
        }
        if (s.binder != null) {
            Utils.log((String)"IPC", (Object)(name.getClassName() + " rebind"));
            if (s.rebind) {
                s.service.onRebind(s.intent);
            }
        } else {
            Utils.log((String)"IPC", (Object)(name.getClassName() + " bind"));
            s.binder = s.service.onBind(intent);
            s.intent = intent.cloneFilter();
        }
        s.users.add(uid);
        return s.binder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindInternal(ServiceRecord s, int uid, Runnable onDestroy) {
        boolean hadUsers = !s.users.isEmpty();
        s.users.remove(uid);
        if (uid < 0 || s.users.isEmpty()) {
            if (hadUsers) {
                s.rebind = s.service.onUnbind(s.intent);
            }
            if (uid < 0 || !this.isDaemon) {
                s.service.onDestroy();
                onDestroy.run();
                for (int user : s.users) {
                    ClientProcess c = (ClientProcess)this.clients.get(user);
                    if (c == null) continue;
                    Message msg = Message.obtain();
                    msg.what = 1;
                    msg.arg1 = this.isDaemon ? 1 : 0;
                    msg.obj = s.intent.getComponent();
                    try {
                        c.m.send(msg);
                    }
                    catch (RemoteException e) {
                        Utils.err((String)"IPC", (Throwable)e);
                    }
                    finally {
                        msg.recycle();
                    }
                }
            }
        }
        if (this.services.isEmpty()) {
            this.exit("No active services");
        }
    }

    private void unbindService(int uid, ComponentName name) {
        ServiceRecord s = this.services.get(name);
        if (s == null) {
            return;
        }
        this.unbindInternal(s, uid, () -> this.services.remove(name));
    }

    private void unbindServices(int uid) {
        Iterator<Map.Entry<ComponentName, ServiceRecord>> it = this.services.entrySet().iterator();
        while (it.hasNext()) {
            ServiceRecord s = it.next().getValue();
            if (uid < 0) {
                s.users.clear();
            }
            this.unbindInternal(s, uid, it::remove);
        }
    }

    private void exit(String reason) {
        Utils.log((String)"IPC", (Object)("Terminate process: " + reason));
        System.exit(0);
    }

    private class AppObserver
    extends FileObserver {
        private final String name;

        AppObserver(File path) {
            super(path.getParent(), 1984);
            Utils.log((String)"IPC", (Object)("Start monitoring: " + path.getParent()));
            this.name = path.getName();
        }

        public void onEvent(int event, @Nullable String path) {
            if (event == 1024 || this.name.equals(path)) {
                RootServiceServer.this.exit("Package updated");
            }
        }
    }

    private class ClientProcess
    extends BinderHolder {
        final Messenger m;
        final int uid;

        ClientProcess(IBinder b, int uid) throws RemoteException {
            super(b);
            this.m = new Messenger(b);
            this.uid = uid;
        }

        @Override
        protected void onBinderDied() {
            Utils.log((String)"IPC", (Object)("Client process terminated, uid=" + this.uid));
            RootServiceServer.this.clients.remove(this.uid);
            RootServiceServer.this.unbindServices(this.uid);
        }
    }

    private static class ServiceRecord {
        final RootService service;
        final Set<Integer> users = Utils.newArraySet();
        Intent intent;
        IBinder binder;
        boolean rebind;

        ServiceRecord(RootService s) {
            this.service = s;
        }
    }
}

