/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public interface IRootServiceManager
extends IInterface {
    public static final String DESCRIPTOR = "com.topjohnwu.superuser.internal.IRootServiceManager";

    public void broadcast(int var1) throws RemoteException;

    public void stop(ComponentName var1, int var2) throws RemoteException;

    public void connect(IBinder var1) throws RemoteException;

    public IBinder bind(Intent var1) throws RemoteException;

    public void unbind(ComponentName var1) throws RemoteException;

    public static class _Parcel {
        private static <T> T readTypedObject(Parcel parcel, Parcelable.Creator<T> c) {
            if (parcel.readInt() != 0) {
                return (T)c.createFromParcel(parcel);
            }
            return null;
        }

        private static <T extends Parcelable> void writeTypedObject(Parcel parcel, T value, int parcelableFlags) {
            if (value != null) {
                parcel.writeInt(1);
                value.writeToParcel(parcel, parcelableFlags);
            } else {
                parcel.writeInt(0);
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements IRootServiceManager {
        static final int TRANSACTION_broadcast = 1;
        static final int TRANSACTION_stop = 2;
        static final int TRANSACTION_connect = 3;
        static final int TRANSACTION_bind = 4;
        static final int TRANSACTION_unbind = 5;

        public Stub() {
            this.attachInterface(this, IRootServiceManager.DESCRIPTOR);
        }

        public static IRootServiceManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRootServiceManager.DESCRIPTOR);
            if (iin != null && iin instanceof IRootServiceManager) {
                return (IRootServiceManager)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRootServiceManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    this.broadcast(_arg0);
                    break;
                }
                case 2: {
                    ComponentName _arg0 = (ComponentName)_Parcel.readTypedObject(data, ComponentName.CREATOR);
                    int _arg1 = data.readInt();
                    this.stop(_arg0, _arg1);
                    break;
                }
                case 3: {
                    IBinder _arg0 = data.readStrongBinder();
                    this.connect(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    Intent _arg0 = (Intent)_Parcel.readTypedObject(data, Intent.CREATOR);
                    IBinder _result = this.bind(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 5: {
                    ComponentName _arg0 = (ComponentName)_Parcel.readTypedObject(data, ComponentName.CREATOR);
                    this.unbind(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IRootServiceManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRootServiceManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void broadcast(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRootServiceManager.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stop(ComponentName name, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRootServiceManager.DESCRIPTOR);
                    _Parcel.writeTypedObject(_data, (Parcelable)name, 0);
                    _data.writeInt(uid);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connect(IBinder binder) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRootServiceManager.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder bind(Intent intent) throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRootServiceManager.DESCRIPTOR);
                    _Parcel.writeTypedObject(_data, (Parcelable)intent, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unbind(ComponentName name) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRootServiceManager.DESCRIPTOR);
                    _Parcel.writeTypedObject(_data, (Parcelable)name, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRootServiceManager {
        @Override
        public void broadcast(int uid) throws RemoteException {
        }

        @Override
        public void stop(ComponentName name, int uid) throws RemoteException {
        }

        @Override
        public void connect(IBinder binder) throws RemoteException {
        }

        @Override
        public IBinder bind(Intent intent) throws RemoteException {
            return null;
        }

        @Override
        public void unbind(ComponentName name) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

