/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.os.IBinder;
import com.topjohnwu.superuser.internal.Utils;
import java.lang.reflect.Method;

@SuppressLint(value={"PrivateApi,DiscouragedPrivateApi,SoonBlockedPrivateApi"})
class HiddenAPIs {
    private static Method addService;
    private static Method attachBaseContext;
    private static Method setAppName;
    public static final int FLAG_RECEIVER_FROM_SHELL;

    HiddenAPIs() {
    }

    static void setAppName(String name) {
        try {
            setAppName.invoke(null, name, 0);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static void addService(String name, IBinder service) {
        try {
            if (addService.getParameterTypes().length == 4) {
                addService.invoke(null, name, service, false, 0);
            } else {
                addService.invoke(null, name, service);
            }
        }
        catch (ReflectiveOperationException e) {
            Utils.err((String)"IPC", (Throwable)e);
        }
    }

    static void attachBaseContext(Object wrapper, Context context) {
        if (wrapper instanceof ContextWrapper) {
            try {
                attachBaseContext.invoke(wrapper, context);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    static {
        FLAG_RECEIVER_FROM_SHELL = Build.VERSION.SDK_INT >= 26 ? 0x400000 : 0;
        try {
            Class<?> sm = Class.forName("android.os.ServiceManager");
            if (Build.VERSION.SDK_INT >= 28) {
                try {
                    addService = sm.getDeclaredMethod("addService", String.class, IBinder.class, Boolean.TYPE, Integer.TYPE);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (addService == null) {
                addService = sm.getDeclaredMethod("addService", String.class, IBinder.class);
            }
            attachBaseContext = ContextWrapper.class.getDeclaredMethod("attachBaseContext", Context.class);
            attachBaseContext.setAccessible(true);
            Class<?> ddm = Class.forName("android.ddm.DdmHandleAppName");
            setAppName = ddm.getDeclaredMethod("setAppName", String.class, Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            Utils.err((String)"IPC", (Throwable)e);
        }
    }
}

