/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.os.RemoteException;
import android.system.ErrnoException;
import android.system.OsConstants;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.topjohnwu.superuser.internal.FileSystemService;
import com.topjohnwu.superuser.internal.FileUtils;
import com.topjohnwu.superuser.internal.IFileSystemService;
import com.topjohnwu.superuser.internal.LocalFile;
import com.topjohnwu.superuser.internal.RemoteFile;
import com.topjohnwu.superuser.internal.RemoteFileChannel;
import com.topjohnwu.superuser.nio.ExtendedFile;
import com.topjohnwu.superuser.nio.FileSystemManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.attribute.FileAttribute;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class NIOFactory {
    private NIOFactory() {
    }

    public static FileSystemManager createLocal() {
        return new FileSystemManager(){

            @Override
            @NonNull
            public ExtendedFile getFile(@NonNull String pathname) {
                return new LocalFile(pathname);
            }

            @Override
            @NonNull
            public ExtendedFile getFile(@Nullable String parent, @NonNull String child) {
                return new LocalFile(parent, child);
            }

            @Override
            @NonNull
            public FileChannel openChannel(@NonNull File file, int mode) throws IOException {
                if (Build.VERSION.SDK_INT >= 26) {
                    return FileChannel.open(file.toPath(), FileUtils.modeToOptions(mode), new FileAttribute[0]);
                }
                FileUtils.Flag f = FileUtils.modeToFlag(mode);
                if (f.write) {
                    if (!f.create && !file.exists()) {
                        ErrnoException e = new ErrnoException("open", OsConstants.ENOENT);
                        throw new FileNotFoundException(file + ": " + e.getMessage());
                    }
                    if (f.append) {
                        return new FileOutputStream(file, true).getChannel();
                    }
                    if (!f.read && f.truncate) {
                        return new FileOutputStream(file, false).getChannel();
                    }
                    FileChannel ch = new RandomAccessFile(file, "rw").getChannel();
                    if (f.truncate) {
                        ch.truncate(0L);
                    }
                    return ch;
                }
                return new FileInputStream(file).getChannel();
            }
        };
    }

    public static FileSystemManager createRemote(IBinder b) throws RemoteException {
        final IFileSystemService fs = IFileSystemService.Stub.asInterface(b);
        if (fs == null) {
            throw new IllegalArgumentException("The IBinder provided is invalid");
        }
        fs.register((IBinder)new Binder());
        return new FileSystemManager(){

            @Override
            @NonNull
            public ExtendedFile getFile(@NonNull String pathname) {
                return new RemoteFile(fs, pathname);
            }

            @Override
            @NonNull
            public ExtendedFile getFile(@Nullable String parent, @NonNull String child) {
                return new RemoteFile(fs, parent, child);
            }

            @Override
            @NonNull
            public FileChannel openChannel(@NonNull File file, int mode) throws IOException {
                return new RemoteFileChannel(fs, file, mode);
            }
        };
    }

    public static FileSystemService createFsService() {
        return new FileSystemService();
    }
}

