/*
 * Decompiled with CFR 0.152.
 */
package com.topjohnwu.superuser.internal;

import android.content.Context;
import android.system.ErrnoException;
import android.system.Os;
import com.topjohnwu.superuser.Shell;
import com.topjohnwu.superuser.internal.IOFactory;
import com.topjohnwu.superuser.internal.Utils;
import com.topjohnwu.superuser.io.SuFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class FifoOutputStream
extends FilterOutputStream {
    static final int FIFO_TIMEOUT = 250;
    static final String TAG = "FIFOIO";
    static final byte[] END_CMD = "echo\n".getBytes(StandardCharsets.UTF_8);
    private final File fifo;
    private boolean append;

    FifoOutputStream(SuFile file, boolean append) throws FileNotFoundException {
        super(null);
        this.append = append;
        if (!this.checkFile(file)) {
            throw new FileNotFoundException("No such file or directory");
        }
        Context c = Utils.getDeContext((Context)Utils.getContext());
        this.fifo = new File(c.getCacheDir(), UUID.randomUUID().toString());
        try {
            Os.mkfifo((String)this.fifo.getPath(), (int)384);
        }
        catch (ErrnoException e) {
            throw (FileNotFoundException)new FileNotFoundException("Failed to mkfifo").initCause(e);
        }
        this.fifo.deleteOnExit();
        try {
            this.openStream(file);
        }
        catch (Exception e) {
            this.fifo.delete();
            throw e;
        }
    }

    private boolean checkFile(SuFile file) {
        if (file.isDirectory()) {
            return false;
        }
        if (file.isBlock() || file.isCharacter()) {
            this.append = false;
            return true;
        }
        if (this.append) {
            return file.canWrite() || file.createNewFile();
        }
        return file.clear();
    }

    private void openStream(SuFile file) throws FileNotFoundException {
        try {
            file.getShell().execTask((in, out, err) -> {
                String cmd = "cat " + this.fifo + this.op() + file.getEscapedPath() + " 2>/dev/null &";
                Utils.log((String)TAG, (Object)cmd);
                in.write(cmd.getBytes(StandardCharsets.UTF_8));
                in.write(10);
                in.flush();
                in.write(END_CMD);
                in.flush();
                out.read(IOFactory.JUNK);
            });
        }
        catch (IOException e) {
            throw (FileNotFoundException)new FileNotFoundException("Error running root command").initCause(e);
        }
        Future<OutputStream> stream = Shell.EXECUTOR.submit(() -> new FileOutputStream(this.fifo));
        try {
            this.out = stream.get(250L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            throw (FileNotFoundException)new FileNotFoundException("Cannot open fifo").initCause(e);
        }
    }

    private String op() {
        return this.append ? " >> " : " > ";
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.fifo.delete();
    }
}

